/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.Application;
import android.net.Uri;
import android.nfc.INdefPushCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NfcActivityManager
extends INdefPushCallback.Stub
implements Application.ActivityLifecycleCallbacks {
    static final String TAG = "NFC";
    static final Boolean DBG = false;
    final NfcAdapter mAdapter;
    final NfcEvent mDefaultEvent;
    final List<NfcApplicationState> mApps;
    final List<NfcActivityState> mActivities;

    NfcApplicationState findAppState(Application app) {
        for (NfcApplicationState appState : this.mApps) {
            if (appState.app != app) continue;
            return appState;
        }
        return null;
    }

    void registerApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            appState = new NfcApplicationState(app);
            this.mApps.add(appState);
        }
        appState.register();
    }

    void unregisterApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            Log.e(TAG, "app was not registered " + app);
            return;
        }
        appState.unregister();
    }

    synchronized NfcActivityState findActivityState(Activity activity) {
        for (NfcActivityState state : this.mActivities) {
            if (state.activity != activity) continue;
            return state;
        }
        return null;
    }

    synchronized NfcActivityState getActivityState(Activity activity) {
        NfcActivityState state = this.findActivityState(activity);
        if (state == null) {
            state = new NfcActivityState(activity);
            this.mActivities.add(state);
        }
        return state;
    }

    synchronized NfcActivityState findResumedActivityState() {
        for (NfcActivityState state : this.mActivities) {
            if (!state.resumed) continue;
            return state;
        }
        return null;
    }

    synchronized void destroyActivityState(Activity activity) {
        NfcActivityState activityState = this.findActivityState(activity);
        if (activityState != null) {
            activityState.destroy();
            this.mActivities.remove(activityState);
        }
    }

    public NfcActivityManager(NfcAdapter adapter) {
        this.mAdapter = adapter;
        this.mActivities = new LinkedList<NfcActivityState>();
        this.mApps = new ArrayList<NfcApplicationState>(1);
        this.mDefaultEvent = new NfcEvent(this.mAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushContentUri(Activity activity, Uri[] uris) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.uris = uris;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushContentUriCallback(Activity activity, NfcAdapter.CreateBeamUrisCallback callback) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.uriCallback = callback;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushMessage(Activity activity, NdefMessage message) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.ndefMessage = message;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushMessageCallback(Activity activity, NfcAdapter.CreateNdefMessageCallback callback) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.ndefMessageCallback = callback;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnNdefPushCompleteCallback(Activity activity, NfcAdapter.OnNdefPushCompleteCallback callback) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.onNdefPushCompleteCallback = callback;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback(true);
        }
    }

    void requestNfcServiceCallback(boolean request) {
        try {
            NfcAdapter.sService.setNdefPushCallback(request ? this : null);
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage createMessage() {
        NdefMessage message;
        NfcAdapter.CreateNdefMessageCallback callback;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return null;
            }
            callback = state.ndefMessageCallback;
            message = state.ndefMessage;
        }
        if (callback != null) {
            return callback.createNdefMessage(this.mDefaultEvent);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri[] getUris() {
        NfcAdapter.CreateBeamUrisCallback callback;
        Uri[] uris;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return null;
            }
            uris = state.uris;
            callback = state.uriCallback;
        }
        if (callback != null) {
            uris = callback.createBeamUris(this.mDefaultEvent);
            if (uris != null) {
                for (Uri uri : uris) {
                    if (uri == null) {
                        Log.e(TAG, "Uri not allowed to be null.");
                        return null;
                    }
                    String scheme = uri.getScheme();
                    if (scheme != null && (scheme.equalsIgnoreCase("file") || scheme.equalsIgnoreCase("content"))) continue;
                    Log.e(TAG, "Uri needs to have either scheme file or scheme content");
                    return null;
                }
            }
            return uris;
        }
        return uris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNdefPushComplete() {
        NfcAdapter.OnNdefPushCompleteCallback callback;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return;
            }
            callback = state.onNdefPushCompleteCallback;
        }
        if (callback != null) {
            callback.onNdefPushComplete(this.mDefaultEvent);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResumed(Activity activity) {
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onResume() for " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = true;
        }
        this.requestNfcServiceCallback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityPaused(Activity activity) {
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onPause() for " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = false;
        }
        this.requestNfcServiceCallback(false);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityDestroyed(Activity activity) {
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onDestroy() for " + activity + " " + state);
            }
            if (state != null) {
                this.destroyActivityState(activity);
            }
        }
    }

    class NfcActivityState {
        boolean resumed = false;
        Activity activity;
        NdefMessage ndefMessage = null;
        NfcAdapter.CreateNdefMessageCallback ndefMessageCallback = null;
        NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback = null;
        NfcAdapter.CreateBeamUrisCallback uriCallback = null;
        Uri[] uris = null;

        public NfcActivityState(Activity activity) {
            if (activity.getWindow().isDestroyed()) {
                throw new IllegalStateException("activity is already destroyed");
            }
            this.resumed = activity.isResumed();
            this.activity = activity;
            NfcActivityManager.this.registerApplication(activity.getApplication());
        }

        public void destroy() {
            NfcActivityManager.this.unregisterApplication(this.activity.getApplication());
            this.resumed = false;
            this.activity = null;
            this.ndefMessage = null;
            this.ndefMessageCallback = null;
            this.onNdefPushCompleteCallback = null;
            this.uriCallback = null;
            this.uris = null;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("[").append(" ");
            s.append(this.ndefMessage).append(" ").append(this.ndefMessageCallback).append(" ");
            s.append(this.uriCallback).append(" ");
            if (this.uris != null) {
                for (Uri uri : this.uris) {
                    s.append(this.onNdefPushCompleteCallback).append(" ").append(uri).append("]");
                }
            }
            return s.toString();
        }
    }

    class NfcApplicationState {
        int refCount = 0;
        final Application app;

        public NfcApplicationState(Application app) {
            this.app = app;
        }

        public void register() {
            ++this.refCount;
            if (this.refCount == 1) {
                this.app.registerActivityLifecycleCallbacks(NfcActivityManager.this);
            }
        }

        public void unregister() {
            --this.refCount;
            if (this.refCount == 0) {
                this.app.unregisterActivityLifecycleCallbacks(NfcActivityManager.this);
            } else if (this.refCount < 0) {
                Log.e(NfcActivityManager.TAG, "-ve refcount for " + this.app);
            }
        }
    }
}

