/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.SurfaceTexture;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.DisplayList;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.GLES20RenderLayer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import com.android.tools.layoutlib.create.OverrideMethod;

class GLES20Canvas
extends HardwareCanvas {
    private static final int MODIFIER_NONE = 0;
    private static final int MODIFIER_SHADOW = 1;
    private static final int MODIFIER_SHADER = 2;
    private static final int MODIFIER_COLOR_FILTER = 4;
    private final boolean mOpaque;
    private int mRenderer;
    private CanvasFinalizer mFinalizer;
    private int mWidth;
    private int mHeight;
    private final float[] mPoint = new float[2];
    private final float[] mLine = new float[4];
    private final Rect mClipBounds = new Rect();
    private final RectF mPathBounds = new RectF();
    private DrawFilter mFilter;
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();
    public static final int FLUSH_CACHES_LAYERS = 0;
    public static final int FLUSH_CACHES_MODERATE = 1;
    public static final int FLUSH_CACHES_FULL = 2;

    private static boolean nIsAvailable() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nIsAvailable()Z", true, null) != 0;
    }

    static boolean isAvailable() {
        return sIsAvailable;
    }

    GLES20Canvas(boolean translucent) {
        this(false, translucent);
    }

    GLES20Canvas(int layer, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = GLES20Canvas.nCreateLayerRenderer(layer);
        this.setupFinalizer();
    }

    protected GLES20Canvas(boolean record, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = record ? GLES20Canvas.nCreateDisplayListRenderer() : GLES20Canvas.nCreateRenderer();
        this.setupFinalizer();
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    protected void resetDisplayListRenderer() {
        GLES20Canvas.nResetDisplayListRenderer(this.mRenderer);
    }

    private static int nCreateRenderer() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateRenderer()I", true, null);
    }

    private static int nCreateLayerRenderer(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateLayerRenderer(I)I", true, null);
    }

    private static int nCreateDisplayListRenderer() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateDisplayListRenderer()I", true, null);
    }

    private static void nResetDisplayListRenderer(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetDisplayListRenderer(I)V", true, null);
    }

    private static void nDestroyRenderer(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyRenderer(I)V", true, null);
    }

    void pushLayerUpdate(HardwareLayer layer) {
        GLES20Canvas.nPushLayerUpdate(this.mRenderer, ((GLES20RenderLayer)layer).mLayer);
    }

    void clearLayerUpdates() {
        GLES20Canvas.nClearLayerUpdates(this.mRenderer);
    }

    static int nCreateTextureLayer(boolean bl, int[] nArray) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateTextureLayer(Z[I)I", true, null);
    }

    static int nCreateLayer(int n, int n2, boolean bl, int[] nArray) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateLayer(IIZ[I)I", true, null);
    }

    static boolean nResizeLayer(int n, int n2, int n3, int[] nArray) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nResizeLayer(III[I)Z", true, null) != 0;
    }

    static void nSetOpaqueLayer(int n, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetOpaqueLayer(IZ)V", true, null);
    }

    static void nSetLayerPaint(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetLayerPaint(II)V", true, null);
    }

    static void nSetLayerColorFilter(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetLayerColorFilter(II)V", true, null);
    }

    static void nUpdateTextureLayer(int n, int n2, int n3, boolean bl, SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nUpdateTextureLayer(IIIZLandroid/graphics/SurfaceTexture;)V", true, null);
    }

    static void nClearLayerTexture(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nClearLayerTexture(I)V", true, null);
    }

    static void nSetTextureLayerTransform(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetTextureLayerTransform(II)V", true, null);
    }

    static void nDestroyLayer(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyLayer(I)V", true, null);
    }

    static void nDestroyLayerDeferred(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyLayerDeferred(I)V", true, null);
    }

    static void nUpdateRenderLayer(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nUpdateRenderLayer(IIIIIII)V", true, null);
    }

    static boolean nCopyLayer(int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCopyLayer(II)Z", true, null) != 0;
    }

    private static void nClearLayerUpdates(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nClearLayerUpdates(I)V", true, null);
    }

    private static void nPushLayerUpdate(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nPushLayerUpdate(II)V", true, null);
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    private static int nGetMaximumTextureWidth() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMaximumTextureWidth()I", true, null);
    }

    private static int nGetMaximumTextureHeight() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMaximumTextureHeight()I", true, null);
    }

    int getRenderer() {
        return this.mRenderer;
    }

    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    private static void nSetViewport(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetViewport(III)V", true, null);
    }

    public int onPreDraw(Rect dirty) {
        if (dirty != null) {
            return GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        }
        return GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
    }

    private static int nPrepare(int n, boolean bl) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPrepare(IZ)I", true, null);
    }

    private static int nPrepareDirty(int n, int n2, int n3, int n4, int n5, boolean bl) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPrepareDirty(IIIIIZ)I", true, null);
    }

    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    private static void nFinish(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFinish(I)V", true, null);
    }

    public static int getStencilSize() {
        return GLES20Canvas.nGetStencilSize();
    }

    private static int nGetStencilSize() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetStencilSize()I", true, null);
    }

    public int callDrawGLFunction(int drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    private static int nCallDrawGLFunction(int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCallDrawGLFunction(II)I", true, null);
    }

    public int invokeFunctors(Rect dirty) {
        return GLES20Canvas.nInvokeFunctors(this.mRenderer, dirty);
    }

    private static int nInvokeFunctors(int n, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nInvokeFunctors(ILandroid/graphics/Rect;)I", true, null);
    }

    public void detachFunctor(int functor) {
        GLES20Canvas.nDetachFunctor(this.mRenderer, functor);
    }

    private static void nDetachFunctor(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDetachFunctor(II)V", true, null);
    }

    public void attachFunctor(int functor) {
        GLES20Canvas.nAttachFunctor(this.mRenderer, functor);
    }

    private static void nAttachFunctor(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nAttachFunctor(II)V", true, null);
    }

    public static void flushCaches(int level) {
        GLES20Canvas.nFlushCaches(level);
    }

    private static void nFlushCaches(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFlushCaches(I)V", true, null);
    }

    public static void terminateCaches() {
        GLES20Canvas.nTerminateCaches();
    }

    private static void nTerminateCaches() {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nTerminateCaches()V", true, null);
    }

    public static void initCaches() {
        GLES20Canvas.nInitCaches();
    }

    private static void nInitCaches() {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nInitCaches()V", true, null);
    }

    int getDisplayList(int displayList) {
        return GLES20Canvas.nGetDisplayList(this.mRenderer, displayList);
    }

    private static int nGetDisplayList(int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetDisplayList(II)I", true, null);
    }

    static void destroyDisplayList(int displayList) {
        GLES20Canvas.nDestroyDisplayList(displayList);
    }

    private static void nDestroyDisplayList(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyDisplayList(I)V", true, null);
    }

    static int getDisplayListSize(int displayList) {
        return GLES20Canvas.nGetDisplayListSize(displayList);
    }

    private static int nGetDisplayListSize(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetDisplayListSize(I)I", true, null);
    }

    static void setDisplayListName(int displayList, String name) {
        GLES20Canvas.nSetDisplayListName(displayList, name);
    }

    private static void nSetDisplayListName(int n, String string2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetDisplayListName(ILjava/lang/String;)V", true, null);
    }

    public int drawDisplayList(DisplayList displayList, Rect dirty, int flags) {
        return GLES20Canvas.nDrawDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList(), dirty, flags);
    }

    private static int nDrawDisplayList(int n, int n2, Rect rect, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nDrawDisplayList(IILandroid/graphics/Rect;I)I", true, null);
    }

    void outputDisplayList(DisplayList displayList) {
        GLES20Canvas.nOutputDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList());
    }

    private static void nOutputDisplayList(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nOutputDisplayList(II)V", true, null);
    }

    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        GLES20Layer glLayer = (GLES20Layer)layer;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawLayer(this.mRenderer, glLayer.getLayer(), x, y, nativePaint);
    }

    private static void nDrawLayer(int n, int n2, float f, float f2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLayer(IIFFI)V", true, null);
    }

    void interrupt() {
        GLES20Canvas.nInterrupt(this.mRenderer);
    }

    void resume() {
        GLES20Canvas.nResume(this.mRenderer);
    }

    private static void nInterrupt(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nInterrupt(I)V", true, null);
    }

    private static void nResume(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResume(I)V", true, null);
    }

    public boolean clipPath(Path path) {
        path.computeBounds(this.mPathBounds, true);
        return GLES20Canvas.nClipRect(this.mRenderer, this.mPathBounds.left, this.mPathBounds.top, this.mPathBounds.right, this.mPathBounds.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipPath(Path path, Region.Op op) {
        path.computeBounds(this.mPathBounds, true);
        return GLES20Canvas.nClipRect(this.mRenderer, this.mPathBounds.left, this.mPathBounds.top, this.mPathBounds.right, this.mPathBounds.bottom, op.nativeInt);
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static boolean nClipRect(int n, float f, float f2, float f3, float f4, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(IFFFFI)Z", true, null) != 0;
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static boolean nClipRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(IIIIII)Z", true, null) != 0;
    }

    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        region.getBounds(this.mClipBounds);
        return GLES20Canvas.nClipRect(this.mRenderer, this.mClipBounds.left, this.mClipBounds.top, this.mClipBounds.right, this.mClipBounds.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        region.getBounds(this.mClipBounds);
        return GLES20Canvas.nClipRect(this.mRenderer, this.mClipBounds.left, this.mClipBounds.top, this.mClipBounds.right, this.mClipBounds.bottom, op.nativeInt);
    }

    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    private static boolean nGetClipBounds(int n, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetClipBounds(ILandroid/graphics/Rect;)Z", true, null) != 0;
    }

    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom, type.nativeInt);
    }

    private static boolean nQuickReject(int n, float f, float f2, float f3, float f4, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nQuickReject(IFFFFI)Z", true, null) != 0;
    }

    public boolean quickReject(Path path, Canvas.EdgeType type) {
        path.computeBounds(this.mPathBounds, true);
        return GLES20Canvas.nQuickReject(this.mRenderer, this.mPathBounds.left, this.mPathBounds.top, this.mPathBounds.right, this.mPathBounds.bottom, type.nativeInt);
    }

    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, type.nativeInt);
    }

    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    private static void nTranslate(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nTranslate(IFF)V", true, null);
    }

    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    private static void nSkew(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSkew(IFF)V", true, null);
    }

    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    private static void nRotate(int n, float f) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRotate(IF)V", true, null);
    }

    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    private static void nScale(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nScale(IFF)V", true, null);
    }

    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix == null ? 0 : matrix.native_instance);
    }

    private static void nSetMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetMatrix(II)V", true, null);
    }

    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static void nGetMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nGetMatrix(II)V", true, null);
    }

    public void concat(Matrix matrix) {
        GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
    }

    private static void nConcatMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nConcatMatrix(II)V", true, null);
    }

    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    private static int nSave(int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSave(II)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        int count;
        if (bounds != null) {
            return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            count = GLES20Canvas.nSaveLayer(this.mRenderer, nativePaint, saveFlags);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
        return count;
    }

    private static int nSaveLayer(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(III)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            int count;
            int modifier = paint != null ? this.setupColorFilter(paint) : 0;
            try {
                int nativePaint = paint == null ? 0 : paint.mNativePaint;
                count = GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
            }
            finally {
                if (modifier != 0) {
                    GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
                }
            }
            return count;
        }
        return this.save(saveFlags);
    }

    private static int nSaveLayer(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(IFFFFII)I", true, null);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds != null) {
            return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, alpha, saveFlags);
    }

    private static int nSaveLayerAlpha(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(III)I", true, null);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static int nSaveLayerAlpha(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(IFFFFII)I", true, null);
    }

    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    private static void nRestore(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestore(I)V", true, null);
    }

    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    private static void nRestoreToCount(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestoreToCount(II)V", true, null);
    }

    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    private static int nGetSaveCount(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetSaveCount(I)I", true, null);
    }

    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
        if (filter == null) {
            GLES20Canvas.nResetPaintFilter(this.mRenderer);
        } else if (filter instanceof PaintFlagsDrawFilter) {
            PaintFlagsDrawFilter flagsFilter = (PaintFlagsDrawFilter)filter;
            GLES20Canvas.nSetupPaintFilter(this.mRenderer, flagsFilter.clearBits, flagsFilter.setBits);
        }
    }

    private static void nResetPaintFilter(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetPaintFilter(I)V", true, null);
    }

    private static void nSetupPaintFilter(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupPaintFilter(III)V", true, null);
    }

    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawArc(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawArc(int n, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawArc(IFFFFFFZI)V", true, null);
    }

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPatch(Bitmap bitmap, byte[] chunks, RectF dst, Paint paint) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Cannot draw recycled bitmaps");
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, chunks, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    private static void nDrawPatch(int n, int n2, byte[] byArray, byte[] byArray2, float f, float f2, float f3, float f4, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPatch(II[B[BFFFFI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Cannot draw recycled bitmaps");
        }
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmap(int n, int n2, byte[] byArray, float f, float f2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(II[BFFI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Cannot draw recycled bitmaps");
        }
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmap(int n, int n2, byte[] byArray, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(II[BII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Cannot draw recycled bitmaps");
        }
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int bottom;
            int right;
            int left;
            int top;
            int nativePaint;
            int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
            if (src == null) {
                top = 0;
                left = 0;
                right = bitmap.getWidth();
                bottom = bitmap.getHeight();
            } else {
                left = src.left;
                right = src.right;
                top = src.top;
                bottom = src.bottom;
            }
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Cannot draw recycled bitmaps");
        }
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            float bottom;
            float right;
            float left;
            float top;
            int nativePaint;
            int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
            if (src == null) {
                top = 0.0f;
                left = 0.0f;
                right = bitmap.getWidth();
                bottom = bitmap.getHeight();
            } else {
                left = src.left;
                right = src.right;
                top = src.top;
                bottom = src.bottom;
            }
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmap(int n, int n2, byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(II[BFFFFFFFFI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, colors, offset, stride, x, y, width, height, hasAlpha, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    private static void nDrawBitmap(int n, int[] nArray, int n2, int n3, float f, float f2, int n4, int n5, boolean bl, int n6) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(I[IIIFFIIZI)V", true, null);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Cannot draw recycled bitmaps");
        }
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        colors = null;
        colorOffset = 0;
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmapMesh(int n, int n2, byte[] byArray, int n3, int n4, float[] fArray, int n5, int[] nArray, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmapMesh(II[BII[FI[III)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawCircle(int n, float f, float f2, float f3, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawCircle(IFFFI)V", true, null);
    }

    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    private static void nDrawColor(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawColor(III)V", true, null);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.mLine[0] = startX;
        this.mLine[1] = startY;
        this.mLine[2] = stopX;
        this.mLine[3] = stopY;
        this.drawLines(this.mLine, 0, 4, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawLines(int n, float[] fArray, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLines(I[FIII)V", true, null);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(RectF oval, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawOval(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawOval(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawOval(IFFFFI)V", true, null);
    }

    public void drawPaint(Paint paint) {
        Rect r = this.mClipBounds;
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPath(Path path, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            if (path.isSimplePath) {
                if (path.rects != null) {
                    GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
                }
            } else {
                GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPath(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPath(III)V", true, null);
    }

    private static void nDrawRects(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRects(III)V", true, null);
    }

    public void drawPicture(Picture picture) {
        if (picture.createdFromStream) {
            return;
        }
        picture.endRecording();
    }

    public void drawPicture(Picture picture, Rect dst) {
        if (picture.createdFromStream) {
            return;
        }
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / picture.getWidth(), dst.height() / picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, RectF dst) {
        if (picture.createdFromStream) {
            return;
        }
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPoint(float x, float y, Paint paint) {
        this.mPoint[0] = x;
        this.mPoint[1] = y;
        this.drawPoints(this.mPoint, 0, 2, paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawPoints(this.mRenderer, pts, offset, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPoints(int n, float[] fArray, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPoints(I[FIII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawPosText(this.mRenderer, text, index, count, pos, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPosText(int n, char[] cArray, int n2, int n3, float[] fArray, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPosText(I[CII[FI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawPosText(this.mRenderer, text, 0, text.length(), pos, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPosText(int n, String string2, int n2, int n3, float[] fArray, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPosText(ILjava/lang/String;II[FI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        if (left == right || top == bottom) {
            return;
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawRect(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRect(IFFFFI)V", true, null);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRoundRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawRoundRect(int n, float f, float f2, float f3, float f4, float f5, float f6, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRoundRect(IFFFFFFI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawText(int n, char[] cArray, int n2, int n3, float f, float f2, int n4, int n5) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(I[CIIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawText(this.mRenderer, ((Object)text).toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
            } else {
                char[] buf = TemporaryBuffer.obtain(end - start);
                TextUtils.getChars(text, start, end, buf, 0);
                GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawText(int n, String string2, int n2, int n3, float f, float f2, int n4, int n5) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(ILjava/lang/String;IIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, index, count, path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextOnPath(int n, char[] cArray, int n2, int n3, int n4, float f, float f2, int n5, int n6) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextOnPath(I[CIIIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() == 0) {
            return;
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, 0, text.length(), path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextOnPath(int n, String string2, int n2, int n3, int n4, float f, float f2, int n5, int n6) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextOnPath(ILjava/lang/String;IIIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Unknown direction: " + dir);
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, dir, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextRun(int n, char[] cArray, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(I[CIIIIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            int flags;
            int n = flags = dir == 0 ? 0 : 1;
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawTextRun(this.mRenderer, ((Object)text).toString(), start, end, contextStart, contextEnd, x, y, flags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, flags, paint);
            } else {
                int contextLen = contextEnd - contextStart;
                int len = end - start;
                char[] buf = TemporaryBuffer.obtain(contextLen);
                TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
                GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, flags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextRun(int n, String string2, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(ILjava/lang/String;IIIIFFII)V", true, null);
    }

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    private int setupModifiers(Bitmap b, Paint paint) {
        if (b.getConfig() != Bitmap.Config.ALPHA_8) {
            ColorFilter filter = paint.getColorFilter();
            if (filter != null) {
                GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
                return 4;
            }
            return 0;
        }
        return this.setupModifiers(paint);
    }

    private int setupModifiers(Paint paint) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupModifiers(Paint paint, int flags) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow && (flags & 1) != 0) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null && (flags & 2) != 0) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null && (flags & 4) != 0) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupColorFilter(Paint paint) {
        ColorFilter filter = paint.getColorFilter();
        if (filter != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            return 4;
        }
        return 0;
    }

    private static void nSetupShader(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupShader(II)V", true, null);
    }

    private static void nSetupColorFilter(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupColorFilter(II)V", true, null);
    }

    private static void nSetupShadow(int n, float f, float f2, float f3, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupShadow(IFFFI)V", true, null);
    }

    private static void nResetModifiers(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetModifiers(II)V", true, null);
    }

    private static class CanvasFinalizer {
        private final int mRenderer;

        public CanvasFinalizer(int renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            finally {
                super.finalize();
            }
        }
    }
}

