/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.HardwareCanvas;

class GLES20RenderLayer
extends GLES20Layer {
    private int mLayerWidth;
    private int mLayerHeight;
    private final GLES20Canvas mCanvas;

    GLES20RenderLayer(int width, int height, boolean isOpaque) {
        super(width, height, isOpaque);
        int[] layerInfo = new int[2];
        this.mLayer = GLES20Canvas.nCreateLayer(width, height, isOpaque, layerInfo);
        if (this.mLayer != 0) {
            this.mLayerWidth = layerInfo[0];
            this.mLayerHeight = layerInfo[1];
            this.mCanvas = new GLES20Canvas(this.mLayer, !isOpaque);
            this.mFinalizer = new GLES20Layer.Finalizer(this.mLayer);
        } else {
            this.mCanvas = null;
            this.mFinalizer = null;
        }
    }

    boolean isValid() {
        return this.mLayer != 0 && this.mLayerWidth > 0 && this.mLayerHeight > 0;
    }

    boolean resize(int width, int height) {
        if (!this.isValid() || width <= 0 || height <= 0) {
            return false;
        }
        this.mWidth = width;
        this.mHeight = height;
        if (width != this.mLayerWidth || height != this.mLayerHeight) {
            int[] layerInfo = new int[2];
            if (GLES20Canvas.nResizeLayer(this.mLayer, width, height, layerInfo)) {
                this.mLayerWidth = layerInfo[0];
                this.mLayerHeight = layerInfo[1];
            } else {
                this.mLayer = 0;
                this.mLayerWidth = 0;
                this.mLayerHeight = 0;
            }
        }
        return this.isValid();
    }

    void setOpaque(boolean isOpaque) {
        this.mOpaque = isOpaque;
        GLES20Canvas.nSetOpaqueLayer(this.mLayer, isOpaque);
    }

    HardwareCanvas getCanvas() {
        return this.mCanvas;
    }

    void end(Canvas currentCanvas) {
        if (currentCanvas instanceof GLES20Canvas) {
            ((GLES20Canvas)currentCanvas).resume();
        }
    }

    HardwareCanvas start(Canvas currentCanvas) {
        if (currentCanvas instanceof GLES20Canvas) {
            ((GLES20Canvas)currentCanvas).interrupt();
        }
        return this.getCanvas();
    }

    void setTransform(Matrix matrix) {
    }

    void redrawLater(DisplayList displayList, Rect dirtyRect) {
        GLES20Canvas.nUpdateRenderLayer(this.mLayer, this.mCanvas.getRenderer(), ((GLES20DisplayList)displayList).getNativeDisplayList(), dirtyRect.left, dirtyRect.top, dirtyRect.right, dirtyRect.bottom);
    }
}

