/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Interpolator;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.Log;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.Property;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.AbsSavedState;
import android.view.AccessibilityIterators;
import android.view.ActionMode;
import android.view.Choreographer;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DisplayList;
import android.view.DragEvent;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InputEventConsistencyVerifier;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.Surface;
import android.view.TouchDelegate;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewPropertyAnimator;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.View_Delegate;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityEventSource;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.ScrollBarDrawable;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import com.android.internal.view.menu.MenuBuilder;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements Drawable.Callback,
KeyEvent.Callback,
AccessibilityEventSource {
    private static final boolean DBG = false;
    protected static final String VIEW_LOG_TAG = "View";
    public static final String DEBUG_LAYOUT_PROPERTY = "debug.layout";
    public static final int NO_ID = -1;
    private static final int NOT_FOCUSABLE = 0;
    private static final int FOCUSABLE = 1;
    private static final int FOCUSABLE_MASK = 1;
    private static final int FITS_SYSTEM_WINDOWS = 2;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    static final int VISIBILITY_MASK = 12;
    private static final int[] VISIBILITY_FLAGS = new int[]{0, 4, 8};
    static final int ENABLED = 0;
    static final int DISABLED = 32;
    static final int ENABLED_MASK = 32;
    static final int WILL_NOT_DRAW = 128;
    static final int DRAW_MASK = 128;
    static final int SCROLLBARS_NONE = 0;
    static final int SCROLLBARS_HORIZONTAL = 256;
    static final int SCROLLBARS_VERTICAL = 512;
    static final int SCROLLBARS_MASK = 768;
    static final int FILTER_TOUCHES_WHEN_OBSCURED = 1024;
    static final int OPTIONAL_FITS_SYSTEM_WINDOWS = 2048;
    static final int FADING_EDGE_NONE = 0;
    static final int FADING_EDGE_HORIZONTAL = 4096;
    static final int FADING_EDGE_VERTICAL = 8192;
    static final int FADING_EDGE_MASK = 12288;
    static final int CLICKABLE = 16384;
    static final int DRAWING_CACHE_ENABLED = 32768;
    static final int SAVE_DISABLED = 65536;
    static final int SAVE_DISABLED_MASK = 65536;
    static final int WILL_NOT_CACHE_DRAWING = 131072;
    static final int FOCUSABLE_IN_TOUCH_MODE = 262144;
    public static final int DRAWING_CACHE_QUALITY_LOW = 524288;
    public static final int DRAWING_CACHE_QUALITY_HIGH = 0x100000;
    public static final int DRAWING_CACHE_QUALITY_AUTO = 0;
    private static final int[] DRAWING_CACHE_QUALITY_FLAGS = new int[]{0, 524288, 0x100000};
    static final int DRAWING_CACHE_QUALITY_MASK = 0x180000;
    static final int LONG_CLICKABLE = 0x200000;
    static final int DUPLICATE_PARENT_STATE = 0x400000;
    public static final int SCROLLBARS_INSIDE_OVERLAY = 0;
    public static final int SCROLLBARS_INSIDE_INSET = 0x1000000;
    public static final int SCROLLBARS_OUTSIDE_OVERLAY = 0x2000000;
    public static final int SCROLLBARS_OUTSIDE_INSET = 0x3000000;
    static final int SCROLLBARS_INSET_MASK = 0x1000000;
    static final int SCROLLBARS_OUTSIDE_MASK = 0x2000000;
    static final int SCROLLBARS_STYLE_MASK = 0x3000000;
    public static final int KEEP_SCREEN_ON = 0x4000000;
    public static final int SOUND_EFFECTS_ENABLED = 0x8000000;
    public static final int HAPTIC_FEEDBACK_ENABLED = 0x10000000;
    static final int PARENT_SAVE_DISABLED = 0x20000000;
    static final int PARENT_SAVE_DISABLED_MASK = 0x20000000;
    public static final int FOCUSABLES_ALL = 0;
    public static final int FOCUSABLES_TOUCH_MODE = 1;
    public static final int FOCUS_BACKWARD = 1;
    public static final int FOCUS_FORWARD = 2;
    public static final int FOCUS_LEFT = 17;
    public static final int FOCUS_UP = 33;
    public static final int FOCUS_RIGHT = 66;
    public static final int FOCUS_DOWN = 130;
    public static final int MEASURED_SIZE_MASK = 0xFFFFFF;
    public static final int MEASURED_STATE_MASK = -16777216;
    public static final int MEASURED_HEIGHT_STATE_SHIFT = 16;
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    protected static final int[] EMPTY_STATE_SET;
    protected static final int[] ENABLED_STATE_SET;
    protected static final int[] FOCUSED_STATE_SET;
    protected static final int[] SELECTED_STATE_SET;
    protected static final int[] PRESSED_STATE_SET;
    protected static final int[] WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_SELECTED_STATE_SET;
    protected static final int[] ENABLED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] FOCUSED_SELECTED_STATE_SET;
    protected static final int[] FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    private static final int[][] VIEW_STATE_SETS;
    static final int VIEW_STATE_WINDOW_FOCUSED = 1;
    static final int VIEW_STATE_SELECTED = 2;
    static final int VIEW_STATE_FOCUSED = 4;
    static final int VIEW_STATE_ENABLED = 8;
    static final int VIEW_STATE_PRESSED = 16;
    static final int VIEW_STATE_ACTIVATED = 32;
    static final int VIEW_STATE_ACCELERATED = 64;
    static final int VIEW_STATE_HOVERED = 128;
    static final int VIEW_STATE_DRAG_CAN_ACCEPT = 256;
    static final int VIEW_STATE_DRAG_HOVERED = 512;
    static final int[] VIEW_STATE_IDS;
    private static final int POPULATING_ACCESSIBILITY_EVENT_TYPES = 172479;
    static final ThreadLocal<Rect> sThreadLocal;
    private SparseArray<Object> mKeyedTags;
    private static int sNextAccessibilityViewId;
    protected Animation mCurrentAnimation = null;
    @ViewDebug.ExportedProperty(category="measurement")
    int mMeasuredWidth;
    @ViewDebug.ExportedProperty(category="measurement")
    int mMeasuredHeight;
    boolean mRecreateDisplayList = false;
    @ViewDebug.ExportedProperty(resolveId=true)
    int mID = -1;
    int mAccessibilityViewId = -1;
    private int mAccessibilityCursorPosition = -1;
    protected Object mTag;
    static final int PFLAG_WANTS_FOCUS = 1;
    static final int PFLAG_FOCUSED = 2;
    static final int PFLAG_SELECTED = 4;
    static final int PFLAG_IS_ROOT_NAMESPACE = 8;
    static final int PFLAG_HAS_BOUNDS = 16;
    static final int PFLAG_DRAWN = 32;
    static final int PFLAG_DRAW_ANIMATION = 64;
    static final int PFLAG_SKIP_DRAW = 128;
    static final int PFLAG_ONLY_DRAWS_BACKGROUND = 256;
    static final int PFLAG_REQUEST_TRANSPARENT_REGIONS = 512;
    static final int PFLAG_DRAWABLE_STATE_DIRTY = 1024;
    static final int PFLAG_MEASURED_DIMENSION_SET = 2048;
    static final int PFLAG_FORCE_LAYOUT = 4096;
    static final int PFLAG_LAYOUT_REQUIRED = 8192;
    private static final int PFLAG_PRESSED = 16384;
    static final int PFLAG_DRAWING_CACHE_VALID = 32768;
    static final int PFLAG_ANIMATION_STARTED = 65536;
    private static final int PFLAG_SAVE_STATE_CALLED = 131072;
    static final int PFLAG_ALPHA_SET = 262144;
    static final int PFLAG_SCROLL_CONTAINER = 524288;
    static final int PFLAG_SCROLL_CONTAINER_ADDED = 0x100000;
    static final int PFLAG_DIRTY = 0x200000;
    static final int PFLAG_DIRTY_OPAQUE = 0x400000;
    static final int PFLAG_DIRTY_MASK = 0x600000;
    static final int PFLAG_OPAQUE_BACKGROUND = 0x800000;
    static final int PFLAG_OPAQUE_SCROLLBARS = 0x1000000;
    static final int PFLAG_OPAQUE_MASK = 0x1800000;
    private static final int PFLAG_PREPRESSED = 0x2000000;
    static final int PFLAG_CANCEL_NEXT_UP_EVENT = 0x4000000;
    private static final int PFLAG_AWAKEN_SCROLL_BARS_ON_ATTACH = 0x8000000;
    private static final int PFLAG_HOVERED = 0x10000000;
    private static final int PFLAG_PIVOT_EXPLICITLY_SET = 0x20000000;
    static final int PFLAG_ACTIVATED = 0x40000000;
    static final int PFLAG_INVALIDATED = Integer.MIN_VALUE;
    static final int PFLAG2_DRAG_CAN_ACCEPT = 1;
    static final int PFLAG2_DRAG_HOVERED = 2;
    public static final int LAYOUT_DIRECTION_LTR = 0;
    public static final int LAYOUT_DIRECTION_RTL = 1;
    public static final int LAYOUT_DIRECTION_INHERIT = 2;
    public static final int LAYOUT_DIRECTION_LOCALE = 3;
    static final int PFLAG2_LAYOUT_DIRECTION_MASK_SHIFT = 2;
    static final int PFLAG2_LAYOUT_DIRECTION_MASK = 12;
    static final int PFLAG2_LAYOUT_DIRECTION_RESOLVED_RTL = 16;
    static final int PFLAG2_LAYOUT_DIRECTION_RESOLVED = 32;
    static final int PFLAG2_LAYOUT_DIRECTION_RESOLVED_MASK = 48;
    private static final int[] LAYOUT_DIRECTION_FLAGS;
    private static final int LAYOUT_DIRECTION_DEFAULT = 2;
    static final int PFLAG2_HAS_TRANSIENT_STATE = 0x400000;
    public static final int TEXT_DIRECTION_INHERIT = 0;
    public static final int TEXT_DIRECTION_FIRST_STRONG = 1;
    public static final int TEXT_DIRECTION_ANY_RTL = 2;
    public static final int TEXT_DIRECTION_LTR = 3;
    public static final int TEXT_DIRECTION_RTL = 4;
    public static final int TEXT_DIRECTION_LOCALE = 5;
    private static final int TEXT_DIRECTION_DEFAULT = 0;
    static final int PFLAG2_TEXT_DIRECTION_MASK_SHIFT = 6;
    static final int PFLAG2_TEXT_DIRECTION_MASK = 448;
    private static final int[] PFLAG2_TEXT_DIRECTION_FLAGS;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED = 512;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED_MASK_SHIFT = 10;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED_MASK = 7168;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED_DEFAULT = 1024;
    public static final int TEXT_ALIGNMENT_INHERIT = 0;
    public static final int TEXT_ALIGNMENT_GRAVITY = 1;
    public static final int TEXT_ALIGNMENT_TEXT_START = 2;
    public static final int TEXT_ALIGNMENT_TEXT_END = 3;
    public static final int TEXT_ALIGNMENT_CENTER = 4;
    public static final int TEXT_ALIGNMENT_VIEW_START = 5;
    public static final int TEXT_ALIGNMENT_VIEW_END = 6;
    private static final int TEXT_ALIGNMENT_DEFAULT = 1;
    static final int PFLAG2_TEXT_ALIGNMENT_MASK_SHIFT = 13;
    static final int PFLAG2_TEXT_ALIGNMENT_MASK = 57344;
    private static final int[] PFLAG2_TEXT_ALIGNMENT_FLAGS;
    static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED = 65536;
    static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED_MASK_SHIFT = 17;
    static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED_MASK = 917504;
    private static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED_DEFAULT = 131072;
    static final int PFLAG2_IMPORTANT_FOR_ACCESSIBILITY_SHIFT = 20;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_AUTO = 0;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_YES = 1;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_NO = 2;
    static final int IMPORTANT_FOR_ACCESSIBILITY_DEFAULT = 0;
    static final int PFLAG2_IMPORTANT_FOR_ACCESSIBILITY_MASK = 0x300000;
    static final int PFLAG2_ACCESSIBILITY_FOCUSED = 0x4000000;
    static final int PFLAG2_ACCESSIBILITY_STATE_CHANGED = 0x8000000;
    static final int PFLAG2_VIEW_QUICK_REJECTED = 0x10000000;
    static final int PFLAG2_PADDING_RESOLVED = 0x20000000;
    static final int PFLAG2_DRAWABLE_RESOLVED = 0x40000000;
    static final int ALL_RTL_PROPERTIES_RESOLVED = 1610678816;
    static final int PFLAG3_VIEW_IS_ANIMATING_TRANSFORM = 1;
    static final int PFLAG3_VIEW_IS_ANIMATING_ALPHA = 2;
    static final int DRAG_MASK = 3;
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    public static final int SYSTEM_UI_FLAG_VISIBLE = 0;
    public static final int SYSTEM_UI_FLAG_LOW_PROFILE = 1;
    public static final int SYSTEM_UI_FLAG_HIDE_NAVIGATION = 2;
    public static final int SYSTEM_UI_FLAG_FULLSCREEN = 4;
    public static final int SYSTEM_UI_FLAG_LAYOUT_STABLE = 256;
    public static final int SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION = 512;
    public static final int SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN = 1024;
    public static final int STATUS_BAR_HIDDEN = 1;
    public static final int STATUS_BAR_VISIBLE = 0;
    public static final int STATUS_BAR_DISABLE_EXPAND = 65536;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_ICONS = 131072;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_ALERTS = 262144;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_TICKER = 524288;
    public static final int STATUS_BAR_DISABLE_SYSTEM_INFO = 0x100000;
    public static final int STATUS_BAR_DISABLE_HOME = 0x200000;
    public static final int STATUS_BAR_DISABLE_BACK = 0x400000;
    public static final int STATUS_BAR_DISABLE_CLOCK = 0x800000;
    public static final int STATUS_BAR_DISABLE_RECENT = 0x1000000;
    public static final int STATUS_BAR_DISABLE_SEARCH = 0x2000000;
    public static final int PUBLIC_STATUS_BAR_VISIBILITY_MASK = 65535;
    public static final int SYSTEM_UI_CLEARABLE_FLAGS = 7;
    public static final int SYSTEM_UI_LAYOUT_FLAGS = 1536;
    public static final int FIND_VIEWS_WITH_TEXT = 1;
    public static final int FIND_VIEWS_WITH_CONTENT_DESCRIPTION = 2;
    public static final int FIND_VIEWS_WITH_ACCESSIBILITY_NODE_PROVIDERS = 4;
    private static final int ACCESSIBILITY_CURSOR_POSITION_UNDEFINED = -1;
    public static final int SCREEN_STATE_OFF = 0;
    public static final int SCREEN_STATE_ON = 1;
    private int mOverScrollMode;
    protected ViewParent mParent;
    AttachInfo mAttachInfo;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=4096, equals=4096, name="FORCE_LAYOUT"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="LAYOUT_REQUIRED"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="DRAWING_CACHE_INVALID", outputIf=false), @ViewDebug.FlagToString(mask=32, equals=32, name="DRAWN", outputIf=true), @ViewDebug.FlagToString(mask=32, equals=32, name="NOT_DRAWN", outputIf=false), @ViewDebug.FlagToString(mask=0x600000, equals=0x400000, name="DIRTY_OPAQUE"), @ViewDebug.FlagToString(mask=0x600000, equals=0x200000, name="DIRTY")})
    int mPrivateFlags;
    int mPrivateFlags2;
    int mPrivateFlags3;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="SYSTEM_UI_FLAG_LOW_PROFILE", outputIf=true), @ViewDebug.FlagToString(mask=2, equals=2, name="SYSTEM_UI_FLAG_HIDE_NAVIGATION", outputIf=true), @ViewDebug.FlagToString(mask=65535, equals=0, name="SYSTEM_UI_FLAG_VISIBLE", outputIf=true)})
    int mSystemUiVisibility;
    int mTransientStateCount = 0;
    int mWindowAttachCount;
    protected ViewGroup.LayoutParams mLayoutParams;
    @ViewDebug.ExportedProperty
    int mViewFlags;
    TransformationInfo mTransformationInfo;
    private boolean mLastIsOpaque;
    private static final float NONZERO_EPSILON = 0.001f;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mLeft;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mRight;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mTop;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mBottom;
    @ViewDebug.ExportedProperty(category="scrolling")
    protected int mScrollX;
    @ViewDebug.ExportedProperty(category="scrolling")
    protected int mScrollY;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingLeft = 0;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingRight = 0;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingTop;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingBottom;
    private Insets mLayoutInsets;
    private CharSequence mContentDescription;
    private int mLabelForId = -1;
    private MatchLabelForPredicate mMatchLabelForPredicate;
    private MatchIdPredicate mMatchIdPredicate;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mUserPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mUserPaddingBottom;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mUserPaddingLeft;
    @ViewDebug.ExportedProperty(category="padding")
    int mUserPaddingStart;
    @ViewDebug.ExportedProperty(category="padding")
    int mUserPaddingEnd;
    int mUserPaddingLeftInitial = 0;
    int mUserPaddingRightInitial = 0;
    private static final int UNDEFINED_PADDING = Integer.MIN_VALUE;
    int mOldWidthMeasureSpec = Integer.MIN_VALUE;
    int mOldHeightMeasureSpec = Integer.MIN_VALUE;
    @ViewDebug.ExportedProperty(deepExport=true, prefix="bg_")
    private Drawable mBackground;
    private int mBackgroundResource;
    private boolean mBackgroundSizeChanged;
    ListenerInfo mListenerInfo;
    protected Context mContext;
    private final Resources mResources;
    private ScrollabilityCache mScrollCache;
    private int[] mDrawableState = null;
    public boolean mCachingFailed;
    private Bitmap mDrawingCache;
    private Bitmap mUnscaledDrawingCache;
    private HardwareLayer mHardwareLayer;
    DisplayList mDisplayList;
    private int mNextFocusLeftId = -1;
    private int mNextFocusRightId = -1;
    private int mNextFocusUpId = -1;
    private int mNextFocusDownId = -1;
    int mNextFocusForwardId = -1;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap = null;
    private PerformClick mPerformClick;
    private SendViewScrolledAccessibilityEvent mSendViewScrolledAccessibilityEvent;
    private UnsetPressedState mUnsetPressedState;
    private boolean mHasPerformedLongPress;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mMinHeight;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mMinWidth;
    private TouchDelegate mTouchDelegate = null;
    private int mDrawingCacheBackgroundColor = 0;
    private ViewTreeObserver mFloatingTreeObserver;
    private int mTouchSlop;
    private ViewPropertyAnimator mAnimator = null;
    public static final int DRAG_FLAG_GLOBAL = 1;
    private float mVerticalScrollFactor;
    private int mVerticalScrollbarPosition;
    public static final int SCROLLBAR_POSITION_DEFAULT = 0;
    public static final int SCROLLBAR_POSITION_LEFT = 1;
    public static final int SCROLLBAR_POSITION_RIGHT = 2;
    public static final int LAYER_TYPE_NONE = 0;
    public static final int LAYER_TYPE_SOFTWARE = 1;
    public static final int LAYER_TYPE_HARDWARE = 2;
    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="SOFTWARE"), @ViewDebug.IntToString(from=2, to="HARDWARE")})
    int mLayerType = 0;
    Paint mLayerPaint;
    Rect mLocalDirtyRect;
    private boolean mSendingHoverAccessibilityEvents;
    AccessibilityDelegate mAccessibilityDelegate;
    protected final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
    private static final AtomicInteger sNextGeneratedId;
    public static final Property<View, Float> ALPHA;
    public static final Property<View, Float> TRANSLATION_X;
    public static final Property<View, Float> TRANSLATION_Y;
    public static final Property<View, Float> X;
    public static final Property<View, Float> Y;
    public static final Property<View, Float> ROTATION;
    public static final Property<View, Float> ROTATION_X;
    public static final Property<View, Float> ROTATION_Y;
    public static final Property<View, Float> SCALE_X;
    public static final Property<View, Float> SCALE_Y;

    public View(Context context) {
        this.mContext = context;
        this.mResources = context != null ? context.getResources() : null;
        this.mViewFlags = 0x18000000;
        this.mPrivateFlags2 = 140296;
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.setOverScrollMode(1);
        this.mUserPaddingStart = Integer.MIN_VALUE;
        this.mUserPaddingEnd = Integer.MIN_VALUE;
    }

    public View(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public View(Context context, AttributeSet attrs, int defStyle) {
        this(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        Drawable background = null;
        int leftPadding = -1;
        int topPadding = -1;
        int rightPadding = -1;
        int bottomPadding = -1;
        int startPadding = Integer.MIN_VALUE;
        int endPadding = Integer.MIN_VALUE;
        int padding = -1;
        int viewFlagValues = 0;
        int viewFlagMasks = 0;
        boolean setScrollContainer = false;
        int x = 0;
        int y = 0;
        float tx = 0.0f;
        float ty = 0.0f;
        float rotation = 0.0f;
        float rotationX = 0.0f;
        float rotationY = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        boolean transformSet = false;
        int scrollbarStyle = 0;
        int overScrollMode = this.mOverScrollMode;
        boolean initializeScrollbars = false;
        boolean leftPaddingDefined = false;
        boolean rightPaddingDefined = false;
        boolean startPaddingDefined = false;
        boolean endPaddingDefined = false;
        int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        int N = a.getIndexCount();
        block59: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 12: {
                    background = a.getDrawable(attr2);
                    continue block59;
                }
                case 13: {
                    this.mUserPaddingLeftInitial = padding = a.getDimensionPixelSize(attr2, -1);
                    this.mUserPaddingRightInitial = padding;
                    leftPaddingDefined = true;
                    rightPaddingDefined = true;
                    continue block59;
                }
                case 14: {
                    this.mUserPaddingLeftInitial = leftPadding = a.getDimensionPixelSize(attr2, -1);
                    leftPaddingDefined = true;
                    continue block59;
                }
                case 15: {
                    topPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block59;
                }
                case 16: {
                    this.mUserPaddingRightInitial = rightPadding = a.getDimensionPixelSize(attr2, -1);
                    rightPaddingDefined = true;
                    continue block59;
                }
                case 17: {
                    bottomPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block59;
                }
                case 65: {
                    startPadding = a.getDimensionPixelSize(attr2, Integer.MIN_VALUE);
                    startPaddingDefined = true;
                    continue block59;
                }
                case 66: {
                    endPadding = a.getDimensionPixelSize(attr2, Integer.MIN_VALUE);
                    endPaddingDefined = true;
                    continue block59;
                }
                case 10: {
                    x = a.getDimensionPixelOffset(attr2, 0);
                    continue block59;
                }
                case 11: {
                    y = a.getDimensionPixelOffset(attr2, 0);
                    continue block59;
                }
                case 47: {
                    this.setAlpha(a.getFloat(attr2, 1.0f));
                    continue block59;
                }
                case 48: {
                    this.setPivotX(a.getDimensionPixelOffset(attr2, 0));
                    continue block59;
                }
                case 49: {
                    this.setPivotY(a.getDimensionPixelOffset(attr2, 0));
                    continue block59;
                }
                case 50: {
                    tx = a.getDimensionPixelOffset(attr2, 0);
                    transformSet = true;
                    continue block59;
                }
                case 51: {
                    ty = a.getDimensionPixelOffset(attr2, 0);
                    transformSet = true;
                    continue block59;
                }
                case 54: {
                    rotation = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block59;
                }
                case 55: {
                    rotationX = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block59;
                }
                case 56: {
                    rotationY = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block59;
                }
                case 52: {
                    sx = a.getFloat(attr2, 1.0f);
                    transformSet = true;
                    continue block59;
                }
                case 53: {
                    sy = a.getFloat(attr2, 1.0f);
                    transformSet = true;
                    continue block59;
                }
                case 8: {
                    this.mID = a.getResourceId(attr2, -1);
                    continue block59;
                }
                case 9: {
                    this.mTag = a.getText(attr2);
                    continue block59;
                }
                case 21: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 2;
                    viewFlagMasks |= 2;
                    continue block59;
                }
                case 18: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 1;
                    viewFlagMasks |= 1;
                    continue block59;
                }
                case 19: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 0x40001;
                    viewFlagMasks |= 0x40001;
                    continue block59;
                }
                case 29: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 0x4000;
                    viewFlagMasks |= 0x4000;
                    continue block59;
                }
                case 30: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 0x200000;
                    viewFlagMasks |= 0x200000;
                    continue block59;
                }
                case 31: {
                    if (a.getBoolean(attr2, true)) continue block59;
                    viewFlagValues |= 0x10000;
                    viewFlagMasks |= 0x10000;
                    continue block59;
                }
                case 33: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 0x400000;
                    viewFlagMasks |= 0x400000;
                    continue block59;
                }
                case 20: {
                    int visibility = a.getInt(attr2, 0);
                    if (visibility == 0) continue block59;
                    viewFlagValues |= VISIBILITY_FLAGS[visibility];
                    viewFlagMasks |= 0xC;
                    continue block59;
                }
                case 64: {
                    this.mPrivateFlags2 &= 0xFFFFFFC3;
                    int layoutDirection = a.getInt(attr2, -1);
                    int value = layoutDirection != -1 ? LAYOUT_DIRECTION_FLAGS[layoutDirection] : 2;
                    this.mPrivateFlags2 |= value << 2;
                    continue block59;
                }
                case 32: {
                    int cacheQuality = a.getInt(attr2, 0);
                    if (cacheQuality == 0) continue block59;
                    viewFlagValues |= DRAWING_CACHE_QUALITY_FLAGS[cacheQuality];
                    viewFlagMasks |= 0x180000;
                    continue block59;
                }
                case 41: {
                    this.setContentDescription(a.getString(attr2));
                    continue block59;
                }
                case 67: {
                    this.setLabelFor(a.getResourceId(attr2, -1));
                    continue block59;
                }
                case 36: {
                    if (a.getBoolean(attr2, true)) continue block59;
                    viewFlagValues &= 0xF7FFFFFF;
                    viewFlagMasks |= 0x8000000;
                    continue block59;
                }
                case 39: {
                    if (a.getBoolean(attr2, true)) continue block59;
                    viewFlagValues &= 0xEFFFFFFF;
                    viewFlagMasks |= 0x10000000;
                    continue block59;
                }
                case 22: {
                    int scrollbars = a.getInt(attr2, 0);
                    if (scrollbars == 0) continue block59;
                    viewFlagValues |= scrollbars;
                    viewFlagMasks |= 0x300;
                    initializeScrollbars = true;
                    continue block59;
                }
                case 23: {
                    if (targetSdkVersion >= 14) continue block59;
                }
                case 60: {
                    int fadingEdge = a.getInt(attr2, 0);
                    if (fadingEdge == 0) continue block59;
                    viewFlagValues |= fadingEdge;
                    viewFlagMasks |= 0x3000;
                    this.initializeFadingEdge(a);
                    continue block59;
                }
                case 7: {
                    scrollbarStyle = a.getInt(attr2, 0);
                    if (scrollbarStyle == 0) continue block59;
                    viewFlagValues |= scrollbarStyle & 0x3000000;
                    viewFlagMasks |= 0x3000000;
                    continue block59;
                }
                case 38: {
                    setScrollContainer = true;
                    if (!a.getBoolean(attr2, false)) continue block59;
                    this.setScrollContainer(true);
                    continue block59;
                }
                case 37: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 0x4000000;
                    viewFlagMasks |= 0x4000000;
                    continue block59;
                }
                case 46: {
                    if (!a.getBoolean(attr2, false)) continue block59;
                    viewFlagValues |= 0x400;
                    viewFlagMasks |= 0x400;
                    continue block59;
                }
                case 25: {
                    this.mNextFocusLeftId = a.getResourceId(attr2, -1);
                    continue block59;
                }
                case 26: {
                    this.mNextFocusRightId = a.getResourceId(attr2, -1);
                    continue block59;
                }
                case 27: {
                    this.mNextFocusUpId = a.getResourceId(attr2, -1);
                    continue block59;
                }
                case 28: {
                    this.mNextFocusDownId = a.getResourceId(attr2, -1);
                    continue block59;
                }
                case 58: {
                    this.mNextFocusForwardId = a.getResourceId(attr2, -1);
                    continue block59;
                }
                case 34: {
                    this.mMinWidth = a.getDimensionPixelSize(attr2, 0);
                    continue block59;
                }
                case 35: {
                    this.mMinHeight = a.getDimensionPixelSize(attr2, 0);
                    continue block59;
                }
                case 40: {
                    if (context.isRestricted()) {
                        throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                    }
                    final String handlerName = a.getString(attr2);
                    if (handlerName == null) continue block59;
                    this.setOnClickListener(new OnClickListener(){
                        private Method mHandler;

                        public void onClick(View v) {
                            if (this.mHandler == null) {
                                try {
                                    this.mHandler = View.this.getContext().getClass().getMethod(handlerName, View.class);
                                }
                                catch (NoSuchMethodException e) {
                                    int id2 = View.this.getId();
                                    String idText = id2 == -1 ? "" : " with id '" + View.this.getContext().getResources().getResourceEntryName(id2) + "'";
                                    throw new IllegalStateException("Could not find a method " + handlerName + "(View) in the activity " + View.this.getContext().getClass() + " for onClick handler" + " on view " + View.this.getClass() + idText, e);
                                }
                            }
                            try {
                                this.mHandler.invoke((Object)View.this.getContext(), View.this);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalStateException("Could not execute non public method of the activity", e);
                            }
                            catch (InvocationTargetException e) {
                                throw new IllegalStateException("Could not execute method of the activity", e);
                            }
                        }
                    });
                    continue block59;
                }
                case 45: {
                    overScrollMode = a.getInt(attr2, 1);
                    continue block59;
                }
                case 57: {
                    this.mVerticalScrollbarPosition = a.getInt(attr2, 0);
                    continue block59;
                }
                case 59: {
                    this.setLayerType(a.getInt(attr2, 0), null);
                    continue block59;
                }
                case 62: {
                    this.mPrivateFlags2 &= 0xFFFFFE3F;
                    int textDirection = a.getInt(attr2, -1);
                    if (textDirection == -1) continue block59;
                    this.mPrivateFlags2 |= PFLAG2_TEXT_DIRECTION_FLAGS[textDirection];
                    continue block59;
                }
                case 63: {
                    this.mPrivateFlags2 &= 0xFFFF1FFF;
                    int textAlignment = a.getInt(attr2, 1);
                    this.mPrivateFlags2 |= PFLAG2_TEXT_ALIGNMENT_FLAGS[textAlignment];
                    continue block59;
                }
                case 61: {
                    this.setImportantForAccessibility(a.getInt(attr2, 0));
                }
            }
        }
        this.setOverScrollMode(overScrollMode);
        this.mUserPaddingStart = startPadding;
        this.mUserPaddingEnd = endPadding;
        if (background != null) {
            this.setBackground(background);
        }
        if (padding >= 0) {
            leftPadding = padding;
            topPadding = padding;
            rightPadding = padding;
            bottomPadding = padding;
            this.mUserPaddingLeftInitial = padding;
            this.mUserPaddingRightInitial = padding;
        }
        if (this.isRtlCompatibilityMode()) {
            if (!leftPaddingDefined && startPaddingDefined) {
                leftPadding = startPadding;
            }
            int n = this.mUserPaddingLeftInitial = leftPadding >= 0 ? leftPadding : this.mUserPaddingLeftInitial;
            if (!rightPaddingDefined && endPaddingDefined) {
                rightPadding = endPadding;
            }
            this.mUserPaddingRightInitial = rightPadding >= 0 ? rightPadding : this.mUserPaddingRightInitial;
        } else {
            if (leftPaddingDefined) {
                this.mUserPaddingLeftInitial = leftPadding;
            }
            if (rightPaddingDefined) {
                this.mUserPaddingRightInitial = rightPadding;
            }
        }
        this.internalSetPadding(this.mUserPaddingLeftInitial, topPadding >= 0 ? topPadding : this.mPaddingTop, this.mUserPaddingRightInitial, bottomPadding >= 0 ? bottomPadding : this.mPaddingBottom);
        if (viewFlagMasks != 0) {
            this.setFlags(viewFlagValues, viewFlagMasks);
        }
        if (initializeScrollbars) {
            this.initializeScrollbars(a);
        }
        a.recycle();
        if (scrollbarStyle != 0) {
            this.recomputePadding();
        }
        if (x != 0 || y != 0) {
            this.scrollTo(x, y);
        }
        if (transformSet) {
            this.setTranslationX(tx);
            this.setTranslationY(ty);
            this.setRotation(rotation);
            this.setRotationX(rotationX);
            this.setRotationY(rotationY);
            this.setScaleX(sx);
            this.setScaleY(sy);
        }
        if (!setScrollContainer && (viewFlagValues & 0x200) != 0) {
            this.setScrollContainer(true);
        }
        this.computeOpaqueFlags();
    }

    View() {
        this.mResources = null;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append(this.getClass().getName());
        out.append('{');
        out.append(Integer.toHexString(System.identityHashCode(this)));
        out.append(' ');
        switch (this.mViewFlags & 0xC) {
            case 0: {
                out.append('V');
                break;
            }
            case 4: {
                out.append('I');
                break;
            }
            case 8: {
                out.append('G');
                break;
            }
            default: {
                out.append('.');
            }
        }
        out.append((this.mViewFlags & 1) == 1 ? (char)'F' : '.');
        out.append((this.mViewFlags & 0x20) == 0 ? (char)'E' : '.');
        out.append((this.mViewFlags & 0x80) == 128 ? (char)'.' : 'D');
        out.append((this.mViewFlags & 0x100) != 0 ? (char)'H' : '.');
        out.append((this.mViewFlags & 0x200) != 0 ? (char)'V' : '.');
        out.append((this.mViewFlags & 0x4000) != 0 ? (char)'C' : '.');
        out.append((this.mViewFlags & 0x200000) != 0 ? (char)'L' : '.');
        out.append(' ');
        out.append((this.mPrivateFlags & 8) != 0 ? (char)'R' : '.');
        out.append((this.mPrivateFlags & 2) != 0 ? (char)'F' : '.');
        out.append((this.mPrivateFlags & 4) != 0 ? (char)'S' : '.');
        if ((this.mPrivateFlags & 0x2000000) != 0) {
            out.append('p');
        } else {
            out.append((this.mPrivateFlags & 0x4000) != 0 ? (char)'P' : '.');
        }
        out.append((this.mPrivateFlags & 0x10000000) != 0 ? (char)'H' : '.');
        out.append((this.mPrivateFlags & 0x40000000) != 0 ? (char)'A' : '.');
        out.append((this.mPrivateFlags & Integer.MIN_VALUE) != 0 ? (char)'I' : '.');
        out.append((this.mPrivateFlags & 0x600000) != 0 ? (char)'D' : '.');
        out.append(' ');
        out.append(this.mLeft);
        out.append(',');
        out.append(this.mTop);
        out.append('-');
        out.append(this.mRight);
        out.append(',');
        out.append(this.mBottom);
        int id2 = this.getId();
        if (id2 != -1) {
            out.append(" #");
            out.append(Integer.toHexString(id2));
            Resources r = this.mResources;
            if (id2 != 0 && r != null) {
                try {
                    String pkgname;
                    switch (id2 & 0xFF000000) {
                        case 0x7F000000: {
                            pkgname = "app";
                            break;
                        }
                        case 0x1000000: {
                            pkgname = "android";
                            break;
                        }
                        default: {
                            pkgname = r.getResourcePackageName(id2);
                        }
                    }
                    String typename = r.getResourceTypeName(id2);
                    String entryname = r.getResourceEntryName(id2);
                    out.append(" ");
                    out.append(pkgname);
                    out.append(":");
                    out.append(typename);
                    out.append("/");
                    out.append(entryname);
                }
                catch (Resources.NotFoundException e) {
                    // empty catch block
                }
            }
        }
        out.append("}");
        return out.toString();
    }

    protected void initializeFadingEdge(TypedArray a) {
        this.initScrollCache();
        this.mScrollCache.fadingEdgeLength = a.getDimensionPixelSize(24, ViewConfiguration.get(this.mContext).getScaledFadingEdgeLength());
    }

    public int getVerticalFadingEdgeLength() {
        ScrollabilityCache cache;
        if (this.isVerticalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public void setFadingEdgeLength(int length) {
        this.initScrollCache();
        this.mScrollCache.fadingEdgeLength = length;
    }

    public int getHorizontalFadingEdgeLength() {
        ScrollabilityCache cache;
        if (this.isHorizontalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public int getVerticalScrollbarWidth() {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBarDrawable scrollBar = cache.scrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(true);
                if (size <= 0) {
                    size = cache.scrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    protected int getHorizontalScrollbarHeight() {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBarDrawable scrollBar = cache.scrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(false);
                if (size <= 0) {
                    size = cache.scrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    protected void initializeScrollbars(TypedArray a) {
        boolean alwaysDraw;
        boolean fadeScrollbars;
        this.initScrollCache();
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        if (scrollabilityCache.scrollBar == null) {
            scrollabilityCache.scrollBar = new ScrollBarDrawable();
        }
        if (!(fadeScrollbars = a.getBoolean(44, true))) {
            scrollabilityCache.state = 1;
        }
        scrollabilityCache.fadeScrollBars = fadeScrollbars;
        scrollabilityCache.scrollBarFadeDuration = a.getInt(42, ViewConfiguration.getScrollBarFadeDuration());
        scrollabilityCache.scrollBarDefaultDelayBeforeFade = a.getInt(43, ViewConfiguration.getScrollDefaultDelay());
        scrollabilityCache.scrollBarSize = a.getDimensionPixelSize(0, ViewConfiguration.get(this.mContext).getScaledScrollBarSize());
        Drawable track = a.getDrawable(3);
        scrollabilityCache.scrollBar.setHorizontalTrackDrawable(track);
        Drawable thumb = a.getDrawable(1);
        if (thumb != null) {
            scrollabilityCache.scrollBar.setHorizontalThumbDrawable(thumb);
        }
        if (alwaysDraw = a.getBoolean(5, false)) {
            scrollabilityCache.scrollBar.setAlwaysDrawHorizontalTrack(true);
        }
        track = a.getDrawable(4);
        scrollabilityCache.scrollBar.setVerticalTrackDrawable(track);
        thumb = a.getDrawable(2);
        if (thumb != null) {
            scrollabilityCache.scrollBar.setVerticalThumbDrawable(thumb);
        }
        if (alwaysDraw = a.getBoolean(6, false)) {
            scrollabilityCache.scrollBar.setAlwaysDrawVerticalTrack(true);
        }
        int layoutDirection = this.getLayoutDirection();
        if (track != null) {
            track.setLayoutDirection(layoutDirection);
        }
        if (thumb != null) {
            thumb.setLayoutDirection(layoutDirection);
        }
        this.resolvePadding();
    }

    private void initScrollCache() {
        if (this.mScrollCache == null) {
            this.mScrollCache = new ScrollabilityCache(ViewConfiguration.get(this.mContext), this);
        }
    }

    private ScrollabilityCache getScrollCache() {
        this.initScrollCache();
        return this.mScrollCache;
    }

    public void setVerticalScrollbarPosition(int position) {
        if (this.mVerticalScrollbarPosition != position) {
            this.mVerticalScrollbarPosition = position;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    public int getVerticalScrollbarPosition() {
        return this.mVerticalScrollbarPosition;
    }

    ListenerInfo getListenerInfo() {
        if (this.mListenerInfo != null) {
            return this.mListenerInfo;
        }
        this.mListenerInfo = new ListenerInfo();
        return this.mListenerInfo;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.getListenerInfo().mOnFocusChangeListener = l;
    }

    public void addOnLayoutChangeListener(OnLayoutChangeListener listener) {
        ListenerInfo li = this.getListenerInfo();
        if (li.mOnLayoutChangeListeners == null) {
            li.mOnLayoutChangeListeners = new ArrayList();
        }
        if (!li.mOnLayoutChangeListeners.contains(listener)) {
            li.mOnLayoutChangeListeners.add(listener);
        }
    }

    public void removeOnLayoutChangeListener(OnLayoutChangeListener listener) {
        ListenerInfo li = this.mListenerInfo;
        if (li == null || li.mOnLayoutChangeListeners == null) {
            return;
        }
        li.mOnLayoutChangeListeners.remove(listener);
    }

    public void addOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
        ListenerInfo li = this.getListenerInfo();
        if (li.mOnAttachStateChangeListeners == null) {
            li.mOnAttachStateChangeListeners = new CopyOnWriteArrayList();
        }
        li.mOnAttachStateChangeListeners.add(listener);
    }

    public void removeOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
        ListenerInfo li = this.mListenerInfo;
        if (li == null || li.mOnAttachStateChangeListeners == null) {
            return;
        }
        li.mOnAttachStateChangeListeners.remove(listener);
    }

    public OnFocusChangeListener getOnFocusChangeListener() {
        ListenerInfo li = this.mListenerInfo;
        return li != null ? li.mOnFocusChangeListener : null;
    }

    public void setOnClickListener(OnClickListener l) {
        if (!this.isClickable()) {
            this.setClickable(true);
        }
        this.getListenerInfo().mOnClickListener = l;
    }

    public boolean hasOnClickListeners() {
        ListenerInfo li = this.mListenerInfo;
        return li != null && li.mOnClickListener != null;
    }

    public void setOnLongClickListener(OnLongClickListener l) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.getListenerInfo().mOnLongClickListener = l;
    }

    public void setOnCreateContextMenuListener(OnCreateContextMenuListener l) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.getListenerInfo().mOnCreateContextMenuListener = l;
    }

    public boolean performClick() {
        this.sendAccessibilityEvent(1);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnClickListener != null) {
            this.playSoundEffect(0);
            li.mOnClickListener.onClick(this);
            return true;
        }
        return false;
    }

    public boolean callOnClick() {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnClickListener != null) {
            li.mOnClickListener.onClick(this);
            return true;
        }
        return false;
    }

    public boolean performLongClick() {
        this.sendAccessibilityEvent(2);
        boolean handled = false;
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnLongClickListener != null) {
            handled = li.mOnLongClickListener.onLongClick(this);
        }
        if (!handled) {
            handled = this.showContextMenu();
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    protected boolean performButtonActionOnTouchDown(MotionEvent event) {
        return (event.getButtonState() & 2) != 0 && this.showContextMenu(event.getX(), event.getY(), event.getMetaState());
    }

    public boolean showContextMenu() {
        return this.getParent().showContextMenuForChild(this);
    }

    public boolean showContextMenu(float x, float y, int metaState) {
        return this.showContextMenu();
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.startActionModeForChild(this, callback);
    }

    public void setOnKeyListener(OnKeyListener l) {
        this.getListenerInfo().mOnKeyListener = l;
    }

    public void setOnTouchListener(OnTouchListener l) {
        this.getListenerInfo().mOnTouchListener = l;
    }

    public void setOnGenericMotionListener(OnGenericMotionListener l) {
        this.getListenerInfo().mOnGenericMotionListener = l;
    }

    public void setOnHoverListener(OnHoverListener l) {
        this.getListenerInfo().mOnHoverListener = l;
    }

    public void setOnDragListener(OnDragListener l) {
        this.getListenerInfo().mOnDragListener = l;
    }

    void handleFocusGainInternal(int direction, Rect previouslyFocusedRect) {
        if ((this.mPrivateFlags & 2) == 0) {
            this.mPrivateFlags |= 2;
            if (this.mParent != null) {
                this.mParent.requestChildFocus(this, this);
            }
            this.onFocusChanged(true, direction, previouslyFocusedRect);
            this.refreshDrawableState();
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.notifyAccessibilityStateChanged();
            }
        }
    }

    public boolean requestRectangleOnScreen(Rect rectangle) {
        return this.requestRectangleOnScreen(rectangle, false);
    }

    public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
        if (this.mParent == null) {
            return false;
        }
        View child = this;
        RectF position = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformRect : new RectF();
        position.set(rectangle);
        ViewParent parent = this.mParent;
        boolean scrolled = false;
        while (parent != null) {
            rectangle.set((int)position.left, (int)position.top, (int)position.right, (int)position.bottom);
            scrolled |= parent.requestChildRectangleOnScreen(child, rectangle, immediate);
            if (!child.hasIdentityMatrix()) {
                child.getMatrix().mapRect(position);
            }
            position.offset(child.mLeft, child.mTop);
            if (!(parent instanceof View)) break;
            View parentView = (View)((Object)parent);
            position.offset(-parentView.getScrollX(), -parentView.getScrollY());
            child = parentView;
            parent = child.getParent();
        }
        return scrolled;
    }

    public void clearFocus() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            if (this.mParent != null) {
                this.mParent.clearChildFocus(this);
            }
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
            this.ensureInputFocusOnFirstFocusable();
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.notifyAccessibilityStateChanged();
            }
        }
    }

    void ensureInputFocusOnFirstFocusable() {
        View root = this.getRootView();
        if (root != null) {
            root.requestFocus();
        }
    }

    void unFocus() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.notifyAccessibilityStateChanged();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public boolean hasFocusable() {
        return (this.mViewFlags & 0xC) == 0 && this.isFocusable();
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus && AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.sendAccessibilityEvent(8);
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (!gainFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            if (imm != null && this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus) {
                imm.focusOut(this);
            }
            this.onFocusLost();
        } else if (imm != null && this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus) {
            imm.focusIn(this);
        }
        this.invalidate(true);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnFocusChangeListener != null) {
            li.mOnFocusChangeListener.onFocusChange(this, gainFocus);
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mKeyDispatchState.reset(this);
        }
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.sendAccessibilityEvent(this, eventType);
        } else {
            this.sendAccessibilityEventInternal(eventType);
        }
    }

    public void announceForAccessibility(CharSequence text) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled() && this.mParent != null) {
            AccessibilityEvent event = AccessibilityEvent.obtain(16384);
            this.onInitializeAccessibilityEvent(event);
            event.getText().add(text);
            event.setContentDescription(null);
            this.mParent.requestSendAccessibilityEvent(this, event);
        }
    }

    void sendAccessibilityEventInternal(int eventType) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.sendAccessibilityEventUnchecked(AccessibilityEvent.obtain(eventType));
        }
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.sendAccessibilityEventUnchecked(this, event);
        } else {
            this.sendAccessibilityEventUncheckedInternal(event);
        }
    }

    void sendAccessibilityEventUncheckedInternal(AccessibilityEvent event) {
        if (!this.isShown()) {
            return;
        }
        this.onInitializeAccessibilityEvent(event);
        if ((event.getEventType() & 0x2A1BF) != 0) {
            this.dispatchPopulateAccessibilityEvent(event);
        }
        this.getParent().requestSendAccessibilityEvent(this, event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.dispatchPopulateAccessibilityEvent(this, event);
        }
        return this.dispatchPopulateAccessibilityEventInternal(event);
    }

    boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return false;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.onPopulateAccessibilityEvent(this, event);
        } else {
            this.onPopulateAccessibilityEventInternal(event);
        }
    }

    void onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.onInitializeAccessibilityEvent(this, event);
        } else {
            this.onInitializeAccessibilityEventInternal(event);
        }
    }

    void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        event.setSource(this);
        event.setClassName(View.class.getName());
        event.setPackageName(this.getContext().getPackageName());
        event.setEnabled(this.isEnabled());
        event.setContentDescription(this.mContentDescription);
        if (event.getEventType() == 8 && this.mAttachInfo != null) {
            ArrayList<View> focusablesTempList = this.mAttachInfo.mTempArrayList;
            this.getRootView().addFocusables(focusablesTempList, 2, 0);
            event.setItemCount(focusablesTempList.size());
            event.setCurrentItemIndex(focusablesTempList.indexOf(this));
            focusablesTempList.clear();
        }
    }

    public AccessibilityNodeInfo createAccessibilityNodeInfo() {
        AccessibilityNodeProvider provider = this.getAccessibilityNodeProvider();
        if (provider != null) {
            return provider.createAccessibilityNodeInfo(-1);
        }
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain(this);
        this.onInitializeAccessibilityNodeInfo(info);
        return info;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.onInitializeAccessibilityNodeInfo(this, info);
        } else {
            this.onInitializeAccessibilityNodeInfoInternal(info);
        }
    }

    void getBoundsOnScreen(Rect outRect) {
        if (this.mAttachInfo == null) {
            return;
        }
        RectF position = this.mAttachInfo.mTmpTransformRect;
        position.set(0.0f, 0.0f, this.mRight - this.mLeft, this.mBottom - this.mTop);
        if (!this.hasIdentityMatrix()) {
            this.getMatrix().mapRect(position);
        }
        position.offset(this.mLeft, this.mTop);
        ViewParent parent = this.mParent;
        while (parent instanceof View) {
            View parentView = (View)((Object)parent);
            position.offset(-parentView.mScrollX, -parentView.mScrollY);
            if (!parentView.hasIdentityMatrix()) {
                parentView.getMatrix().mapRect(position);
            }
            position.offset(parentView.mLeft, parentView.mTop);
            parent = parentView.mParent;
        }
        if (parent instanceof ViewRootImpl) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)parent;
            position.offset(0.0f, -viewRootImpl.mCurScrollY);
        }
        position.offset(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
        outRect.set((int)(position.left + 0.5f), (int)(position.top + 0.5f), (int)(position.right + 0.5f), (int)(position.bottom + 0.5f));
    }

    void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        View rootView;
        Rect bounds = this.mAttachInfo.mTmpInvalRect;
        this.getDrawingRect(bounds);
        info.setBoundsInParent(bounds);
        this.getBoundsOnScreen(bounds);
        info.setBoundsInScreen(bounds);
        ViewParent parent = this.getParentForAccessibility();
        if (parent instanceof View) {
            info.setParent((View)((Object)parent));
        }
        if (this.mID != -1) {
            View label;
            rootView = this.getRootView();
            if (rootView == null) {
                rootView = this;
            }
            if ((label = rootView.findLabelForView(this, this.mID)) != null) {
                info.setLabeledBy(label);
            }
        }
        if (this.mLabelForId != -1) {
            View labeled;
            rootView = this.getRootView();
            if (rootView == null) {
                rootView = this;
            }
            if ((labeled = rootView.findViewInsideOutShouldExist(this, this.mLabelForId)) != null) {
                info.setLabelFor(labeled);
            }
        }
        info.setVisibleToUser(this.isVisibleToUser());
        info.setPackageName(this.mContext.getPackageName());
        info.setClassName(View.class.getName());
        info.setContentDescription(this.getContentDescription());
        info.setEnabled(this.isEnabled());
        info.setClickable(this.isClickable());
        info.setFocusable(this.isFocusable());
        info.setFocused(this.isFocused());
        info.setAccessibilityFocused(this.isAccessibilityFocused());
        info.setSelected(this.isSelected());
        info.setLongClickable(this.isLongClickable());
        info.addAction(4);
        info.addAction(8);
        if (this.isFocusable()) {
            if (this.isFocused()) {
                info.addAction(2);
            } else {
                info.addAction(1);
            }
        }
        if (!this.isAccessibilityFocused()) {
            info.addAction(64);
        } else {
            info.addAction(128);
        }
        if (this.isClickable() && this.isEnabled()) {
            info.addAction(16);
        }
        if (this.isLongClickable() && this.isEnabled()) {
            info.addAction(32);
        }
        if (this.mContentDescription != null && this.mContentDescription.length() > 0) {
            info.addAction(256);
            info.addAction(512);
            info.setMovementGranularities(11);
        }
    }

    private View findLabelForView(View view, int labeledId) {
        if (this.mMatchLabelForPredicate == null) {
            this.mMatchLabelForPredicate = new MatchLabelForPredicate();
        }
        this.mMatchLabelForPredicate.mLabeledId = labeledId;
        return this.findViewByPredicateInsideOut(view, this.mMatchLabelForPredicate);
    }

    protected boolean isVisibleToUser() {
        return this.isVisibleToUser(null);
    }

    protected boolean isVisibleToUser(Rect boundInView) {
        if (this.mAttachInfo != null) {
            if (this.mAttachInfo.mWindowVisibility != 0) {
                return false;
            }
            Object current = this;
            while (current instanceof View) {
                Object view = current;
                if (((View)view).getAlpha() <= 0.0f || ((View)view).getVisibility() != 0) {
                    return false;
                }
                current = ((View)view).mParent;
            }
            Rect visibleRect = this.mAttachInfo.mTmpInvalRect;
            Point offset = this.mAttachInfo.mPoint;
            if (!this.getGlobalVisibleRect(visibleRect, offset)) {
                return false;
            }
            if (boundInView != null) {
                visibleRect.offset(-offset.x, -offset.y);
                return boundInView.intersect(visibleRect);
            }
            return true;
        }
        return false;
    }

    public AccessibilityDelegate getAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public void setAccessibilityDelegate(AccessibilityDelegate delegate) {
        this.mAccessibilityDelegate = delegate;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.getAccessibilityNodeProvider(this);
        }
        return null;
    }

    public int getAccessibilityViewId() {
        if (this.mAccessibilityViewId == -1) {
            this.mAccessibilityViewId = sNextAccessibilityViewId++;
        }
        return this.mAccessibilityViewId;
    }

    public int getAccessibilityWindowId() {
        return this.mAttachInfo != null ? this.mAttachInfo.mAccessibilityWindowId : -1;
    }

    @ViewDebug.ExportedProperty(category="accessibility")
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @RemotableViewMethod
    public void setContentDescription(CharSequence contentDescription) {
        boolean nonEmptyDesc;
        if (this.mContentDescription == null ? contentDescription == null : this.mContentDescription.equals(contentDescription)) {
            return;
        }
        this.mContentDescription = contentDescription;
        boolean bl = nonEmptyDesc = contentDescription != null && contentDescription.length() > 0;
        if (nonEmptyDesc && this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.notifyAccessibilityStateChanged();
    }

    @ViewDebug.ExportedProperty(category="accessibility")
    public int getLabelFor() {
        return this.mLabelForId;
    }

    @RemotableViewMethod
    public void setLabelFor(int id2) {
        this.mLabelForId = id2;
        if (this.mLabelForId != -1 && this.mID == -1) {
            this.mID = View.generateViewId();
        }
    }

    protected void onFocusLost() {
        this.resetPressedState();
    }

    private void resetPressedState() {
        if ((this.mViewFlags & 0x20) == 32) {
            return;
        }
        if (this.isPressed()) {
            this.setPressed(false);
            if (!this.mHasPerformedLongPress) {
                this.removeLongPressCallback();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean isFocused() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public View findFocus() {
        return (this.mPrivateFlags & 2) != 0 ? this : null;
    }

    public boolean isScrollContainer() {
        return (this.mPrivateFlags & 0x100000) != 0;
    }

    public void setScrollContainer(boolean isScrollContainer) {
        if (isScrollContainer) {
            if (this.mAttachInfo != null && (this.mPrivateFlags & 0x100000) == 0) {
                this.mAttachInfo.mScrollContainers.add(this);
                this.mPrivateFlags |= 0x100000;
            }
            this.mPrivateFlags |= 0x80000;
        } else {
            if ((this.mPrivateFlags & 0x100000) != 0) {
                this.mAttachInfo.mScrollContainers.remove(this);
            }
            this.mPrivateFlags &= 0xFFE7FFFF;
        }
    }

    public int getDrawingCacheQuality() {
        return this.mViewFlags & 0x180000;
    }

    public void setDrawingCacheQuality(int quality) {
        this.setFlags(quality, 0x180000);
    }

    public boolean getKeepScreenOn() {
        return (this.mViewFlags & 0x4000000) != 0;
    }

    public void setKeepScreenOn(boolean keepScreenOn) {
        this.setFlags(keepScreenOn ? 0x4000000 : 0, 0x4000000);
    }

    public int getNextFocusLeftId() {
        return this.mNextFocusLeftId;
    }

    public void setNextFocusLeftId(int nextFocusLeftId) {
        this.mNextFocusLeftId = nextFocusLeftId;
    }

    public int getNextFocusRightId() {
        return this.mNextFocusRightId;
    }

    public void setNextFocusRightId(int nextFocusRightId) {
        this.mNextFocusRightId = nextFocusRightId;
    }

    public int getNextFocusUpId() {
        return this.mNextFocusUpId;
    }

    public void setNextFocusUpId(int nextFocusUpId) {
        this.mNextFocusUpId = nextFocusUpId;
    }

    public int getNextFocusDownId() {
        return this.mNextFocusDownId;
    }

    public void setNextFocusDownId(int nextFocusDownId) {
        this.mNextFocusDownId = nextFocusDownId;
    }

    public int getNextFocusForwardId() {
        return this.mNextFocusForwardId;
    }

    public void setNextFocusForwardId(int nextFocusForwardId) {
        this.mNextFocusForwardId = nextFocusForwardId;
    }

    public boolean isShown() {
        ViewParent parent;
        View current = this;
        do {
            if ((current.mViewFlags & 0xC) != 0) {
                return false;
            }
            parent = current.mParent;
            if (parent == null) {
                return false;
            }
            if (parent instanceof View) continue;
            return true;
        } while ((current = (View)((Object)parent)) != null);
        return false;
    }

    protected boolean fitSystemWindows(Rect insets) {
        if ((this.mViewFlags & 2) == 2) {
            this.mUserPaddingStart = Integer.MIN_VALUE;
            this.mUserPaddingEnd = Integer.MIN_VALUE;
            if ((this.mViewFlags & 0x800) == 0 || this.mAttachInfo == null || (this.mAttachInfo.mSystemUiVisibility & 0x600) == 0) {
                this.internalSetPadding(insets.left, insets.top, insets.right, insets.bottom);
                return true;
            }
            this.internalSetPadding(0, 0, 0, 0);
            return false;
        }
        return false;
    }

    public void setFitsSystemWindows(boolean fitSystemWindows) {
        this.setFlags(fitSystemWindows ? 2 : 0, 2);
    }

    public boolean getFitsSystemWindows() {
        return (this.mViewFlags & 2) == 2;
    }

    public boolean fitsSystemWindows() {
        return this.getFitsSystemWindows();
    }

    public void requestFitSystemWindows() {
        if (this.mParent != null) {
            this.mParent.requestFitSystemWindows();
        }
    }

    public void makeOptionalFitsSystemWindows() {
        this.setFlags(2048, 2048);
    }

    @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=0, to="VISIBLE"), @ViewDebug.IntToString(from=4, to="INVISIBLE"), @ViewDebug.IntToString(from=8, to="GONE")})
    public int getVisibility() {
        return this.mViewFlags & 0xC;
    }

    @RemotableViewMethod
    public void setVisibility(int visibility) {
        this.setFlags(visibility, 12);
        if (this.mBackground != null) {
            this.mBackground.setVisible(visibility == 0, false);
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isEnabled() {
        return (this.mViewFlags & 0x20) == 0;
    }

    @RemotableViewMethod
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.setFlags(enabled ? 0 : 32, 32);
        this.refreshDrawableState();
        this.invalidate(true);
    }

    public void setFocusable(boolean focusable) {
        if (!focusable) {
            this.setFlags(0, 262144);
        }
        this.setFlags(focusable ? 1 : 0, 1);
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        this.setFlags(focusableInTouchMode ? 262144 : 0, 262144);
        if (focusableInTouchMode) {
            this.setFlags(1, 1);
        }
    }

    public void setSoundEffectsEnabled(boolean soundEffectsEnabled) {
        this.setFlags(soundEffectsEnabled ? 0x8000000 : 0, 0x8000000);
    }

    @ViewDebug.ExportedProperty
    public boolean isSoundEffectsEnabled() {
        return 0x8000000 == (this.mViewFlags & 0x8000000);
    }

    public void setHapticFeedbackEnabled(boolean hapticFeedbackEnabled) {
        this.setFlags(hapticFeedbackEnabled ? 0x10000000 : 0, 0x10000000);
    }

    @ViewDebug.ExportedProperty
    public boolean isHapticFeedbackEnabled() {
        return 0x10000000 == (this.mViewFlags & 0x10000000);
    }

    @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=0, to="LTR"), @ViewDebug.IntToString(from=1, to="RTL"), @ViewDebug.IntToString(from=2, to="INHERIT"), @ViewDebug.IntToString(from=3, to="LOCALE")})
    public int getRawLayoutDirection() {
        return (this.mPrivateFlags2 & 0xC) >> 2;
    }

    @RemotableViewMethod
    public void setLayoutDirection(int layoutDirection) {
        if (this.getRawLayoutDirection() != layoutDirection) {
            this.mPrivateFlags2 &= 0xFFFFFFF3;
            this.resetRtlProperties();
            this.mPrivateFlags2 |= layoutDirection << 2 & 0xC;
            this.resolveRtlPropertiesIfNeeded();
            this.requestLayout();
            this.invalidate(true);
        }
    }

    @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=0, to="RESOLVED_DIRECTION_LTR"), @ViewDebug.IntToString(from=1, to="RESOLVED_DIRECTION_RTL")})
    public int getLayoutDirection() {
        int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion < 17) {
            this.mPrivateFlags2 |= 0x20;
            return 0;
        }
        return (this.mPrivateFlags2 & 0x10) == 16 ? 1 : 0;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public boolean isLayoutRtl() {
        return this.getLayoutDirection() == 1;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public boolean hasTransientState() {
        return (this.mPrivateFlags2 & 0x400000) == 0x400000;
    }

    public void setHasTransientState(boolean hasTransientState) {
        int n = this.mTransientStateCount = hasTransientState ? this.mTransientStateCount + 1 : this.mTransientStateCount - 1;
        if (this.mTransientStateCount < 0) {
            this.mTransientStateCount = 0;
            Log.e(VIEW_LOG_TAG, "hasTransientState decremented below 0: unmatched pair of setHasTransientState calls");
        }
        if (hasTransientState && this.mTransientStateCount == 1 || !hasTransientState && this.mTransientStateCount == 0) {
            this.mPrivateFlags2 = this.mPrivateFlags2 & 0xFFBFFFFF | (hasTransientState ? 0x400000 : 0);
            if (this.mParent != null) {
                try {
                    this.mParent.childHasTransientStateChanged(this, hasTransientState);
                }
                catch (AbstractMethodError e) {
                    Log.e(VIEW_LOG_TAG, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", e);
                }
            }
        }
    }

    public void setWillNotDraw(boolean willNotDraw) {
        this.setFlags(willNotDraw ? 128 : 0, 128);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean willNotDraw() {
        return (this.mViewFlags & 0x80) == 128;
    }

    public void setWillNotCacheDrawing(boolean willNotCacheDrawing) {
        this.setFlags(willNotCacheDrawing ? 131072 : 0, 131072);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean willNotCacheDrawing() {
        return (this.mViewFlags & 0x20000) == 131072;
    }

    @ViewDebug.ExportedProperty
    public boolean isClickable() {
        return (this.mViewFlags & 0x4000) == 16384;
    }

    public void setClickable(boolean clickable) {
        this.setFlags(clickable ? 16384 : 0, 16384);
    }

    public boolean isLongClickable() {
        return (this.mViewFlags & 0x200000) == 0x200000;
    }

    public void setLongClickable(boolean longClickable) {
        this.setFlags(longClickable ? 0x200000 : 0, 0x200000);
    }

    public void setPressed(boolean pressed) {
        boolean needsRefresh;
        boolean bl = needsRefresh = pressed != ((this.mPrivateFlags & 0x4000) == 16384);
        this.mPrivateFlags = pressed ? (this.mPrivateFlags |= 0x4000) : (this.mPrivateFlags &= 0xFFFFBFFF);
        if (needsRefresh) {
            this.refreshDrawableState();
        }
        this.dispatchSetPressed(pressed);
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    public boolean isPressed() {
        return (this.mPrivateFlags & 0x4000) == 16384;
    }

    public boolean isSaveEnabled() {
        return (this.mViewFlags & 0x10000) != 65536;
    }

    public void setSaveEnabled(boolean enabled) {
        this.setFlags(enabled ? 0 : 65536, 65536);
    }

    @ViewDebug.ExportedProperty
    public boolean getFilterTouchesWhenObscured() {
        return (this.mViewFlags & 0x400) != 0;
    }

    public void setFilterTouchesWhenObscured(boolean enabled) {
        this.setFlags(enabled ? 0 : 1024, 1024);
    }

    public boolean isSaveFromParentEnabled() {
        return (this.mViewFlags & 0x20000000) != 0x20000000;
    }

    public void setSaveFromParentEnabled(boolean enabled) {
        this.setFlags(enabled ? 0 : 0x20000000, 0x20000000);
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean isFocusable() {
        return 1 == (this.mViewFlags & 1);
    }

    @ViewDebug.ExportedProperty
    public boolean isFocusableInTouchMode() {
        return 262144 == (this.mViewFlags & 0x40000);
    }

    public View focusSearch(int direction) {
        if (this.mParent != null) {
            return this.mParent.focusSearch(this, direction);
        }
        return null;
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        return false;
    }

    View findUserSetNextFocus(View root, int direction) {
        switch (direction) {
            case 17: {
                if (this.mNextFocusLeftId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusLeftId);
            }
            case 66: {
                if (this.mNextFocusRightId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusRightId);
            }
            case 33: {
                if (this.mNextFocusUpId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusUpId);
            }
            case 130: {
                if (this.mNextFocusDownId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusDownId);
            }
            case 2: {
                if (this.mNextFocusForwardId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusForwardId);
            }
            case 1: {
                if (this.mID == -1) {
                    return null;
                }
                final int id2 = this.mID;
                return root.findViewByPredicateInsideOut(this, new Predicate<View>(){

                    @Override
                    public boolean apply(View t) {
                        return t.mNextFocusForwardId == id2;
                    }
                });
            }
        }
        return null;
    }

    private View findViewInsideOutShouldExist(View root, int id2) {
        if (this.mMatchIdPredicate == null) {
            this.mMatchIdPredicate = new MatchIdPredicate();
        }
        this.mMatchIdPredicate.mId = id2;
        View result = root.findViewByPredicateInsideOut(this, this.mMatchIdPredicate);
        if (result == null) {
            Log.w(VIEW_LOG_TAG, "couldn't find view with id " + id2);
        }
        return result;
    }

    public ArrayList<View> getFocusables(int direction) {
        ArrayList<View> result = new ArrayList<View>(24);
        this.addFocusables(result, direction);
        return result;
    }

    public void addFocusables(ArrayList<View> views, int direction) {
        this.addFocusables(views, direction, 1);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (views == null) {
            return;
        }
        if (!this.isFocusable()) {
            return;
        }
        if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
            return;
        }
        views.add(this);
    }

    public void findViewsWithText(ArrayList<View> outViews, CharSequence searched, int flags) {
        if (this.getAccessibilityNodeProvider() != null) {
            if ((flags & 4) != 0) {
                outViews.add(this);
            }
        } else if ((flags & 2) != 0 && searched != null && searched.length() > 0 && this.mContentDescription != null && this.mContentDescription.length() > 0) {
            String searchedLowerCase = ((Object)searched).toString().toLowerCase();
            String contentDescriptionLowerCase = ((Object)this.mContentDescription).toString().toLowerCase();
            if (contentDescriptionLowerCase.contains(searchedLowerCase)) {
                outViews.add(this);
            }
        }
    }

    public ArrayList<View> getTouchables() {
        ArrayList<View> result = new ArrayList<View>();
        this.addTouchables(result);
        return result;
    }

    public void addTouchables(ArrayList<View> views) {
        int viewFlags = this.mViewFlags;
        if (((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000) && (viewFlags & 0x20) == 0) {
            views.add(this);
        }
    }

    boolean isAccessibilityFocused() {
        return (this.mPrivateFlags2 & 0x4000000) != 0;
    }

    public boolean requestAccessibilityFocus() {
        AccessibilityManager manager = AccessibilityManager.getInstance(this.mContext);
        if (!manager.isEnabled() || !manager.isTouchExplorationEnabled()) {
            return false;
        }
        if ((this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if ((this.mPrivateFlags2 & 0x4000000) == 0) {
            this.mPrivateFlags2 |= 0x4000000;
            ViewRootImpl viewRootImpl = this.getViewRootImpl();
            if (viewRootImpl != null) {
                viewRootImpl.setAccessibilityFocus(this, null);
            }
            this.invalidate();
            this.sendAccessibilityEvent(32768);
            this.notifyAccessibilityStateChanged();
            return true;
        }
        return false;
    }

    public void clearAccessibilityFocus() {
        View focusHost;
        ViewRootImpl viewRootImpl;
        if ((this.mPrivateFlags2 & 0x4000000) != 0) {
            this.mPrivateFlags2 &= 0xFBFFFFFF;
            this.invalidate();
            this.sendAccessibilityEvent(65536);
            this.notifyAccessibilityStateChanged();
        }
        if ((viewRootImpl = this.getViewRootImpl()) != null && (focusHost = viewRootImpl.getAccessibilityFocusedHost()) != null && ViewRootImpl.isViewDescendantOf(focusHost, this)) {
            viewRootImpl.setAccessibilityFocus(null, null);
        }
    }

    private void sendAccessibilityHoverEvent(int eventType) {
        View source = this;
        while (true) {
            if (source.includeForAccessibility()) {
                source.sendAccessibilityEvent(eventType);
                return;
            }
            ViewParent parent = source.getParent();
            if (!(parent instanceof View)) break;
            source = (View)((Object)parent);
        }
    }

    void clearAccessibilityFocusNoCallbacks() {
        if ((this.mPrivateFlags2 & 0x4000000) != 0) {
            this.mPrivateFlags2 &= 0xFBFFFFFF;
            this.invalidate();
        }
    }

    public boolean requestFocus() {
        return this.requestFocus(130);
    }

    public boolean requestFocus(int direction) {
        return this.requestFocus(direction, null);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        return this.requestFocusNoSearch(direction, previouslyFocusedRect);
    }

    private boolean requestFocusNoSearch(int direction, Rect previouslyFocusedRect) {
        if ((this.mViewFlags & 1) != 1 || (this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if (this.isInTouchMode() && 262144 != (this.mViewFlags & 0x40000)) {
            return false;
        }
        if (this.hasAncestorThatBlocksDescendantFocus()) {
            return false;
        }
        this.handleFocusGainInternal(direction, previouslyFocusedRect);
        return true;
    }

    public boolean requestFocusFromTouch() {
        ViewRootImpl viewRoot;
        if (this.isInTouchMode() && (viewRoot = this.getViewRootImpl()) != null) {
            viewRoot.ensureTouchMode(false);
        }
        return this.requestFocus(130);
    }

    private boolean hasAncestorThatBlocksDescendantFocus() {
        ViewParent ancestor = this.mParent;
        while (ancestor instanceof ViewGroup) {
            ViewGroup vgAncestor = (ViewGroup)ancestor;
            if (vgAncestor.getDescendantFocusability() == 393216) {
                return true;
            }
            ancestor = vgAncestor.getParent();
        }
        return false;
    }

    @ViewDebug.ExportedProperty(category="accessibility", mapping={@ViewDebug.IntToString(from=0, to="auto"), @ViewDebug.IntToString(from=1, to="yes"), @ViewDebug.IntToString(from=2, to="no")})
    public int getImportantForAccessibility() {
        return (this.mPrivateFlags2 & 0x300000) >> 20;
    }

    public void setImportantForAccessibility(int mode) {
        if (mode != this.getImportantForAccessibility()) {
            this.mPrivateFlags2 &= 0xFFCFFFFF;
            this.mPrivateFlags2 |= mode << 20 & 0x300000;
            this.notifyAccessibilityStateChanged();
        }
    }

    public boolean isImportantForAccessibility() {
        int mode = (this.mPrivateFlags2 & 0x300000) >> 20;
        switch (mode) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                return this.isActionableForAccessibility() || this.hasListenersForAccessibility() || this.getAccessibilityNodeProvider() != null;
            }
        }
        throw new IllegalArgumentException("Unknow important for accessibility mode: " + mode);
    }

    public ViewParent getParentForAccessibility() {
        if (this.mParent instanceof View) {
            View parentView = (View)((Object)this.mParent);
            if (parentView.includeForAccessibility()) {
                return this.mParent;
            }
            return this.mParent.getParentForAccessibility();
        }
        return null;
    }

    public void addChildrenForAccessibility(ArrayList<View> children) {
        if (this.includeForAccessibility()) {
            children.add(this);
        }
    }

    public boolean includeForAccessibility() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mIncludeNotImportantViews || this.isImportantForAccessibility();
        }
        return false;
    }

    public boolean isActionableForAccessibility() {
        return this.isClickable() || this.isLongClickable() || this.isFocusable();
    }

    private boolean hasListenersForAccessibility() {
        ListenerInfo info = this.getListenerInfo();
        return this.mTouchDelegate != null || info.mOnKeyListener != null || info.mOnTouchListener != null || info.mOnGenericMotionListener != null || info.mOnHoverListener != null || info.mOnDragListener != null;
    }

    public void notifyAccessibilityStateChanged() {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        if ((this.mPrivateFlags2 & 0x8000000) == 0) {
            this.mPrivateFlags2 |= 0x8000000;
            if (this.mParent != null) {
                this.mParent.childAccessibilityStateChanged(this);
            }
        }
    }

    public void resetAccessibilityStateChanged() {
        this.mPrivateFlags2 &= 0xF7FFFFFF;
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.performAccessibilityAction(this, action, arguments);
        }
        return this.performAccessibilityActionInternal(action, arguments);
    }

    boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        switch (action) {
            case 16: {
                if (!this.isClickable()) break;
                this.performClick();
                return true;
            }
            case 32: {
                if (!this.isLongClickable()) break;
                this.performLongClick();
                return true;
            }
            case 1: {
                if (this.hasFocus()) break;
                this.getViewRootImpl().ensureTouchMode(false);
                return this.requestFocus();
            }
            case 2: {
                if (!this.hasFocus()) break;
                this.clearFocus();
                return !this.isFocused();
            }
            case 4: {
                if (this.isSelected()) break;
                this.setSelected(true);
                return this.isSelected();
            }
            case 8: {
                if (!this.isSelected()) break;
                this.setSelected(false);
                return !this.isSelected();
            }
            case 64: {
                if (this.isAccessibilityFocused()) break;
                return this.requestAccessibilityFocus();
            }
            case 128: {
                if (!this.isAccessibilityFocused()) break;
                this.clearAccessibilityFocus();
                return true;
            }
            case 256: {
                if (arguments == null) break;
                int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                return this.nextAtGranularity(granularity);
            }
            case 512: {
                if (arguments == null) break;
                int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                return this.previousAtGranularity(granularity);
            }
        }
        return false;
    }

    private boolean nextAtGranularity(int granularity) {
        CharSequence text = this.getIterableTextForAccessibility();
        if (text == null || text.length() == 0) {
            return false;
        }
        AccessibilityIterators.TextSegmentIterator iterator = this.getIteratorForGranularity(granularity);
        if (iterator == null) {
            return false;
        }
        int current = this.getAccessibilityCursorPosition();
        int[] range = iterator.following(current);
        if (range == null) {
            return false;
        }
        int start = range[0];
        int end = range[1];
        this.setAccessibilityCursorPosition(end);
        this.sendViewTextTraversedAtGranularityEvent(256, granularity, start, end);
        return true;
    }

    private boolean previousAtGranularity(int granularity) {
        CharSequence text = this.getIterableTextForAccessibility();
        if (text == null || text.length() == 0) {
            return false;
        }
        AccessibilityIterators.TextSegmentIterator iterator = this.getIteratorForGranularity(granularity);
        if (iterator == null) {
            return false;
        }
        int current = this.getAccessibilityCursorPosition();
        if (current == -1) {
            current = text.length();
            this.setAccessibilityCursorPosition(current);
        } else if (granularity == 1) {
            this.setAccessibilityCursorPosition(--current);
        }
        int[] range = iterator.preceding(current);
        if (range == null) {
            return false;
        }
        int start = range[0];
        int end = range[1];
        if (granularity == 1) {
            this.setAccessibilityCursorPosition(end);
        } else {
            this.setAccessibilityCursorPosition(start);
        }
        this.sendViewTextTraversedAtGranularityEvent(512, granularity, start, end);
        return true;
    }

    public CharSequence getIterableTextForAccessibility() {
        return this.getContentDescription();
    }

    public int getAccessibilityCursorPosition() {
        return this.mAccessibilityCursorPosition;
    }

    public void setAccessibilityCursorPosition(int position) {
        this.mAccessibilityCursorPosition = position;
    }

    private void sendViewTextTraversedAtGranularityEvent(int action, int granularity, int fromIndex, int toIndex) {
        if (this.mParent == null) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(131072);
        this.onInitializeAccessibilityEvent(event);
        this.onPopulateAccessibilityEvent(event);
        event.setFromIndex(fromIndex);
        event.setToIndex(toIndex);
        event.setAction(action);
        event.setMovementGranularity(granularity);
        this.mParent.requestSendAccessibilityEvent(this, event);
    }

    public AccessibilityIterators.TextSegmentIterator getIteratorForGranularity(int granularity) {
        switch (granularity) {
            case 1: {
                CharSequence text = this.getIterableTextForAccessibility();
                if (text == null || text.length() <= 0) break;
                AccessibilityIterators.CharacterTextSegmentIterator iterator = AccessibilityIterators.CharacterTextSegmentIterator.getInstance(this.mContext.getResources().getConfiguration().locale);
                iterator.initialize(((Object)text).toString());
                return iterator;
            }
            case 2: {
                CharSequence text = this.getIterableTextForAccessibility();
                if (text == null || text.length() <= 0) break;
                AccessibilityIterators.WordTextSegmentIterator iterator = AccessibilityIterators.WordTextSegmentIterator.getInstance(this.mContext.getResources().getConfiguration().locale);
                iterator.initialize(((Object)text).toString());
                return iterator;
            }
            case 8: {
                CharSequence text = this.getIterableTextForAccessibility();
                if (text == null || text.length() <= 0) break;
                AccessibilityIterators.ParagraphTextSegmentIterator iterator = AccessibilityIterators.ParagraphTextSegmentIterator.getInstance();
                iterator.initialize(((Object)text).toString());
                return iterator;
            }
        }
        return null;
    }

    public void dispatchStartTemporaryDetach() {
        this.clearAccessibilityFocus();
        this.clearDisplayList();
        this.onStartTemporaryDetach();
    }

    public void onStartTemporaryDetach() {
        this.removeUnsetPressCallback();
        this.mPrivateFlags |= 0x4000000;
    }

    public void dispatchFinishTemporaryDetach() {
        this.onFinishTemporaryDetach();
    }

    public void onFinishTemporaryDetach() {
    }

    public KeyEvent.DispatcherState getKeyDispatcherState() {
        return this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null;
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        return this.onKeyPreIme(event.getKeyCode(), event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        ListenerInfo li;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(event, 0);
        }
        if ((li = this.mListenerInfo) != null && li.mOnKeyListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnKeyListener.onKey(this, event.getKeyCode(), event)) {
            return true;
        }
        if (event.dispatch(this, this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null, this)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(event, 0);
        }
        if (this.onFilterTouchEventForSecurity(event)) {
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnTouchListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnTouchListener.onTouch(this, event)) {
                return true;
            }
            if (this.onTouchEvent(event)) {
                return true;
            }
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    public boolean onFilterTouchEventForSecurity(MotionEvent event) {
        return (this.mViewFlags & 0x400) == 0 || (event.getFlags() & 1) == 0;
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(event, 0);
        }
        return this.onTrackballEvent(event);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        int action;
        int source;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onGenericMotionEvent(event, 0);
        }
        if (((source = event.getSource()) & 2) != 0 ? ((action = event.getAction()) == 9 || action == 7 || action == 10 ? this.dispatchHoverEvent(event) : this.dispatchGenericPointerEvent(event)) : this.dispatchGenericFocusedEvent(event)) {
            return true;
        }
        if (this.dispatchGenericMotionEventInternal(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    private boolean dispatchGenericMotionEventInternal(MotionEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnGenericMotionListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnGenericMotionListener.onGenericMotion(this, event)) {
            return true;
        }
        if (this.onGenericMotionEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnHoverListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnHoverListener.onHover(this, event)) {
            return true;
        }
        return this.onHoverEvent(event);
    }

    protected boolean hasHoveredChild() {
        return false;
    }

    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        return false;
    }

    protected boolean dispatchGenericFocusedEvent(MotionEvent event) {
        return false;
    }

    public boolean dispatchPointerEvent(MotionEvent event) {
        if (event.isTouchEvent()) {
            return this.dispatchTouchEvent(event);
        }
        return this.dispatchGenericMotionEvent(event);
    }

    public void dispatchWindowFocusChanged(boolean hasFocus) {
        this.onWindowFocusChanged(hasFocus);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (!hasWindowFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            if (imm != null && (this.mPrivateFlags & 2) != 0) {
                imm.focusOut(this);
            }
            this.removeLongPressCallback();
            this.removeTapCallback();
            this.onFocusLost();
        } else if (imm != null && (this.mPrivateFlags & 2) != 0) {
            imm.focusIn(this);
        }
        this.refreshDrawableState();
    }

    public boolean hasWindowFocus() {
        return this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus;
    }

    protected void dispatchVisibilityChanged(View changedView, int visibility) {
        this.onVisibilityChanged(changedView, visibility);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (visibility == 0) {
            if (this.mAttachInfo != null) {
                this.initialAwakenScrollBars();
            } else {
                this.mPrivateFlags |= 0x8000000;
            }
        }
    }

    public void dispatchDisplayHint(int hint) {
        this.onDisplayHint(hint);
    }

    protected void onDisplayHint(int hint) {
    }

    public void dispatchWindowVisibilityChanged(int visibility) {
        this.onWindowVisibilityChanged(visibility);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (visibility == 0) {
            this.initialAwakenScrollBars();
        }
    }

    public int getWindowVisibility() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowVisibility : 8;
    }

    public void getWindowVisibleDisplayFrame(Rect outRect) {
        if (this.mAttachInfo != null) {
            try {
                this.mAttachInfo.mSession.getDisplayFrame(this.mAttachInfo.mWindow, outRect);
            }
            catch (RemoteException e) {
                return;
            }
            Rect insets = this.mAttachInfo.mVisibleInsets;
            outRect.left += insets.left;
            outRect.top += insets.top;
            outRect.right -= insets.right;
            outRect.bottom -= insets.bottom;
            return;
        }
        Display d = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        d.getRectSize(outRect);
    }

    public void dispatchConfigurationChanged(Configuration newConfig) {
        this.onConfigurationChanged(newConfig);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
    }

    void dispatchCollectViewAttributes(AttachInfo attachInfo, int visibility) {
        this.performCollectViewAttributes(attachInfo, visibility);
    }

    void performCollectViewAttributes(AttachInfo attachInfo, int visibility) {
        if ((visibility & 0xC) == 0) {
            if ((this.mViewFlags & 0x4000000) == 0x4000000) {
                attachInfo.mKeepScreenOn = true;
            }
            attachInfo.mSystemUiVisibility |= this.mSystemUiVisibility;
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnSystemUiVisibilityChangeListener != null) {
                attachInfo.mHasSystemUiListeners = true;
            }
        }
    }

    void needGlobalAttributesUpdate(boolean force) {
        AttachInfo ai = this.mAttachInfo;
        if (ai != null && !ai.mRecomputeGlobalAttributes && (force || ai.mKeepScreenOn || ai.mSystemUiVisibility != 0 || ai.mHasSystemUiListeners)) {
            ai.mRecomputeGlobalAttributes = true;
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isInTouchMode() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mInTouchMode;
        }
        return ViewRootImpl.isInTouchMode();
    }

    @ViewDebug.CapturedViewProperty
    public Context getContext() {
        return this.mContext;
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 23: 
            case 66: {
                if ((this.mViewFlags & 0x20) == 32) {
                    return true;
                }
                if ((this.mViewFlags & 0x4000) != 16384 && (this.mViewFlags & 0x200000) != 0x200000 || event.getRepeatCount() != 0) break;
                this.setPressed(true);
                this.checkForLongClick(0);
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 23: 
            case 66: {
                if ((this.mViewFlags & 0x20) == 32) {
                    return true;
                }
                if ((this.mViewFlags & 0x4000) != 16384 || !this.isPressed()) break;
                this.setPressed(false);
                if (this.mHasPerformedLongPress) break;
                this.removeLongPressCallback();
                result = this.performClick();
            }
        }
        return result;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onCheckIsTextEditor() {
        return false;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return null;
    }

    public boolean checkInputConnectionProxy(View view) {
        return false;
    }

    public void createContextMenu(ContextMenu menu2) {
        ContextMenu.ContextMenuInfo menuInfo = this.getContextMenuInfo();
        ((MenuBuilder)((Object)menu2)).setCurrentMenuInfo(menuInfo);
        this.onCreateContextMenu(menu2);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnCreateContextMenuListener != null) {
            li.mOnCreateContextMenuListener.onCreateContextMenu(menu2, this, menuInfo);
        }
        ((MenuBuilder)((Object)menu2)).setCurrentMenuInfo(null);
        if (this.mParent != null) {
            this.mParent.createContextMenu(menu2);
        }
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return null;
    }

    protected void onCreateContextMenu(ContextMenu menu2) {
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public boolean onHoverEvent(MotionEvent event) {
        int action = event.getActionMasked();
        if (!this.mSendingHoverAccessibilityEvents) {
            if ((action == 9 || action == 7) && !this.hasHoveredChild() && this.pointInView(event.getX(), event.getY())) {
                this.sendAccessibilityHoverEvent(128);
                this.mSendingHoverAccessibilityEvents = true;
            }
        } else if (action == 10 || action == 2 && !this.pointInView(event.getX(), event.getY())) {
            this.mSendingHoverAccessibilityEvents = false;
            this.sendAccessibilityHoverEvent(256);
            if (this.mAttachInfo != null && !this.mAttachInfo.mHasWindowFocus) {
                this.getViewRootImpl().setAccessibilityFocus(null, null);
            }
        }
        if (this.isHoverable()) {
            switch (action) {
                case 9: {
                    this.setHovered(true);
                    break;
                }
                case 10: {
                    this.setHovered(false);
                }
            }
            this.dispatchGenericMotionEventInternal(event);
            return true;
        }
        return false;
    }

    private boolean isHoverable() {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x20) == 32) {
            return false;
        }
        return (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000;
    }

    @ViewDebug.ExportedProperty
    public boolean isHovered() {
        return (this.mPrivateFlags & 0x10000000) != 0;
    }

    public void setHovered(boolean hovered) {
        if (hovered) {
            if ((this.mPrivateFlags & 0x10000000) == 0) {
                this.mPrivateFlags |= 0x10000000;
                this.refreshDrawableState();
                this.onHoverChanged(true);
            }
        } else if ((this.mPrivateFlags & 0x10000000) != 0) {
            this.mPrivateFlags &= 0xEFFFFFFF;
            this.refreshDrawableState();
            this.onHoverChanged(false);
        }
    }

    public void onHoverChanged(boolean hovered) {
    }

    public boolean onTouchEvent(MotionEvent event) {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x20) == 32) {
            if (event.getAction() == 1 && (this.mPrivateFlags & 0x4000) != 0) {
                this.setPressed(false);
            }
            return (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000;
        }
        if (this.mTouchDelegate != null && this.mTouchDelegate.onTouchEvent(event)) {
            return true;
        }
        if ((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000) {
            switch (event.getAction()) {
                case 1: {
                    boolean prepressed;
                    boolean bl = prepressed = (this.mPrivateFlags & 0x2000000) != 0;
                    if ((this.mPrivateFlags & 0x4000) == 0 && !prepressed) break;
                    boolean focusTaken = false;
                    if (this.isFocusable() && this.isFocusableInTouchMode() && !this.isFocused()) {
                        focusTaken = this.requestFocus();
                    }
                    if (prepressed) {
                        this.setPressed(true);
                    }
                    if (!this.mHasPerformedLongPress) {
                        this.removeLongPressCallback();
                        if (!focusTaken) {
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            if (!this.post(this.mPerformClick)) {
                                this.performClick();
                            }
                        }
                    }
                    if (this.mUnsetPressedState == null) {
                        this.mUnsetPressedState = new UnsetPressedState();
                    }
                    if (prepressed) {
                        this.postDelayed(this.mUnsetPressedState, ViewConfiguration.getPressedStateDuration());
                    } else if (!this.post(this.mUnsetPressedState)) {
                        this.mUnsetPressedState.run();
                    }
                    this.removeTapCallback();
                    break;
                }
                case 0: {
                    this.mHasPerformedLongPress = false;
                    if (this.performButtonActionOnTouchDown(event)) break;
                    boolean isInScrollingContainer = this.isInScrollingContainer();
                    if (isInScrollingContainer) {
                        this.mPrivateFlags |= 0x2000000;
                        if (this.mPendingCheckForTap == null) {
                            this.mPendingCheckForTap = new CheckForTap();
                        }
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                        break;
                    }
                    this.setPressed(true);
                    this.checkForLongClick(0);
                    break;
                }
                case 3: {
                    this.setPressed(false);
                    this.removeTapCallback();
                    this.removeLongPressCallback();
                    break;
                }
                case 2: {
                    int x = (int)event.getX();
                    int y = (int)event.getY();
                    if (this.pointInView(x, y, this.mTouchSlop)) break;
                    this.removeTapCallback();
                    if ((this.mPrivateFlags & 0x4000) == 0) break;
                    this.removeLongPressCallback();
                    this.setPressed(false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    private void removeLongPressCallback() {
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
    }

    private void removePerformClickCallback() {
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
    }

    private void removeUnsetPressCallback() {
        if ((this.mPrivateFlags & 0x4000) != 0 && this.mUnsetPressedState != null) {
            this.setPressed(false);
            this.removeCallbacks(this.mUnsetPressedState);
        }
    }

    private void removeTapCallback() {
        if (this.mPendingCheckForTap != null) {
            this.mPrivateFlags &= 0xFDFFFFFF;
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    public void cancelLongPress() {
        this.removeLongPressCallback();
        this.removeTapCallback();
    }

    private void removeSendViewScrolledAccessibilityEventCallback() {
        if (this.mSendViewScrolledAccessibilityEvent != null) {
            this.removeCallbacks(this.mSendViewScrolledAccessibilityEvent);
            this.mSendViewScrolledAccessibilityEvent.mIsPending = false;
        }
    }

    public void setTouchDelegate(TouchDelegate delegate) {
        this.mTouchDelegate = delegate;
    }

    public TouchDelegate getTouchDelegate() {
        return this.mTouchDelegate;
    }

    void setFlags(int flags, int mask) {
        int old = this.mViewFlags;
        this.mViewFlags = this.mViewFlags & ~mask | flags & mask;
        int changed = this.mViewFlags ^ old;
        if (changed == 0) {
            return;
        }
        int privateFlags = this.mPrivateFlags;
        if ((changed & 1) != 0 && (privateFlags & 0x10) != 0) {
            if ((old & 1) == 1 && (privateFlags & 2) != 0) {
                this.clearFocus();
            } else if ((old & 1) == 0 && (privateFlags & 2) == 0 && this.mParent != null) {
                this.mParent.focusableViewAvailable(this);
            }
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.notifyAccessibilityStateChanged();
            }
        }
        if ((flags & 0xC) == 0 && (changed & 0xC) != 0) {
            this.mPrivateFlags |= 0x20;
            this.invalidate(true);
            this.needGlobalAttributesUpdate(true);
            if (this.mParent != null && this.mBottom > this.mTop && this.mRight > this.mLeft) {
                this.mParent.focusableViewAvailable(this);
            }
        }
        if ((changed & 8) != 0) {
            this.needGlobalAttributesUpdate(false);
            this.requestLayout();
            if ((this.mViewFlags & 0xC) == 8) {
                if (this.hasFocus()) {
                    this.clearFocus();
                }
                this.clearAccessibilityFocus();
                this.destroyDrawingCache();
                if (this.mParent instanceof View) {
                    ((View)((Object)this.mParent)).invalidate(true);
                }
                this.mPrivateFlags |= 0x20;
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 4) != 0) {
            this.needGlobalAttributesUpdate(false);
            this.mPrivateFlags |= 0x20;
            if ((this.mViewFlags & 0xC) == 4 && this.hasFocus() && this.getRootView() != this) {
                this.clearFocus();
                this.clearAccessibilityFocus();
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 0xC) != 0) {
            if (this.mParent instanceof ViewGroup) {
                ((ViewGroup)this.mParent).onChildVisibilityChanged(this, changed & 0xC, flags & 0xC);
                ((View)((Object)this.mParent)).invalidate(true);
            } else if (this.mParent != null) {
                this.mParent.invalidateChild(this, null);
            }
            this.dispatchVisibilityChanged(this, flags & 0xC);
        }
        if ((changed & 0x20000) != 0) {
            this.destroyDrawingCache();
        }
        if ((changed & 0x8000) != 0) {
            this.destroyDrawingCache();
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.invalidateParentCaches();
        }
        if ((changed & 0x180000) != 0) {
            this.destroyDrawingCache();
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
        if ((changed & 0x80) != 0) {
            if ((this.mViewFlags & 0x80) != 0) {
                if (this.mBackground != null) {
                    this.mPrivateFlags &= 0xFFFFFF7F;
                    this.mPrivateFlags |= 0x100;
                } else {
                    this.mPrivateFlags |= 0x80;
                }
            } else {
                this.mPrivateFlags &= 0xFFFFFF7F;
            }
            this.requestLayout();
            this.invalidate(true);
        }
        if ((changed & 0x4000000) != 0 && this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mParent.recomputeViewAttributes(this);
        }
        if (AccessibilityManager.getInstance(this.mContext).isEnabled() && ((changed & 1) != 0 || (changed & 0x4000) != 0 || (changed & 0x200000) != 0 || (changed & 0) != 0)) {
            this.notifyAccessibilityStateChanged();
        }
    }

    public void bringToFront() {
        if (this.mParent != null) {
            this.mParent.bringChildToFront(this);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.postSendViewScrolledAccessibilityEventCallback();
        }
        this.mBackgroundSizeChanged = true;
        AttachInfo ai = this.mAttachInfo;
        if (ai != null) {
            ai.mViewScrollChanged = true;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    public ViewParent getParent() {
        return this.mParent;
    }

    public void setScrollX(int value) {
        this.scrollTo(value, this.mScrollY);
    }

    public void setScrollY(int value) {
        this.scrollTo(this.mScrollX, value);
    }

    public int getScrollX() {
        return this.mScrollX;
    }

    public int getScrollY() {
        return this.mScrollY;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getWidth() {
        return this.mRight - this.mLeft;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getHeight() {
        return this.mBottom - this.mTop;
    }

    public void getDrawingRect(Rect outRect) {
        outRect.left = this.mScrollX;
        outRect.top = this.mScrollY;
        outRect.right = this.mScrollX + (this.mRight - this.mLeft);
        outRect.bottom = this.mScrollY + (this.mBottom - this.mTop);
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth & 0xFFFFFF;
    }

    public int getMeasuredWidthAndState() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight & 0xFFFFFF;
    }

    public int getMeasuredHeightAndState() {
        return this.mMeasuredHeight;
    }

    public int getMeasuredState() {
        return this.mMeasuredWidth & 0xFF000000 | this.mMeasuredHeight >> 16 & 0xFFFFFF00;
    }

    public Matrix getMatrix() {
        if (this.mTransformationInfo != null) {
            this.updateMatrix();
            return this.mTransformationInfo.mMatrix;
        }
        return Matrix.IDENTITY_MATRIX;
    }

    private static boolean nonzero(float value) {
        return value < -0.001f || value > 0.001f;
    }

    boolean hasIdentityMatrix() {
        if (this.mTransformationInfo != null) {
            this.updateMatrix();
            return this.mTransformationInfo.mMatrixIsIdentity;
        }
        return true;
    }

    void ensureTransformationInfo() {
        if (this.mTransformationInfo == null) {
            this.mTransformationInfo = new TransformationInfo();
        }
    }

    private void updateMatrix() {
        TransformationInfo info = this.mTransformationInfo;
        if (info == null) {
            return;
        }
        if (info.mMatrixDirty) {
            if ((this.mPrivateFlags & 0x20000000) == 0 && (this.mRight - this.mLeft != info.mPrevWidth || this.mBottom - this.mTop != info.mPrevHeight)) {
                info.mPrevWidth = this.mRight - this.mLeft;
                info.mPrevHeight = this.mBottom - this.mTop;
                info.mPivotX = (float)info.mPrevWidth / 2.0f;
                info.mPivotY = (float)info.mPrevHeight / 2.0f;
            }
            info.mMatrix.reset();
            if (!View.nonzero(info.mRotationX) && !View.nonzero(info.mRotationY)) {
                info.mMatrix.setTranslate(info.mTranslationX, info.mTranslationY);
                info.mMatrix.preRotate(info.mRotation, info.mPivotX, info.mPivotY);
                info.mMatrix.preScale(info.mScaleX, info.mScaleY, info.mPivotX, info.mPivotY);
            } else {
                if (info.mCamera == null) {
                    info.mCamera = new Camera();
                    info.matrix3D = new Matrix();
                }
                info.mCamera.save();
                info.mMatrix.preScale(info.mScaleX, info.mScaleY, info.mPivotX, info.mPivotY);
                info.mCamera.rotate(info.mRotationX, info.mRotationY, -info.mRotation);
                info.mCamera.getMatrix(info.matrix3D);
                info.matrix3D.preTranslate(-info.mPivotX, -info.mPivotY);
                info.matrix3D.postTranslate(info.mPivotX + info.mTranslationX, info.mPivotY + info.mTranslationY);
                info.mMatrix.postConcat(info.matrix3D);
                info.mCamera.restore();
            }
            info.mMatrixDirty = false;
            info.mMatrixIsIdentity = info.mMatrix.isIdentity();
            info.mInverseMatrixDirty = true;
        }
    }

    Matrix getInverseMatrix() {
        TransformationInfo info = this.mTransformationInfo;
        if (info != null) {
            this.updateMatrix();
            if (info.mInverseMatrixDirty) {
                if (info.mInverseMatrix == null) {
                    info.mInverseMatrix = new Matrix();
                }
                info.mMatrix.invert(info.mInverseMatrix);
                info.mInverseMatrixDirty = false;
            }
            return info.mInverseMatrix;
        }
        return Matrix.IDENTITY_MATRIX;
    }

    public float getCameraDistance() {
        this.ensureTransformationInfo();
        float dpi = this.mResources.getDisplayMetrics().densityDpi;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mCamera == null) {
            info.mCamera = new Camera();
            info.matrix3D = new Matrix();
        }
        return -(info.mCamera.getLocationZ() * dpi);
    }

    public void setCameraDistance(float distance) {
        this.invalidateViewProperty(true, false);
        this.ensureTransformationInfo();
        float dpi = this.mResources.getDisplayMetrics().densityDpi;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mCamera == null) {
            info.mCamera = new Camera();
            info.matrix3D = new Matrix();
        }
        info.mCamera.setLocation(0.0f, 0.0f, -Math.abs(distance) / dpi);
        info.mMatrixDirty = true;
        this.invalidateViewProperty(false, false);
        if (this.mDisplayList != null) {
            this.mDisplayList.setCameraDistance(-Math.abs(distance) / dpi);
        }
        if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getRotation() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mRotation : 0.0f;
    }

    public void setRotation(float rotation) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mRotation != rotation) {
            this.invalidateViewProperty(true, false);
            info.mRotation = rotation;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setRotation(rotation);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getRotationY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mRotationY : 0.0f;
    }

    public void setRotationY(float rotationY) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mRotationY != rotationY) {
            this.invalidateViewProperty(true, false);
            info.mRotationY = rotationY;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setRotationY(rotationY);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getRotationX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mRotationX : 0.0f;
    }

    public void setRotationX(float rotationX) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mRotationX != rotationX) {
            this.invalidateViewProperty(true, false);
            info.mRotationX = rotationX;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setRotationX(rotationX);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getScaleX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mScaleX : 1.0f;
    }

    public void setScaleX(float scaleX) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mScaleX != scaleX) {
            this.invalidateViewProperty(true, false);
            info.mScaleX = scaleX;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setScaleX(scaleX);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getScaleY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mScaleY : 1.0f;
    }

    public void setScaleY(float scaleY) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mScaleY != scaleY) {
            this.invalidateViewProperty(true, false);
            info.mScaleY = scaleY;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setScaleY(scaleY);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getPivotX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mPivotX : 0.0f;
    }

    public void setPivotX(float pivotX) {
        this.ensureTransformationInfo();
        this.mPrivateFlags |= 0x20000000;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mPivotX != pivotX) {
            this.invalidateViewProperty(true, false);
            info.mPivotX = pivotX;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setPivotX(pivotX);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getPivotY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mPivotY : 0.0f;
    }

    public void setPivotY(float pivotY) {
        this.ensureTransformationInfo();
        this.mPrivateFlags |= 0x20000000;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mPivotY != pivotY) {
            this.invalidateViewProperty(true, false);
            info.mPivotY = pivotY;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setPivotY(pivotY);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getAlpha() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mAlpha : 1.0f;
    }

    public boolean hasOverlappingRendering() {
        return true;
    }

    public void setAlpha(float alpha) {
        this.ensureTransformationInfo();
        if (this.mTransformationInfo.mAlpha != alpha) {
            this.mTransformationInfo.mAlpha = alpha;
            if (this.onSetAlpha((int)(alpha * 255.0f))) {
                this.mPrivateFlags |= 0x40000;
                this.invalidateParentCaches();
                this.invalidate(true);
            } else {
                this.mPrivateFlags &= 0xFFFBFFFF;
                this.invalidateViewProperty(true, false);
                if (this.mDisplayList != null) {
                    this.mDisplayList.setAlpha(alpha);
                }
            }
        }
    }

    boolean setAlphaNoInvalidation(float alpha) {
        this.ensureTransformationInfo();
        if (this.mTransformationInfo.mAlpha != alpha) {
            this.mTransformationInfo.mAlpha = alpha;
            boolean subclassHandlesAlpha = this.onSetAlpha((int)(alpha * 255.0f));
            if (subclassHandlesAlpha) {
                this.mPrivateFlags |= 0x40000;
                return true;
            }
            this.mPrivateFlags &= 0xFFFBFFFF;
            if (this.mDisplayList != null) {
                this.mDisplayList.setAlpha(alpha);
            }
        }
        return false;
    }

    @ViewDebug.CapturedViewProperty
    public int getTop() {
        return this.mTop;
    }

    public void setTop(int top) {
        if (top != this.mTop) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int yLoc;
                    int minTop;
                    if (top < this.mTop) {
                        minTop = top;
                        yLoc = top - this.mTop;
                    } else {
                        minTop = this.mTop;
                        yLoc = 0;
                    }
                    this.invalidate(0, yLoc, this.mRight - this.mLeft, this.mBottom - minTop);
                }
            } else {
                this.invalidate(true);
            }
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mTop = top;
            if (this.mDisplayList != null) {
                this.mDisplayList.setTop(this.mTop);
            }
            this.onSizeChanged(width, this.mBottom - this.mTop, width, oldHeight);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getBottom() {
        return this.mBottom;
    }

    public boolean isDirty() {
        return (this.mPrivateFlags & 0x600000) != 0;
    }

    public void setBottom(int bottom) {
        if (bottom != this.mBottom) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int maxBottom = bottom < this.mBottom ? this.mBottom : bottom;
                    this.invalidate(0, 0, this.mRight - this.mLeft, maxBottom - this.mTop);
                }
            } else {
                this.invalidate(true);
            }
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mBottom = bottom;
            if (this.mDisplayList != null) {
                this.mDisplayList.setBottom(this.mBottom);
            }
            this.onSizeChanged(width, this.mBottom - this.mTop, width, oldHeight);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getLeft() {
        return this.mLeft;
    }

    public void setLeft(int left) {
        if (left != this.mLeft) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int xLoc;
                    int minLeft;
                    if (left < this.mLeft) {
                        minLeft = left;
                        xLoc = left - this.mLeft;
                    } else {
                        minLeft = this.mLeft;
                        xLoc = 0;
                    }
                    this.invalidate(xLoc, 0, this.mRight - minLeft, this.mBottom - this.mTop);
                }
            } else {
                this.invalidate(true);
            }
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mLeft = left;
            if (this.mDisplayList != null) {
                this.mDisplayList.setLeft(left);
            }
            this.onSizeChanged(this.mRight - this.mLeft, height, oldWidth, height);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getRight() {
        return this.mRight;
    }

    public void setRight(int right) {
        if (right != this.mRight) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int maxRight = right < this.mRight ? this.mRight : right;
                    this.invalidate(0, 0, maxRight - this.mLeft, this.mBottom - this.mTop);
                }
            } else {
                this.invalidate(true);
            }
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mRight = right;
            if (this.mDisplayList != null) {
                this.mDisplayList.setRight(this.mRight);
            }
            this.onSizeChanged(this.mRight - this.mLeft, height, oldWidth, height);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getX() {
        return (float)this.mLeft + (this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationX : 0.0f);
    }

    public void setX(float x) {
        this.setTranslationX(x - (float)this.mLeft);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getY() {
        return (float)this.mTop + (this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationY : 0.0f);
    }

    public void setY(float y) {
        this.setTranslationY(y - (float)this.mTop);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getTranslationX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationX : 0.0f;
    }

    public void setTranslationX(float translationX) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mTranslationX != translationX) {
            this.invalidateViewProperty(true, false);
            info.mTranslationX = translationX;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setTranslationX(translationX);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public float getTranslationY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationY : 0.0f;
    }

    public void setTranslationY(float translationY) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mTranslationY != translationY) {
            this.invalidateViewProperty(true, false);
            info.mTranslationY = translationY;
            info.mMatrixDirty = true;
            this.invalidateViewProperty(false, true);
            if (this.mDisplayList != null) {
                this.mDisplayList.setTranslationY(translationY);
            }
            if ((this.mPrivateFlags2 & 0x10000000) == 0x10000000) {
                this.invalidateParentIfNeeded();
            }
        }
    }

    public void getHitRect(Rect outRect) {
        this.updateMatrix();
        TransformationInfo info = this.mTransformationInfo;
        if (info == null || info.mMatrixIsIdentity || this.mAttachInfo == null) {
            outRect.set(this.mLeft, this.mTop, this.mRight, this.mBottom);
        } else {
            RectF tmpRect = this.mAttachInfo.mTmpTransformRect;
            tmpRect.set(-info.mPivotX, -info.mPivotY, (float)this.getWidth() - info.mPivotX, (float)this.getHeight() - info.mPivotY);
            info.mMatrix.mapRect(tmpRect);
            outRect.set((int)tmpRect.left + this.mLeft, (int)tmpRect.top + this.mTop, (int)tmpRect.right + this.mLeft, (int)tmpRect.bottom + this.mTop);
        }
    }

    boolean pointInView(float localX, float localY) {
        return localX >= 0.0f && localX < (float)(this.mRight - this.mLeft) && localY >= 0.0f && localY < (float)(this.mBottom - this.mTop);
    }

    private boolean pointInView(float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(this.mRight - this.mLeft) + slop && localY < (float)(this.mBottom - this.mTop) + slop;
    }

    public void getFocusedRect(Rect r) {
        this.getDrawingRect(r);
    }

    public boolean getGlobalVisibleRect(Rect r, Point globalOffset) {
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width > 0 && height > 0) {
            r.set(0, 0, width, height);
            if (globalOffset != null) {
                globalOffset.set(-this.mScrollX, -this.mScrollY);
            }
            return this.mParent == null || this.mParent.getChildVisibleRect(this, r, globalOffset);
        }
        return false;
    }

    public boolean getGlobalVisibleRect(Rect r) {
        return this.getGlobalVisibleRect(r, null);
    }

    public boolean getLocalVisibleRect(Rect r) {
        Point offset;
        Point point = offset = this.mAttachInfo != null ? this.mAttachInfo.mPoint : new Point();
        if (this.getGlobalVisibleRect(r, offset)) {
            r.offset(-offset.x, -offset.y);
            return true;
        }
        return false;
    }

    public void offsetTopAndBottom(int offset) {
        if (offset != 0) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mDisplayList != null) {
                    this.invalidateViewProperty(false, false);
                } else {
                    ViewParent p = this.mParent;
                    if (p != null && this.mAttachInfo != null) {
                        int yLoc;
                        int maxBottom;
                        int minTop;
                        Rect r = this.mAttachInfo.mTmpInvalRect;
                        if (offset < 0) {
                            minTop = this.mTop + offset;
                            maxBottom = this.mBottom;
                            yLoc = offset;
                        } else {
                            minTop = this.mTop;
                            maxBottom = this.mBottom + offset;
                            yLoc = 0;
                        }
                        r.set(0, yLoc, this.mRight - this.mLeft, maxBottom - minTop);
                        p.invalidateChild(this, r);
                    }
                }
            } else {
                this.invalidateViewProperty(false, false);
            }
            this.mTop += offset;
            this.mBottom += offset;
            if (this.mDisplayList != null) {
                this.mDisplayList.offsetTopBottom(offset);
                this.invalidateViewProperty(false, false);
            } else {
                if (!matrixIsIdentity) {
                    this.invalidateViewProperty(false, true);
                }
                this.invalidateParentIfNeeded();
            }
        }
    }

    public void offsetLeftAndRight(int offset) {
        if (offset != 0) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mDisplayList != null) {
                    this.invalidateViewProperty(false, false);
                } else {
                    ViewParent p = this.mParent;
                    if (p != null && this.mAttachInfo != null) {
                        int maxRight;
                        int minLeft;
                        Rect r = this.mAttachInfo.mTmpInvalRect;
                        if (offset < 0) {
                            minLeft = this.mLeft + offset;
                            maxRight = this.mRight;
                        } else {
                            minLeft = this.mLeft;
                            maxRight = this.mRight + offset;
                        }
                        r.set(0, 0, maxRight - minLeft, this.mBottom - this.mTop);
                        p.invalidateChild(this, r);
                    }
                }
            } else {
                this.invalidateViewProperty(false, false);
            }
            this.mLeft += offset;
            this.mRight += offset;
            if (this.mDisplayList != null) {
                this.mDisplayList.offsetLeftRight(offset);
                this.invalidateViewProperty(false, false);
            } else {
                if (!matrixIsIdentity) {
                    this.invalidateViewProperty(false, true);
                }
                this.invalidateParentIfNeeded();
            }
        }
    }

    @ViewDebug.ExportedProperty(deepExport=true, prefix="layout_")
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params == null) {
            throw new NullPointerException("Layout parameters cannot be null");
        }
        this.mLayoutParams = params;
        this.resolveLayoutParams();
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).onSetLayoutParams(this, params);
        }
        this.requestLayout();
    }

    public void resolveLayoutParams() {
        if (this.mLayoutParams != null) {
            this.mLayoutParams.resolveLayoutDirection(this.getLayoutDirection());
        }
    }

    public void scrollTo(int x, int y) {
        if (this.mScrollX != x || this.mScrollY != y) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = x;
            this.mScrollY = y;
            this.invalidateParentCaches();
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (!this.awakenScrollBars()) {
                this.postInvalidateOnAnimation();
            }
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo(this.mScrollX + x, this.mScrollY + y);
    }

    protected boolean awakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade, true);
    }

    private boolean initialAwakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade * 4, true);
    }

    protected boolean awakenScrollBars(int startDelay) {
        return this.awakenScrollBars(startDelay, true);
    }

    protected boolean awakenScrollBars(int startDelay, boolean invalidate) {
        ScrollabilityCache scrollCache = this.mScrollCache;
        if (scrollCache == null || !scrollCache.fadeScrollBars) {
            return false;
        }
        if (scrollCache.scrollBar == null) {
            scrollCache.scrollBar = new ScrollBarDrawable();
        }
        if (this.isHorizontalScrollBarEnabled() || this.isVerticalScrollBarEnabled()) {
            long fadeStartTime;
            if (invalidate) {
                this.postInvalidateOnAnimation();
            }
            if (scrollCache.state == 0) {
                int KEY_REPEAT_FIRST_DELAY = 750;
                startDelay = Math.max(750, startDelay);
            }
            scrollCache.fadeStartTime = fadeStartTime = AnimationUtils.currentAnimationTimeMillis() + (long)startDelay;
            scrollCache.state = 1;
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mHandler.removeCallbacks(scrollCache);
                this.mAttachInfo.mHandler.postAtTime(scrollCache, fadeStartTime);
            }
            return true;
        }
        return false;
    }

    private boolean skipInvalidate() {
        return (this.mViewFlags & 0xC) != 0 && this.mCurrentAnimation == null && (!(this.mParent instanceof ViewGroup) || !((ViewGroup)this.mParent).isViewTransitioning(this));
    }

    public void invalidate(Rect dirty) {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            this.mPrivateFlags |= 0x200000;
            ViewParent p = this.mParent;
            AttachInfo ai = this.mAttachInfo;
            if (p != null && ai != null) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                Rect r = ai.mTmpInvalRect;
                r.set(dirty.left - scrollX, dirty.top - scrollY, dirty.right - scrollX, dirty.bottom - scrollY);
                this.mParent.invalidateChild(this, r);
            }
        }
    }

    public void invalidate(int l, int t, int r, int b) {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            this.mPrivateFlags |= 0x200000;
            ViewParent p = this.mParent;
            AttachInfo ai = this.mAttachInfo;
            if (p != null && ai != null && l < r && t < b) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                Rect tmpr = ai.mTmpInvalRect;
                tmpr.set(l - scrollX, t - scrollY, r - scrollX, b - scrollY);
                p.invalidateChild(this, tmpr);
            }
        }
    }

    public void invalidate() {
        this.invalidate(true);
    }

    void invalidate(boolean invalidateCache) {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || invalidateCache && (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE || this.isOpaque() != this.mLastIsOpaque) {
            this.mLastIsOpaque = this.isOpaque();
            this.mPrivateFlags &= 0xFFFFFFDF;
            this.mPrivateFlags |= 0x200000;
            if (invalidateCache) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
                this.mPrivateFlags &= 0xFFFF7FFF;
            }
            AttachInfo ai = this.mAttachInfo;
            ViewParent p = this.mParent;
            if (p != null && ai != null) {
                Rect r = ai.mTmpInvalRect;
                r.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                p.invalidateChild(this, r);
            }
        }
    }

    void invalidateViewProperty(boolean invalidateParent, boolean forceRedraw) {
        if (this.mDisplayList == null || (this.mPrivateFlags & 0x40) == 64) {
            if (invalidateParent) {
                this.invalidateParentCaches();
            }
            if (forceRedraw) {
                this.mPrivateFlags |= 0x20;
            }
            this.invalidate(false);
        } else {
            AttachInfo ai = this.mAttachInfo;
            ViewParent p = this.mParent;
            if (p != null && ai != null) {
                Rect r = ai.mTmpInvalRect;
                r.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                if (this.mParent instanceof ViewGroup) {
                    ((ViewGroup)this.mParent).invalidateChildFast(this, r);
                } else {
                    this.mParent.invalidateChild(this, r);
                }
            }
        }
    }

    void transformRect(Rect rect) {
        if (!this.getMatrix().isIdentity()) {
            RectF boundingRect = this.mAttachInfo.mTmpTransformRect;
            boundingRect.set(rect);
            this.getMatrix().mapRect(boundingRect);
            rect.set((int)(boundingRect.left - 0.5f), (int)(boundingRect.top - 0.5f), (int)(boundingRect.right + 0.5f), (int)(boundingRect.bottom + 0.5f));
        }
    }

    protected void invalidateParentCaches() {
        if (this.mParent instanceof View) {
            ((View)((Object)this.mParent)).mPrivateFlags |= Integer.MIN_VALUE;
        }
    }

    protected void invalidateParentIfNeeded() {
        if (this.isHardwareAccelerated() && this.mParent instanceof View) {
            ((View)((Object)this.mParent)).invalidate(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isOpaque() {
        if ((this.mPrivateFlags & 0x1800000) != 0x1800000) return false;
        float f = this.mTransformationInfo != null ? this.mTransformationInfo.mAlpha : 1.0f;
        if (!(f >= 1.0f)) return false;
        return true;
    }

    protected void computeOpaqueFlags() {
        this.mPrivateFlags = this.mBackground != null && this.mBackground.getOpacity() == -1 ? (this.mPrivateFlags |= 0x800000) : (this.mPrivateFlags &= 0xFF7FFFFF);
        int flags = this.mViewFlags;
        this.mPrivateFlags = (flags & 0x200) == 0 && (flags & 0x100) == 0 || (flags & 0x3000000) == 0 ? (this.mPrivateFlags |= 0x1000000) : (this.mPrivateFlags &= 0xFEFFFFFF);
    }

    protected boolean hasOpaqueScrollbars() {
        return (this.mPrivateFlags & 0x1000000) == 0x1000000;
    }

    public Handler getHandler() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mHandler;
        }
        return null;
    }

    public ViewRootImpl getViewRootImpl() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mViewRootImpl;
        }
        return null;
    }

    public boolean post(Runnable action) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            return attachInfo.mHandler.post(action);
        }
        ViewRootImpl.getRunQueue().post(action);
        return true;
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            return attachInfo.mHandler.postDelayed(action, delayMillis);
        }
        ViewRootImpl.getRunQueue().postDelayed(action, delayMillis);
        return true;
    }

    public void postOnAnimation(Runnable action) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRootImpl.mChoreographer.postCallback(1, action, null);
        } else {
            ViewRootImpl.getRunQueue().post(action);
        }
    }

    public void postOnAnimationDelayed(Runnable action, long delayMillis) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRootImpl.mChoreographer.postCallbackDelayed(1, action, null, delayMillis);
        } else {
            ViewRootImpl.getRunQueue().postDelayed(action, delayMillis);
        }
    }

    public boolean removeCallbacks(Runnable action) {
        if (action != null) {
            AttachInfo attachInfo = this.mAttachInfo;
            if (attachInfo != null) {
                attachInfo.mHandler.removeCallbacks(action);
                attachInfo.mViewRootImpl.mChoreographer.removeCallbacks(1, action, null);
            } else {
                ViewRootImpl.getRunQueue().removeCallbacks(action);
            }
        }
        return true;
    }

    public void postInvalidate() {
        this.postInvalidateDelayed(0L);
    }

    public void postInvalidate(int left, int top, int right, int bottom) {
        this.postInvalidateDelayed(0L, left, top, right, bottom);
    }

    public void postInvalidateDelayed(long delayMilliseconds) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRootImpl.dispatchInvalidateDelayed(this, delayMilliseconds);
        }
    }

    public void postInvalidateDelayed(long delayMilliseconds, int left, int top, int right, int bottom) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            AttachInfo.InvalidateInfo info = AttachInfo.InvalidateInfo.acquire();
            info.target = this;
            info.left = left;
            info.top = top;
            info.right = right;
            info.bottom = bottom;
            attachInfo.mViewRootImpl.dispatchInvalidateRectDelayed(info, delayMilliseconds);
        }
    }

    public void postInvalidateOnAnimation() {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRootImpl.dispatchInvalidateOnAnimation(this);
        }
    }

    public void postInvalidateOnAnimation(int left, int top, int right, int bottom) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            AttachInfo.InvalidateInfo info = AttachInfo.InvalidateInfo.acquire();
            info.target = this;
            info.left = left;
            info.top = top;
            info.right = right;
            info.bottom = bottom;
            attachInfo.mViewRootImpl.dispatchInvalidateRectOnAnimation(info);
        }
    }

    private void postSendViewScrolledAccessibilityEventCallback() {
        if (this.mSendViewScrolledAccessibilityEvent == null) {
            this.mSendViewScrolledAccessibilityEvent = new SendViewScrolledAccessibilityEvent();
        }
        if (!this.mSendViewScrolledAccessibilityEvent.mIsPending) {
            this.mSendViewScrolledAccessibilityEvent.mIsPending = true;
            this.postDelayed(this.mSendViewScrolledAccessibilityEvent, ViewConfiguration.getSendRecurringAccessibilityEventsInterval());
        }
    }

    public void computeScroll() {
    }

    public boolean isHorizontalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x1000) == 4096;
    }

    public void setHorizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
        if (this.isHorizontalFadingEdgeEnabled() != horizontalFadingEdgeEnabled) {
            if (horizontalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x1000;
        }
    }

    public boolean isVerticalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x2000) == 8192;
    }

    public void setVerticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
        if (this.isVerticalFadingEdgeEnabled() != verticalFadingEdgeEnabled) {
            if (verticalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x2000;
        }
    }

    protected float getTopFadingEdgeStrength() {
        return this.computeVerticalScrollOffset() > 0 ? 1.0f : 0.0f;
    }

    protected float getBottomFadingEdgeStrength() {
        return this.computeVerticalScrollOffset() + this.computeVerticalScrollExtent() < this.computeVerticalScrollRange() ? 1.0f : 0.0f;
    }

    protected float getLeftFadingEdgeStrength() {
        return this.computeHorizontalScrollOffset() > 0 ? 1.0f : 0.0f;
    }

    protected float getRightFadingEdgeStrength() {
        return this.computeHorizontalScrollOffset() + this.computeHorizontalScrollExtent() < this.computeHorizontalScrollRange() ? 1.0f : 0.0f;
    }

    public boolean isHorizontalScrollBarEnabled() {
        return (this.mViewFlags & 0x100) == 256;
    }

    public void setHorizontalScrollBarEnabled(boolean horizontalScrollBarEnabled) {
        if (this.isHorizontalScrollBarEnabled() != horizontalScrollBarEnabled) {
            this.mViewFlags ^= 0x100;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    public boolean isVerticalScrollBarEnabled() {
        return (this.mViewFlags & 0x200) == 512;
    }

    public void setVerticalScrollBarEnabled(boolean verticalScrollBarEnabled) {
        if (this.isVerticalScrollBarEnabled() != verticalScrollBarEnabled) {
            this.mViewFlags ^= 0x200;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    protected void recomputePadding() {
        this.internalSetPadding(this.mUserPaddingLeft, this.mPaddingTop, this.mUserPaddingRight, this.mUserPaddingBottom);
    }

    public void setScrollbarFadingEnabled(boolean fadeScrollbars) {
        this.initScrollCache();
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        scrollabilityCache.fadeScrollBars = fadeScrollbars;
        scrollabilityCache.state = fadeScrollbars ? 0 : 1;
    }

    public boolean isScrollbarFadingEnabled() {
        return this.mScrollCache != null && this.mScrollCache.fadeScrollBars;
    }

    public int getScrollBarDefaultDelayBeforeFade() {
        return this.mScrollCache == null ? ViewConfiguration.getScrollDefaultDelay() : this.mScrollCache.scrollBarDefaultDelayBeforeFade;
    }

    public void setScrollBarDefaultDelayBeforeFade(int scrollBarDefaultDelayBeforeFade) {
        this.getScrollCache().scrollBarDefaultDelayBeforeFade = scrollBarDefaultDelayBeforeFade;
    }

    public int getScrollBarFadeDuration() {
        return this.mScrollCache == null ? ViewConfiguration.getScrollBarFadeDuration() : this.mScrollCache.scrollBarFadeDuration;
    }

    public void setScrollBarFadeDuration(int scrollBarFadeDuration) {
        this.getScrollCache().scrollBarFadeDuration = scrollBarFadeDuration;
    }

    public int getScrollBarSize() {
        return this.mScrollCache == null ? ViewConfiguration.get(this.mContext).getScaledScrollBarSize() : this.mScrollCache.scrollBarSize;
    }

    public void setScrollBarSize(int scrollBarSize) {
        this.getScrollCache().scrollBarSize = scrollBarSize;
    }

    public void setScrollBarStyle(int style2) {
        if (style2 != (this.mViewFlags & 0x3000000)) {
            this.mViewFlags = this.mViewFlags & 0xFCFFFFFF | style2 & 0x3000000;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=0, to="INSIDE_OVERLAY"), @ViewDebug.IntToString(from=0x1000000, to="INSIDE_INSET"), @ViewDebug.IntToString(from=0x2000000, to="OUTSIDE_OVERLAY"), @ViewDebug.IntToString(from=0x3000000, to="OUTSIDE_INSET")})
    public int getScrollBarStyle() {
        return this.mViewFlags & 0x3000000;
    }

    protected int computeHorizontalScrollRange() {
        return this.getWidth();
    }

    protected int computeHorizontalScrollOffset() {
        return this.mScrollX;
    }

    protected int computeHorizontalScrollExtent() {
        return this.getWidth();
    }

    protected int computeVerticalScrollRange() {
        return this.getHeight();
    }

    protected int computeVerticalScrollOffset() {
        return this.mScrollY;
    }

    protected int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    public boolean canScrollHorizontally(int direction) {
        int offset = this.computeHorizontalScrollOffset();
        int range = this.computeHorizontalScrollRange() - this.computeHorizontalScrollExtent();
        if (range == 0) {
            return false;
        }
        if (direction < 0) {
            return offset > 0;
        }
        return offset < range - 1;
    }

    public boolean canScrollVertically(int direction) {
        int offset = this.computeVerticalScrollOffset();
        int range = this.computeVerticalScrollRange() - this.computeVerticalScrollExtent();
        if (range == 0) {
            return false;
        }
        if (direction < 0) {
            return offset > 0;
        }
        return offset < range - 1;
    }

    protected void onDrawScrollBars(Canvas canvas) {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            boolean drawVerticalScrollBar;
            int state = cache.state;
            if (state == 0) {
                return;
            }
            boolean invalidate = false;
            if (state == 2) {
                float[] values;
                if (cache.interpolatorValues == null) {
                    cache.interpolatorValues = new float[1];
                }
                if (cache.scrollBarInterpolator.timeToValues(values = cache.interpolatorValues) == Interpolator.Result.FREEZE_END) {
                    cache.state = 0;
                } else {
                    cache.scrollBar.setAlpha(Math.round(values[0]));
                }
                invalidate = true;
            } else {
                cache.scrollBar.setAlpha(255);
            }
            int viewFlags = this.mViewFlags;
            boolean drawHorizontalScrollBar = (viewFlags & 0x100) == 256;
            boolean bl = drawVerticalScrollBar = (viewFlags & 0x200) == 512 && !this.isVerticalScrollBarHidden();
            if (drawVerticalScrollBar || drawHorizontalScrollBar) {
                int bottom;
                int right;
                int left;
                int top;
                int size;
                int inside;
                int width = this.mRight - this.mLeft;
                int height = this.mBottom - this.mTop;
                ScrollBarDrawable scrollBar = cache.scrollBar;
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                int n = inside = (viewFlags & 0x2000000) == 0 ? -1 : 0;
                if (drawHorizontalScrollBar) {
                    size = scrollBar.getSize(false);
                    if (size <= 0) {
                        size = cache.scrollBarSize;
                    }
                    scrollBar.setParameters(this.computeHorizontalScrollRange(), this.computeHorizontalScrollOffset(), this.computeHorizontalScrollExtent(), false);
                    int verticalScrollBarGap = drawVerticalScrollBar ? this.getVerticalScrollbarWidth() : 0;
                    top = scrollY + height - size - (this.mUserPaddingBottom & inside);
                    left = scrollX + (this.mPaddingLeft & inside);
                    right = scrollX + width - (this.mUserPaddingRight & inside) - verticalScrollBarGap;
                    bottom = top + size;
                    this.onDrawHorizontalScrollBar(canvas, scrollBar, left, top, right, bottom);
                    if (invalidate) {
                        this.invalidate(left, top, right, bottom);
                    }
                }
                if (drawVerticalScrollBar) {
                    size = scrollBar.getSize(true);
                    if (size <= 0) {
                        size = cache.scrollBarSize;
                    }
                    scrollBar.setParameters(this.computeVerticalScrollRange(), this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent(), true);
                    int verticalScrollbarPosition = this.mVerticalScrollbarPosition;
                    if (verticalScrollbarPosition == 0) {
                        verticalScrollbarPosition = this.isLayoutRtl() ? 1 : 2;
                    }
                    switch (verticalScrollbarPosition) {
                        default: {
                            left = scrollX + width - size - (this.mUserPaddingRight & inside);
                            break;
                        }
                        case 1: {
                            left = scrollX + (this.mUserPaddingLeft & inside);
                        }
                    }
                    top = scrollY + (this.mPaddingTop & inside);
                    right = left + size;
                    bottom = scrollY + height - (this.mUserPaddingBottom & inside);
                    this.onDrawVerticalScrollBar(canvas, scrollBar, left, top, right, bottom);
                    if (invalidate) {
                        this.invalidate(left, top, right, bottom);
                    }
                }
            }
        }
    }

    protected boolean isVerticalScrollBarHidden() {
        return false;
    }

    protected void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
    }

    void assignParent(ViewParent parent) {
        if (this.mParent == null) {
            this.mParent = parent;
        } else if (parent == null) {
            this.mParent = null;
        } else {
            throw new RuntimeException("view " + this + " being added, but" + " it already has a parent");
        }
    }

    protected void onAttachedToWindow() {
        if ((this.mPrivateFlags & 0x200) != 0) {
            this.mParent.requestTransparentRegion(this);
        }
        if ((this.mPrivateFlags & 0x8000000) != 0) {
            this.initialAwakenScrollBars();
            this.mPrivateFlags &= 0xF7FFFFFF;
        }
        this.jumpDrawablesToCurrentState();
        this.clearAccessibilityFocus();
        if (this.isFocused()) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            imm.focusIn(this);
        }
        if (this.mAttachInfo != null && this.mDisplayList != null) {
            this.mAttachInfo.mViewRootImpl.dequeueDisplayList(this.mDisplayList);
        }
    }

    public void resolveRtlPropertiesIfNeeded() {
        if (!this.needRtlPropertiesResolution()) {
            return;
        }
        if (!this.isLayoutDirectionResolved()) {
            this.resolveLayoutDirection();
            this.resolveLayoutParams();
        }
        if (!this.isTextDirectionResolved()) {
            this.resolveTextDirection();
        }
        if (!this.isTextAlignmentResolved()) {
            this.resolveTextAlignment();
        }
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        if (!this.isDrawablesResolved()) {
            this.resolveDrawables();
        }
        this.onRtlPropertiesChanged(this.getLayoutDirection());
    }

    public void resetRtlProperties() {
        this.resetResolvedLayoutDirection();
        this.resetResolvedTextDirection();
        this.resetResolvedTextAlignment();
        this.resetResolvedPadding();
        this.resetResolvedDrawables();
    }

    void dispatchScreenStateChanged(int screenState) {
        this.onScreenStateChanged(screenState);
    }

    public void onScreenStateChanged(int screenState) {
    }

    private boolean hasRtlSupport() {
        return this.mContext.getApplicationInfo().hasRtlSupport();
    }

    private boolean isRtlCompatibilityMode() {
        int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
        return targetSdkVersion < 17 || !this.hasRtlSupport();
    }

    private boolean needRtlPropertiesResolution() {
        return (this.mPrivateFlags2 & 0x60010220) != 1610678816;
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
    }

    public boolean resolveLayoutDirection() {
        this.mPrivateFlags2 &= 0xFFFFFFCF;
        if (this.hasRtlSupport()) {
            switch ((this.mPrivateFlags2 & 0xC) >> 2) {
                case 2: {
                    if (!this.canResolveLayoutDirection()) {
                        return false;
                    }
                    View parent = (View)((Object)this.mParent);
                    if (!parent.isLayoutDirectionResolved()) {
                        return false;
                    }
                    if (parent.getLayoutDirection() != 1) break;
                    this.mPrivateFlags2 |= 0x10;
                    break;
                }
                case 1: {
                    this.mPrivateFlags2 |= 0x10;
                    break;
                }
                case 3: {
                    if (1 != TextUtils.getLayoutDirectionFromLocale(Locale.getDefault())) break;
                    this.mPrivateFlags2 |= 0x10;
                    break;
                }
            }
        }
        this.mPrivateFlags2 |= 0x20;
        return true;
    }

    public boolean canResolveLayoutDirection() {
        switch (this.getRawLayoutDirection()) {
            case 2: {
                return this.mParent != null && this.mParent instanceof ViewGroup && ((ViewGroup)this.mParent).canResolveLayoutDirection();
            }
        }
        return true;
    }

    public void resetResolvedLayoutDirection() {
        this.mPrivateFlags2 &= 0xFFFFFFCF;
    }

    public boolean isLayoutDirectionInherited() {
        return this.getRawLayoutDirection() == 2;
    }

    private boolean isLayoutDirectionResolved() {
        return (this.mPrivateFlags2 & 0x20) == 32;
    }

    boolean isPaddingResolved() {
        return (this.mPrivateFlags2 & 0x20000000) == 0x20000000;
    }

    public void resolvePadding() {
        if (!this.isRtlCompatibilityMode()) {
            int resolvedLayoutDirection = this.getLayoutDirection();
            this.mUserPaddingLeft = this.mUserPaddingLeftInitial;
            this.mUserPaddingRight = this.mUserPaddingRightInitial;
            switch (resolvedLayoutDirection) {
                case 1: {
                    if (this.mUserPaddingStart != Integer.MIN_VALUE) {
                        this.mUserPaddingRight = this.mUserPaddingStart;
                    }
                    if (this.mUserPaddingEnd == Integer.MIN_VALUE) break;
                    this.mUserPaddingLeft = this.mUserPaddingEnd;
                    break;
                }
                default: {
                    if (this.mUserPaddingStart != Integer.MIN_VALUE) {
                        this.mUserPaddingLeft = this.mUserPaddingStart;
                    }
                    if (this.mUserPaddingEnd == Integer.MIN_VALUE) break;
                    this.mUserPaddingRight = this.mUserPaddingEnd;
                }
            }
            this.mUserPaddingBottom = this.mUserPaddingBottom >= 0 ? this.mUserPaddingBottom : this.mPaddingBottom;
            this.internalSetPadding(this.mUserPaddingLeft, this.mPaddingTop, this.mUserPaddingRight, this.mUserPaddingBottom);
            this.onRtlPropertiesChanged(resolvedLayoutDirection);
        }
        this.mPrivateFlags2 |= 0x20000000;
    }

    public void resetResolvedPadding() {
        this.mPrivateFlags2 &= 0xDFFFFFFF;
    }

    protected void onDetachedFromWindow() {
        this.mPrivateFlags &= 0xFBFFFFFF;
        this.removeUnsetPressCallback();
        this.removeLongPressCallback();
        this.removePerformClickCallback();
        this.removeSendViewScrolledAccessibilityEventCallback();
        this.destroyDrawingCache();
        this.destroyLayer(false);
        if (this.mAttachInfo != null) {
            if (this.mDisplayList != null) {
                this.mAttachInfo.mViewRootImpl.enqueueDisplayList(this.mDisplayList);
            }
            this.mAttachInfo.mViewRootImpl.cancelInvalidate(this);
        } else {
            this.clearDisplayList();
        }
        this.mCurrentAnimation = null;
        this.resetAccessibilityStateChanged();
    }

    protected int getWindowAttachCount() {
        return this.mWindowAttachCount;
    }

    public IBinder getWindowToken() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowToken : null;
    }

    public IBinder getApplicationWindowToken() {
        AttachInfo ai = this.mAttachInfo;
        if (ai != null) {
            IBinder appWindowToken = ai.mPanelParentWindowToken;
            if (appWindowToken == null) {
                appWindowToken = ai.mWindowToken;
            }
            return appWindowToken;
        }
        return null;
    }

    public Display getDisplay() {
        return this.mAttachInfo != null ? this.mAttachInfo.mDisplay : null;
    }

    IWindowSession getWindowSession() {
        return this.mAttachInfo != null ? this.mAttachInfo.mSession : null;
    }

    void dispatchAttachedToWindow(AttachInfo info, int visibility) {
        int vis;
        CopyOnWriteArrayList listeners;
        this.mAttachInfo = info;
        ++this.mWindowAttachCount;
        this.mPrivateFlags |= 0x400;
        if (this.mFloatingTreeObserver != null) {
            info.mTreeObserver.merge(this.mFloatingTreeObserver);
            this.mFloatingTreeObserver = null;
        }
        if ((this.mPrivateFlags & 0x80000) != 0) {
            this.mAttachInfo.mScrollContainers.add(this);
            this.mPrivateFlags |= 0x100000;
        }
        this.performCollectViewAttributes(this.mAttachInfo, visibility);
        this.onAttachedToWindow();
        ListenerInfo li = this.mListenerInfo;
        CopyOnWriteArrayList copyOnWriteArrayList = listeners = li != null ? li.mOnAttachStateChangeListeners : null;
        if (listeners != null && listeners.size() > 0) {
            for (OnAttachStateChangeListener listener : listeners) {
                listener.onViewAttachedToWindow(this);
            }
        }
        if ((vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(vis);
        }
        if ((this.mPrivateFlags & 0x400) != 0) {
            this.refreshDrawableState();
        }
        this.needGlobalAttributesUpdate(false);
    }

    void dispatchDetachedFromWindow() {
        CopyOnWriteArrayList listeners;
        int vis;
        AttachInfo info = this.mAttachInfo;
        if (info != null && (vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(8);
        }
        this.onDetachedFromWindow();
        ListenerInfo li = this.mListenerInfo;
        CopyOnWriteArrayList copyOnWriteArrayList = listeners = li != null ? li.mOnAttachStateChangeListeners : null;
        if (listeners != null && listeners.size() > 0) {
            for (OnAttachStateChangeListener listener : listeners) {
                listener.onViewDetachedFromWindow(this);
            }
        }
        if ((this.mPrivateFlags & 0x100000) != 0) {
            this.mAttachInfo.mScrollContainers.remove(this);
            this.mPrivateFlags &= 0xFFEFFFFF;
        }
        this.mAttachInfo = null;
    }

    public void saveHierarchyState(SparseArray<Parcelable> container) {
        this.dispatchSaveInstanceState(container);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        if (this.mID != -1 && (this.mViewFlags & 0x10000) == 0) {
            this.mPrivateFlags &= 0xFFFDFFFF;
            Parcelable state = this.onSaveInstanceState();
            if ((this.mPrivateFlags & 0x20000) == 0) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.put(this.mID, state);
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        this.mPrivateFlags |= 0x20000;
        return BaseSavedState.EMPTY_STATE;
    }

    public void restoreHierarchyState(SparseArray<Parcelable> container) {
        this.dispatchRestoreInstanceState(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable state;
        if (this.mID != -1 && (state = container.get(this.mID)) != null) {
            this.mPrivateFlags &= 0xFFFDFFFF;
            this.onRestoreInstanceState(state);
            if ((this.mPrivateFlags & 0x20000) == 0) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        this.mPrivateFlags |= 0x20000;
        if (state != BaseSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class, expecting View State but received " + state.getClass().toString() + " instead. This usually happens " + "when two views of different type have the same id in the same hierarchy. " + "This view's id is " + ViewDebug.resolveId(this.mContext, this.getId()) + ". Make sure " + "other views do not use the same id.");
        }
    }

    public long getDrawingTime() {
        return this.mAttachInfo != null ? this.mAttachInfo.mDrawingTime : 0L;
    }

    public void setDuplicateParentStateEnabled(boolean enabled) {
        this.setFlags(enabled ? 0x400000 : 0, 0x400000);
    }

    public boolean isDuplicateParentStateEnabled() {
        return (this.mViewFlags & 0x400000) == 0x400000;
    }

    public void setLayerType(int layerType, Paint paint) {
        boolean layerDisabled;
        if (layerType < 0 || layerType > 2) {
            throw new IllegalArgumentException("Layer type can only be one of: LAYER_TYPE_NONE, LAYER_TYPE_SOFTWARE or LAYER_TYPE_HARDWARE");
        }
        if (layerType == this.mLayerType) {
            if (layerType != 0 && paint != this.mLayerPaint) {
                this.mLayerPaint = paint == null ? new Paint() : paint;
                this.invalidateParentCaches();
                this.invalidate(true);
            }
            return;
        }
        switch (this.mLayerType) {
            case 2: {
                this.destroyLayer(false);
            }
            case 1: {
                this.destroyDrawingCache();
                break;
            }
        }
        this.mLayerType = layerType;
        boolean bl = layerDisabled = this.mLayerType == 0;
        this.mLayerPaint = layerDisabled ? null : (paint == null ? new Paint() : paint);
        this.mLocalDirtyRect = layerDisabled ? null : new Rect();
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    public void setLayerPaint(Paint paint) {
        int layerType = this.getLayerType();
        if (layerType != 0) {
            Paint paint2 = this.mLayerPaint = paint == null ? new Paint() : paint;
            if (layerType == 2) {
                HardwareLayer layer = this.getHardwareLayer();
                if (layer != null) {
                    layer.setLayerPaint(paint);
                }
                this.invalidateViewProperty(false, false);
            } else {
                this.invalidate();
            }
        }
    }

    boolean hasStaticLayer() {
        return true;
    }

    public int getLayerType() {
        return this.mLayerType;
    }

    public void buildLayer() {
        if (this.mLayerType == 0) {
            return;
        }
        if (this.mAttachInfo == null) {
            throw new IllegalStateException("This view must be attached to a window first");
        }
        switch (this.mLayerType) {
            case 2: {
                if (this.mAttachInfo.mHardwareRenderer == null || !this.mAttachInfo.mHardwareRenderer.isEnabled() || !this.mAttachInfo.mHardwareRenderer.validate()) break;
                this.getHardwareLayer();
                break;
            }
            case 1: {
                this.buildDrawingCache(true);
            }
        }
    }

    HardwareLayer getHardwareLayer() {
        if (this.mAttachInfo == null || this.mAttachInfo.mHardwareRenderer == null || !this.mAttachInfo.mHardwareRenderer.isEnabled()) {
            return null;
        }
        if (!this.mAttachInfo.mHardwareRenderer.validate()) {
            return null;
        }
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width == 0 || height == 0) {
            return null;
        }
        if ((this.mPrivateFlags & 0x8000) == 0 || this.mHardwareLayer == null) {
            if (this.mHardwareLayer == null) {
                this.mHardwareLayer = this.mAttachInfo.mHardwareRenderer.createHardwareLayer(width, height, this.isOpaque());
                this.mLocalDirtyRect.set(0, 0, width, height);
            } else {
                if ((this.mHardwareLayer.getWidth() != width || this.mHardwareLayer.getHeight() != height) && this.mHardwareLayer.resize(width, height)) {
                    this.mLocalDirtyRect.set(0, 0, width, height);
                }
                this.computeOpaqueFlags();
                boolean opaque = this.isOpaque();
                if (this.mHardwareLayer.isValid() && this.mHardwareLayer.isOpaque() != opaque) {
                    this.mHardwareLayer.setOpaque(opaque);
                    this.mLocalDirtyRect.set(0, 0, width, height);
                }
            }
            if (!this.mHardwareLayer.isValid()) {
                return null;
            }
            this.mHardwareLayer.setLayerPaint(this.mLayerPaint);
            this.mHardwareLayer.redrawLater(this.getHardwareLayerDisplayList(this.mHardwareLayer), this.mLocalDirtyRect);
            ViewRootImpl viewRoot = this.getViewRootImpl();
            if (viewRoot != null) {
                viewRoot.pushHardwareLayerUpdate(this.mHardwareLayer);
            }
            this.mLocalDirtyRect.setEmpty();
        }
        return this.mHardwareLayer;
    }

    boolean destroyLayer(boolean valid) {
        if (this.mHardwareLayer != null) {
            AttachInfo info = this.mAttachInfo;
            if (info != null && info.mHardwareRenderer != null && info.mHardwareRenderer.isEnabled() && (valid || info.mHardwareRenderer.validate())) {
                this.mHardwareLayer.destroy();
                this.mHardwareLayer = null;
                if (this.mDisplayList != null) {
                    this.mDisplayList.reset();
                }
                this.invalidate(true);
                this.invalidateParentCaches();
            }
            return true;
        }
        return false;
    }

    protected void destroyHardwareResources() {
        this.destroyLayer(true);
    }

    public void setDrawingCacheEnabled(boolean enabled) {
        this.mCachingFailed = false;
        this.setFlags(enabled ? 32768 : 0, 32768);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isDrawingCacheEnabled() {
        return (this.mViewFlags & 0x8000) == 32768;
    }

    public void outputDirtyFlags(String indent, boolean clear, int clearMask) {
        Log.d(VIEW_LOG_TAG, indent + this + "             DIRTY(" + (this.mPrivateFlags & 0x600000) + ") DRAWN(" + (this.mPrivateFlags & 0x20) + ")" + " CACHE_VALID(" + (this.mPrivateFlags & 0x8000) + ") INVALIDATED(" + (this.mPrivateFlags & Integer.MIN_VALUE) + ")");
        if (clear) {
            this.mPrivateFlags &= clearMask;
        }
        if (this instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)this;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = parent.getChildAt(i);
                child.outputDirtyFlags(indent + "  ", clear, clearMask);
            }
        }
    }

    protected void dispatchGetDisplayList() {
    }

    public boolean canHaveDisplayList() {
        return this.mAttachInfo != null && this.mAttachInfo.mHardwareRenderer != null;
    }

    public HardwareRenderer getHardwareRenderer() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mHardwareRenderer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DisplayList getDisplayList(DisplayList displayList, boolean isLayer) {
        if (!this.canHaveDisplayList()) {
            return null;
        }
        if ((this.mPrivateFlags & 0x8000) == 0 || displayList == null || !displayList.isValid() || !isLayer && this.mRecreateDisplayList) {
            if (displayList != null && displayList.isValid() && !isLayer && !this.mRecreateDisplayList) {
                this.mPrivateFlags |= 0x8020;
                this.mPrivateFlags &= 0xFF9FFFFF;
                this.dispatchGetDisplayList();
                return displayList;
            }
            if (!isLayer) {
                this.mRecreateDisplayList = true;
            }
            if (displayList == null) {
                String name = this.getClass().getSimpleName();
                displayList = this.mAttachInfo.mHardwareRenderer.createDisplayList(name);
                this.invalidateParentCaches();
            }
            boolean caching = false;
            HardwareCanvas canvas = displayList.start();
            int width = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            try {
                canvas.setViewport(width, height);
                canvas.onPreDraw(null);
                int layerType = this.getLayerType();
                if (!isLayer && layerType != 0) {
                    if (layerType == 2) {
                        HardwareLayer layer = this.getHardwareLayer();
                        if (layer != null && layer.isValid()) {
                            canvas.drawHardwareLayer(layer, 0.0f, 0.0f, this.mLayerPaint);
                        } else {
                            canvas.saveLayer(0.0f, 0.0f, this.mRight - this.mLeft, this.mBottom - this.mTop, this.mLayerPaint, 20);
                        }
                        caching = true;
                        return displayList;
                    }
                    this.buildDrawingCache(true);
                    Bitmap cache = this.getDrawingCache(true);
                    if (cache == null) return displayList;
                    canvas.drawBitmap(cache, 0.0f, 0.0f, this.mLayerPaint);
                    caching = true;
                    return displayList;
                }
                this.computeScroll();
                canvas.translate(-this.mScrollX, -this.mScrollY);
                if (!isLayer) {
                    this.mPrivateFlags |= 0x8020;
                    this.mPrivateFlags &= 0xFF9FFFFF;
                }
                if ((this.mPrivateFlags & 0x80) == 128) {
                    this.dispatchDraw(canvas);
                    return displayList;
                }
                this.draw(canvas);
                return displayList;
            }
            finally {
                canvas.onPostDraw();
                displayList.end();
                displayList.setCaching(caching);
                if (isLayer) {
                    displayList.setLeftTopRightBottom(0, 0, width, height);
                } else {
                    this.setDisplayListProperties(displayList);
                }
            }
        } else {
            if (isLayer) return displayList;
            this.mPrivateFlags |= 0x8020;
            this.mPrivateFlags &= 0xFF9FFFFF;
        }
        return displayList;
    }

    private DisplayList getHardwareLayerDisplayList(HardwareLayer layer) {
        DisplayList displayList = this.getDisplayList(layer.getDisplayList(), true);
        layer.setDisplayList(displayList);
        return displayList;
    }

    public DisplayList getDisplayList() {
        this.mDisplayList = this.getDisplayList(this.mDisplayList, false);
        return this.mDisplayList;
    }

    private void clearDisplayList() {
        if (this.mDisplayList != null) {
            this.mDisplayList.invalidate();
            this.mDisplayList.clear();
        }
    }

    public Bitmap getDrawingCache() {
        return this.getDrawingCache(false);
    }

    public Bitmap getDrawingCache(boolean autoScale) {
        if ((this.mViewFlags & 0x20000) == 131072) {
            return null;
        }
        if ((this.mViewFlags & 0x8000) == 32768) {
            this.buildDrawingCache(autoScale);
        }
        return autoScale ? this.mDrawingCache : this.mUnscaledDrawingCache;
    }

    public void destroyDrawingCache() {
        if (this.mDrawingCache != null) {
            this.mDrawingCache.recycle();
            this.mDrawingCache = null;
        }
        if (this.mUnscaledDrawingCache != null) {
            this.mUnscaledDrawingCache.recycle();
            this.mUnscaledDrawingCache = null;
        }
    }

    public void setDrawingCacheBackgroundColor(int color2) {
        if (color2 != this.mDrawingCacheBackgroundColor) {
            this.mDrawingCacheBackgroundColor = color2;
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
    }

    public int getDrawingCacheBackgroundColor() {
        return this.mDrawingCacheBackgroundColor;
    }

    public void buildDrawingCache() {
        this.buildDrawingCache(false);
    }

    public void buildDrawingCache(boolean autoScale) {
        if ((this.mPrivateFlags & 0x8000) == 0 || (autoScale ? this.mDrawingCache == null : this.mUnscaledDrawingCache == null)) {
            Canvas canvas;
            Bitmap bitmap;
            int drawingCacheBackgroundColor;
            boolean scalingRequired;
            this.mCachingFailed = false;
            int width = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            AttachInfo attachInfo = this.mAttachInfo;
            boolean bl = scalingRequired = attachInfo != null && attachInfo.mScalingRequired;
            if (autoScale && scalingRequired) {
                width = (int)((float)width * attachInfo.mApplicationScale + 0.5f);
                height = (int)((float)height * attachInfo.mApplicationScale + 0.5f);
            }
            boolean opaque = (drawingCacheBackgroundColor = this.mDrawingCacheBackgroundColor) != 0 || this.isOpaque();
            boolean use32BitCache = attachInfo != null && attachInfo.mUse32BitDrawingCache;
            long projectedBitmapSize = width * height * (opaque && !use32BitCache ? 2 : 4);
            long drawingCacheSize = ViewConfiguration.get(this.mContext).getScaledMaximumDrawingCacheSize();
            if (width <= 0 || height <= 0 || projectedBitmapSize > drawingCacheSize) {
                if (width > 0 && height > 0) {
                    Log.w(VIEW_LOG_TAG, "View too large to fit into drawing cache, needs " + projectedBitmapSize + " bytes, only " + drawingCacheSize + " available");
                }
                this.destroyDrawingCache();
                this.mCachingFailed = true;
                return;
            }
            boolean clear = true;
            Bitmap bitmap2 = bitmap = autoScale ? this.mDrawingCache : this.mUnscaledDrawingCache;
            if (bitmap == null || bitmap.getWidth() != width || bitmap.getHeight() != height) {
                Bitmap.Config quality;
                if (!opaque) {
                    switch (this.mViewFlags & 0x180000) {
                        case 0: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        case 524288: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        case 0x100000: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        default: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                    }
                } else {
                    Bitmap.Config config = quality = use32BitCache ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                }
                if (bitmap != null) {
                    bitmap.recycle();
                }
                try {
                    bitmap = Bitmap.createBitmap(this.mResources.getDisplayMetrics(), width, height, quality);
                    bitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
                    if (autoScale) {
                        this.mDrawingCache = bitmap;
                    } else {
                        this.mUnscaledDrawingCache = bitmap;
                    }
                    if (opaque && use32BitCache) {
                        bitmap.setHasAlpha(false);
                    }
                }
                catch (OutOfMemoryError e) {
                    if (autoScale) {
                        this.mDrawingCache = null;
                    } else {
                        this.mUnscaledDrawingCache = null;
                    }
                    this.mCachingFailed = true;
                    return;
                }
                boolean bl2 = clear = drawingCacheBackgroundColor != 0;
            }
            if (attachInfo != null) {
                canvas = attachInfo.mCanvas;
                if (canvas == null) {
                    canvas = new Canvas();
                }
                canvas.setBitmap(bitmap);
                attachInfo.mCanvas = null;
            } else {
                canvas = new Canvas(bitmap);
            }
            if (clear) {
                bitmap.eraseColor(drawingCacheBackgroundColor);
            }
            this.computeScroll();
            int restoreCount = canvas.save();
            if (autoScale && scalingRequired) {
                float scale = attachInfo.mApplicationScale;
                canvas.scale(scale, scale);
            }
            canvas.translate(-this.mScrollX, -this.mScrollY);
            this.mPrivateFlags |= 0x20;
            if (this.mAttachInfo == null || !this.mAttachInfo.mHardwareAccelerated || this.mLayerType != 0) {
                this.mPrivateFlags |= 0x8000;
            }
            if ((this.mPrivateFlags & 0x80) == 128) {
                this.mPrivateFlags &= 0xFF9FFFFF;
                this.dispatchDraw(canvas);
            } else {
                this.draw(canvas);
            }
            canvas.restoreToCount(restoreCount);
            canvas.setBitmap(null);
            if (attachInfo != null) {
                attachInfo.mCanvas = canvas;
            }
        }
    }

    Bitmap createSnapshot(Bitmap.Config quality, int backgroundColor, boolean skipChildren) {
        Canvas canvas;
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        AttachInfo attachInfo = this.mAttachInfo;
        float scale = attachInfo != null ? attachInfo.mApplicationScale : 1.0f;
        width = (int)((float)width * scale + 0.5f);
        height = (int)((float)height * scale + 0.5f);
        Bitmap bitmap = Bitmap.createBitmap(this.mResources.getDisplayMetrics(), width > 0 ? width : 1, height > 0 ? height : 1, quality);
        if (bitmap == null) {
            throw new OutOfMemoryError();
        }
        Resources resources = this.getResources();
        if (resources != null) {
            bitmap.setDensity(resources.getDisplayMetrics().densityDpi);
        }
        if (attachInfo != null) {
            canvas = attachInfo.mCanvas;
            if (canvas == null) {
                canvas = new Canvas();
            }
            canvas.setBitmap(bitmap);
            attachInfo.mCanvas = null;
        } else {
            canvas = new Canvas(bitmap);
        }
        if ((backgroundColor & 0xFF000000) != 0) {
            bitmap.eraseColor(backgroundColor);
        }
        this.computeScroll();
        int restoreCount = canvas.save();
        canvas.scale(scale, scale);
        canvas.translate(-this.mScrollX, -this.mScrollY);
        int flags = this.mPrivateFlags;
        this.mPrivateFlags &= 0xFF9FFFFF;
        if ((this.mPrivateFlags & 0x80) == 128) {
            this.dispatchDraw(canvas);
        } else {
            this.draw(canvas);
        }
        this.mPrivateFlags = flags;
        canvas.restoreToCount(restoreCount);
        canvas.setBitmap(null);
        if (attachInfo != null) {
            attachInfo.mCanvas = canvas;
        }
        return bitmap;
    }

    public boolean isInEditMode_Original() {
        return false;
    }

    @LayoutlibDelegate
    public boolean isInEditMode() {
        return View_Delegate.isInEditMode(this);
    }

    protected boolean isPaddingOffsetRequired() {
        return false;
    }

    protected int getLeftPaddingOffset() {
        return 0;
    }

    protected int getRightPaddingOffset() {
        return 0;
    }

    protected int getTopPaddingOffset() {
        return 0;
    }

    protected int getBottomPaddingOffset() {
        return 0;
    }

    protected int getFadeTop(boolean offsetRequired) {
        int top = this.mPaddingTop;
        if (offsetRequired) {
            top += this.getTopPaddingOffset();
        }
        return top;
    }

    protected int getFadeHeight(boolean offsetRequired) {
        int padding = this.mPaddingTop;
        if (offsetRequired) {
            padding += this.getTopPaddingOffset();
        }
        return this.mBottom - this.mTop - this.mPaddingBottom - padding;
    }

    public boolean isHardwareAccelerated() {
        return this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerated;
    }

    private boolean drawAnimation(ViewGroup parent, long drawingTime, Animation a, boolean scalingRequired) {
        Transformation invalidationTransform;
        int flags = parent.mGroupFlags;
        boolean initialized = a.isInitialized();
        if (!initialized) {
            a.initialize(this.mRight - this.mLeft, this.mBottom - this.mTop, parent.getWidth(), parent.getHeight());
            a.initializeInvalidateRegion(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            if (this.mAttachInfo != null) {
                a.setListenerHandler(this.mAttachInfo.mHandler);
            }
            this.onAnimationStart();
        }
        boolean more = a.getTransformation(drawingTime, parent.mChildTransformation, 1.0f);
        if (scalingRequired && this.mAttachInfo.mApplicationScale != 1.0f) {
            if (parent.mInvalidationTransformation == null) {
                parent.mInvalidationTransformation = new Transformation();
            }
            invalidationTransform = parent.mInvalidationTransformation;
            a.getTransformation(drawingTime, invalidationTransform, 1.0f);
        } else {
            invalidationTransform = parent.mChildTransformation;
        }
        if (more) {
            if (!a.willChangeBounds()) {
                if ((flags & 0x90) == 128) {
                    parent.mGroupFlags |= 4;
                } else if ((flags & 4) == 0) {
                    parent.mPrivateFlags |= 0x40;
                    parent.invalidate(this.mLeft, this.mTop, this.mRight, this.mBottom);
                }
            } else {
                if (parent.mInvalidateRegion == null) {
                    parent.mInvalidateRegion = new RectF();
                }
                RectF region = parent.mInvalidateRegion;
                a.getInvalidateRegion(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop, region, invalidationTransform);
                parent.mPrivateFlags |= 0x40;
                int left = this.mLeft + (int)region.left;
                int top = this.mTop + (int)region.top;
                parent.invalidate(left, top, left + (int)(region.width() + 0.5f), top + (int)(region.height() + 0.5f));
            }
        }
        return more;
    }

    void setDisplayListProperties(DisplayList displayList) {
        if (displayList != null) {
            ViewGroup parentVG;
            boolean hasTransform;
            displayList.setLeftTopRightBottom(this.mLeft, this.mTop, this.mRight, this.mBottom);
            displayList.setHasOverlappingRendering(this.hasOverlappingRendering());
            if (this.mParent instanceof ViewGroup) {
                displayList.setClipChildren((((ViewGroup)this.mParent).mGroupFlags & 1) != 0);
            }
            float alpha = 1.0f;
            if (this.mParent instanceof ViewGroup && (((ViewGroup)this.mParent).mGroupFlags & 0x800) != 0 && (hasTransform = (parentVG = (ViewGroup)this.mParent).getChildStaticTransformation(this, parentVG.mChildTransformation))) {
                Transformation transform = parentVG.mChildTransformation;
                int transformType = parentVG.mChildTransformation.getTransformationType();
                if (transformType != Transformation.TYPE_IDENTITY) {
                    if ((transformType & Transformation.TYPE_ALPHA) != 0) {
                        alpha = transform.getAlpha();
                    }
                    if ((transformType & Transformation.TYPE_MATRIX) != 0) {
                        displayList.setStaticMatrix(transform.getMatrix());
                    }
                }
            }
            if (this.mTransformationInfo != null) {
                int multipliedAlpha;
                if ((alpha *= this.mTransformationInfo.mAlpha) < 1.0f && this.onSetAlpha(multipliedAlpha = (int)(255.0f * alpha))) {
                    alpha = 1.0f;
                }
                displayList.setTransformationInfo(alpha, this.mTransformationInfo.mTranslationX, this.mTransformationInfo.mTranslationY, this.mTransformationInfo.mRotation, this.mTransformationInfo.mRotationX, this.mTransformationInfo.mRotationY, this.mTransformationInfo.mScaleX, this.mTransformationInfo.mScaleY);
                if (this.mTransformationInfo.mCamera == null) {
                    this.mTransformationInfo.mCamera = new Camera();
                    this.mTransformationInfo.matrix3D = new Matrix();
                }
                displayList.setCameraDistance(this.mTransformationInfo.mCamera.getLocationZ());
                if ((this.mPrivateFlags & 0x20000000) == 0x20000000) {
                    displayList.setPivotX(this.getPivotX());
                    displayList.setPivotY(this.getPivotY());
                }
            } else if (alpha < 1.0f) {
                displayList.setAlpha(alpha);
            }
        }
    }

    boolean draw(Canvas canvas, ViewGroup parent, long drawingTime) {
        int scrollY;
        float alpha;
        Animation a;
        boolean caching;
        boolean useDisplayListProperties = this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerated;
        boolean more = false;
        boolean childHasIdentityMatrix = this.hasIdentityMatrix();
        int flags = parent.mGroupFlags;
        if ((flags & 0x100) == 256) {
            parent.mChildTransformation.clear();
            parent.mGroupFlags &= 0xFFFFFEFF;
        }
        Transformation transformToApply = null;
        boolean concatMatrix = false;
        boolean scalingRequired = false;
        int layerType = this.getLayerType();
        boolean hardwareAccelerated = canvas.isHardwareAccelerated();
        if ((flags & 0x8000) != 0 || (flags & 0x4000) != 0) {
            caching = true;
            if (this.mAttachInfo != null) {
                scalingRequired = this.mAttachInfo.mScalingRequired;
            }
        } else {
            boolean bl = caching = layerType != 0 || hardwareAccelerated;
        }
        if ((a = this.getAnimation()) != null) {
            more = this.drawAnimation(parent, drawingTime, a, scalingRequired);
            concatMatrix = a.willChangeTransformationMatrix();
            if (concatMatrix) {
                this.mPrivateFlags3 |= 1;
            }
            transformToApply = parent.mChildTransformation;
        } else {
            boolean hasTransform;
            if ((this.mPrivateFlags3 & 1) == 1 && this.mDisplayList != null) {
                this.mDisplayList.setAnimationMatrix(null);
                this.mPrivateFlags3 &= 0xFFFFFFFE;
            }
            if (!useDisplayListProperties && (flags & 0x800) != 0 && (hasTransform = parent.getChildStaticTransformation(this, parent.mChildTransformation))) {
                int transformType = parent.mChildTransformation.getTransformationType();
                transformToApply = transformType != Transformation.TYPE_IDENTITY ? parent.mChildTransformation : null;
                concatMatrix = (transformType & Transformation.TYPE_MATRIX) != 0;
            }
        }
        boolean bl = !childHasIdentityMatrix;
        this.mPrivateFlags |= 0x20;
        if (!(concatMatrix |= bl) && (flags & 0x801) == 1 && canvas.quickReject(this.mLeft, this.mTop, this.mRight, this.mBottom, Canvas.EdgeType.BW) && (this.mPrivateFlags & 0x40) == 0) {
            this.mPrivateFlags2 |= 0x10000000;
            return more;
        }
        this.mPrivateFlags2 &= 0xEFFFFFFF;
        if (hardwareAccelerated) {
            this.mRecreateDisplayList = (this.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
            this.mPrivateFlags &= Integer.MAX_VALUE;
        }
        DisplayList displayList = null;
        Bitmap cache = null;
        boolean hasDisplayList = false;
        if (caching) {
            if (!hardwareAccelerated) {
                if (layerType != 0) {
                    layerType = 1;
                    this.buildDrawingCache(true);
                }
                cache = this.getDrawingCache(true);
            } else {
                switch (layerType) {
                    case 1: {
                        if (useDisplayListProperties) {
                            hasDisplayList = this.canHaveDisplayList();
                            break;
                        }
                        this.buildDrawingCache(true);
                        cache = this.getDrawingCache(true);
                        break;
                    }
                    case 2: {
                        if (!useDisplayListProperties) break;
                        hasDisplayList = this.canHaveDisplayList();
                        break;
                    }
                    case 0: {
                        hasDisplayList = this.canHaveDisplayList();
                    }
                }
            }
        }
        if ((useDisplayListProperties &= hasDisplayList) && !(displayList = this.getDisplayList()).isValid()) {
            displayList = null;
            hasDisplayList = false;
            useDisplayListProperties = false;
        }
        int sx = 0;
        int sy = 0;
        if (!hasDisplayList) {
            this.computeScroll();
            sx = this.mScrollX;
            sy = this.mScrollY;
        }
        boolean hasNoCache = cache == null || hasDisplayList;
        boolean offsetForScroll = cache == null && !hasDisplayList && layerType != 2;
        int restoreTo = -1;
        if (!useDisplayListProperties || transformToApply != null) {
            restoreTo = canvas.save();
        }
        if (offsetForScroll) {
            canvas.translate(this.mLeft - sx, this.mTop - sy);
        } else {
            if (!useDisplayListProperties) {
                canvas.translate(this.mLeft, this.mTop);
            }
            if (scalingRequired) {
                if (useDisplayListProperties) {
                    restoreTo = canvas.save();
                }
                float scale = 1.0f / this.mAttachInfo.mApplicationScale;
                canvas.scale(scale, scale);
            }
        }
        float f = alpha = useDisplayListProperties ? 1.0f : this.getAlpha();
        if (transformToApply != null || alpha < 1.0f || !this.hasIdentityMatrix() || (this.mPrivateFlags3 & 2) == 2) {
            if (transformToApply != null || !childHasIdentityMatrix) {
                int transX = 0;
                int transY = 0;
                if (offsetForScroll) {
                    transX = -sx;
                    transY = -sy;
                }
                if (transformToApply != null) {
                    float transformAlpha;
                    if (concatMatrix) {
                        if (useDisplayListProperties) {
                            displayList.setAnimationMatrix(transformToApply.getMatrix());
                        } else {
                            canvas.translate(-transX, -transY);
                            canvas.concat(transformToApply.getMatrix());
                            canvas.translate(transX, transY);
                        }
                        parent.mGroupFlags |= 0x100;
                    }
                    if ((transformAlpha = transformToApply.getAlpha()) < 1.0f) {
                        alpha *= transformAlpha;
                        parent.mGroupFlags |= 0x100;
                    }
                }
                if (!childHasIdentityMatrix && !useDisplayListProperties) {
                    canvas.translate(-transX, -transY);
                    canvas.concat(this.getMatrix());
                    canvas.translate(transX, transY);
                }
            }
            if (alpha < 1.0f || (this.mPrivateFlags3 & 2) == 2) {
                this.mPrivateFlags3 = alpha < 1.0f ? (this.mPrivateFlags3 |= 2) : (this.mPrivateFlags3 &= 0xFFFFFFFD);
                parent.mGroupFlags |= 0x100;
                if (hasNoCache) {
                    int multipliedAlpha = (int)(255.0f * alpha);
                    if (!this.onSetAlpha(multipliedAlpha)) {
                        int layerFlags = 4;
                        if ((flags & 1) != 0 || layerType != 0) {
                            layerFlags |= 0x10;
                        }
                        if (useDisplayListProperties) {
                            displayList.setAlpha(alpha * this.getAlpha());
                        } else if (layerType == 0) {
                            int scrollX = hasDisplayList ? 0 : sx;
                            scrollY = hasDisplayList ? 0 : sy;
                            canvas.saveLayerAlpha(scrollX, scrollY, scrollX + this.mRight - this.mLeft, scrollY + this.mBottom - this.mTop, multipliedAlpha, layerFlags);
                        }
                    } else {
                        this.mPrivateFlags |= 0x40000;
                    }
                }
            }
        } else if ((this.mPrivateFlags & 0x40000) == 262144) {
            this.onSetAlpha(255);
            this.mPrivateFlags &= 0xFFFBFFFF;
        }
        if ((flags & 1) == 1 && !useDisplayListProperties) {
            if (offsetForScroll) {
                canvas.clipRect(sx, sy, sx + (this.mRight - this.mLeft), sy + (this.mBottom - this.mTop));
            } else if (!scalingRequired || cache == null) {
                canvas.clipRect(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            } else {
                canvas.clipRect(0, 0, cache.getWidth(), cache.getHeight());
            }
        }
        if (!useDisplayListProperties && hasDisplayList && !(displayList = this.getDisplayList()).isValid()) {
            displayList = null;
            hasDisplayList = false;
        }
        if (hasNoCache) {
            boolean layerRendered = false;
            if (layerType == 2 && !useDisplayListProperties) {
                HardwareLayer layer = this.getHardwareLayer();
                if (layer != null && layer.isValid()) {
                    this.mLayerPaint.setAlpha((int)(alpha * 255.0f));
                    ((HardwareCanvas)canvas).drawHardwareLayer(layer, 0.0f, 0.0f, this.mLayerPaint);
                    layerRendered = true;
                } else {
                    int scrollX = hasDisplayList ? 0 : sx;
                    scrollY = hasDisplayList ? 0 : sy;
                    canvas.saveLayer(scrollX, scrollY, scrollX + this.mRight - this.mLeft, scrollY + this.mBottom - this.mTop, this.mLayerPaint, 20);
                }
            }
            if (!layerRendered) {
                if (!hasDisplayList) {
                    if ((this.mPrivateFlags & 0x80) == 128) {
                        this.mPrivateFlags &= 0xFF9FFFFF;
                        this.dispatchDraw(canvas);
                    } else {
                        this.draw(canvas);
                    }
                } else {
                    this.mPrivateFlags &= 0xFF9FFFFF;
                    ((HardwareCanvas)canvas).drawDisplayList(displayList, null, flags);
                }
            }
        } else if (cache != null) {
            Paint cachePaint;
            this.mPrivateFlags &= 0xFF9FFFFF;
            if (layerType == 0) {
                cachePaint = parent.mCachePaint;
                if (cachePaint == null) {
                    cachePaint = new Paint();
                    cachePaint.setDither(false);
                    parent.mCachePaint = cachePaint;
                }
                if (alpha < 1.0f) {
                    cachePaint.setAlpha((int)(alpha * 255.0f));
                    parent.mGroupFlags |= 0x1000;
                } else if ((flags & 0x1000) != 0) {
                    cachePaint.setAlpha(255);
                    parent.mGroupFlags &= 0xFFFFEFFF;
                }
            } else {
                cachePaint = this.mLayerPaint;
                cachePaint.setAlpha((int)(alpha * 255.0f));
            }
            canvas.drawBitmap(cache, 0.0f, 0.0f, cachePaint);
        }
        if (restoreTo >= 0) {
            canvas.restoreToCount(restoreTo);
        }
        if (a != null && !more) {
            if (!hardwareAccelerated && !a.getFillAfter()) {
                this.onSetAlpha(255);
            }
            parent.finishAnimatingView(this, a);
        }
        if (more && hardwareAccelerated) {
            parent.invalidate(true);
            if (a.hasAlpha() && (this.mPrivateFlags & 0x40000) == 262144) {
                this.invalidate(true);
            }
        }
        this.mRecreateDisplayList = false;
        return more;
    }

    public void draw(Canvas canvas) {
        boolean verticalEdges;
        int viewFlags;
        Drawable background;
        int privateFlags = this.mPrivateFlags;
        boolean dirtyOpaque = (privateFlags & 0x600000) == 0x400000 && (this.mAttachInfo == null || !this.mAttachInfo.mIgnoreDirtyState);
        this.mPrivateFlags = privateFlags & 0xFF9FFFFF | 0x20;
        if (!dirtyOpaque && (background = this.mBackground) != null) {
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            if (this.mBackgroundSizeChanged) {
                background.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                this.mBackgroundSizeChanged = false;
            }
            if ((scrollX | scrollY) == 0) {
                background.draw(canvas);
            } else {
                canvas.translate(scrollX, scrollY);
                background.draw(canvas);
                canvas.translate(-scrollX, -scrollY);
            }
        }
        boolean horizontalEdges = ((viewFlags = this.mViewFlags) & 0x1000) != 0;
        boolean bl = verticalEdges = (viewFlags & 0x2000) != 0;
        if (!verticalEdges && !horizontalEdges) {
            if (!dirtyOpaque) {
                this.onDraw(canvas);
            }
            this.dispatchDraw(canvas);
            this.onDrawScrollBars(canvas);
            return;
        }
        boolean drawTop = false;
        boolean drawBottom = false;
        boolean drawLeft = false;
        boolean drawRight = false;
        float topFadeStrength = 0.0f;
        float bottomFadeStrength = 0.0f;
        float leftFadeStrength = 0.0f;
        float rightFadeStrength = 0.0f;
        int paddingLeft = this.mPaddingLeft;
        boolean offsetRequired = this.isPaddingOffsetRequired();
        if (offsetRequired) {
            paddingLeft += this.getLeftPaddingOffset();
        }
        int left = this.mScrollX + paddingLeft;
        int right = left + this.mRight - this.mLeft - this.mPaddingRight - paddingLeft;
        int top = this.mScrollY + this.getFadeTop(offsetRequired);
        int bottom = top + this.getFadeHeight(offsetRequired);
        if (offsetRequired) {
            right += this.getRightPaddingOffset();
            bottom += this.getBottomPaddingOffset();
        }
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        float fadeHeight = scrollabilityCache.fadingEdgeLength;
        int length = (int)fadeHeight;
        if (verticalEdges && top + length > bottom - length) {
            length = (bottom - top) / 2;
        }
        if (horizontalEdges && left + length > right - length) {
            length = (right - left) / 2;
        }
        if (verticalEdges) {
            topFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getTopFadingEdgeStrength()));
            drawTop = topFadeStrength * fadeHeight > 1.0f;
            bottomFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getBottomFadingEdgeStrength()));
            boolean bl2 = drawBottom = bottomFadeStrength * fadeHeight > 1.0f;
        }
        if (horizontalEdges) {
            leftFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getLeftFadingEdgeStrength()));
            drawLeft = leftFadeStrength * fadeHeight > 1.0f;
            rightFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getRightFadingEdgeStrength()));
            drawRight = rightFadeStrength * fadeHeight > 1.0f;
        }
        int saveCount = canvas.getSaveCount();
        int solidColor = this.getSolidColor();
        if (solidColor == 0) {
            int flags = 4;
            if (drawTop) {
                canvas.saveLayer(left, top, right, top + length, null, 4);
            }
            if (drawBottom) {
                canvas.saveLayer(left, bottom - length, right, bottom, null, 4);
            }
            if (drawLeft) {
                canvas.saveLayer(left, top, left + length, bottom, null, 4);
            }
            if (drawRight) {
                canvas.saveLayer(right - length, top, right, bottom, null, 4);
            }
        } else {
            scrollabilityCache.setFadeColor(solidColor);
        }
        if (!dirtyOpaque) {
            this.onDraw(canvas);
        }
        this.dispatchDraw(canvas);
        Paint p = scrollabilityCache.paint;
        Matrix matrix = scrollabilityCache.matrix;
        Shader fade = scrollabilityCache.shader;
        if (drawTop) {
            matrix.setScale(1.0f, fadeHeight * topFadeStrength);
            matrix.postTranslate(left, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, top, right, top + length, p);
        }
        if (drawBottom) {
            matrix.setScale(1.0f, fadeHeight * bottomFadeStrength);
            matrix.postRotate(180.0f);
            matrix.postTranslate(left, bottom);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, bottom - length, right, bottom, p);
        }
        if (drawLeft) {
            matrix.setScale(1.0f, fadeHeight * leftFadeStrength);
            matrix.postRotate(-90.0f);
            matrix.postTranslate(left, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, top, left + length, bottom, p);
        }
        if (drawRight) {
            matrix.setScale(1.0f, fadeHeight * rightFadeStrength);
            matrix.postRotate(90.0f);
            matrix.postTranslate(right, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(right - length, top, right, bottom, p);
        }
        canvas.restoreToCount(saveCount);
        this.onDrawScrollBars(canvas);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public int getSolidColor() {
        return 0;
    }

    private static String printFlags(int flags) {
        String output = "";
        int numFlags = 0;
        if ((flags & 1) == 1) {
            output = output + "TAKES_FOCUS";
            ++numFlags;
        }
        switch (flags & 0xC) {
            case 4: {
                if (numFlags > 0) {
                    output = output + " ";
                }
                output = output + "INVISIBLE";
                break;
            }
            case 8: {
                if (numFlags > 0) {
                    output = output + " ";
                }
                output = output + "GONE";
                break;
            }
        }
        return output;
    }

    private static String printPrivateFlags(int privateFlags) {
        String output = "";
        int numFlags = 0;
        if ((privateFlags & 1) == 1) {
            output = output + "WANTS_FOCUS";
            ++numFlags;
        }
        if ((privateFlags & 2) == 2) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "FOCUSED";
            ++numFlags;
        }
        if ((privateFlags & 4) == 4) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "SELECTED";
            ++numFlags;
        }
        if ((privateFlags & 8) == 8) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "IS_ROOT_NAMESPACE";
            ++numFlags;
        }
        if ((privateFlags & 0x10) == 16) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "HAS_BOUNDS";
            ++numFlags;
        }
        if ((privateFlags & 0x20) == 32) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "DRAWN";
        }
        return output;
    }

    public boolean isLayoutRequested() {
        return (this.mPrivateFlags & 0x1000) == 4096;
    }

    public void layout(int l, int t, int r, int b) {
        int oldL = this.mLeft;
        int oldT = this.mTop;
        int oldB = this.mBottom;
        int oldR = this.mRight;
        boolean changed = this.setFrame(l, t, r, b);
        if (changed || (this.mPrivateFlags & 0x2000) == 8192) {
            this.onLayout(changed, l, t, r, b);
            this.mPrivateFlags &= 0xFFFFDFFF;
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnLayoutChangeListeners != null) {
                ArrayList listenersCopy = (ArrayList)li.mOnLayoutChangeListeners.clone();
                int numListeners = listenersCopy.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((OnLayoutChangeListener)listenersCopy.get(i)).onLayoutChange(this, l, t, r, b, oldL, oldT, oldR, oldB);
                }
            }
        }
        this.mPrivateFlags &= 0xFFFFEFFF;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = false;
        if (this.mLeft != left || this.mRight != right || this.mTop != top || this.mBottom != bottom) {
            changed = true;
            int drawn = this.mPrivateFlags & 0x20;
            int oldWidth = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            int newWidth = right - left;
            int newHeight = bottom - top;
            boolean sizeChanged = newWidth != oldWidth || newHeight != oldHeight;
            this.invalidate(sizeChanged);
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            if (this.mDisplayList != null) {
                this.mDisplayList.setLeftTopRightBottom(this.mLeft, this.mTop, this.mRight, this.mBottom);
            }
            this.mPrivateFlags |= 0x10;
            if (sizeChanged) {
                if ((this.mPrivateFlags & 0x20000000) == 0 && this.mTransformationInfo != null) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
            }
            if ((this.mViewFlags & 0xC) == 0) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(sizeChanged);
                this.invalidateParentCaches();
            }
            this.mPrivateFlags |= drawn;
            this.mBackgroundSizeChanged = true;
        }
        return changed;
    }

    protected void onFinishInflate() {
    }

    public Resources getResources() {
        return this.mResources;
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.verifyDrawable(who) && what != null) {
            long delay = when - SystemClock.uptimeMillis();
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewRootImpl.mChoreographer.postCallbackDelayed(1, what, who, Choreographer.subtractFrameDelay(delay));
            } else {
                ViewRootImpl.getRunQueue().postDelayed(what, delay);
            }
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (this.verifyDrawable(who) && what != null) {
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewRootImpl.mChoreographer.removeCallbacks(1, what, who);
            } else {
                ViewRootImpl.getRunQueue().removeCallbacks(what);
            }
        }
    }

    public void unscheduleDrawable(Drawable who) {
        if (this.mAttachInfo != null && who != null) {
            this.mAttachInfo.mViewRootImpl.mChoreographer.removeCallbacks(1, null, who);
        }
    }

    protected void resolveDrawables() {
        if (this.canResolveLayoutDirection()) {
            if (this.mBackground != null) {
                this.mBackground.setLayoutDirection(this.getLayoutDirection());
            }
            this.mPrivateFlags2 |= 0x40000000;
            this.onResolveDrawables(this.getLayoutDirection());
        }
    }

    public void onResolveDrawables(int layoutDirection) {
    }

    protected void resetResolvedDrawables() {
        this.mPrivateFlags2 &= 0xBFFFFFFF;
    }

    private boolean isDrawablesResolved() {
        return (this.mPrivateFlags2 & 0x40000000) == 0x40000000;
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mBackground;
    }

    protected void drawableStateChanged() {
        Drawable d = this.mBackground;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    public void refreshDrawableState() {
        this.mPrivateFlags |= 0x400;
        this.drawableStateChanged();
        ViewParent parent = this.mParent;
        if (parent != null) {
            parent.childDrawableStateChanged(this);
        }
    }

    public int[] getDrawableState() {
        if (this.mDrawableState != null && (this.mPrivateFlags & 0x400) == 0) {
            return this.mDrawableState;
        }
        this.mDrawableState = this.onCreateDrawableState(0);
        this.mPrivateFlags &= 0xFFFFFBFF;
        return this.mDrawableState;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] fullState;
        int privateFlags2;
        if ((this.mViewFlags & 0x400000) == 0x400000 && this.mParent instanceof View) {
            return ((View)((Object)this.mParent)).onCreateDrawableState(extraSpace);
        }
        int privateFlags = this.mPrivateFlags;
        int viewStateIndex = 0;
        if ((privateFlags & 0x4000) != 0) {
            viewStateIndex |= 0x10;
        }
        if ((this.mViewFlags & 0x20) == 0) {
            viewStateIndex |= 8;
        }
        if (this.isFocused()) {
            viewStateIndex |= 4;
        }
        if ((privateFlags & 4) != 0) {
            viewStateIndex |= 2;
        }
        if (this.hasWindowFocus()) {
            viewStateIndex |= 1;
        }
        if ((privateFlags & 0x40000000) != 0) {
            viewStateIndex |= 0x20;
        }
        if (this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerationRequested && HardwareRenderer.isAvailable()) {
            viewStateIndex |= 0x40;
        }
        if ((privateFlags & 0x10000000) != 0) {
            viewStateIndex |= 0x80;
        }
        if (((privateFlags2 = this.mPrivateFlags2) & 1) != 0) {
            viewStateIndex |= 0x100;
        }
        if ((privateFlags2 & 2) != 0) {
            viewStateIndex |= 0x200;
        }
        int[] drawableState = VIEW_STATE_SETS[viewStateIndex];
        if (extraSpace == 0) {
            return drawableState;
        }
        if (drawableState != null) {
            fullState = new int[drawableState.length + extraSpace];
            System.arraycopy(drawableState, 0, fullState, 0, drawableState.length);
        } else {
            fullState = new int[extraSpace];
        }
        return fullState;
    }

    protected static int[] mergeDrawableStates(int[] baseState, int[] additionalState) {
        int i;
        int N = baseState.length;
        for (i = N - 1; i >= 0 && baseState[i] == 0; --i) {
        }
        System.arraycopy(additionalState, 0, baseState, i + 1, additionalState.length);
        return baseState;
    }

    public void jumpDrawablesToCurrentState() {
        if (this.mBackground != null) {
            this.mBackground.jumpToCurrentState();
        }
    }

    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        if (this.mBackground instanceof ColorDrawable) {
            ((ColorDrawable)this.mBackground.mutate()).setColor(color2);
            this.computeOpaqueFlags();
        } else {
            this.setBackground(new ColorDrawable(color2));
        }
    }

    @RemotableViewMethod
    public void setBackgroundResource(int resid) {
        if (resid != 0 && resid == this.mBackgroundResource) {
            return;
        }
        Drawable d = null;
        if (resid != 0) {
            d = this.mResources.getDrawable(resid);
        }
        this.setBackground(d);
        this.mBackgroundResource = resid;
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        this.computeOpaqueFlags();
        if (background == this.mBackground) {
            return;
        }
        boolean requestLayout = false;
        this.mBackgroundResource = 0;
        if (this.mBackground != null) {
            this.mBackground.setCallback(null);
            this.unscheduleDrawable(this.mBackground);
        }
        if (background != null) {
            Rect padding = sThreadLocal.get();
            if (padding == null) {
                padding = new Rect();
                sThreadLocal.set(padding);
            }
            this.resetResolvedDrawables();
            background.setLayoutDirection(this.getLayoutDirection());
            if (background.getPadding(padding)) {
                this.resetResolvedPadding();
                switch (background.getLayoutDirection()) {
                    case 1: {
                        this.mUserPaddingLeftInitial = padding.right;
                        this.mUserPaddingRightInitial = padding.left;
                        this.internalSetPadding(padding.right, padding.top, padding.left, padding.bottom);
                        break;
                    }
                    default: {
                        this.mUserPaddingLeftInitial = padding.left;
                        this.mUserPaddingRightInitial = padding.right;
                        this.internalSetPadding(padding.left, padding.top, padding.right, padding.bottom);
                    }
                }
            }
            if (this.mBackground == null || this.mBackground.getMinimumHeight() != background.getMinimumHeight() || this.mBackground.getMinimumWidth() != background.getMinimumWidth()) {
                requestLayout = true;
            }
            background.setCallback(this);
            if (background.isStateful()) {
                background.setState(this.getDrawableState());
            }
            background.setVisible(this.getVisibility() == 0, false);
            this.mBackground = background;
            if ((this.mPrivateFlags & 0x80) != 0) {
                this.mPrivateFlags &= 0xFFFFFF7F;
                this.mPrivateFlags |= 0x100;
                requestLayout = true;
            }
        } else {
            this.mBackground = null;
            if ((this.mPrivateFlags & 0x100) != 0) {
                this.mPrivateFlags &= 0xFFFFFEFF;
                this.mPrivateFlags |= 0x80;
            }
            requestLayout = true;
        }
        this.computeOpaqueFlags();
        if (requestLayout) {
            this.requestLayout();
        }
        this.mBackgroundSizeChanged = true;
        this.invalidate(true);
    }

    public Drawable getBackground() {
        return this.mBackground;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.resetResolvedPadding();
        this.mUserPaddingStart = Integer.MIN_VALUE;
        this.mUserPaddingEnd = Integer.MIN_VALUE;
        this.mUserPaddingLeftInitial = left;
        this.mUserPaddingRightInitial = right;
        this.internalSetPadding(left, top, right, bottom);
    }

    protected void internalSetPadding(int left, int top, int right, int bottom) {
        this.mUserPaddingLeft = left;
        this.mUserPaddingRight = right;
        this.mUserPaddingBottom = bottom;
        int viewFlags = this.mViewFlags;
        boolean changed = false;
        if ((viewFlags & 0x300) != 0) {
            if ((viewFlags & 0x200) != 0) {
                int offset = (viewFlags & 0x1000000) == 0 ? 0 : this.getVerticalScrollbarWidth();
                switch (this.mVerticalScrollbarPosition) {
                    case 0: {
                        if (this.isLayoutRtl()) {
                            left += offset;
                            break;
                        }
                        right += offset;
                        break;
                    }
                    case 2: {
                        right += offset;
                        break;
                    }
                    case 1: {
                        left += offset;
                    }
                }
            }
            if ((viewFlags & 0x100) != 0) {
                bottom += (viewFlags & 0x1000000) == 0 ? 0 : this.getHorizontalScrollbarHeight();
            }
        }
        if (this.mPaddingLeft != left) {
            changed = true;
            this.mPaddingLeft = left;
        }
        if (this.mPaddingTop != top) {
            changed = true;
            this.mPaddingTop = top;
        }
        if (this.mPaddingRight != right) {
            changed = true;
            this.mPaddingRight = right;
        }
        if (this.mPaddingBottom != bottom) {
            changed = true;
            this.mPaddingBottom = bottom;
        }
        if (changed) {
            this.requestLayout();
        }
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        this.resetResolvedPadding();
        this.mUserPaddingStart = start;
        this.mUserPaddingEnd = end;
        switch (this.getLayoutDirection()) {
            case 1: {
                this.mUserPaddingLeftInitial = end;
                this.mUserPaddingRightInitial = start;
                this.internalSetPadding(end, top, start, bottom);
                break;
            }
            default: {
                this.mUserPaddingLeftInitial = start;
                this.mUserPaddingRightInitial = end;
                this.internalSetPadding(start, top, end, bottom);
            }
        }
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.mPaddingLeft;
    }

    public int getPaddingStart() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.getLayoutDirection() == 1 ? this.mPaddingRight : this.mPaddingLeft;
    }

    public int getPaddingRight() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.mPaddingRight;
    }

    public int getPaddingEnd() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.getLayoutDirection() == 1 ? this.mPaddingLeft : this.mPaddingRight;
    }

    public boolean isPaddingRelative() {
        return this.mUserPaddingStart != Integer.MIN_VALUE || this.mUserPaddingEnd != Integer.MIN_VALUE;
    }

    public void resetPaddingToInitialValues() {
        if (this.isRtlCompatibilityMode()) {
            this.mPaddingLeft = this.mUserPaddingLeftInitial;
            this.mPaddingRight = this.mUserPaddingRightInitial;
            return;
        }
        if (this.isLayoutRtl()) {
            this.mPaddingLeft = this.mUserPaddingEnd >= 0 ? this.mUserPaddingEnd : this.mUserPaddingLeftInitial;
            this.mPaddingRight = this.mUserPaddingStart >= 0 ? this.mUserPaddingStart : this.mUserPaddingRightInitial;
        } else {
            this.mPaddingLeft = this.mUserPaddingStart >= 0 ? this.mUserPaddingStart : this.mUserPaddingLeftInitial;
            this.mPaddingRight = this.mUserPaddingEnd >= 0 ? this.mUserPaddingEnd : this.mUserPaddingRightInitial;
        }
    }

    public Insets getOpticalInsets() {
        if (this.mLayoutInsets == null) {
            this.mLayoutInsets = this.mBackground == null ? Insets.NONE : this.mBackground.getLayoutInsets();
        }
        return this.mLayoutInsets;
    }

    public void setLayoutInsets(Insets layoutInsets) {
        this.mLayoutInsets = layoutInsets;
    }

    public void setSelected(boolean selected) {
        if ((this.mPrivateFlags & 4) != 0 != selected) {
            this.mPrivateFlags = this.mPrivateFlags & 0xFFFFFFFB | (selected ? 4 : 0);
            if (!selected) {
                this.resetPressedState();
            }
            this.invalidate(true);
            this.refreshDrawableState();
            this.dispatchSetSelected(selected);
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.notifyAccessibilityStateChanged();
            }
        }
    }

    protected void dispatchSetSelected(boolean selected) {
    }

    @ViewDebug.ExportedProperty
    public boolean isSelected() {
        return (this.mPrivateFlags & 4) != 0;
    }

    public void setActivated(boolean activated) {
        if ((this.mPrivateFlags & 0x40000000) != 0 != activated) {
            this.mPrivateFlags = this.mPrivateFlags & 0xBFFFFFFF | (activated ? 0x40000000 : 0);
            this.invalidate(true);
            this.refreshDrawableState();
            this.dispatchSetActivated(activated);
        }
    }

    protected void dispatchSetActivated(boolean activated) {
    }

    @ViewDebug.ExportedProperty
    public boolean isActivated() {
        return (this.mPrivateFlags & 0x40000000) != 0;
    }

    public ViewTreeObserver getViewTreeObserver() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mTreeObserver;
        }
        if (this.mFloatingTreeObserver == null) {
            this.mFloatingTreeObserver = new ViewTreeObserver();
        }
        return this.mFloatingTreeObserver;
    }

    public View getRootView() {
        View v;
        if (this.mAttachInfo != null && (v = this.mAttachInfo.mRootView) != null) {
            return v;
        }
        View parent = this;
        while (parent.mParent != null && parent.mParent instanceof View) {
            parent = (View)((Object)parent.mParent);
        }
        return parent;
    }

    public void getLocationOnScreen(int[] location) {
        this.getLocationInWindow(location);
        AttachInfo info = this.mAttachInfo;
        if (info != null) {
            location[0] = location[0] + info.mWindowLeft;
            location[1] = location[1] + info.mWindowTop;
        }
    }

    public void getLocationInWindow(int[] location) {
        if (location == null || location.length < 2) {
            throw new IllegalArgumentException("location must be an array of two integers");
        }
        if (this.mAttachInfo == null) {
            location[1] = 0;
            location[0] = 0;
            return;
        }
        float[] position = this.mAttachInfo.mTmpTransformLocation;
        position[1] = 0.0f;
        position[0] = 0.0f;
        if (!this.hasIdentityMatrix()) {
            this.getMatrix().mapPoints(position);
        }
        position[0] = position[0] + (float)this.mLeft;
        position[1] = position[1] + (float)this.mTop;
        ViewParent viewParent = this.mParent;
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            position[0] = position[0] - (float)view.mScrollX;
            position[1] = position[1] - (float)view.mScrollY;
            if (!view.hasIdentityMatrix()) {
                view.getMatrix().mapPoints(position);
            }
            position[0] = position[0] + (float)view.mLeft;
            position[1] = position[1] + (float)view.mTop;
            viewParent = view.mParent;
        }
        if (viewParent instanceof ViewRootImpl) {
            ViewRootImpl vr = (ViewRootImpl)viewParent;
            position[1] = position[1] - (float)vr.mCurScrollY;
        }
        location[0] = (int)(position[0] + 0.5f);
        location[1] = (int)(position[1] + 0.5f);
    }

    protected View findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return this;
        }
        return null;
    }

    protected View findViewWithTagTraversal(Object tag) {
        if (tag != null && tag.equals(this.mTag)) {
            return this;
        }
        return null;
    }

    protected View findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        if (predicate.apply(this)) {
            return this;
        }
        return null;
    }

    public View findViewById(int id2) {
        if (id2 < 0) {
            return null;
        }
        return this.findViewTraversal(id2);
    }

    View findViewByAccessibilityId(int accessibilityId) {
        if (accessibilityId < 0) {
            return null;
        }
        return this.findViewByAccessibilityIdTraversal(accessibilityId);
    }

    View findViewByAccessibilityIdTraversal(int accessibilityId) {
        if (this.getAccessibilityViewId() == accessibilityId) {
            return this;
        }
        return null;
    }

    public View findViewWithTag(Object tag) {
        if (tag == null) {
            return null;
        }
        return this.findViewWithTagTraversal(tag);
    }

    public View findViewByPredicate(Predicate<View> predicate) {
        return this.findViewByPredicateTraversal(predicate, null);
    }

    public View findViewByPredicateInsideOut(View start, Predicate<View> predicate) {
        View childToSkip = null;
        View view;
        while ((view = start.findViewByPredicateTraversal(predicate, childToSkip)) == null && start != this) {
            ViewParent parent = start.getParent();
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            childToSkip = start;
            start = (View)((Object)parent);
        }
        return view;
    }

    public void setId(int id2) {
        this.mID = id2;
        if (this.mID == -1 && this.mLabelForId != -1) {
            this.mID = View.generateViewId();
        }
    }

    public void setIsRootNamespace(boolean isRoot) {
        this.mPrivateFlags = isRoot ? (this.mPrivateFlags |= 8) : (this.mPrivateFlags &= 0xFFFFFFF7);
    }

    public boolean isRootNamespace() {
        return (this.mPrivateFlags & 8) != 0;
    }

    @ViewDebug.CapturedViewProperty
    public int getId() {
        return this.mID;
    }

    @ViewDebug.ExportedProperty
    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public Object getTag(int key) {
        if (this.mKeyedTags != null) {
            return this.mKeyedTags.get(key);
        }
        return null;
    }

    public void setTag(int key, Object tag) {
        if (key >>> 24 < 2) {
            throw new IllegalArgumentException("The key must be an application-specific resource id.");
        }
        this.setKeyedTag(key, tag);
    }

    public void setTagInternal(int key, Object tag) {
        if (key >>> 24 != 1) {
            throw new IllegalArgumentException("The key must be a framework-specific resource id.");
        }
        this.setKeyedTag(key, tag);
    }

    private void setKeyedTag(int key, Object tag) {
        if (this.mKeyedTags == null) {
            this.mKeyedTags = new SparseArray();
        }
        this.mKeyedTags.put(key, tag);
    }

    public void debug() {
        this.debug(0);
    }

    protected void debug(int depth) {
        Object tag;
        String output = View.debugIndent(depth - 1);
        output = output + "+ " + this;
        int id2 = this.getId();
        if (id2 != -1) {
            output = output + " (id=" + id2 + ")";
        }
        if ((tag = this.getTag()) != null) {
            output = output + " (tag=" + tag + ")";
        }
        Log.d(VIEW_LOG_TAG, output);
        if ((this.mPrivateFlags & 2) != 0) {
            output = View.debugIndent(depth) + " FOCUSED";
            Log.d(VIEW_LOG_TAG, output);
        }
        output = View.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        Log.d(VIEW_LOG_TAG, output);
        if (this.mPaddingLeft != 0 || this.mPaddingTop != 0 || this.mPaddingRight != 0 || this.mPaddingBottom != 0) {
            output = View.debugIndent(depth);
            output = output + "padding={" + this.mPaddingLeft + ", " + this.mPaddingTop + ", " + this.mPaddingRight + ", " + this.mPaddingBottom + "}";
            Log.d(VIEW_LOG_TAG, output);
        }
        output = View.debugIndent(depth);
        output = output + "mMeasureWidth=" + this.mMeasuredWidth + " mMeasureHeight=" + this.mMeasuredHeight;
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = this.mLayoutParams == null ? output + "BAD! no layout params" : this.mLayoutParams.debug(output);
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = output + "flags={";
        output = output + View.printFlags(this.mViewFlags);
        output = output + "}";
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = output + "privateFlags={";
        output = output + View.printPrivateFlags(this.mPrivateFlags);
        output = output + "}";
        Log.d(VIEW_LOG_TAG, output);
    }

    protected static String debugIndent(int depth) {
        StringBuilder spaces = new StringBuilder((depth * 2 + 3) * 2);
        for (int i = 0; i < depth * 2 + 3; ++i) {
            spaces.append(' ').append(' ');
        }
        return spaces.toString();
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getBaseline() {
        return -1;
    }

    public void requestLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (this.mParent != null && !this.mParent.isLayoutRequested()) {
            this.mParent.requestLayout();
        }
    }

    public void forceLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
    }

    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        if ((this.mPrivateFlags & 0x1000) == 4096 || widthMeasureSpec != this.mOldWidthMeasureSpec || heightMeasureSpec != this.mOldHeightMeasureSpec) {
            this.mPrivateFlags &= 0xFFFFF7FF;
            this.resolveRtlPropertiesIfNeeded();
            this.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if ((this.mPrivateFlags & 0x800) != 2048) {
                throw new IllegalStateException("onMeasure() did not set the measured dimension by calling setMeasuredDimension()");
            }
            this.mPrivateFlags |= 0x2000;
        }
        this.mOldWidthMeasureSpec = widthMeasureSpec;
        this.mOldHeightMeasureSpec = heightMeasureSpec;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.getDefaultSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), View.getDefaultSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    protected void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.mMeasuredWidth = measuredWidth;
        this.mMeasuredHeight = measuredHeight;
        this.mPrivateFlags |= 0x800;
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    public static int resolveSize(int size, int measureSpec) {
        return View.resolveSizeAndState(size, measureSpec, 0) & 0xFFFFFF;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    public static int getDefaultSize(int size, int measureSpec) {
        int result = size;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: 
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    protected int getSuggestedMinimumHeight() {
        return this.mBackground == null ? this.mMinHeight : Math.max(this.mMinHeight, this.mBackground.getMinimumHeight());
    }

    protected int getSuggestedMinimumWidth() {
        return this.mBackground == null ? this.mMinWidth : Math.max(this.mMinWidth, this.mBackground.getMinimumWidth());
    }

    public int getMinimumHeight() {
        return this.mMinHeight;
    }

    public void setMinimumHeight(int minHeight) {
        this.mMinHeight = minHeight;
        this.requestLayout();
    }

    public int getMinimumWidth() {
        return this.mMinWidth;
    }

    public void setMinimumWidth(int minWidth) {
        this.mMinWidth = minWidth;
        this.requestLayout();
    }

    public Animation getAnimation() {
        return this.mCurrentAnimation;
    }

    public void startAnimation(Animation animation) {
        animation.setStartTime(-1L);
        this.setAnimation(animation);
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    public void clearAnimation() {
        if (this.mCurrentAnimation != null) {
            this.mCurrentAnimation.detach();
        }
        this.mCurrentAnimation = null;
        this.invalidateParentIfNeeded();
    }

    public void setAnimation(Animation animation) {
        this.mCurrentAnimation = animation;
        if (animation != null) {
            if (this.mAttachInfo != null && !this.mAttachInfo.mScreenOn && animation.getStartTime() == -1L) {
                animation.setStartTime(AnimationUtils.currentAnimationTimeMillis());
            }
            animation.reset();
        }
    }

    protected void onAnimationStart() {
        this.mPrivateFlags |= 0x10000;
    }

    protected void onAnimationEnd() {
        this.mPrivateFlags &= 0xFFFEFFFF;
    }

    protected boolean onSetAlpha(int alpha) {
        return false;
    }

    public boolean gatherTransparentRegion(Region region) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (region != null && attachInfo != null) {
            int pflags = this.mPrivateFlags;
            if ((pflags & 0x80) == 0) {
                int[] location = attachInfo.mTransparentLocation;
                this.getLocationInWindow(location);
                region.op(location[0], location[1], location[0] + this.mRight - this.mLeft, location[1] + this.mBottom - this.mTop, Region.Op.DIFFERENCE);
            } else if ((pflags & 0x100) != 0 && this.mBackground != null) {
                this.applyDrawableToTransparentRegion(this.mBackground, region);
            }
        }
        return true;
    }

    public void playSoundEffect(int soundConstant) {
        if (this.mAttachInfo == null || this.mAttachInfo.mRootCallbacks == null || !this.isSoundEffectsEnabled()) {
            return;
        }
        this.mAttachInfo.mRootCallbacks.playSoundEffect(soundConstant);
    }

    public boolean performHapticFeedback(int feedbackConstant) {
        return this.performHapticFeedback(feedbackConstant, 0);
    }

    public boolean performHapticFeedback(int feedbackConstant, int flags) {
        if (this.mAttachInfo == null) {
            return false;
        }
        if ((flags & 1) == 0 && !this.isHapticFeedbackEnabled()) {
            return false;
        }
        return this.mAttachInfo.mRootCallbacks.performHapticFeedback(feedbackConstant, (flags & 2) != 0);
    }

    public void setSystemUiVisibility(int visibility) {
        if (visibility != this.mSystemUiVisibility) {
            this.mSystemUiVisibility = visibility;
            if (this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
                this.mParent.recomputeViewAttributes(this);
            }
        }
    }

    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    public int getWindowSystemUiVisibility() {
        return this.mAttachInfo != null ? this.mAttachInfo.mSystemUiVisibility : 0;
    }

    public void onWindowSystemUiVisibilityChanged(int visible) {
    }

    public void dispatchWindowSystemUiVisiblityChanged(int visible) {
        this.onWindowSystemUiVisibilityChanged(visible);
    }

    public void setOnSystemUiVisibilityChangeListener(OnSystemUiVisibilityChangeListener l) {
        this.getListenerInfo().mOnSystemUiVisibilityChangeListener = l;
        if (this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mParent.recomputeViewAttributes(this);
        }
    }

    public void dispatchSystemUiVisibilityChanged(int visibility) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnSystemUiVisibilityChangeListener != null) {
            li.mOnSystemUiVisibilityChangeListener.onSystemUiVisibilityChange(visibility & 0xFFFF);
        }
    }

    boolean updateLocalSystemUiVisibility(int localValue, int localChanges) {
        int val = this.mSystemUiVisibility & ~localChanges | localValue & localChanges;
        if (val != this.mSystemUiVisibility) {
            this.setSystemUiVisibility(val);
            return true;
        }
        return false;
    }

    public void setDisabledSystemUiVisibility(int flags) {
        if (this.mAttachInfo != null && this.mAttachInfo.mDisabledSystemUiVisibility != flags) {
            this.mAttachInfo.mDisabledSystemUiVisibility = flags;
            if (this.mParent != null) {
                this.mParent.recomputeViewAttributes(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDrag(ClipData data, DragShadowBuilder shadowBuilder, Object myLocalState, int flags) {
        boolean okay;
        block6: {
            okay = false;
            Point shadowSize = new Point();
            Point shadowTouchPoint = new Point();
            shadowBuilder.onProvideShadowMetrics(shadowSize, shadowTouchPoint);
            if (shadowSize.x < 0 || shadowSize.y < 0 || shadowTouchPoint.x < 0 || shadowTouchPoint.y < 0) {
                throw new IllegalStateException("Drag shadow dimensions must not be negative");
            }
            Surface surface = new Surface();
            try {
                IBinder token = this.mAttachInfo.mSession.prepareDrag(this.mAttachInfo.mWindow, flags, shadowSize.x, shadowSize.y, surface);
                if (token == null) break block6;
                Canvas canvas = surface.lockCanvas(null);
                try {
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    shadowBuilder.onDrawShadow(canvas);
                }
                finally {
                    surface.unlockCanvasAndPost(canvas);
                }
                ViewRootImpl root = this.getViewRootImpl();
                root.setLocalDragState(myLocalState);
                root.getLastTouchPoint(shadowSize);
                okay = this.mAttachInfo.mSession.performDrag(this.mAttachInfo.mWindow, token, shadowSize.x, shadowSize.y, shadowTouchPoint.x, shadowTouchPoint.y, data);
                surface.release();
            }
            catch (Exception e) {
                Log.e(VIEW_LOG_TAG, "Unable to initiate drag", e);
                surface.destroy();
            }
        }
        return okay;
    }

    public boolean onDragEvent(DragEvent event) {
        return false;
    }

    public boolean dispatchDragEvent(DragEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnDragListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnDragListener.onDrag(this, event)) {
            return true;
        }
        return this.onDragEvent(event);
    }

    boolean canAcceptDrag() {
        return (this.mPrivateFlags2 & 1) != 0;
    }

    public void onCloseSystemDialogs(String reason) {
    }

    public void applyDrawableToTransparentRegion(Drawable dr, Region region) {
        Region r = dr.getTransparentRegion();
        Rect db = dr.getBounds();
        AttachInfo attachInfo = this.mAttachInfo;
        if (r != null && attachInfo != null) {
            int w = this.getRight() - this.getLeft();
            int h = this.getBottom() - this.getTop();
            if (db.left > 0) {
                r.op(0, 0, db.left, h, Region.Op.UNION);
            }
            if (db.right < w) {
                r.op(db.right, 0, w, h, Region.Op.UNION);
            }
            if (db.top > 0) {
                r.op(0, 0, w, db.top, Region.Op.UNION);
            }
            if (db.bottom < h) {
                r.op(0, db.bottom, w, h, Region.Op.UNION);
            }
            int[] location = attachInfo.mTransparentLocation;
            this.getLocationInWindow(location);
            r.translate(location[0], location[1]);
            region.op(r, Region.Op.INTERSECT);
        } else {
            region.op(db, Region.Op.DIFFERENCE);
        }
    }

    private void checkForLongClick(int delayOffset) {
        if ((this.mViewFlags & 0x200000) == 0x200000) {
            this.mHasPerformedLongPress = false;
            if (this.mPendingCheckForLongPress == null) {
                this.mPendingCheckForLongPress = new CheckForLongPress();
            }
            this.mPendingCheckForLongPress.rememberWindowAttachCount();
            this.postDelayed(this.mPendingCheckForLongPress, ViewConfiguration.getLongPressTimeout() - delayOffset);
        }
    }

    public static View inflate(Context context, int resource, ViewGroup root) {
        LayoutInflater factory = LayoutInflater.from(context);
        return factory.inflate(resource, root);
    }

    protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        int overScrollMode = this.mOverScrollMode;
        boolean canScrollHorizontal = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean canScrollVertical = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        boolean overScrollHorizontal = overScrollMode == 0 || overScrollMode == 1 && canScrollHorizontal;
        boolean overScrollVertical = overScrollMode == 0 || overScrollMode == 1 && canScrollVertical;
        int newScrollX = scrollX + deltaX;
        if (!overScrollHorizontal) {
            maxOverScrollX = 0;
        }
        int newScrollY = scrollY + deltaY;
        if (!overScrollVertical) {
            maxOverScrollY = 0;
        }
        int left = -maxOverScrollX;
        int right = maxOverScrollX + scrollRangeX;
        int top = -maxOverScrollY;
        int bottom = maxOverScrollY + scrollRangeY;
        boolean clampedX = false;
        if (newScrollX > right) {
            newScrollX = right;
            clampedX = true;
        } else if (newScrollX < left) {
            newScrollX = left;
            clampedX = true;
        }
        boolean clampedY = false;
        if (newScrollY > bottom) {
            newScrollY = bottom;
            clampedY = true;
        } else if (newScrollY < top) {
            newScrollY = top;
            clampedY = true;
        }
        this.onOverScrolled(newScrollX, newScrollY, clampedX, clampedY);
        return clampedX || clampedY;
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
    }

    public int getOverScrollMode() {
        return this.mOverScrollMode;
    }

    public void setOverScrollMode(int overScrollMode) {
        if (overScrollMode != 0 && overScrollMode != 1 && overScrollMode != 2) {
            throw new IllegalArgumentException("Invalid overscroll mode " + overScrollMode);
        }
        this.mOverScrollMode = overScrollMode;
    }

    protected float getVerticalScrollFactor() {
        if (this.mVerticalScrollFactor == 0.0f) {
            TypedValue outValue = new TypedValue();
            if (!this.mContext.getTheme().resolveAttribute(16842829, outValue, true)) {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
            this.mVerticalScrollFactor = outValue.getDimension(this.mContext.getResources().getDisplayMetrics());
        }
        return this.mVerticalScrollFactor;
    }

    protected float getHorizontalScrollFactor() {
        return this.getVerticalScrollFactor();
    }

    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="INHERIT"), @ViewDebug.IntToString(from=1, to="FIRST_STRONG"), @ViewDebug.IntToString(from=2, to="ANY_RTL"), @ViewDebug.IntToString(from=3, to="LTR"), @ViewDebug.IntToString(from=4, to="RTL"), @ViewDebug.IntToString(from=5, to="LOCALE")})
    public int getRawTextDirection() {
        return (this.mPrivateFlags2 & 0x1C0) >> 6;
    }

    public void setTextDirection(int textDirection) {
        if (this.getRawTextDirection() != textDirection) {
            this.mPrivateFlags2 &= 0xFFFFFE3F;
            this.resetResolvedTextDirection();
            this.mPrivateFlags2 |= textDirection << 6 & 0x1C0;
            this.resolveTextDirection();
            this.onRtlPropertiesChanged(this.getLayoutDirection());
            this.requestLayout();
            this.invalidate(true);
        }
    }

    public int getTextDirection() {
        return (this.mPrivateFlags2 & 0x1C00) >> 10;
    }

    public boolean resolveTextDirection() {
        this.mPrivateFlags2 &= 0xFFFFE1FF;
        if (this.hasRtlSupport()) {
            int textDirection = this.getRawTextDirection();
            block0 : switch (textDirection) {
                case 0: {
                    if (!this.canResolveTextDirection()) {
                        this.mPrivateFlags2 |= 0x400;
                        return false;
                    }
                    View parent = (View)((Object)this.mParent);
                    if (!parent.isTextDirectionResolved()) {
                        this.mPrivateFlags2 |= 0x400;
                        return false;
                    }
                    int parentResolvedDirection = parent.getTextDirection();
                    switch (parentResolvedDirection) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.mPrivateFlags2 |= parentResolvedDirection << 10;
                            break block0;
                        }
                    }
                    this.mPrivateFlags2 |= 0x400;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.mPrivateFlags2 |= textDirection << 10;
                    break;
                }
                default: {
                    this.mPrivateFlags2 |= 0x400;
                    break;
                }
            }
        } else {
            this.mPrivateFlags2 |= 0x400;
        }
        this.mPrivateFlags2 |= 0x200;
        return true;
    }

    private boolean canResolveTextDirection() {
        switch (this.getRawTextDirection()) {
            case 0: {
                return this.mParent != null && this.mParent instanceof View && ((View)((Object)this.mParent)).canResolveTextDirection();
            }
        }
        return true;
    }

    public void resetResolvedTextDirection() {
        this.mPrivateFlags2 &= 0xFFFFE1FF;
        this.mPrivateFlags2 |= 0x400;
    }

    public boolean isTextDirectionInherited() {
        return this.getRawTextDirection() == 0;
    }

    private boolean isTextDirectionResolved() {
        return (this.mPrivateFlags2 & 0x200) == 512;
    }

    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="INHERIT"), @ViewDebug.IntToString(from=1, to="GRAVITY"), @ViewDebug.IntToString(from=2, to="TEXT_START"), @ViewDebug.IntToString(from=3, to="TEXT_END"), @ViewDebug.IntToString(from=4, to="CENTER"), @ViewDebug.IntToString(from=5, to="VIEW_START"), @ViewDebug.IntToString(from=6, to="VIEW_END")})
    public int getRawTextAlignment() {
        return (this.mPrivateFlags2 & 0xE000) >> 13;
    }

    public void setTextAlignment(int textAlignment) {
        if (textAlignment != this.getRawTextAlignment()) {
            this.mPrivateFlags2 &= 0xFFFF1FFF;
            this.resetResolvedTextAlignment();
            this.mPrivateFlags2 |= textAlignment << 13 & 0xE000;
            this.resolveTextAlignment();
            this.onRtlPropertiesChanged(this.getLayoutDirection());
            this.requestLayout();
            this.invalidate(true);
        }
    }

    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="INHERIT"), @ViewDebug.IntToString(from=1, to="GRAVITY"), @ViewDebug.IntToString(from=2, to="TEXT_START"), @ViewDebug.IntToString(from=3, to="TEXT_END"), @ViewDebug.IntToString(from=4, to="CENTER"), @ViewDebug.IntToString(from=5, to="VIEW_START"), @ViewDebug.IntToString(from=6, to="VIEW_END")})
    public int getTextAlignment() {
        return (this.mPrivateFlags2 & 0xE0000) >> 17;
    }

    public boolean resolveTextAlignment() {
        this.mPrivateFlags2 &= 0xFFF0FFFF;
        if (this.hasRtlSupport()) {
            int textAlignment = this.getRawTextAlignment();
            block0 : switch (textAlignment) {
                case 0: {
                    if (!this.canResolveTextAlignment()) {
                        this.mPrivateFlags2 |= 0x20000;
                        return false;
                    }
                    View parent = (View)((Object)this.mParent);
                    if (!parent.isTextAlignmentResolved()) {
                        this.mPrivateFlags2 |= 0x20000;
                        return false;
                    }
                    int parentResolvedTextAlignment = parent.getTextAlignment();
                    switch (parentResolvedTextAlignment) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.mPrivateFlags2 |= parentResolvedTextAlignment << 17;
                            break block0;
                        }
                    }
                    this.mPrivateFlags2 |= 0x20000;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.mPrivateFlags2 |= textAlignment << 17;
                    break;
                }
                default: {
                    this.mPrivateFlags2 |= 0x20000;
                    break;
                }
            }
        } else {
            this.mPrivateFlags2 |= 0x20000;
        }
        this.mPrivateFlags2 |= 0x10000;
        return true;
    }

    private boolean canResolveTextAlignment() {
        switch (this.getRawTextAlignment()) {
            case 0: {
                return this.mParent != null && this.mParent instanceof View && ((View)((Object)this.mParent)).canResolveTextAlignment();
            }
        }
        return true;
    }

    public void resetResolvedTextAlignment() {
        this.mPrivateFlags2 &= 0xFFF0FFFF;
        this.mPrivateFlags2 |= 0x20000;
    }

    public boolean isTextAlignmentInherited() {
        return this.getRawTextAlignment() == 0;
    }

    private boolean isTextAlignmentResolved() {
        return (this.mPrivateFlags2 & 0x10000) == 65536;
    }

    public static int generateViewId() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public void hackTurnOffWindowResizeAnim(boolean off) {
        this.mAttachInfo.mTurnOffWindowResizeAnim = off;
    }

    public ViewPropertyAnimator animate() {
        if (this.mAnimator == null) {
            this.mAnimator = new ViewPropertyAnimator(this);
        }
        return this.mAnimator;
    }

    private static void dumpFlags() {
        HashMap<String, String> found = Maps.newHashMap();
        try {
            for (Field field : View.class.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                if (field.getType().equals(Integer.TYPE)) {
                    int value = field.getInt(null);
                    View.dumpFlag(found, field.getName(), value);
                    continue;
                }
                if (!field.getType().equals(int[].class)) continue;
                int[] values = (int[])field.get(null);
                for (int i = 0; i < values.length; ++i) {
                    View.dumpFlag(found, field.getName() + "[" + i + "]", values[i]);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> keys = Lists.newArrayList();
        keys.addAll(found.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Log.d(VIEW_LOG_TAG, (String)found.get(key));
        }
    }

    private static void dumpFlag(HashMap<String, String> found, String name, int value) {
        String bits = String.format("%32s", Integer.toBinaryString(value)).replace('0', ' ');
        int prefix = name.indexOf(95);
        String key = (prefix > 0 ? name.substring(0, prefix) : name) + bits + name;
        String output = bits + " " + name;
        found.put(key, output);
    }

    static {
        VIEW_STATE_IDS = new int[]{16842909, 1, 0x10100A1, 2, 16842908, 4, 16842910, 8, 16842919, 16, 16843518, 32, 16843547, 64, 16843623, 128, 16843624, 256, 16843625, 512};
        if (VIEW_STATE_IDS.length / 2 != R.styleable.ViewDrawableStates.length) {
            throw new IllegalStateException("VIEW_STATE_IDs array length does not match ViewDrawableStates style array");
        }
        int[] orderedIds = new int[VIEW_STATE_IDS.length];
        for (int i = 0; i < R.styleable.ViewDrawableStates.length; ++i) {
            int viewState = R.styleable.ViewDrawableStates[i];
            for (int j = 0; j < VIEW_STATE_IDS.length; j += 2) {
                if (VIEW_STATE_IDS[j] != viewState) continue;
                orderedIds[i * 2] = viewState;
                orderedIds[i * 2 + 1] = VIEW_STATE_IDS[j + 1];
            }
        }
        int NUM_BITS = VIEW_STATE_IDS.length / 2;
        VIEW_STATE_SETS = new int[1 << NUM_BITS][];
        for (int i = 0; i < VIEW_STATE_SETS.length; ++i) {
            int numBits = Integer.bitCount(i);
            int[] set = new int[numBits];
            int pos = 0;
            for (int j = 0; j < orderedIds.length; j += 2) {
                if ((i & orderedIds[j + 1]) == 0) continue;
                set[pos++] = orderedIds[j];
            }
            View.VIEW_STATE_SETS[i] = set;
        }
        EMPTY_STATE_SET = VIEW_STATE_SETS[0];
        WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[1];
        SELECTED_STATE_SET = VIEW_STATE_SETS[2];
        SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[3];
        FOCUSED_STATE_SET = VIEW_STATE_SETS[4];
        FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[5];
        FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[6];
        FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[7];
        ENABLED_STATE_SET = VIEW_STATE_SETS[8];
        ENABLED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[9];
        ENABLED_SELECTED_STATE_SET = VIEW_STATE_SETS[10];
        ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[11];
        ENABLED_FOCUSED_STATE_SET = VIEW_STATE_SETS[12];
        ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[13];
        ENABLED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[14];
        ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[15];
        PRESSED_STATE_SET = VIEW_STATE_SETS[16];
        PRESSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[17];
        PRESSED_SELECTED_STATE_SET = VIEW_STATE_SETS[18];
        PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[19];
        PRESSED_FOCUSED_STATE_SET = VIEW_STATE_SETS[20];
        PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[21];
        PRESSED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[22];
        PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[23];
        PRESSED_ENABLED_STATE_SET = VIEW_STATE_SETS[24];
        PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[25];
        PRESSED_ENABLED_SELECTED_STATE_SET = VIEW_STATE_SETS[26];
        PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[27];
        PRESSED_ENABLED_FOCUSED_STATE_SET = VIEW_STATE_SETS[28];
        PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[29];
        PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[30];
        PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[31];
        sThreadLocal = new ThreadLocal();
        LAYOUT_DIRECTION_FLAGS = new int[]{0, 1, 2, 3};
        PFLAG2_TEXT_DIRECTION_FLAGS = new int[]{0, 64, 128, 192, 256, 320};
        PFLAG2_TEXT_ALIGNMENT_FLAGS = new int[]{0, 8192, 16384, 24576, 32768, 40960, 49152};
        sNextGeneratedId = new AtomicInteger(1);
        ALPHA = new FloatProperty<View>("alpha"){

            @Override
            public void setValue(View object, float value) {
                object.setAlpha(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getAlpha());
            }
        };
        TRANSLATION_X = new FloatProperty<View>("translationX"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationX());
            }
        };
        TRANSLATION_Y = new FloatProperty<View>("translationY"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationY());
            }
        };
        X = new FloatProperty<View>("x"){

            @Override
            public void setValue(View object, float value) {
                object.setX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getX());
            }
        };
        Y = new FloatProperty<View>("y"){

            @Override
            public void setValue(View object, float value) {
                object.setY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getY());
            }
        };
        ROTATION = new FloatProperty<View>("rotation"){

            @Override
            public void setValue(View object, float value) {
                object.setRotation(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotation());
            }
        };
        ROTATION_X = new FloatProperty<View>("rotationX"){

            @Override
            public void setValue(View object, float value) {
                object.setRotationX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotationX());
            }
        };
        ROTATION_Y = new FloatProperty<View>("rotationY"){

            @Override
            public void setValue(View object, float value) {
                object.setRotationY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotationY());
            }
        };
        SCALE_X = new FloatProperty<View>("scaleX"){

            @Override
            public void setValue(View object, float value) {
                object.setScaleX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getScaleX());
            }
        };
        SCALE_Y = new FloatProperty<View>("scaleY"){

            @Override
            public void setValue(View object, float value) {
                object.setScaleY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getScaleY());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchLabelForPredicate
    implements Predicate<View> {
        private int mLabeledId;

        private MatchLabelForPredicate() {
        }

        @Override
        public boolean apply(View view) {
            return view.mLabelForId == this.mLabeledId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchIdPredicate
    implements Predicate<View> {
        public int mId;

        private MatchIdPredicate() {
        }

        @Override
        public boolean apply(View view) {
            return view.mID == this.mId;
        }
    }

    public static class AccessibilityDelegate {
        public void sendAccessibilityEvent(View host, int eventType) {
            host.sendAccessibilityEventInternal(eventType);
        }

        public boolean performAccessibilityAction(View host, int action, Bundle args) {
            return host.performAccessibilityActionInternal(action, args);
        }

        public void sendAccessibilityEventUnchecked(View host, AccessibilityEvent event) {
            host.sendAccessibilityEventUncheckedInternal(event);
        }

        public boolean dispatchPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            return host.dispatchPopulateAccessibilityEventInternal(event);
        }

        public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            host.onPopulateAccessibilityEventInternal(event);
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            host.onInitializeAccessibilityEventInternal(event);
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            host.onInitializeAccessibilityNodeInfoInternal(info);
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            return host.onRequestSendAccessibilityEventInternal(child, event);
        }

        public AccessibilityNodeProvider getAccessibilityNodeProvider(View host) {
            return null;
        }
    }

    private class SendViewScrolledAccessibilityEvent
    implements Runnable {
        public volatile boolean mIsPending;

        private SendViewScrolledAccessibilityEvent() {
        }

        public void run() {
            View.this.sendAccessibilityEvent(4096);
            this.mIsPending = false;
        }
    }

    private static class ScrollabilityCache
    implements Runnable {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FADING = 2;
        public boolean fadeScrollBars;
        public int fadingEdgeLength;
        public int scrollBarDefaultDelayBeforeFade;
        public int scrollBarFadeDuration;
        public int scrollBarSize;
        public ScrollBarDrawable scrollBar;
        public float[] interpolatorValues;
        public View host;
        public final Paint paint;
        public final Matrix matrix;
        public Shader shader;
        public final Interpolator scrollBarInterpolator = new Interpolator(1, 2);
        private static final float[] OPAQUE = new float[]{255.0f};
        private static final float[] TRANSPARENT = new float[]{0.0f};
        public long fadeStartTime;
        public int state = 0;
        private int mLastColor;

        public ScrollabilityCache(ViewConfiguration configuration, View host) {
            this.fadingEdgeLength = configuration.getScaledFadingEdgeLength();
            this.scrollBarSize = configuration.getScaledScrollBarSize();
            this.scrollBarDefaultDelayBeforeFade = ViewConfiguration.getScrollDefaultDelay();
            this.scrollBarFadeDuration = ViewConfiguration.getScrollBarFadeDuration();
            this.paint = new Paint();
            this.matrix = new Matrix();
            this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, -16777216, 0, Shader.TileMode.CLAMP);
            this.paint.setShader(this.shader);
            this.paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.host = host;
        }

        public void setFadeColor(int color2) {
            if (color2 != this.mLastColor) {
                this.mLastColor = color2;
                if (color2 != 0) {
                    this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, color2 | 0xFF000000, color2 & 0xFFFFFF, Shader.TileMode.CLAMP);
                    this.paint.setShader(this.shader);
                    this.paint.setXfermode(null);
                } else {
                    this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, -16777216, 0, Shader.TileMode.CLAMP);
                    this.paint.setShader(this.shader);
                    this.paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
                }
            }
        }

        public void run() {
            long now = AnimationUtils.currentAnimationTimeMillis();
            if (now >= this.fadeStartTime) {
                int nextFrame = (int)now;
                int framesCount = 0;
                Interpolator interpolator2 = this.scrollBarInterpolator;
                interpolator2.setKeyFrame(framesCount++, nextFrame, OPAQUE);
                interpolator2.setKeyFrame(framesCount, nextFrame += this.scrollBarFadeDuration, TRANSPARENT);
                this.state = 2;
                this.host.invalidate(true);
            }
        }
    }

    static class AttachInfo {
        final IWindowSession mSession;
        final IWindow mWindow;
        final IBinder mWindowToken;
        final Display mDisplay;
        final Callbacks mRootCallbacks;
        HardwareCanvas mHardwareCanvas;
        View mRootView;
        IBinder mPanelParentWindowToken;
        Surface mSurface;
        boolean mHardwareAccelerated;
        boolean mHardwareAccelerationRequested;
        HardwareRenderer mHardwareRenderer;
        boolean mScreenOn;
        float mApplicationScale;
        boolean mScalingRequired;
        boolean mTurnOffWindowResizeAnim;
        int mWindowLeft;
        int mWindowTop;
        boolean mUse32BitDrawingCache;
        final Rect mContentInsets = new Rect();
        final Rect mVisibleInsets = new Rect();
        final ViewTreeObserver.InternalInsetsInfo mGivenInternalInsets = new ViewTreeObserver.InternalInsetsInfo();
        final ArrayList<View> mScrollContainers = new ArrayList();
        final KeyEvent.DispatcherState mKeyDispatchState = new KeyEvent.DispatcherState();
        boolean mHasWindowFocus;
        int mWindowVisibility;
        long mDrawingTime;
        boolean mIgnoreDirtyState;
        boolean mSetIgnoreDirtyState = false;
        boolean mInTouchMode;
        boolean mRecomputeGlobalAttributes;
        boolean mForceReportNewAttributes;
        boolean mKeepScreenOn;
        int mSystemUiVisibility;
        int mDisabledSystemUiVisibility;
        int mGlobalSystemUiVisibility;
        boolean mHasSystemUiListeners;
        boolean mViewVisibilityChanged;
        boolean mViewScrollChanged;
        final int[] mTransparentLocation = new int[2];
        final int[] mInvalidateChildLocation = new int[2];
        final float[] mTmpTransformLocation = new float[2];
        final ViewTreeObserver mTreeObserver = new ViewTreeObserver();
        Canvas mCanvas;
        final ViewRootImpl mViewRootImpl;
        final Handler mHandler;
        final Rect mTmpInvalRect = new Rect();
        final RectF mTmpTransformRect = new RectF();
        final Matrix mTmpMatrix = new Matrix();
        final Transformation mTmpTransformation = new Transformation();
        final ArrayList<View> mTempArrayList = new ArrayList(24);
        int mAccessibilityWindowId = -1;
        boolean mIncludeNotImportantViews;
        Drawable mAccessibilityFocusDrawable;
        boolean mDebugLayout = SystemProperties.getBoolean("debug.layout", false);
        final Point mPoint = new Point();

        AttachInfo(IWindowSession session, IWindow window, Display display, ViewRootImpl viewRootImpl, Handler handler, Callbacks effectPlayer) {
            this.mSession = session;
            this.mWindow = window;
            this.mWindowToken = window.asBinder();
            this.mDisplay = display;
            this.mViewRootImpl = viewRootImpl;
            this.mHandler = handler;
            this.mRootCallbacks = effectPlayer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class InvalidateInfo
        implements Poolable<InvalidateInfo> {
            private static final int POOL_LIMIT = 10;
            private static final Pool<InvalidateInfo> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<InvalidateInfo>(){

                @Override
                public InvalidateInfo newInstance() {
                    return new InvalidateInfo();
                }

                @Override
                public void onAcquired(InvalidateInfo element) {
                }

                @Override
                public void onReleased(InvalidateInfo element) {
                    element.target = null;
                }
            }, 10));
            private InvalidateInfo mNext;
            private boolean mIsPooled;
            View target;
            int left;
            int top;
            int right;
            int bottom;

            InvalidateInfo() {
            }

            @Override
            public void setNextPoolable(InvalidateInfo element) {
                this.mNext = element;
            }

            @Override
            public InvalidateInfo getNextPoolable() {
                return this.mNext;
            }

            static InvalidateInfo acquire() {
                return sPool.acquire();
            }

            void release() {
                sPool.release(this);
            }

            @Override
            public boolean isPooled() {
                return this.mIsPooled;
            }

            @Override
            public void setPooled(boolean isPooled) {
                this.mIsPooled = isPooled;
            }
        }

        static interface Callbacks {
            public void playSoundEffect(int var1);

            public boolean performHapticFeedback(int var1, boolean var2);
        }
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            @Override
            public BaseSavedState createFromParcel(Parcel in) {
                return new BaseSavedState(in);
            }

            public BaseSavedState[] newArray(int size) {
                return new BaseSavedState[size];
            }
        };

        public BaseSavedState(Parcel source) {
            super(source);
        }

        public BaseSavedState(Parcelable superState) {
            super(superState);
        }
    }

    private class UnsetPressedState
    implements Runnable {
        private UnsetPressedState() {
        }

        public void run() {
            View.this.setPressed(false);
        }
    }

    public static interface OnAttachStateChangeListener {
        public void onViewAttachedToWindow(View var1);

        public void onViewDetachedFromWindow(View var1);
    }

    public static interface OnSystemUiVisibilityChangeListener {
        public void onSystemUiVisibilityChange(int var1);
    }

    public static interface OnCreateContextMenuListener {
        public void onCreateContextMenu(ContextMenu var1, View var2, ContextMenu.ContextMenuInfo var3);
    }

    public static interface OnClickListener {
        public void onClick(View var1);
    }

    public static interface OnFocusChangeListener {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface OnDragListener {
        public boolean onDrag(View var1, DragEvent var2);
    }

    public static interface OnLongClickListener {
        public boolean onLongClick(View var1);
    }

    public static interface OnGenericMotionListener {
        public boolean onGenericMotion(View var1, MotionEvent var2);
    }

    public static interface OnHoverListener {
        public boolean onHover(View var1, MotionEvent var2);
    }

    public static interface OnTouchListener {
        public boolean onTouch(View var1, MotionEvent var2);
    }

    public static interface OnKeyListener {
        public boolean onKey(View var1, int var2, KeyEvent var3);
    }

    private class PerformClick
    implements Runnable {
        private PerformClick() {
        }

        public void run() {
            View.this.performClick();
        }
    }

    private class CheckForTap
    implements Runnable {
        private CheckForTap() {
        }

        public void run() {
            View.this.mPrivateFlags &= 0xFDFFFFFF;
            View.this.setPressed(true);
            View.this.checkForLongClick(ViewConfiguration.getTapTimeout());
        }
    }

    class CheckForLongPress
    implements Runnable {
        private int mOriginalWindowAttachCount;

        CheckForLongPress() {
        }

        public void run() {
            if (View.this.isPressed() && View.this.mParent != null && this.mOriginalWindowAttachCount == View.this.mWindowAttachCount && View.this.performLongClick()) {
                View.this.mHasPerformedLongPress = true;
            }
        }

        public void rememberWindowAttachCount() {
            this.mOriginalWindowAttachCount = View.this.mWindowAttachCount;
        }
    }

    public static class MeasureSpec {
        private static final int MODE_SHIFT = 30;
        private static final int MODE_MASK = -1073741824;
        public static final int UNSPECIFIED = 0;
        public static final int EXACTLY = 0x40000000;
        public static final int AT_MOST = Integer.MIN_VALUE;

        public static int makeMeasureSpec(int size, int mode) {
            return size + mode;
        }

        public static int getMode(int measureSpec) {
            return measureSpec & 0xC0000000;
        }

        public static int getSize(int measureSpec) {
            return measureSpec & 0x3FFFFFFF;
        }

        public static String toString(int measureSpec) {
            int mode = MeasureSpec.getMode(measureSpec);
            int size = MeasureSpec.getSize(measureSpec);
            StringBuilder sb = new StringBuilder("MeasureSpec: ");
            if (mode == 0) {
                sb.append("UNSPECIFIED ");
            } else if (mode == 0x40000000) {
                sb.append("EXACTLY ");
            } else if (mode == Integer.MIN_VALUE) {
                sb.append("AT_MOST ");
            } else {
                sb.append(mode).append(" ");
            }
            sb.append(size);
            return sb.toString();
        }
    }

    public static class DragShadowBuilder {
        private final WeakReference<View> mView;

        public DragShadowBuilder(View view) {
            this.mView = new WeakReference<View>(view);
        }

        public DragShadowBuilder() {
            this.mView = new WeakReference<Object>(null);
        }

        public View getView() {
            return (View)this.mView.get();
        }

        public void onProvideShadowMetrics(Point shadowSize, Point shadowTouchPoint) {
            View view = (View)this.mView.get();
            if (view != null) {
                shadowSize.set(view.getWidth(), view.getHeight());
                shadowTouchPoint.set(shadowSize.x / 2, shadowSize.y / 2);
            } else {
                Log.e(View.VIEW_LOG_TAG, "Asked for drag thumb metrics but no view");
            }
        }

        public void onDrawShadow(Canvas canvas) {
            View view = (View)this.mView.get();
            if (view != null) {
                view.draw(canvas);
            } else {
                Log.e(View.VIEW_LOG_TAG, "Asked to draw drag shadow but no view");
            }
        }
    }

    public static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }

    static class ListenerInfo {
        protected OnFocusChangeListener mOnFocusChangeListener;
        private ArrayList<OnLayoutChangeListener> mOnLayoutChangeListeners;
        private CopyOnWriteArrayList<OnAttachStateChangeListener> mOnAttachStateChangeListeners;
        public OnClickListener mOnClickListener;
        protected OnLongClickListener mOnLongClickListener;
        protected OnCreateContextMenuListener mOnCreateContextMenuListener;
        private OnKeyListener mOnKeyListener;
        private OnTouchListener mOnTouchListener;
        private OnHoverListener mOnHoverListener;
        private OnGenericMotionListener mOnGenericMotionListener;
        private OnDragListener mOnDragListener;
        private OnSystemUiVisibilityChangeListener mOnSystemUiVisibilityChangeListener;

        ListenerInfo() {
        }
    }

    static class TransformationInfo {
        private final Matrix mMatrix = new Matrix();
        private Matrix mInverseMatrix;
        boolean mMatrixDirty = false;
        private boolean mInverseMatrixDirty = true;
        private boolean mMatrixIsIdentity = true;
        private Camera mCamera = null;
        private Matrix matrix3D = null;
        private int mPrevWidth = -1;
        private int mPrevHeight = -1;
        @ViewDebug.ExportedProperty
        float mRotationY = 0.0f;
        @ViewDebug.ExportedProperty
        float mRotationX = 0.0f;
        @ViewDebug.ExportedProperty
        float mRotation = 0.0f;
        @ViewDebug.ExportedProperty
        float mTranslationX = 0.0f;
        @ViewDebug.ExportedProperty
        float mTranslationY = 0.0f;
        @ViewDebug.ExportedProperty
        float mScaleX = 1.0f;
        @ViewDebug.ExportedProperty
        float mScaleY = 1.0f;
        @ViewDebug.ExportedProperty
        float mPivotX = 0.0f;
        @ViewDebug.ExportedProperty
        float mPivotY = 0.0f;
        @ViewDebug.ExportedProperty
        float mAlpha = 1.0f;

        TransformationInfo() {
        }
    }
}

