/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.SystemProperties;
import android.util.FloatMath;
import android.util.Log;
import android.util.Slog;

public abstract class WindowOrientationListener {
    private static final String TAG = "WindowOrientationListener";
    private static final boolean LOG = SystemProperties.getBoolean("debug.orientation.log", false);
    private static final boolean USE_GRAVITY_SENSOR = false;
    private SensorManager mSensorManager;
    private boolean mEnabled;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListenerImpl mSensorEventListener;
    int mCurrentRotation = -1;

    public WindowOrientationListener(Context context) {
        this(context, 2);
    }

    private WindowOrientationListener(Context context, int rate) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl(this);
        }
    }

    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (!this.mEnabled) {
            if (LOG) {
                Log.d(TAG, "WindowOrientationListener enabled");
            }
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
        }
    }

    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (this.mEnabled) {
            if (LOG) {
                Log.d(TAG, "WindowOrientationListener disabled");
            }
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
        }
    }

    public void setCurrentRotation(int rotation) {
        this.mCurrentRotation = rotation;
    }

    public int getProposedRotation() {
        if (this.mEnabled) {
            return this.mSensorEventListener.getProposedRotation();
        }
        return -1;
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    public abstract void onProposedRotationChanged(int var1);

    static class SensorEventListenerImpl
    implements SensorEventListener {
        private static final float RADIANS_TO_DEGREES = 57.29578f;
        private static final long NANOS_PER_MS = 1000000L;
        private static final int ACCELEROMETER_DATA_X = 0;
        private static final int ACCELEROMETER_DATA_Y = 1;
        private static final int ACCELEROMETER_DATA_Z = 2;
        private final WindowOrientationListener mOrientationListener;
        private static final long PROPOSAL_SETTLE_TIME_NANOS = 40000000L;
        private static final long PROPOSAL_MIN_TIME_SINCE_FLAT_ENDED_NANOS = 500000000L;
        private static final long PROPOSAL_MIN_TIME_SINCE_SWING_ENDED_NANOS = 300000000L;
        private static final long PROPOSAL_MIN_TIME_SINCE_ACCELERATION_ENDED_NANOS = 500000000L;
        private static final float FLAT_ANGLE = 75.0f;
        private static final long FLAT_TIME_NANOS = 1000000000L;
        private static final float SWING_AWAY_ANGLE_DELTA = 20.0f;
        private static final long SWING_TIME_NANOS = 300000000L;
        private static final long MAX_FILTER_DELTA_TIME_NANOS = 1000000000L;
        private static final float FILTER_TIME_CONSTANT_MS = 200.0f;
        private static final float NEAR_ZERO_MAGNITUDE = 1.0f;
        private static final float ACCELERATION_TOLERANCE = 4.0f;
        private static final float MIN_ACCELERATION_MAGNITUDE = 5.80665f;
        private static final float MAX_ACCELERATION_MAGNITUDE = 13.80665f;
        private static final int MAX_TILT = 75;
        private static final int[][] TILT_TOLERANCE = new int[][]{{-25, 70}, {-25, 65}, {-25, 60}, {-25, 65}};
        private static final int ADJACENT_ORIENTATION_ANGLE_GAP = 45;
        private long mLastFilteredTimestampNanos;
        private float mLastFilteredX;
        private float mLastFilteredY;
        private float mLastFilteredZ;
        private int mProposedRotation;
        private int mPredictedRotation;
        private long mPredictedRotationTimestampNanos;
        private long mFlatTimestampNanos;
        private long mSwingTimestampNanos;
        private long mAccelerationTimestampNanos;
        private static final int TILT_HISTORY_SIZE = 40;
        private float[] mTiltHistory = new float[40];
        private long[] mTiltHistoryTimestampNanos = new long[40];
        private int mTiltHistoryIndex;

        public SensorEventListenerImpl(WindowOrientationListener orientationListener) {
            this.mOrientationListener = orientationListener;
            this.reset();
        }

        public int getProposedRotation() {
            return this.mProposedRotation;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        public void onSensorChanged(SensorEvent event) {
            boolean skipSample;
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            if (LOG) {
                Slog.v(WindowOrientationListener.TAG, "Raw acceleration vector: x=" + x + ", y=" + y + ", z=" + z + ", magnitude=" + FloatMath.sqrt(x * x + y * y + z * z));
            }
            long now = event.timestamp;
            long then = this.mLastFilteredTimestampNanos;
            float timeDeltaMS = (float)(now - then) * 1.0E-6f;
            if (now < then || now > then + 1000000000L || x == 0.0f && y == 0.0f && z == 0.0f) {
                if (LOG) {
                    Slog.v(WindowOrientationListener.TAG, "Resetting orientation listener.");
                }
                this.reset();
                skipSample = true;
            } else {
                float alpha = timeDeltaMS / (200.0f + timeDeltaMS);
                x = alpha * (x - this.mLastFilteredX) + this.mLastFilteredX;
                y = alpha * (y - this.mLastFilteredY) + this.mLastFilteredY;
                z = alpha * (z - this.mLastFilteredZ) + this.mLastFilteredZ;
                if (LOG) {
                    Slog.v(WindowOrientationListener.TAG, "Filtered acceleration vector: x=" + x + ", y=" + y + ", z=" + z + ", magnitude=" + FloatMath.sqrt(x * x + y * y + z * z));
                }
                skipSample = false;
            }
            this.mLastFilteredTimestampNanos = now;
            this.mLastFilteredX = x;
            this.mLastFilteredY = y;
            this.mLastFilteredZ = z;
            boolean isAccelerating = false;
            boolean isFlat = false;
            boolean isSwinging = false;
            if (!skipSample) {
                float magnitude = FloatMath.sqrt(x * x + y * y + z * z);
                if (magnitude < 1.0f) {
                    if (LOG) {
                        Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, magnitude too close to zero.");
                    }
                    this.clearPredictedRotation();
                } else {
                    if (this.isAccelerating(magnitude)) {
                        isAccelerating = true;
                        this.mAccelerationTimestampNanos = now;
                    }
                    int tiltAngle = (int)Math.round(Math.asin(z / magnitude) * (double)57.29578f);
                    this.addTiltHistoryEntry(now, tiltAngle);
                    if (this.isFlat(now)) {
                        isFlat = true;
                        this.mFlatTimestampNanos = now;
                    }
                    if (this.isSwinging(now, tiltAngle)) {
                        isSwinging = true;
                        this.mSwingTimestampNanos = now;
                    }
                    if (Math.abs(tiltAngle) > 75) {
                        if (LOG) {
                            Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, tilt angle too high: tiltAngle=" + tiltAngle);
                        }
                        this.clearPredictedRotation();
                    } else {
                        int nearestRotation;
                        int orientationAngle = (int)Math.round(-Math.atan2(-x, y) * (double)57.29578f);
                        if (orientationAngle < 0) {
                            orientationAngle += 360;
                        }
                        if ((nearestRotation = (orientationAngle + 45) / 90) == 4) {
                            nearestRotation = 0;
                        }
                        if (this.isTiltAngleAcceptable(nearestRotation, tiltAngle) && this.isOrientationAngleAcceptable(nearestRotation, orientationAngle)) {
                            this.updatePredictedRotation(now, nearestRotation);
                            if (LOG) {
                                Slog.v(WindowOrientationListener.TAG, "Predicted: tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle + ", predictedRotation=" + this.mPredictedRotation + ", predictedRotationAgeMS=" + (float)(now - this.mPredictedRotationTimestampNanos) * 1.0E-6f);
                            }
                        } else {
                            if (LOG) {
                                Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, no predicted rotation: tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle);
                            }
                            this.clearPredictedRotation();
                        }
                    }
                }
            }
            int oldProposedRotation = this.mProposedRotation;
            if (this.mPredictedRotation < 0 || this.isPredictedRotationAcceptable(now)) {
                this.mProposedRotation = this.mPredictedRotation;
            }
            if (LOG) {
                Slog.v(WindowOrientationListener.TAG, "Result: currentRotation=" + this.mOrientationListener.mCurrentRotation + ", proposedRotation=" + this.mProposedRotation + ", predictedRotation=" + this.mPredictedRotation + ", timeDeltaMS=" + timeDeltaMS + ", isAccelerating=" + isAccelerating + ", isFlat=" + isFlat + ", isSwinging=" + isSwinging + ", timeUntilSettledMS=" + SensorEventListenerImpl.remainingMS(now, this.mPredictedRotationTimestampNanos + 40000000L) + ", timeUntilAccelerationDelayExpiredMS=" + SensorEventListenerImpl.remainingMS(now, this.mAccelerationTimestampNanos + 500000000L) + ", timeUntilFlatDelayExpiredMS=" + SensorEventListenerImpl.remainingMS(now, this.mFlatTimestampNanos + 500000000L) + ", timeUntilSwingDelayExpiredMS=" + SensorEventListenerImpl.remainingMS(now, this.mSwingTimestampNanos + 300000000L));
            }
            if (this.mProposedRotation != oldProposedRotation && this.mProposedRotation >= 0) {
                if (LOG) {
                    Slog.v(WindowOrientationListener.TAG, "Proposed rotation changed!  proposedRotation=" + this.mProposedRotation + ", oldProposedRotation=" + oldProposedRotation);
                }
                this.mOrientationListener.onProposedRotationChanged(this.mProposedRotation);
            }
        }

        private boolean isTiltAngleAcceptable(int rotation, int tiltAngle) {
            return tiltAngle >= TILT_TOLERANCE[rotation][0] && tiltAngle <= TILT_TOLERANCE[rotation][1];
        }

        private boolean isOrientationAngleAcceptable(int rotation, int orientationAngle) {
            int currentRotation = this.mOrientationListener.mCurrentRotation;
            if (currentRotation >= 0) {
                if (rotation == currentRotation || rotation == (currentRotation + 1) % 4) {
                    int lowerBound = rotation * 90 - 45 + 22;
                    if (rotation == 0 ? orientationAngle >= 315 && orientationAngle < lowerBound + 360 : orientationAngle < lowerBound) {
                        return false;
                    }
                }
                if (rotation == currentRotation || rotation == (currentRotation + 3) % 4) {
                    int upperBound = rotation * 90 + 45 - 22;
                    if (rotation == 0 ? orientationAngle <= 45 && orientationAngle > upperBound : orientationAngle > upperBound) {
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean isPredictedRotationAcceptable(long now) {
            if (now < this.mPredictedRotationTimestampNanos + 40000000L) {
                return false;
            }
            if (now < this.mFlatTimestampNanos + 500000000L) {
                return false;
            }
            if (now < this.mSwingTimestampNanos + 300000000L) {
                return false;
            }
            return now >= this.mAccelerationTimestampNanos + 500000000L;
        }

        private void reset() {
            this.mLastFilteredTimestampNanos = Long.MIN_VALUE;
            this.mProposedRotation = -1;
            this.mFlatTimestampNanos = Long.MIN_VALUE;
            this.mSwingTimestampNanos = Long.MIN_VALUE;
            this.mAccelerationTimestampNanos = Long.MIN_VALUE;
            this.clearPredictedRotation();
            this.clearTiltHistory();
        }

        private void clearPredictedRotation() {
            this.mPredictedRotation = -1;
            this.mPredictedRotationTimestampNanos = Long.MIN_VALUE;
        }

        private void updatePredictedRotation(long now, int rotation) {
            if (this.mPredictedRotation != rotation) {
                this.mPredictedRotation = rotation;
                this.mPredictedRotationTimestampNanos = now;
            }
        }

        private boolean isAccelerating(float magnitude) {
            return magnitude < 5.80665f || magnitude > 13.80665f;
        }

        private void clearTiltHistory() {
            this.mTiltHistoryTimestampNanos[0] = Long.MIN_VALUE;
            this.mTiltHistoryIndex = 1;
        }

        private void addTiltHistoryEntry(long now, float tilt) {
            this.mTiltHistory[this.mTiltHistoryIndex] = tilt;
            this.mTiltHistoryTimestampNanos[this.mTiltHistoryIndex] = now;
            this.mTiltHistoryIndex = (this.mTiltHistoryIndex + 1) % 40;
            this.mTiltHistoryTimestampNanos[this.mTiltHistoryIndex] = Long.MIN_VALUE;
        }

        private boolean isFlat(long now) {
            int i = this.mTiltHistoryIndex;
            while ((i = this.nextTiltHistoryIndex(i)) >= 0 && !(this.mTiltHistory[i] < 75.0f)) {
                if (this.mTiltHistoryTimestampNanos[i] + 1000000000L > now) continue;
                return true;
            }
            return false;
        }

        private boolean isSwinging(long now, float tilt) {
            int i = this.mTiltHistoryIndex;
            while ((i = this.nextTiltHistoryIndex(i)) >= 0 && this.mTiltHistoryTimestampNanos[i] + 300000000L >= now) {
                if (!(this.mTiltHistory[i] + 20.0f <= tilt)) continue;
                return true;
            }
            return false;
        }

        private int nextTiltHistoryIndex(int index) {
            index = (index == 0 ? 40 : index) - 1;
            return this.mTiltHistoryTimestampNanos[index] != Long.MIN_VALUE ? index : -1;
        }

        private static float remainingMS(long now, long until) {
            return now >= until ? 0.0f : (float)(until - now) * 1.0E-6f;
        }
    }
}

