/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebViewClassic;
import android.widget.AbsoluteLayout;
import android.widget.AdapterView;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AutoCompletePopup
implements AdapterView.OnItemClickListener,
Filter.FilterListener,
PopupWindow.OnDismissListener {
    private static final int AUTOFILL_FORM = 100;
    private boolean mIsAutoFillProfileSet;
    private Handler mHandler;
    private int mQueryId;
    private ListPopupWindow mPopup;
    private Filter mFilter;
    private CharSequence mText;
    private ListAdapter mAdapter;
    private View mAnchor;
    private WebViewClassic.WebViewInputConnection mInputConnection;
    private WebViewClassic mWebView;

    public AutoCompletePopup(WebViewClassic webView, WebViewClassic.WebViewInputConnection inputConnection) {
        this.mInputConnection = inputConnection;
        this.mWebView = webView;
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        AutoCompletePopup.this.mWebView.autoFillForm(AutoCompletePopup.this.mQueryId);
                    }
                }
            }
        };
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (this.mPopup == null) {
            return false;
        }
        if (keyCode == 4 && this.mPopup.isShowing()) {
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state = this.mAnchor.getKeyDispatcherState();
                if (state != null) {
                    state.startTracking(event, this);
                }
                return true;
            }
            if (event.getAction() == 1) {
                KeyEvent.DispatcherState state = this.mAnchor.getKeyDispatcherState();
                if (state != null) {
                    state.handleUpEvent(event);
                }
                if (event.isTracking() && !event.isCanceled()) {
                    this.mPopup.dismiss();
                    return true;
                }
            }
        }
        if (this.mPopup.isShowing()) {
            return this.mPopup.onKeyPreIme(keyCode, event);
        }
        return false;
    }

    public void setText(CharSequence text) {
        this.mText = text;
        if (this.mFilter != null) {
            this.mFilter.filter(text, this);
        }
    }

    public void setAutoFillQueryId(int queryId) {
        this.mQueryId = queryId;
    }

    public void clearAdapter() {
        this.mAdapter = null;
        this.mFilter = null;
        if (this.mPopup != null) {
            this.mPopup.dismiss();
            this.mPopup.setAdapter(null);
        }
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T adapter) {
        this.ensurePopup();
        this.mPopup.setAdapter(adapter);
        this.mAdapter = adapter;
        if (adapter != null) {
            this.mFilter = ((Filterable)adapter).getFilter();
            this.mFilter.filter(this.mText, this);
        } else {
            this.mFilter = null;
        }
        this.resetRect();
    }

    public void resetRect() {
        this.ensurePopup();
        int left = this.mWebView.contentToViewX(this.mWebView.mEditTextContentBounds.left);
        int right = this.mWebView.contentToViewX(this.mWebView.mEditTextContentBounds.right);
        int width = right - left;
        this.mPopup.setWidth(width);
        int bottom = this.mWebView.contentToViewY(this.mWebView.mEditTextContentBounds.bottom);
        int top = this.mWebView.contentToViewY(this.mWebView.mEditTextContentBounds.top);
        int height = bottom - top;
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.mAnchor.getLayoutParams();
        boolean needsUpdate = false;
        if (null == lp) {
            lp = new AbsoluteLayout.LayoutParams(width, height, left, top);
        } else if (lp.x != left || lp.y != top || lp.width != width || lp.height != height) {
            needsUpdate = true;
            lp.x = left;
            lp.y = top;
            lp.width = width;
            lp.height = height;
        }
        if (needsUpdate) {
            this.mAnchor.setLayoutParams(lp);
        }
        if (this.mPopup.isShowing()) {
            this.mPopup.show();
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mPopup == null) {
            return;
        }
        if (id2 == 0L && position == 0 && this.mInputConnection.getIsAutoFillable()) {
            this.mText = "";
            this.pushTextToInputConnection();
            if (this.mIsAutoFillProfileSet) {
                this.mWebView.autoFillForm(this.mQueryId);
            } else {
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient != null) {
                    webChromeClient.setupAutoFill(this.mHandler.obtainMessage(100));
                }
            }
        } else {
            Object selectedItem = position < 0 ? this.mPopup.getSelectedItem() : this.mAdapter.getItem(position);
            if (selectedItem != null) {
                this.setText(this.mFilter.convertResultToString(selectedItem));
                this.pushTextToInputConnection();
            }
        }
        this.mPopup.dismiss();
    }

    public void setIsAutoFillProfileSet(boolean isAutoFillProfileSet) {
        this.mIsAutoFillProfileSet = isAutoFillProfileSet;
    }

    private void pushTextToInputConnection() {
        Editable oldText = this.mInputConnection.getEditable();
        this.mInputConnection.setSelection(0, oldText.length());
        this.mInputConnection.replaceSelection(this.mText);
        this.mInputConnection.setSelection(this.mText.length(), this.mText.length());
    }

    @Override
    public void onFilterComplete(int count) {
        boolean showDropDown;
        this.ensurePopup();
        boolean bl = showDropDown = count > 0 && (this.mInputConnection.getIsAutoFillable() || this.mText.length() > 0);
        if (showDropDown) {
            if (!this.mPopup.isShowing()) {
                this.mPopup.setInputMethodMode(1);
            }
            this.mPopup.show();
            this.mPopup.getListView().setOverScrollMode(0);
        } else {
            this.mPopup.dismiss();
        }
    }

    @Override
    public void onDismiss() {
        this.mWebView.getWebView().removeView(this.mAnchor);
    }

    private void ensurePopup() {
        if (this.mPopup == null) {
            this.mPopup = new ListPopupWindow(this.mWebView.getContext());
            this.mAnchor = new AnchorView(this.mWebView.getContext());
            this.mWebView.getWebView().addView(this.mAnchor);
            this.mPopup.setOnItemClickListener(this);
            this.mPopup.setAnchorView(this.mAnchor);
            this.mPopup.setPromptPosition(1);
        } else if (this.mWebView.getWebView().indexOfChild(this.mAnchor) < 0) {
            this.mWebView.getWebView().addView(this.mAnchor);
        }
    }

    private static class AnchorView
    extends View {
        AnchorView(Context context) {
            super(context);
            this.setFocusable(false);
            this.setVisibility(4);
        }
    }
}

