/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.Metadata;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.HTML5VideoView;
import android.webkit.HTML5VideoViewProxy;
import android.webkit.WebChromeClient;
import android.webkit.WebViewClassic;
import android.widget.FrameLayout;
import android.widget.MediaController;

public class HTML5VideoFullScreen
extends HTML5VideoView
implements MediaController.MediaPlayerControl,
MediaPlayer.OnPreparedListener,
View.OnTouchListener {
    private VideoSurfaceView mVideoSurfaceView;
    static final int FULLSCREEN_OFF = 0;
    static final int FULLSCREEN_SURFACECREATING = 1;
    static final int FULLSCREEN_SURFACECREATED = 2;
    private int mFullScreenMode;
    private MediaController mMediaController;
    private SurfaceHolder mSurfaceHolder = null;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private boolean mCanPause;
    private int mCurrentBufferPercentage;
    private static View mProgressView;
    private static FrameLayout mLayout;
    private int mVideoWidth;
    private int mVideoHeight;
    private boolean mPlayingWhenDestroyed = false;
    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            if (HTML5VideoView.mPlayer != null && HTML5VideoFullScreen.this.mMediaController != null && HTML5VideoView.mCurrentState == 2) {
                if (HTML5VideoFullScreen.this.mMediaController.isShowing()) {
                    HTML5VideoFullScreen.this.mMediaController.hide();
                }
                HTML5VideoFullScreen.this.mMediaController.show();
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            HTML5VideoFullScreen.this.mSurfaceHolder = holder;
            HTML5VideoFullScreen.this.mFullScreenMode = 2;
            HTML5VideoFullScreen.this.prepareForFullScreen();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            HTML5VideoFullScreen.this.mPlayingWhenDestroyed = HTML5VideoView.mPlayer.isPlaying();
            HTML5VideoFullScreen.this.pauseAndDispatch(HTML5VideoFullScreen.this.mProxy);
            HTML5VideoView.mPlayer.setDisplay(null);
            HTML5VideoFullScreen.this.mSurfaceHolder = null;
            if (HTML5VideoFullScreen.this.mMediaController != null) {
                HTML5VideoFullScreen.this.mMediaController.hide();
            }
        }
    };
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            HTML5VideoFullScreen.this.mVideoWidth = mp.getVideoWidth();
            HTML5VideoFullScreen.this.mVideoHeight = mp.getVideoHeight();
            if (HTML5VideoFullScreen.this.mVideoWidth != 0 && HTML5VideoFullScreen.this.mVideoHeight != 0) {
                HTML5VideoFullScreen.this.mVideoSurfaceView.getHolder().setFixedSize(HTML5VideoFullScreen.this.mVideoWidth, HTML5VideoFullScreen.this.mVideoHeight);
            }
        }
    };
    private final WebChromeClient.CustomViewCallback mCallback = new WebChromeClient.CustomViewCallback(){

        public void onCustomViewHidden() {
            mLayout.removeView(HTML5VideoFullScreen.this.getSurfaceView());
            if (mProgressView != null) {
                mLayout.removeView(mProgressView);
                mProgressView = null;
            }
            mLayout = null;
            HTML5VideoFullScreen.this.mProxy.getWebView().getViewManager().showAll();
            HTML5VideoFullScreen.this.mMediaController = null;
            HTML5VideoFullScreen.this.mProxy.dispatchOnStopFullScreen(HTML5VideoFullScreen.this.mPlayingWhenDestroyed);
            HTML5VideoFullScreen.this.mProxy = null;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            HTML5VideoFullScreen.this.mCurrentBufferPercentage = percent;
        }
    };

    private SurfaceView getSurfaceView() {
        return this.mVideoSurfaceView;
    }

    HTML5VideoFullScreen(Context context, int videoLayerId, int position, boolean skipPrepare) {
        this.mVideoSurfaceView = new VideoSurfaceView(context);
        this.mFullScreenMode = 0;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.init(videoLayerId, position, skipPrepare);
    }

    private void setMediaController(MediaController m) {
        this.mMediaController = m;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (mPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            this.mMediaController.setAnchorView(this.mVideoSurfaceView);
            this.mMediaController.setEnabled(false);
        }
    }

    public void decideDisplayMode() {
        mPlayer.setDisplay(this.mSurfaceHolder);
    }

    private void prepareForFullScreen() {
        FullScreenMediaController mc = new FullScreenMediaController(this.mProxy.getContext(), mLayout);
        mc.setSystemUiVisibility(mLayout.getSystemUiVisibility());
        this.setMediaController(mc);
        mPlayer.setScreenOnWhilePlaying(true);
        mPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
        this.prepareDataAndDisplayMode(this.mProxy);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        super.onPrepared(mp);
        this.mVideoSurfaceView.setOnTouchListener(this);
        Metadata data = mp.getMetadata(false, false);
        if (data != null) {
            this.mCanPause = !data.has(1) || data.getBoolean(1);
            this.mCanSeekBack = !data.has(2) || data.getBoolean(2);
            this.mCanSeekForward = !data.has(3) || data.getBoolean(3);
        } else {
            this.mCanSeekForward = true;
            this.mCanSeekBack = true;
            this.mCanPause = true;
        }
        if (this.getStartWhenPrepared()) {
            mPlayer.start();
            this.setStartWhenPrepared(false);
        }
        if (this.mMediaController != null) {
            this.mMediaController.setEnabled(true);
            this.mMediaController.show();
        }
        if (mProgressView != null) {
            mProgressView.setVisibility(8);
        }
        this.mVideoWidth = mp.getVideoWidth();
        this.mVideoHeight = mp.getVideoHeight();
        this.mVideoSurfaceView.getHolder().setFixedSize(this.mVideoWidth, this.mVideoHeight);
    }

    public boolean fullScreenExited() {
        return mLayout == null;
    }

    public void enterFullScreenVideoState(int layerId, HTML5VideoViewProxy proxy, WebViewClassic webView) {
        this.mFullScreenMode = 1;
        this.mCurrentBufferPercentage = 0;
        mPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
        this.mProxy = proxy;
        this.mVideoSurfaceView.getHolder().addCallback(this.mSHCallback);
        this.mVideoSurfaceView.getHolder().setType(3);
        this.mVideoSurfaceView.setFocusable(true);
        this.mVideoSurfaceView.setFocusableInTouchMode(true);
        this.mVideoSurfaceView.requestFocus();
        this.mVideoSurfaceView.setOnKeyListener(this.mProxy);
        mLayout = new FrameLayout(this.mProxy.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        mLayout.addView((View)this.getSurfaceView(), layoutParams);
        mLayout.setVisibility(0);
        WebChromeClient client = webView.getWebChromeClient();
        if (client != null) {
            client.onShowCustomView(mLayout, this.mCallback);
            if (webView.getViewManager() != null) {
                webView.getViewManager().hideAll();
            }
            if ((mProgressView = client.getVideoLoadingProgressView()) != null) {
                mLayout.addView(mProgressView, layoutParams);
                mProgressView.setVisibility(0);
            }
        }
    }

    public boolean isFullScreenMode() {
        return true;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public int getBufferPercentage() {
        if (mPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    public void showControllerInFullScreen() {
        if (this.mMediaController != null) {
            this.mMediaController.show(0);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mFullScreenMode >= 2 && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    protected void switchProgressView(boolean playerBuffering) {
        if (mProgressView != null) {
            if (playerBuffering) {
                mProgressView.setVisibility(0);
            } else {
                mProgressView.setVisibility(8);
            }
        }
    }

    static class FullScreenMediaController
    extends MediaController {
        View mVideoView;

        public FullScreenMediaController(Context context, View video) {
            super(context);
            this.mVideoView = video;
        }

        public void show() {
            super.show();
            if (this.mVideoView != null) {
                this.mVideoView.setSystemUiVisibility(0);
            }
        }

        public void hide() {
            if (this.mVideoView != null) {
                this.mVideoView.setSystemUiVisibility(3);
            }
            super.hide();
        }
    }

    private class VideoSurfaceView
    extends SurfaceView {
        public VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = VideoSurfaceView.getDefaultSize(HTML5VideoFullScreen.this.mVideoWidth, widthMeasureSpec);
            int height = VideoSurfaceView.getDefaultSize(HTML5VideoFullScreen.this.mVideoHeight, heightMeasureSpec);
            if (HTML5VideoFullScreen.this.mVideoWidth > 0 && HTML5VideoFullScreen.this.mVideoHeight > 0) {
                if (HTML5VideoFullScreen.this.mVideoWidth * height > width * HTML5VideoFullScreen.this.mVideoHeight) {
                    height = width * HTML5VideoFullScreen.this.mVideoHeight / HTML5VideoFullScreen.this.mVideoWidth;
                } else if (HTML5VideoFullScreen.this.mVideoWidth * height < width * HTML5VideoFullScreen.this.mVideoHeight) {
                    width = height * HTML5VideoFullScreen.this.mVideoWidth / HTML5VideoFullScreen.this.mVideoHeight;
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

