/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import android.webkit.HTML5VideoView;
import android.webkit.HTML5VideoViewProxy;

public class HTML5VideoInline
extends HTML5VideoView {
    private static SurfaceTexture mSurfaceTexture = null;
    private static int[] mTextureNames = null;
    private static int mVideoLayerUsingSurfaceTexture = -1;

    public void start() {
        if (!this.getPauseDuringPreparing()) {
            super.start();
        }
    }

    HTML5VideoInline(int videoLayerId, int position, boolean skipPrepare) {
        this.init(videoLayerId, position, skipPrepare);
    }

    public void decideDisplayMode() {
        SurfaceTexture surfaceTexture = HTML5VideoInline.getSurfaceTexture(this.getVideoLayerId());
        Surface surface = new Surface(surfaceTexture);
        mPlayer.setSurface(surface);
        surface.release();
    }

    public void prepareDataAndDisplayMode(HTML5VideoViewProxy proxy) {
        super.prepareDataAndDisplayMode(proxy);
        this.setFrameAvailableListener(proxy);
        if (this.mProxy.getContext().checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
            mPlayer.setWakeMode(proxy.getContext(), 26);
        }
    }

    public void pauseAndDispatch(HTML5VideoViewProxy proxy) {
        super.pauseAndDispatch(proxy);
    }

    public static SurfaceTexture getSurfaceTexture(int videoLayerId) {
        if (videoLayerId != mVideoLayerUsingSurfaceTexture || mSurfaceTexture == null || mTextureNames == null) {
            mTextureNames = new int[1];
            GLES20.glGenTextures(1, mTextureNames, 0);
            mSurfaceTexture = new SurfaceTexture(mTextureNames[0]);
        }
        mVideoLayerUsingSurfaceTexture = videoLayerId;
        return mSurfaceTexture;
    }

    public static boolean surfaceTextureDeleted() {
        return mSurfaceTexture == null;
    }

    public void deleteSurfaceTexture() {
        HTML5VideoInline.cleanupSurfaceTexture();
    }

    public static void cleanupSurfaceTexture() {
        mSurfaceTexture = null;
        mVideoLayerUsingSurfaceTexture = -1;
    }

    public int getTextureName() {
        if (mTextureNames != null) {
            return mTextureNames[0];
        }
        return 0;
    }

    private void setFrameAvailableListener(SurfaceTexture.OnFrameAvailableListener l) {
        if (mSurfaceTexture != null) {
            mSurfaceTexture.setOnFrameAvailableListener(l);
        }
    }
}

