/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.media.MediaPlayer;
import android.net.Uri;
import android.webkit.CookieManager;
import android.webkit.HTML5VideoViewProxy;
import android.webkit.WebViewClassic;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTML5VideoView
implements MediaPlayer.OnPreparedListener {
    protected static final String LOGTAG = "HTML5VideoView";
    protected static final String COOKIE = "Cookie";
    protected static final String HIDE_URL_LOGS = "x-hide-urls-from-log";
    static final int STATE_INITIALIZED = 0;
    static final int STATE_PREPARING = 1;
    static final int STATE_PREPARED = 2;
    static final int STATE_PLAYING = 3;
    static final int STATE_RESETTED = 4;
    static final int STATE_RELEASED = 5;
    protected HTML5VideoViewProxy mProxy;
    protected int mSaveSeekTime;
    protected int mVideoLayerId;
    protected static MediaPlayer mPlayer = null;
    protected static int mCurrentState = -1;
    protected Uri mUri;
    protected Map<String, String> mHeaders;
    protected static Timer mTimer;
    protected boolean mPauseDuringPreparing;
    private static final int TIMEUPDATE_PERIOD = 250;
    private boolean mSkipPrepare = false;
    public boolean mPlayerBuffering = false;
    private boolean mStartWhenPrepared = false;

    public void start() {
        if (mCurrentState == 2) {
            if (mTimer == null) {
                mTimer = new Timer();
                mTimer.schedule((TimerTask)new TimeupdateTask(this.mProxy), 250L, 250L);
            }
            mPlayer.start();
            this.setPlayerBuffering(false);
        }
    }

    public void pause() {
        if (this.isPlaying()) {
            mPlayer.pause();
        } else if (mCurrentState == 1) {
            this.mPauseDuringPreparing = true;
        }
        if (mTimer != null) {
            mTimer.purge();
            mTimer.cancel();
            mTimer = null;
        }
    }

    public int getDuration() {
        if (mCurrentState == 2) {
            return mPlayer.getDuration();
        }
        return -1;
    }

    public int getCurrentPosition() {
        if (mCurrentState == 2) {
            return mPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int pos) {
        if (mCurrentState == 2) {
            mPlayer.seekTo(pos);
        } else {
            this.mSaveSeekTime = pos;
        }
    }

    public boolean isPlaying() {
        if (mCurrentState == 2) {
            return mPlayer.isPlaying();
        }
        return false;
    }

    public void reset() {
        if (mCurrentState < 4) {
            mPlayer.reset();
        }
        mCurrentState = 4;
    }

    public void stopPlayback() {
        if (mCurrentState == 2) {
            mPlayer.stop();
        }
    }

    public static void release() {
        if (mPlayer != null && mCurrentState != 5) {
            mPlayer.release();
            mPlayer = null;
        }
        mCurrentState = 5;
    }

    public boolean isReleased() {
        return mCurrentState == 5;
    }

    public boolean getPauseDuringPreparing() {
        return this.mPauseDuringPreparing;
    }

    public void init(int videoLayerId, int position, boolean skipPrepare) {
        if (mPlayer == null) {
            mPlayer = new MediaPlayer();
            mCurrentState = 0;
        }
        this.mSkipPrepare = skipPrepare;
        if (!this.mSkipPrepare) {
            mCurrentState = 0;
        }
        this.mProxy = null;
        this.mVideoLayerId = videoLayerId;
        this.mSaveSeekTime = position;
        mTimer = null;
        this.mPauseDuringPreparing = false;
    }

    protected HTML5VideoView() {
    }

    protected static Map<String, String> generateHeaders(String url, HTML5VideoViewProxy proxy) {
        boolean isPrivate = proxy.getWebView().isPrivateBrowsingEnabled();
        String cookieValue = CookieManager.getInstance().getCookie(url, isPrivate);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (cookieValue != null) {
            headers.put(COOKIE, cookieValue);
        }
        if (isPrivate) {
            headers.put(HIDE_URL_LOGS, "true");
        }
        return headers;
    }

    public void setVideoURI(String uri, HTML5VideoViewProxy proxy) {
        this.mUri = Uri.parse(uri);
        this.mHeaders = HTML5VideoView.generateHeaders(uri, proxy);
    }

    public void setOnCompletionListener(HTML5VideoViewProxy proxy) {
        mPlayer.setOnCompletionListener(proxy);
    }

    public void setOnErrorListener(HTML5VideoViewProxy proxy) {
        mPlayer.setOnErrorListener(proxy);
    }

    public void setOnPreparedListener(HTML5VideoViewProxy proxy) {
        this.mProxy = proxy;
        mPlayer.setOnPreparedListener(this);
    }

    public void setOnInfoListener(HTML5VideoViewProxy proxy) {
        mPlayer.setOnInfoListener(proxy);
    }

    public void prepareDataCommon(HTML5VideoViewProxy proxy) {
        if (!this.mSkipPrepare) {
            try {
                mPlayer.reset();
                mPlayer.setDataSource(proxy.getContext(), this.mUri, this.mHeaders);
                mPlayer.prepareAsync();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            mCurrentState = 1;
        } else {
            if (mCurrentState >= 2) {
                this.onPrepared(mPlayer);
            }
            this.mSkipPrepare = false;
        }
    }

    public void reprepareData(HTML5VideoViewProxy proxy) {
        mPlayer.reset();
        this.prepareDataCommon(proxy);
    }

    public void prepareDataAndDisplayMode(HTML5VideoViewProxy proxy) {
        this.decideDisplayMode();
        this.setOnCompletionListener(proxy);
        this.setOnPreparedListener(proxy);
        this.setOnErrorListener(proxy);
        this.setOnInfoListener(proxy);
        this.prepareDataCommon(proxy);
    }

    public int getVideoLayerId() {
        return this.mVideoLayerId;
    }

    public int getCurrentState() {
        if (this.isPlaying()) {
            return 3;
        }
        return mCurrentState;
    }

    @Override
    public void onPrepared(MediaPlayer mp) {
        mCurrentState = 2;
        this.seekTo(this.mSaveSeekTime);
        if (this.mProxy != null) {
            this.mProxy.onPrepared(mp);
        }
        if (this.mPauseDuringPreparing) {
            this.pauseAndDispatch(this.mProxy);
            this.mPauseDuringPreparing = false;
        }
    }

    public void pauseAndDispatch(HTML5VideoViewProxy proxy) {
        this.pause();
        if (proxy != null) {
            proxy.dispatchOnPaused();
        }
    }

    public void enterFullScreenVideoState(int layerId, HTML5VideoViewProxy proxy, WebViewClassic webView) {
    }

    public boolean isFullScreenMode() {
        return false;
    }

    public void decideDisplayMode() {
    }

    public boolean getReadyToUseSurfTex() {
        return false;
    }

    public void deleteSurfaceTexture() {
    }

    public int getTextureName() {
        return 0;
    }

    public boolean getPlayerBuffering() {
        return this.mPlayerBuffering;
    }

    public void setPlayerBuffering(boolean playerBuffering) {
        this.mPlayerBuffering = playerBuffering;
        this.switchProgressView(playerBuffering);
    }

    protected void switchProgressView(boolean playerBuffering) {
    }

    public boolean fullScreenExited() {
        return false;
    }

    public void setStartWhenPrepared(boolean willPlay) {
        this.mStartWhenPrepared = willPlay;
    }

    public boolean getStartWhenPrepared() {
        return this.mStartWhenPrepared;
    }

    public void showControllerInFullScreen() {
    }

    private static class TimeupdateTask
    extends TimerTask {
        private HTML5VideoViewProxy mProxy;

        public TimeupdateTask(HTML5VideoViewProxy proxy) {
            this.mProxy = proxy;
        }

        public void run() {
            this.mProxy.onTimeupdate();
        }
    }
}

