/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebViewClassic;
import android.widget.FrameLayout;

class PluginFullScreenHolder {
    private final WebViewClassic mWebView;
    private final int mNpp;
    private final int mOrientation;
    private static CustomFrameLayout mLayout;
    private View mContentView;
    private final WebChromeClient.CustomViewCallback mCallback = new WebChromeClient.CustomViewCallback(){

        public void onCustomViewHidden() {
            ((PluginFullScreenHolder)PluginFullScreenHolder.this).mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
            PluginFullScreenHolder.this.mWebView.getWebViewCore().sendMessage(182, PluginFullScreenHolder.this.mNpp, 0);
            mLayout.removeView(PluginFullScreenHolder.this.mContentView);
            mLayout = null;
            PluginFullScreenHolder.this.mWebView.getViewManager().showAll();
        }
    };

    PluginFullScreenHolder(WebViewClassic webView, int orientation, int npp) {
        this.mWebView = webView;
        this.mNpp = npp;
        this.mOrientation = orientation;
    }

    public void setContentView(View contentView) {
        SurfaceView sView;
        mLayout = new CustomFrameLayout(this.mWebView.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        mLayout.addView(contentView, layoutParams);
        mLayout.setVisibility(0);
        if (contentView instanceof SurfaceView && (sView = (SurfaceView)contentView).isFixedSize()) {
            sView.getHolder().setSizeFromLayout();
        }
        this.mContentView = contentView;
    }

    public void show() {
        if (this.mWebView.getViewManager() != null) {
            this.mWebView.getViewManager().hideAll();
        }
        WebChromeClient client = this.mWebView.getWebChromeClient();
        client.onShowCustomView(mLayout, this.mOrientation, this.mCallback);
    }

    public void hide() {
        WebChromeClient client = this.mWebView.getWebChromeClient();
        client.onHideCustomView();
    }

    private class CustomFrameLayout
    extends FrameLayout {
        CustomFrameLayout(Context context) {
            super(context);
        }

        public boolean onKeyDown(int keyCode, KeyEvent event) {
            if (event.isSystem()) {
                return super.onKeyDown(keyCode, event);
            }
            PluginFullScreenHolder.this.mWebView.onKeyDown(keyCode, event);
            return true;
        }

        public boolean onKeyUp(int keyCode, KeyEvent event) {
            if (event.isSystem()) {
                return super.onKeyUp(keyCode, event);
            }
            PluginFullScreenHolder.this.mWebView.onKeyUp(keyCode, event);
            return true;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return true;
        }

        public boolean onTrackballEvent(MotionEvent event) {
            PluginFullScreenHolder.this.mWebView.onTrackballEvent(event);
            return true;
        }
    }
}

