/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.Point;
import android.webkit.WebViewCore;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ViewStateSerializer {
    private static final int WORKING_STREAM_STORAGE = 16384;
    static final int VERSION = 1;

    static boolean serializeViewState(OutputStream stream, WebViewCore.DrawData draw) throws IOException {
        int baseLayer = draw.mBaseLayer;
        if (baseLayer == 0) {
            return false;
        }
        DataOutputStream dos = new DataOutputStream(stream);
        dos.writeInt(1);
        dos.writeInt(draw.mContentSize.x);
        dos.writeInt(draw.mContentSize.y);
        return ViewStateSerializer.nativeSerializeViewState(baseLayer, dos, new byte[16384]);
    }

    static WebViewCore.DrawData deserializeViewState(InputStream stream) throws IOException {
        DataInputStream dis = new DataInputStream(stream);
        int version = dis.readInt();
        if (version > 1) {
            throw new IOException("Unexpected version: " + version);
        }
        int contentWidth = dis.readInt();
        int contentHeight = dis.readInt();
        int baseLayer = ViewStateSerializer.nativeDeserializeViewState(version, dis, new byte[16384]);
        WebViewCore.DrawData draw = new WebViewCore.DrawData();
        draw.mViewState = new WebViewCore.ViewState();
        draw.mContentSize = new Point(contentWidth, contentHeight);
        draw.mBaseLayer = baseLayer;
        stream.close();
        return draw;
    }

    public static void dumpLayerHierarchy(int baseLayer, OutputStream out, int level) {
        ViewStateSerializer.nativeDumpLayerHierarchy(baseLayer, level, out, new byte[16384]);
    }

    private static void nativeDumpLayerHierarchy(int n, int n2, OutputStream outputStream, byte[] byArray) {
        OverrideMethod.invokeV("android.webkit.ViewStateSerializer#nativeDumpLayerHierarchy(IILjava/io/OutputStream;[B)V", true, null);
    }

    private static boolean nativeSerializeViewState(int n, OutputStream outputStream, byte[] byArray) {
        return OverrideMethod.invokeI("android.webkit.ViewStateSerializer#nativeSerializeViewState(ILjava/io/OutputStream;[B)Z", true, null) != 0;
    }

    private static int nativeDeserializeViewState(int n, InputStream inputStream, byte[] byArray) {
        return OverrideMethod.invokeI("android.webkit.ViewStateSerializer#nativeDeserializeViewState(ILjava/io/InputStream;[B)I", true, null);
    }

    private ViewStateSerializer() {
    }
}

