/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.animation.ObjectAnimator;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RegionIterator;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.ProxyProperties;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.view.HardwareCanvas;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.AccessibilityInjector;
import android.webkit.AutoCompletePopup;
import android.webkit.BrowserFrame;
import android.webkit.CallbackProxy;
import android.webkit.CookieManager;
import android.webkit.CookieManagerClassic;
import android.webkit.DownloadListener;
import android.webkit.FindActionModeCallback;
import android.webkit.GeolocationPermissions;
import android.webkit.GeolocationPermissionsClassic;
import android.webkit.HTML5VideoInline;
import android.webkit.HTML5VideoView;
import android.webkit.HTML5VideoViewProxy;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.JniUtil;
import android.webkit.L10nUtils;
import android.webkit.OverScrollGlow;
import android.webkit.PluginFullScreenHolder;
import android.webkit.PluginList;
import android.webkit.PluginManager;
import android.webkit.QuadF;
import android.webkit.SelectActionModeCallback;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.ViewStateSerializer;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClassic;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebCoreThreadWatchdog;
import android.webkit.WebHistoryItem;
import android.webkit.WebHistoryItemClassic;
import android.webkit.WebIconDatabase;
import android.webkit.WebIconDatabaseClassic;
import android.webkit.WebSettings;
import android.webkit.WebSettingsClassic;
import android.webkit.WebStorage;
import android.webkit.WebStorageClassic;
import android.webkit.WebTextView;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewDatabaseClassic;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewInputDispatcher;
import android.webkit.WebViewProvider;
import android.webkit.ZoomManager;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.OverScroller;
import android.widget.PopupWindow;
import android.widget.Scroller;
import android.widget.TextView;
import android.widget.Toast;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewClassic
implements WebViewProvider,
WebViewProvider.ScrollDelegate,
WebViewProvider.ViewDelegate {
    private static final boolean AUTO_REDRAW_HACK = false;
    private static final float TEXT_SCROLL_RATE = 0.01f;
    private static final long TEXT_SCROLL_FIRST_SCROLL_MS = 16L;
    private static final int EDIT_RECT_BUFFER = 10;
    private static final long SELECTION_HANDLE_ANIMATION_MS = 150L;
    private boolean mAutoRedraw;
    private AlertDialog mListBoxDialog = null;
    private AlertDialog mSavePasswordDialog = null;
    static final String LOGTAG = "webview";
    private ZoomManager mZoomManager;
    private final Rect mInvScreenRect = new Rect();
    private final Rect mScreenRect = new Rect();
    private final RectF mVisibleContentRect = new RectF();
    private boolean mIsWebViewVisible = true;
    WebViewInputConnection mInputConnection = null;
    private int mFieldPointer;
    private PastePopupWindow mPasteWindow;
    private AutoCompletePopup mAutoCompletePopup;
    Rect mEditTextContentBounds = new Rect();
    Rect mEditTextContent = new Rect();
    int mEditTextLayerId;
    boolean mIsEditingText = false;
    ArrayList<Message> mBatchedTextChanges = new ArrayList();
    boolean mIsBatchingTextChanges = false;
    private long mLastEditScroll = 0L;
    private CallbackProxy mCallbackProxy;
    private WebViewDatabaseClassic mDatabase;
    private SslCertificate mCertificate;
    private int mNativeClass;
    private WebViewCore mWebViewCore;
    final Handler mPrivateHandler = new PrivateHandler();
    private int mTextGeneration;
    ViewManager mViewManager;
    PluginFullScreenHolder mFullScreenHolder;
    private int mLastTouchX;
    private int mLastTouchY;
    private int mStartTouchX;
    private int mStartTouchY;
    private float mAverageAngle;
    private long mLastTouchTime;
    private long mLastSentTouchTime;
    private static final int TOUCH_SENT_INTERVAL = 0;
    private int mCurrentTouchInterval = 0;
    VelocityTracker mVelocityTracker;
    private int mMaximumFling;
    private float mLastVelocity;
    private float mLastVelX;
    private float mLastVelY;
    private int mCurrentScrollingLayerId;
    private Rect mScrollingLayerRect = new Rect();
    private static final float MINIMUM_VELOCITY_RATIO_FOR_ACCELERATION = 0.2f;
    private int mTouchMode = 7;
    private static final int TOUCH_INIT_MODE = 1;
    private static final int TOUCH_DRAG_START_MODE = 2;
    private static final int TOUCH_DRAG_MODE = 3;
    private static final int TOUCH_SHORTPRESS_START_MODE = 4;
    private static final int TOUCH_SHORTPRESS_MODE = 5;
    private static final int TOUCH_DOUBLE_TAP_MODE = 6;
    private static final int TOUCH_DONE_MODE = 7;
    private static final int TOUCH_PINCH_DRAG = 8;
    private static final int TOUCH_DRAG_LAYER_MODE = 9;
    private static final int TOUCH_DRAG_TEXT_MODE = 10;
    private boolean mConfirmMove;
    private boolean mTouchInEditText;
    private boolean mDrawCursorRing = true;
    private boolean mIsPaused;
    private WebView.HitTestResult mInitialHitTestResult;
    private WebViewCore.WebKitHitTest mFocusedNode;
    private int mTouchSlopSquare;
    private int mDoubleTapSlopSquare;
    private int mNavSlop;
    private static final int TAP_TIMEOUT = 300;
    private static final int LONG_PRESS_TIMEOUT = 1000;
    private static final int MIN_FLING_TIME = 250;
    private static final int MOTIONLESS_TIME = 100;
    private static final int PAGE_SCROLL_OVERLAP = 24;
    boolean mWidthCanMeasure;
    boolean mHeightCanMeasure;
    int mLastWidthSent;
    int mLastHeightSent;
    int mLastActualHeightSent;
    private int mContentWidth;
    private int mContentHeight;
    private boolean mOverlayHorizontalScrollbar = true;
    private boolean mOverlayVerticalScrollbar = false;
    private static final int STD_SPEED = 480;
    private static final int MAX_DURATION = 750;
    OverScroller mScroller;
    Scroller mEditTextScroller;
    private boolean mInOverScrollMode = false;
    private static Paint mOverScrollBackground;
    private static Paint mOverScrollBorder;
    private boolean mWrapContent;
    private static final int MOTIONLESS_FALSE = 0;
    private static final int MOTIONLESS_PENDING = 1;
    private static final int MOTIONLESS_TRUE = 2;
    private static final int MOTIONLESS_IGNORE = 3;
    private int mHeldMotionless;
    private AccessibilityInjector mAccessibilityInjector;
    private static final long CARET_HANDLE_STAMINA_MS = 3000L;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    private Drawable mSelectHandleCenter;
    private Point mSelectOffset;
    private Point mSelectCursorBase = new Point();
    private Rect mSelectHandleBaseBounds = new Rect();
    private int mSelectCursorBaseLayerId;
    private QuadF mSelectCursorBaseTextQuad = new QuadF();
    private Point mSelectCursorExtent = new Point();
    private Rect mSelectHandleExtentBounds = new Rect();
    private int mSelectCursorExtentLayerId;
    private QuadF mSelectCursorExtentTextQuad = new QuadF();
    private Point mSelectDraggingCursor;
    private QuadF mSelectDraggingTextQuad;
    private boolean mIsCaretSelection;
    static final int HANDLE_ID_BASE = 0;
    static final int HANDLE_ID_EXTENT = 1;
    static final int HIGHLIGHT_COLOR = 1714664933;
    private Region mTouchHighlightRegion = new Region();
    private Paint mTouchHightlightPaint = new Paint();
    private static final boolean DEBUG_TOUCH_HIGHLIGHT = true;
    private static final int TOUCH_HIGHLIGHT_ELAPSE_TIME = 2000;
    private Paint mTouchCrossHairColor;
    private int mTouchHighlightX;
    private int mTouchHighlightY;
    private boolean mShowTapHighlight;
    private HTML5VideoViewProxy mHTML5VideoViewProxy;
    private boolean mBlockWebkitViewMessages = false;
    private boolean mHardwareAccelSkia = false;
    private static final int REMEMBER_PASSWORD = 1;
    private static final int NEVER_REMEMBER_PASSWORD = 2;
    private static final int SWITCH_TO_SHORTPRESS = 3;
    private static final int SWITCH_TO_LONGPRESS = 4;
    private static final int RELEASE_SINGLE_TAP = 5;
    private static final int REQUEST_FORM_DATA = 6;
    private static final int DRAG_HELD_MOTIONLESS = 8;
    private static final int PREVENT_DEFAULT_TIMEOUT = 10;
    private static final int SCROLL_SELECT_TEXT = 11;
    private static final int FIRST_PRIVATE_MSG_ID = 1;
    private static final int LAST_PRIVATE_MSG_ID = 11;
    static final int SCROLL_TO_MSG_ID = 101;
    static final int NEW_PICTURE_MSG_ID = 105;
    static final int WEBCORE_INITIALIZED_MSG_ID = 107;
    static final int UPDATE_TEXTFIELD_TEXT_MSG_ID = 108;
    static final int UPDATE_ZOOM_RANGE = 109;
    static final int TAKE_FOCUS = 110;
    static final int CLEAR_TEXT_ENTRY = 111;
    static final int UPDATE_TEXT_SELECTION_MSG_ID = 112;
    static final int SHOW_RECT_MSG_ID = 113;
    static final int LONG_PRESS_CENTER = 114;
    static final int PREVENT_TOUCH_ID = 115;
    static final int WEBCORE_NEED_TOUCH_EVENTS = 116;
    static final int INVAL_RECT_MSG_ID = 117;
    static final int REQUEST_KEYBOARD = 118;
    static final int SHOW_FULLSCREEN = 120;
    static final int HIDE_FULLSCREEN = 121;
    static final int UPDATE_MATCH_COUNT = 126;
    static final int CENTER_FIT_RECT = 127;
    static final int SET_SCROLLBAR_MODES = 129;
    static final int SELECTION_STRING_CHANGED = 130;
    static final int HIT_TEST_RESULT = 131;
    static final int SAVE_WEBARCHIVE_FINISHED = 132;
    static final int SET_AUTOFILLABLE = 133;
    static final int AUTOFILL_COMPLETE = 134;
    static final int SCREEN_ON = 136;
    static final int UPDATE_ZOOM_DENSITY = 139;
    static final int EXIT_FULLSCREEN_VIDEO = 140;
    static final int COPY_TO_CLIPBOARD = 141;
    static final int INIT_EDIT_FIELD = 142;
    static final int REPLACE_TEXT = 143;
    static final int CLEAR_CARET_HANDLE = 144;
    static final int KEY_PRESS = 145;
    static final int RELOCATE_AUTO_COMPLETE_POPUP = 146;
    static final int FOCUS_NODE_CHANGED = 147;
    static final int AUTOFILL_FORM = 148;
    static final int SCROLL_EDIT_TEXT = 149;
    static final int EDIT_TEXT_SIZE_CHANGED = 150;
    static final int SHOW_CARET_HANDLE = 151;
    static final int UPDATE_CONTENT_BOUNDS = 152;
    static final int SCROLL_HANDLE_INTO_VIEW = 153;
    private static final int FIRST_PACKAGE_MSG_ID = 101;
    private static final int LAST_PACKAGE_MSG_ID = 131;
    static final String[] HandlerPrivateDebugString;
    static final String[] HandlerPackageDebugString;
    static final int DEFAULT_VIEWPORT_WIDTH = 980;
    static int sMaxViewportWidth;
    private int mInitialScaleInPercent = 0;
    private boolean mSendScrollEvent = true;
    private int mSnapScrollMode = 0;
    private static final int SNAP_NONE = 0;
    private static final int SNAP_LOCK = 1;
    private static final int SNAP_X = 2;
    private static final int SNAP_Y = 4;
    private boolean mSnapPositive;
    private static final int DRAW_EXTRAS_NONE = 0;
    private static final int DRAW_EXTRAS_SELECTION = 1;
    private static final int DRAW_EXTRAS_CURSOR_RING = 2;
    private static final int SCROLLBAR_AUTO = 0;
    private static final int SCROLLBAR_ALWAYSOFF = 1;
    private static final int SCROLLBAR_ALWAYSON = 2;
    private int mHorizontalScrollBarMode = 0;
    private int mVerticalScrollBarMode = 0;
    private int mOverscrollDistance;
    private int mOverflingDistance;
    private OverScrollGlow mOverScrollGlow;
    private Vector<Integer> mKeysPressed;
    static boolean mLogEvent;
    private long mLastTouchUpTime = 0L;
    private WebViewCore.AutoFillData mAutoFillData;
    private static boolean sNotificationsEnabled;
    public static final String SCHEME_TEL = "tel:";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_GEO = "geo:0,0?q=";
    private int mBackgroundColor = -1;
    private static final long SELECT_SCROLL_INTERVAL = 16L;
    private int mAutoScrollX = 0;
    private int mAutoScrollY = 0;
    private int mMinAutoScrollX = 0;
    private int mMaxAutoScrollX = 0;
    private int mMinAutoScrollY = 0;
    private int mMaxAutoScrollY = 0;
    private Rect mScrollingLayerBounds = new Rect();
    private boolean mSentAutoScrollMessage = false;
    private WebViewInputDispatcher mInputDispatcher;
    private boolean mPictureUpdatePausedForFocusChange = false;
    private WebView.PictureListener mPictureListener;
    private WebView.FindListener mFindListener;
    private Message mResumeMsg;
    private final WebView mWebView;
    private final WebView.PrivateAccess mWebViewPrivate;
    private final Context mContext;
    private static TrustStorageListener sTrustStorageListener;
    private static ProxyReceiver sProxyReceiver;
    private static boolean sPackageInstallationReceiverAdded;
    private static Set<String> sGoogleApps;
    private int mCachedOverlappingActionModeHeight = -1;
    static final int NO_LEFTEDGE = -1;
    private Rect mLastVisibleRectSent = new Rect();
    private Rect mLastGlobalRect = new Rect();
    private Rect mVisibleRect = new Rect();
    private Rect mGlobalVisibleRect = new Rect();
    private Point mScrollOffset = new Point();
    private Point mGlobalVisibleOffset = new Point();
    private final Rect mTempContentVisibleRect = new Rect();
    private FindActionModeCallback mFindCallback;
    private boolean mFindIsUp;
    private WebViewCore.FindAllRequest mFindRequest = null;
    private int mOrientation = 0;
    private SelectActionModeCallback mSelectCallback;
    private static final int ZOOM_BITS = 134;
    private static final int SCROLL_BITS = 6;
    private final DrawFilter mZoomFilter = new PaintFlagsDrawFilter(134, 64);
    private final DrawFilter mScrollFilter = new PaintFlagsDrawFilter(6, 0);
    private boolean mDrawHistory = false;
    private Picture mHistoryPicture = null;
    private int mHistoryWidth = 0;
    private int mHistoryHeight = 0;
    private boolean mGotCenterDown = false;
    private final Point mTempVisibleRectOffset = new Point();
    private final Rect mTempVisibleRect = new Rect();
    private static final float HSLOPE_TO_START_SNAP = 0.25f;
    private static final float HSLOPE_TO_BREAK_SNAP = 0.4f;
    private static final float VSLOPE_TO_START_SNAP = 1.25f;
    private static final float VSLOPE_TO_BREAK_SNAP = 0.95f;
    private static final float ANGLE_VERT = 2.0f;
    private static final float ANGLE_HORIZ = 0.0f;
    private static final float MMA_WEIGHT_N = 5.0f;
    private float DRAG_LAYER_INVERSE_DENSITY_SQUARED;
    private static final int DRAG_LAYER_FINGER_DISTANCE = 20000;
    private long mTrackballFirstTime = 0L;
    private long mTrackballLastTime = 0L;
    private float mTrackballRemainsX = 0.0f;
    private float mTrackballRemainsY = 0.0f;
    private int mTrackballXMove = 0;
    private int mTrackballYMove = 0;
    private boolean mSelectingText = false;
    private boolean mShowTextSelectionExtra = false;
    private boolean mSelectionStarted = false;
    private static final int TRACKBALL_KEY_TIMEOUT = 1000;
    private static final int TRACKBALL_TIMEOUT = 200;
    private static final int TRACKBALL_WAIT = 100;
    private static final int TRACKBALL_SCALE = 400;
    private static final int TRACKBALL_SCROLL_COUNT = 5;
    private static final int TRACKBALL_MOVE_COUNT = 10;
    private static final int TRACKBALL_MULTIPLIER = 3;
    private static final int SELECT_CURSOR_OFFSET = 16;
    private static final int SELECT_SCROLL = 5;
    private int mSelectX = 0;
    private int mSelectY = 0;
    private boolean mTrackballDown = false;
    private long mTrackballUpTime = 0L;
    private long mLastCursorTime = 0L;
    private Rect mLastCursorBounds;
    private SelectionHandleAlpha mBaseAlpha = new SelectionHandleAlpha();
    private SelectionHandleAlpha mExtentAlpha = new SelectionHandleAlpha();
    private ObjectAnimator mBaseHandleAlphaAnimator = ObjectAnimator.ofInt(this.mBaseAlpha, "alpha", 0);
    private ObjectAnimator mExtentHandleAlphaAnimator = ObjectAnimator.ofInt(this.mExtentAlpha, "alpha", 0);
    private boolean mMapTrackballToArrowKeys = true;
    private WebViewCore.DrawData mDelaySetPicture;
    private WebViewCore.DrawData mLoadedPicture;
    private FocusTransitionDrawable mFocusTransition = null;
    long mLastSwapTime;
    double mAverageSwapFps;
    private Message mListBoxMessage;

    void incrementTextGeneration() {
        ++this.mTextGeneration;
    }

    public WebViewClassic(WebView webView, WebView.PrivateAccess privateAccess) {
        this.mWebView = webView;
        this.mWebViewPrivate = privateAccess;
        this.mContext = webView.getContext();
    }

    @Override
    public void init(Map<String, Object> javaScriptInterfaces, boolean privateBrowsing) {
        Context context = this.mContext;
        JniUtil.setContext(context);
        this.mCallbackProxy = new CallbackProxy(context, this);
        this.mViewManager = new ViewManager(this);
        L10nUtils.setApplicationContext(context.getApplicationContext());
        this.mWebViewCore = new WebViewCore(context, this, this.mCallbackProxy, javaScriptInterfaces);
        this.mDatabase = WebViewDatabaseClassic.getInstance(context);
        this.mScroller = new OverScroller(context, null, 0.0f, 0.0f, false);
        this.mZoomManager = new ZoomManager(this, this.mCallbackProxy);
        this.init();
        this.setupPackageListener(context);
        WebViewClassic.setupProxyListener(context);
        WebViewClassic.setupTrustStorageListener(context);
        this.updateMultiTouchSupport(context);
        if (privateBrowsing) {
            this.startPrivateBrowsing();
        }
        this.mAutoFillData = new WebViewCore.AutoFillData();
        this.mEditTextScroller = new Scroller(context);
    }

    private void onHandleUiEvent(MotionEvent event, int eventType, int flags) {
        switch (eventType) {
            case 3: {
                WebView.HitTestResult hitTest = this.getHitTestResult();
                if (hitTest == null) break;
                this.mWebView.performLongClick();
                break;
            }
            case 5: {
                this.mZoomManager.handleDoubleTap(event.getX(), event.getY());
                break;
            }
            case 0: {
                this.onHandleUiTouchEvent(event);
                break;
            }
            case 4: {
                if (this.mFocusedNode == null || this.mFocusedNode.mIntentUrl == null) break;
                this.mWebView.playSoundEffect(0);
                this.overrideLoading(this.mFocusedNode.mIntentUrl);
            }
        }
    }

    private void onHandleUiTouchEvent(MotionEvent ev) {
        ScaleGestureDetector detector = this.mZoomManager.getScaleGestureDetector();
        int action = ev.getActionMasked();
        boolean pointerUp = action == 6;
        boolean configChanged = action == 6 || action == 5;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = ev.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float x = sumX / (float)div;
        float y = sumY / (float)div;
        if (configChanged) {
            this.mLastTouchX = Math.round(x);
            this.mLastTouchY = Math.round(y);
            this.mLastTouchTime = ev.getEventTime();
            this.mWebView.cancelLongPress();
            this.mPrivateHandler.removeMessages(4);
        }
        if (detector != null) {
            detector.onTouchEvent(ev);
            if (detector.isInProgress()) {
                this.mLastTouchTime = ev.getEventTime();
                if (!this.mZoomManager.supportsPanDuringZoom()) {
                    return;
                }
                this.mTouchMode = 3;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
            }
        }
        if (action == 5) {
            this.cancelTouch();
            action = 0;
        } else if (action == 2 && (x < 0.0f || y < 0.0f)) {
            return;
        }
        this.handleTouchEventCommon(ev, action, Math.round(x), Math.round(y));
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    @Override
    public WebViewProvider.ViewDelegate getViewDelegate() {
        return this;
    }

    @Override
    public WebViewProvider.ScrollDelegate getScrollDelegate() {
        return this;
    }

    public static WebViewClassic fromWebView(WebView webView) {
        return webView == null ? null : (WebViewClassic)webView.getWebViewProvider();
    }

    int getScrollX() {
        return this.mWebView.getScrollX();
    }

    int getScrollY() {
        return this.mWebView.getScrollY();
    }

    int getWidth() {
        return this.mWebView.getWidth();
    }

    int getHeight() {
        return this.mWebView.getHeight();
    }

    Context getContext() {
        return this.mContext;
    }

    void invalidate() {
        this.mWebView.invalidate();
    }

    void setScrollXRaw(int mScrollX) {
        this.mWebViewPrivate.setScrollXRaw(mScrollX);
    }

    void setScrollYRaw(int mScrollY) {
        this.mWebViewPrivate.setScrollYRaw(mScrollY);
    }

    private static void handleCertTrustChanged() {
        WebViewCore.sendStaticMessage(220, null);
    }

    private static void setupTrustStorageListener(Context context) {
        if (sTrustStorageListener != null) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.security.STORAGE_CHANGED");
        sTrustStorageListener = new TrustStorageListener();
        Intent current = context.getApplicationContext().registerReceiver(sTrustStorageListener, filter);
        if (current != null) {
            WebViewClassic.handleCertTrustChanged();
        }
    }

    private static synchronized void setupProxyListener(Context context) {
        if (sProxyReceiver != null || !sNotificationsEnabled) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PROXY_CHANGE");
        sProxyReceiver = new ProxyReceiver();
        Intent currentProxy = context.getApplicationContext().registerReceiver(sProxyReceiver, filter);
        if (currentProxy != null) {
            WebViewClassic.handleProxyBroadcast(currentProxy);
        }
    }

    private static synchronized void disableProxyListener(Context context) {
        if (sProxyReceiver == null) {
            return;
        }
        context.getApplicationContext().unregisterReceiver(sProxyReceiver);
        sProxyReceiver = null;
    }

    private static void handleProxyBroadcast(Intent intent) {
        ProxyProperties proxyProperties = (ProxyProperties)intent.getExtra("proxy");
        if (proxyProperties == null || proxyProperties.getHost() == null) {
            WebViewCore.sendStaticMessage(193, null);
            return;
        }
        WebViewCore.sendStaticMessage(193, proxyProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPackageListener(Context context) {
        Class<WebViewClassic> clazz = WebViewClassic.class;
        synchronized (WebViewClassic.class) {
            if (sPackageInstallationReceiverAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addDataScheme("package");
            PackageListener packageListener = new PackageListener();
            context.getApplicationContext().registerReceiver(packageListener, filter);
            sPackageInstallationReceiverAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            AsyncTask<Void, Void, Set<String>> task = new AsyncTask<Void, Void, Set<String>>(){

                protected Set<String> doInBackground(Void ... unused) {
                    HashSet<String> installedPackages = new HashSet<String>();
                    PackageManager pm = WebViewClassic.this.mContext.getPackageManager();
                    for (String name : sGoogleApps) {
                        try {
                            pm.getPackageInfo(name, 5);
                            installedPackages.add(name);
                        }
                        catch (PackageManager.NameNotFoundException e) {}
                    }
                    return installedPackages;
                }

                @Override
                protected void onPostExecute(Set<String> installedPackages) {
                    if (WebViewClassic.this.mWebViewCore != null) {
                        WebViewClassic.this.mWebViewCore.sendMessage(184, installedPackages);
                    }
                }
            };
            task.execute(new Void[0]);
            return;
        }
    }

    void updateMultiTouchSupport(Context context) {
        this.mZoomManager.updateMultiTouchSupport(context);
    }

    void updateJavaScriptEnabled(boolean enabled) {
        if (this.isAccessibilityInjectionEnabled()) {
            this.getAccessibilityInjector().updateJavaScriptEnabled(enabled);
        }
    }

    private void init() {
        OnTrimMemoryListener.init(this.mContext);
        this.mWebView.setWillNotDraw(false);
        this.mWebView.setClickable(true);
        this.mWebView.setLongClickable(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        int slop = configuration.getScaledTouchSlop();
        this.mTouchSlopSquare = slop * slop;
        slop = configuration.getScaledDoubleTapSlop();
        this.mDoubleTapSlopSquare = slop * slop;
        float density = WebViewCore.getFixedDisplayDensity(this.mContext);
        this.mNavSlop = (int)(16.0f * density);
        this.mZoomManager.init(density);
        this.mMaximumFling = configuration.getScaledMaximumFlingVelocity();
        this.DRAG_LAYER_INVERSE_DENSITY_SQUARED = 1.0f / (density * density);
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.setScrollBarStyle(this.mWebViewPrivate.super_getScrollBarStyle());
        this.mKeysPressed = new Vector(2);
        this.mHTML5VideoViewProxy = null;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (!this.mWebView.isEnabled()) {
            return this.mWebViewPrivate.super_performAccessibilityAction(action, arguments);
        }
        if (this.getAccessibilityInjector().supportsAccessibilityAction(action)) {
            return this.getAccessibilityInjector().performAccessibilityAction(action, arguments);
        }
        switch (action) {
            case 4096: 
            case 8192: {
                boolean canScrollForward;
                int convertedContentHeight = this.contentToViewY(this.getContentHeight());
                int adjustedViewHeight = this.getHeight() - this.mWebView.getPaddingTop() - this.mWebView.getPaddingBottom();
                int maxScrollY = Math.max(convertedContentHeight - adjustedViewHeight, 0);
                boolean canScrollBackward = this.getScrollY() > 0;
                boolean bl = canScrollForward = this.getScrollY() - maxScrollY > 0;
                if (action == 8192 && canScrollBackward) {
                    this.mWebView.scrollBy(0, adjustedViewHeight);
                    return true;
                }
                if (action == 4096 && canScrollForward) {
                    this.mWebView.scrollBy(0, -adjustedViewHeight);
                    return true;
                }
                return false;
            }
        }
        return this.mWebViewPrivate.super_performAccessibilityAction(action, arguments);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        boolean canScrollForward;
        if (!this.mWebView.isEnabled()) {
            return;
        }
        info.setScrollable(this.isScrollableForAccessibility());
        int convertedContentHeight = this.contentToViewY(this.getContentHeight());
        int adjustedViewHeight = this.getHeight() - this.mWebView.getPaddingTop() - this.mWebView.getPaddingBottom();
        int maxScrollY = Math.max(convertedContentHeight - adjustedViewHeight, 0);
        boolean canScrollBackward = this.getScrollY() > 0;
        boolean bl = canScrollForward = this.getScrollY() - maxScrollY > 0;
        if (canScrollForward) {
            info.addAction(4096);
        }
        if (canScrollForward) {
            info.addAction(8192);
        }
        this.getAccessibilityInjector().onInitializeAccessibilityNodeInfo(info);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setScrollable(this.isScrollableForAccessibility());
        event.setScrollX(this.getScrollX());
        event.setScrollY(this.getScrollY());
        int convertedContentWidth = this.contentToViewX(this.getContentWidth());
        int adjustedViewWidth = this.getWidth() - this.mWebView.getPaddingLeft() - this.mWebView.getPaddingLeft();
        event.setMaxScrollX(Math.max(convertedContentWidth - adjustedViewWidth, 0));
        int convertedContentHeight = this.contentToViewY(this.getContentHeight());
        int adjustedViewHeight = this.getHeight() - this.mWebView.getPaddingTop() - this.mWebView.getPaddingBottom();
        event.setMaxScrollY(Math.max(convertedContentHeight - adjustedViewHeight, 0));
    }

    private boolean isAccessibilityInjectionEnabled() {
        AccessibilityManager manager = AccessibilityManager.getInstance(this.mContext);
        if (!manager.isEnabled()) {
            return false;
        }
        List services = manager.getEnabledAccessibilityServiceList(1);
        return !services.isEmpty();
    }

    private AccessibilityInjector getAccessibilityInjector() {
        if (this.mAccessibilityInjector == null) {
            this.mAccessibilityInjector = new AccessibilityInjector(this);
        }
        return this.mAccessibilityInjector;
    }

    private boolean isScrollableForAccessibility() {
        return this.contentToViewX(this.getContentWidth()) > this.getWidth() - this.mWebView.getPaddingLeft() - this.mWebView.getPaddingRight() || this.contentToViewY(this.getContentHeight()) > this.getHeight() - this.mWebView.getPaddingTop() - this.mWebView.getPaddingBottom();
    }

    @Override
    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mOverScrollGlow == null) {
                this.mOverScrollGlow = new OverScrollGlow(this);
            }
        } else {
            this.mOverScrollGlow = null;
        }
    }

    void adjustDefaultZoomDensity(int zoomDensity) {
        float density = WebViewCore.getFixedDisplayDensity(this.mContext) * 100.0f / (float)zoomDensity;
        this.updateDefaultZoomDensity(density);
    }

    void updateDefaultZoomDensity(float density) {
        this.mNavSlop = (int)(16.0f * density);
        this.mZoomManager.updateDefaultZoomDensity(density);
    }

    int getScaledNavSlop() {
        return this.viewToContentDimension(this.mNavSlop);
    }

    boolean onSavePassword(String schemePlusHost, String username, String password, final Message resumeMsg) {
        boolean rVal = false;
        if (resumeMsg == null) {
            this.mDatabase.setUsernamePassword(schemePlusHost, username, password);
        } else {
            if (this.mResumeMsg != null) {
                Log.w(LOGTAG, "onSavePassword should not be called while dialog is up");
                resumeMsg.sendToTarget();
                return true;
            }
            this.mResumeMsg = resumeMsg;
            final Message remember = this.mPrivateHandler.obtainMessage(1);
            remember.getData().putString("host", schemePlusHost);
            remember.getData().putString("username", username);
            remember.getData().putString("password", password);
            remember.obj = resumeMsg;
            final Message neverRemember = this.mPrivateHandler.obtainMessage(2);
            neverRemember.getData().putString("host", schemePlusHost);
            neverRemember.getData().putString("username", username);
            neverRemember.getData().putString("password", password);
            neverRemember.obj = resumeMsg;
            this.mSavePasswordDialog = new AlertDialog.Builder(this.mContext).setTitle(17040196).setMessage(17040277).setPositiveButton(17040278, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (WebViewClassic.this.mResumeMsg != null) {
                        resumeMsg.sendToTarget();
                        WebViewClassic.this.mResumeMsg = null;
                    }
                    WebViewClassic.this.mSavePasswordDialog = null;
                }
            }).setNeutralButton(17040279, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (WebViewClassic.this.mResumeMsg != null) {
                        remember.sendToTarget();
                        WebViewClassic.this.mResumeMsg = null;
                    }
                    WebViewClassic.this.mSavePasswordDialog = null;
                }
            }).setNegativeButton(17040280, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (WebViewClassic.this.mResumeMsg != null) {
                        neverRemember.sendToTarget();
                        WebViewClassic.this.mResumeMsg = null;
                    }
                    WebViewClassic.this.mSavePasswordDialog = null;
                }
            }).setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (WebViewClassic.this.mResumeMsg != null) {
                        resumeMsg.sendToTarget();
                        WebViewClassic.this.mResumeMsg = null;
                    }
                    WebViewClassic.this.mSavePasswordDialog = null;
                }
            }).show();
            rVal = true;
        }
        return rVal;
    }

    @Override
    public void setScrollBarStyle(int style2) {
        if (style2 == 0x1000000 || style2 == 0x3000000) {
            this.mOverlayVerticalScrollbar = false;
            this.mOverlayHorizontalScrollbar = false;
        } else {
            this.mOverlayVerticalScrollbar = true;
            this.mOverlayHorizontalScrollbar = true;
        }
    }

    @Override
    public void setHorizontalScrollbarOverlay(boolean overlay) {
        this.mOverlayHorizontalScrollbar = overlay;
    }

    @Override
    public void setVerticalScrollbarOverlay(boolean overlay) {
        this.mOverlayVerticalScrollbar = overlay;
    }

    @Override
    public boolean overlayHorizontalScrollbar() {
        return this.mOverlayHorizontalScrollbar;
    }

    @Override
    public boolean overlayVerticalScrollbar() {
        return this.mOverlayVerticalScrollbar;
    }

    int getViewWidth() {
        if (!this.mWebView.isVerticalScrollBarEnabled() || this.mOverlayVerticalScrollbar) {
            return this.getWidth();
        }
        return Math.max(0, this.getWidth() - this.mWebView.getVerticalScrollbarWidth());
    }

    protected int getTitleHeight() {
        if (this.mWebView instanceof TitleBarDelegate) {
            return ((TitleBarDelegate)((Object)this.mWebView)).getTitleHeight();
        }
        return 0;
    }

    @Override
    @Deprecated
    public int getVisibleTitleHeight() {
        return this.getVisibleTitleHeightImpl();
    }

    private int getVisibleTitleHeightImpl() {
        return Math.max(this.getTitleHeight() - Math.max(0, this.getScrollY()), this.getOverlappingActionModeHeight());
    }

    private int getOverlappingActionModeHeight() {
        if (this.mFindCallback == null) {
            return 0;
        }
        if (this.mCachedOverlappingActionModeHeight < 0) {
            this.mWebView.getGlobalVisibleRect(this.mGlobalVisibleRect, this.mGlobalVisibleOffset);
            this.mCachedOverlappingActionModeHeight = Math.max(0, this.mFindCallback.getActionModeGlobalBottom() - this.mGlobalVisibleRect.top);
        }
        return this.mCachedOverlappingActionModeHeight;
    }

    int getViewHeight() {
        return this.getViewHeightWithTitle() - this.getVisibleTitleHeightImpl();
    }

    int getViewHeightWithTitle() {
        int height = this.getHeight();
        if (this.mWebView.isHorizontalScrollBarEnabled() && !this.mOverlayHorizontalScrollbar) {
            height -= this.mWebViewPrivate.getHorizontalScrollbarHeight();
        }
        return height;
    }

    @Override
    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    @Override
    public void setCertificate(SslCertificate certificate) {
        this.mCertificate = certificate;
    }

    @Override
    public void savePassword(String host, String username, String password) {
        this.mDatabase.setUsernamePassword(host, username, password);
    }

    @Override
    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        this.mDatabase.setHttpAuthUsernamePassword(host, realm, username, password);
    }

    @Override
    public String[] getHttpAuthUsernamePassword(String host, String realm) {
        return this.mDatabase.getHttpAuthUsernamePassword(host, realm);
    }

    private void clearActionModes() {
        if (this.mSelectCallback != null) {
            this.mSelectCallback.finish();
        }
        if (this.mFindCallback != null) {
            this.mFindCallback.finish();
        }
    }

    private void clearHelpers() {
        this.hideSoftKeyboard();
        this.clearActionModes();
        this.dismissFullScreenMode();
        this.cancelDialogs();
    }

    private void cancelDialogs() {
        if (this.mListBoxDialog != null) {
            this.mListBoxDialog.cancel();
            this.mListBoxDialog = null;
        }
        if (this.mSavePasswordDialog != null) {
            this.mSavePasswordDialog.dismiss();
            this.mSavePasswordDialog = null;
        }
    }

    @Override
    public void destroy() {
        if (this.mWebView.getViewRootImpl() != null) {
            Log.e(LOGTAG, "Error: WebView.destroy() called while still attached!");
        }
        this.ensureFunctorDetached();
        this.destroyJava();
        this.destroyNative();
    }

    private void ensureFunctorDetached() {
        if (this.mWebView.isHardwareAccelerated()) {
            int drawGLFunction = this.nativeGetDrawGLFunction(this.mNativeClass);
            ViewRootImpl viewRoot = this.mWebView.getViewRootImpl();
            if (drawGLFunction != 0 && viewRoot != null) {
                viewRoot.detachFunctor(drawGLFunction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyJava() {
        this.mCallbackProxy.blockMessages();
        if (this.mAccessibilityInjector != null) {
            this.mAccessibilityInjector.destroy();
            this.mAccessibilityInjector = null;
        }
        if (this.mWebViewCore != null) {
            WebViewClassic webViewClassic = this;
            synchronized (webViewClassic) {
                WebViewCore webViewCore = this.mWebViewCore;
                this.mWebViewCore = null;
                webViewCore.destroy();
            }
            this.mPrivateHandler.removeCallbacksAndMessages(null);
        }
    }

    private void destroyNative() {
        if (this.mNativeClass == 0) {
            return;
        }
        int nptr = this.mNativeClass;
        this.mNativeClass = 0;
        if (Thread.currentThread() == this.mPrivateHandler.getLooper().getThread()) {
            WebViewClassic.nativeDestroy(nptr);
        } else {
            this.mPrivateHandler.post(new DestroyNativeRunnable(nptr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void enablePlatformNotifications() {
        Class<WebViewClassic> clazz = WebViewClassic.class;
        synchronized (WebViewClassic.class) {
            sNotificationsEnabled = true;
            Context context = JniUtil.getContext();
            if (context != null) {
                WebViewClassic.setupProxyListener(context);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void disablePlatformNotifications() {
        Class<WebViewClassic> clazz = WebViewClassic.class;
        synchronized (WebViewClassic.class) {
            sNotificationsEnabled = false;
            Context context = JniUtil.getContext();
            if (context != null) {
                WebViewClassic.disableProxyListener(context);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setJsFlags(String flags) {
        this.mWebViewCore.sendMessage(174, flags);
    }

    @Override
    public void setNetworkAvailable(boolean networkUp) {
        this.mWebViewCore.sendMessage(119, networkUp ? 1 : 0, 0);
    }

    public void setNetworkType(String type, String subtype) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("subtype", subtype);
        this.mWebViewCore.sendMessage(183, map);
    }

    @Override
    public WebBackForwardList saveState(Bundle outState) {
        if (outState == null) {
            return null;
        }
        WebBackForwardListClassic list = this.copyBackForwardList();
        int currentIndex = list.getCurrentIndex();
        int size = list.getSize();
        if (currentIndex < 0 || currentIndex >= size || size == 0) {
            return null;
        }
        outState.putInt("index", currentIndex);
        ArrayList<byte[]> history = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            WebHistoryItemClassic item = list.getItemAtIndex(i);
            if (null == item) {
                Log.w(LOGTAG, "saveState: Unexpected null history item.");
                return null;
            }
            byte[] data = item.getFlattenedData();
            if (data == null) {
                return null;
            }
            history.add(data);
        }
        outState.putSerializable("history", history);
        if (this.mCertificate != null) {
            outState.putBundle("certificate", SslCertificate.saveState(this.mCertificate));
        }
        outState.putBoolean("privateBrowsingEnabled", this.isPrivateBrowsingEnabled());
        this.mZoomManager.saveZoomState(outState);
        return list;
    }

    @Override
    @Deprecated
    public boolean savePicture(Bundle b, final File dest) {
        if (dest == null || b == null) {
            return false;
        }
        final Picture p = this.capturePicture();
        final File temp = new File(dest.getPath() + ".writing");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block11: {
                    FileOutputStream out;
                    block10: {
                        out = null;
                        out = new FileOutputStream(temp);
                        p.writeToStream(out);
                        temp.renameTo(dest);
                        Object var4_2 = null;
                        if (out == null) break block10;
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    temp.delete();
                    {
                        break block11;
                        catch (Exception exception) {
                            Object var4_3 = null;
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            temp.delete();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        temp.delete();
                        throw throwable;
                    }
                }
            }
        }).start();
        b.putInt("scrollX", this.getScrollX());
        b.putInt("scrollY", this.getScrollY());
        this.mZoomManager.saveZoomState(b);
        return true;
    }

    private void restoreHistoryPictureFields(Picture p, Bundle b) {
        int sx = b.getInt("scrollX", 0);
        int sy = b.getInt("scrollY", 0);
        this.mDrawHistory = true;
        this.mHistoryPicture = p;
        this.setScrollXRaw(sx);
        this.setScrollYRaw(sy);
        this.mZoomManager.restoreZoomState(b);
        float scale = this.mZoomManager.getScale();
        this.mHistoryWidth = Math.round((float)p.getWidth() * scale);
        this.mHistoryHeight = Math.round((float)p.getHeight() * scale);
        this.invalidate();
    }

    @Override
    @Deprecated
    public boolean restorePicture(Bundle b, File src) {
        if (src == null || b == null) {
            return false;
        }
        if (!src.exists()) {
            return false;
        }
        try {
            final FileInputStream in = new FileInputStream(src);
            final Bundle copy = new Bundle(b);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        final Picture p = Picture.createFromStream(in);
                        if (p != null) {
                            WebViewClassic.this.mPrivateHandler.post(new Runnable(){

                                public void run() {
                                    WebViewClassic.this.restoreHistoryPictureFields(p, copy);
                                }
                            });
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }).start();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void saveViewState(OutputStream stream, ValueCallback<Boolean> callback) {
        if (this.mWebViewCore == null) {
            callback.onReceiveValue(false);
            return;
        }
        this.mWebViewCore.sendMessageAtFrontOfQueue(225, new WebViewCore.SaveViewStateRequest(stream, callback));
    }

    public void loadViewState(InputStream stream) {
        this.mBlockWebkitViewMessages = true;
        new AsyncTask<InputStream, Void, WebViewCore.DrawData>(){

            protected WebViewCore.DrawData doInBackground(InputStream ... params) {
                try {
                    return ViewStateSerializer.deserializeViewState(params[0]);
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            protected void onPostExecute(WebViewCore.DrawData draw) {
                if (draw == null) {
                    Log.e(WebViewClassic.LOGTAG, "Failed to load view state!");
                    return;
                }
                int viewWidth = WebViewClassic.this.getViewWidth();
                int viewHeight = WebViewClassic.this.getViewHeightWithTitle() - WebViewClassic.this.getTitleHeight();
                draw.mViewSize = new Point(viewWidth, viewHeight);
                draw.mViewState.mDefaultScale = WebViewClassic.this.getDefaultZoomScale();
                WebViewClassic.this.mLoadedPicture = draw;
                WebViewClassic.this.setNewPicture(WebViewClassic.this.mLoadedPicture, true);
                ((WebViewClassic)WebViewClassic.this).mLoadedPicture.mViewState = null;
            }
        }.execute(stream);
    }

    public void clearViewState() {
        this.mBlockWebkitViewMessages = false;
        this.mLoadedPicture = null;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebBackForwardList restoreState(Bundle inState) {
        WebBackForwardListClassic returnList = null;
        if (inState == null) {
            return returnList;
        }
        if (inState.containsKey("index") && inState.containsKey("history")) {
            this.mCertificate = SslCertificate.restoreState(inState.getBundle("certificate"));
            WebBackForwardListClassic list = this.mCallbackProxy.getBackForwardList();
            int index = inState.getInt("index");
            WebBackForwardListClassic webBackForwardListClassic = list;
            synchronized (webBackForwardListClassic) {
                List history = (List)((Object)inState.getSerializable("history"));
                int size = history.size();
                if (index < 0 || index >= size) {
                    return null;
                }
                for (int i = 0; i < size; ++i) {
                    byte[] data = (byte[])history.remove(0);
                    if (data == null) {
                        return null;
                    }
                    WebHistoryItemClassic item = new WebHistoryItemClassic(data);
                    list.addHistoryItem(item);
                }
                returnList = this.copyBackForwardList();
                returnList.setCurrentIndex(index);
            }
            if (inState.getBoolean("privateBrowsingEnabled")) {
                this.getSettings().setPrivateBrowsingEnabled(true);
            }
            this.mZoomManager.restoreZoomState(inState);
            this.mWebViewCore.removeMessages();
            if (this.isAccessibilityInjectionEnabled()) {
                this.getAccessibilityInjector().addAccessibilityApisIfNecessary();
            }
            this.mWebViewCore.sendMessage(108, index);
        }
        return returnList;
    }

    @Override
    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.loadUrlImpl(url, additionalHttpHeaders);
    }

    private void loadUrlImpl(String url, Map<String, String> extraHeaders) {
        this.switchOutDrawHistory();
        WebViewCore.GetUrlData arg = new WebViewCore.GetUrlData();
        arg.mUrl = url;
        arg.mExtraHeaders = extraHeaders;
        this.mWebViewCore.sendMessage(100, arg);
        this.clearHelpers();
    }

    @Override
    public void loadUrl(String url) {
        this.loadUrlImpl(url);
    }

    private void loadUrlImpl(String url) {
        if (url == null) {
            return;
        }
        this.loadUrlImpl(url, null);
    }

    @Override
    public void postUrl(String url, byte[] postData) {
        if (URLUtil.isNetworkUrl(url)) {
            this.switchOutDrawHistory();
            WebViewCore.PostUrlData arg = new WebViewCore.PostUrlData();
            arg.mUrl = url;
            arg.mPostData = postData;
            this.mWebViewCore.sendMessage(132, arg);
            this.clearHelpers();
        } else {
            this.loadUrlImpl(url);
        }
    }

    @Override
    public void loadData(String data, String mimeType, String encoding) {
        this.loadDataImpl(data, mimeType, encoding);
    }

    private void loadDataImpl(String data, String mimeType, String encoding) {
        StringBuilder dataUrl = new StringBuilder("data:");
        dataUrl.append(mimeType);
        if ("base64".equals(encoding)) {
            dataUrl.append(";base64");
        }
        dataUrl.append(",");
        dataUrl.append(data);
        this.loadUrlImpl(dataUrl.toString());
    }

    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        if (baseUrl != null && baseUrl.toLowerCase().startsWith("data:")) {
            this.loadDataImpl(data, mimeType, encoding);
            return;
        }
        this.switchOutDrawHistory();
        WebViewCore.BaseUrlData arg = new WebViewCore.BaseUrlData();
        arg.mBaseUrl = baseUrl;
        arg.mData = data;
        arg.mMimeType = mimeType;
        arg.mEncoding = encoding;
        arg.mHistoryUrl = historyUrl;
        this.mWebViewCore.sendMessage(139, arg);
        this.clearHelpers();
    }

    @Override
    public void saveWebArchive(String filename) {
        this.saveWebArchiveImpl(filename, false, null);
    }

    @Override
    public void saveWebArchive(String basename, boolean autoname, ValueCallback<String> callback) {
        this.saveWebArchiveImpl(basename, autoname, callback);
    }

    private void saveWebArchiveImpl(String basename, boolean autoname, ValueCallback<String> callback) {
        this.mWebViewCore.sendMessage(147, new SaveWebArchiveMessage(basename, autoname, callback));
    }

    @Override
    public void stopLoading() {
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(101);
    }

    @Override
    public void reload() {
        this.clearHelpers();
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canGoBack() {
        WebBackForwardListClassic l;
        WebBackForwardListClassic webBackForwardListClassic = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardListClassic) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() > 0;
        }
    }

    @Override
    public void goBack() {
        this.goBackOrForwardImpl(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canGoForward() {
        WebBackForwardListClassic l;
        WebBackForwardListClassic webBackForwardListClassic = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardListClassic) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() < l.getSize() - 1;
        }
    }

    @Override
    public void goForward() {
        this.goBackOrForwardImpl(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canGoBackOrForward(int steps) {
        WebBackForwardListClassic l;
        WebBackForwardListClassic webBackForwardListClassic = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardListClassic) {
            if (l.getClearPending()) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            int newIndex = l.getCurrentIndex() + steps;
            return newIndex >= 0 && newIndex < l.getSize();
        }
    }

    @Override
    public void goBackOrForward(int steps) {
        this.goBackOrForwardImpl(steps);
    }

    private void goBackOrForwardImpl(int steps) {
        this.goBackOrForward(steps, false);
    }

    private void goBackOrForward(int steps, boolean ignoreSnapshot) {
        if (steps != 0) {
            this.clearHelpers();
            this.mWebViewCore.sendMessage(106, steps, ignoreSnapshot ? 1 : 0);
        }
    }

    @Override
    public boolean isPrivateBrowsingEnabled() {
        WebSettingsClassic settings = this.getSettings();
        return settings != null ? settings.isPrivateBrowsingEnabled() : false;
    }

    private void startPrivateBrowsing() {
        this.getSettings().setPrivateBrowsingEnabled(true);
    }

    private boolean extendScroll(int y) {
        int finalY = this.mScroller.getFinalY();
        int newY = this.pinLocY(finalY + y);
        if (newY == finalY) {
            return false;
        }
        this.mScroller.setFinalY(newY);
        this.mScroller.extendDuration(WebViewClassic.computeDuration(0, y));
        return true;
    }

    @Override
    public boolean pageUp(boolean top) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (top) {
            return this.pinScrollTo(this.getScrollX(), 0, true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? -h + 24 : -h / 2;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    @Override
    public boolean pageDown(boolean bottom) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (bottom) {
            return this.pinScrollTo(this.getScrollX(), this.computeRealVerticalScrollRange(), true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? h - 24 : h / 2;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    @Override
    public void clearView() {
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        this.setBaseLayer(0, false, false);
        this.mWebViewCore.sendMessage(134);
    }

    @Override
    public Picture capturePicture() {
        if (this.mNativeClass == 0) {
            return null;
        }
        Picture result = new Picture();
        this.nativeCopyBaseContentToPicture(result);
        return result;
    }

    @Override
    public float getScale() {
        return this.mZoomManager.getScale();
    }

    float computeReadingLevelScale(float scale) {
        return this.mZoomManager.computeReadingLevelScale(scale);
    }

    @Override
    public void setInitialScale(int scaleInPercent) {
        this.mZoomManager.setInitialScaleInPercent(scaleInPercent);
    }

    @Override
    public void invokeZoomPicker() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return;
        }
        this.clearHelpers();
        this.mZoomManager.invokeZoomPicker();
    }

    @Override
    public WebView.HitTestResult getHitTestResult() {
        return this.mInitialHitTestResult;
    }

    int getBlockLeftEdge(int x, int y, float readingScale) {
        float invReadingScale = 1.0f / readingScale;
        int readingWidth = (int)((float)this.getViewWidth() * invReadingScale);
        int left = -1;
        if (this.mFocusedNode != null) {
            for (Rect rect : this.mFocusedNode.mEnclosingParentRects) {
                if (rect.width() < this.mFocusedNode.mHitTestSlop) continue;
                if (rect.width() > readingWidth) break;
                left = rect.left;
            }
        }
        return left;
    }

    @Override
    public void requestFocusNodeHref(Message hrefMsg) {
        if (hrefMsg == null) {
            return;
        }
        int contentX = this.viewToContentX(this.mLastTouchX + this.getScrollX());
        int contentY = this.viewToContentY(this.mLastTouchY + this.getScrollY());
        if (this.mFocusedNode != null && this.mFocusedNode.mHitTestX == contentX && this.mFocusedNode.mHitTestY == contentY) {
            hrefMsg.getData().putString("url", this.mFocusedNode.mLinkUrl);
            hrefMsg.getData().putString("title", this.mFocusedNode.mAnchorText);
            hrefMsg.getData().putString("src", this.mFocusedNode.mImageUrl);
            hrefMsg.sendToTarget();
            return;
        }
        this.mWebViewCore.sendMessage(137, contentX, contentY, hrefMsg);
    }

    @Override
    public void requestImageRef(Message msg) {
        if (0 == this.mNativeClass) {
            return;
        }
        String url = this.mFocusedNode != null ? this.mFocusedNode.mImageUrl : null;
        Bundle data = msg.getData();
        data.putString("url", url);
        msg.setData(data);
        msg.sendToTarget();
    }

    static int pinLoc(int x, int viewMax, int docMax) {
        if (docMax < viewMax) {
            x = 0;
        } else if (x < 0) {
            x = 0;
        } else if (x + viewMax > docMax) {
            x = docMax - viewMax;
        }
        return x;
    }

    int pinLocX(int x) {
        if (this.mInOverScrollMode) {
            return x;
        }
        return WebViewClassic.pinLoc(x, this.getViewWidth(), this.computeRealHorizontalScrollRange());
    }

    int pinLocY(int y) {
        if (this.mInOverScrollMode) {
            return y;
        }
        return WebViewClassic.pinLoc(y, this.getViewHeightWithTitle(), this.computeRealVerticalScrollRange() + this.getTitleHeight());
    }

    private int viewToContentDimension(int d) {
        return Math.round((float)d * this.mZoomManager.getInvScale());
    }

    int viewToContentX(int x) {
        return this.viewToContentDimension(x);
    }

    int viewToContentY(int y) {
        return this.viewToContentDimension(y - this.getTitleHeight());
    }

    private float viewToContentXf(int x) {
        return (float)x * this.mZoomManager.getInvScale();
    }

    private float viewToContentYf(int y) {
        return (float)(y - this.getTitleHeight()) * this.mZoomManager.getInvScale();
    }

    int contentToViewDimension(int d) {
        return Math.round((float)d * this.mZoomManager.getScale());
    }

    int contentToViewX(int x) {
        return this.contentToViewDimension(x);
    }

    int contentToViewY(int y) {
        return this.contentToViewDimension(y) + this.getTitleHeight();
    }

    private Rect contentToViewRect(Rect x) {
        return new Rect(this.contentToViewX(x.left), this.contentToViewY(x.top), this.contentToViewX(x.right), this.contentToViewY(x.bottom));
    }

    private void viewInvalidate(int l, int t, int r, int b) {
        float scale = this.mZoomManager.getScale();
        int dy = this.getTitleHeight();
        this.mWebView.invalidate((int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    private void viewInvalidateDelayed(long delay, int l, int t, int r, int b) {
        float scale = this.mZoomManager.getScale();
        int dy = this.getTitleHeight();
        this.mWebView.postInvalidateDelayed(delay, (int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    private void invalidateContentRect(Rect r) {
        this.viewInvalidate(r.left, r.top, r.right, r.bottom);
    }

    private void abortAnimation() {
        this.mScroller.abortAnimation();
        this.mLastVelocity = 0.0f;
    }

    private void recordNewContentSize(int w, int h, boolean updateLayout) {
        if ((w | h) == 0) {
            this.invalidate();
            return;
        }
        if (this.mContentWidth != w || this.mContentHeight != h) {
            this.mContentWidth = w;
            this.mContentHeight = h;
            if (!this.mDrawHistory) {
                this.updateScrollCoordinates(this.pinLocX(this.getScrollX()), this.pinLocY(this.getScrollY()));
                if (!this.mScroller.isFinished()) {
                    this.mScroller.setFinalX(this.pinLocX(this.mScroller.getFinalX()));
                    this.mScroller.setFinalY(this.pinLocY(this.mScroller.getFinalY()));
                }
            }
            this.invalidate();
        }
        this.contentSizeChanged(updateLayout);
    }

    Rect sendOurVisibleRect() {
        if (this.mZoomManager.isPreventingWebkitUpdates()) {
            return this.mLastVisibleRectSent;
        }
        this.calcOurContentVisibleRect(this.mVisibleRect);
        if (!this.mVisibleRect.equals(this.mLastVisibleRectSent)) {
            if (!this.mBlockWebkitViewMessages) {
                this.mScrollOffset.set(this.mVisibleRect.left, this.mVisibleRect.top);
                this.mWebViewCore.removeMessages(107);
                this.mWebViewCore.sendMessage(107, this.mSendScrollEvent ? 1 : 0, this.mScrollOffset);
            }
            this.mLastVisibleRectSent.set(this.mVisibleRect);
            this.mPrivateHandler.removeMessages(4);
        }
        if (this.mWebView.getGlobalVisibleRect(this.mGlobalVisibleRect) && !this.mGlobalVisibleRect.equals(this.mLastGlobalRect)) {
            if (!this.mBlockWebkitViewMessages) {
                this.mWebViewCore.sendMessage(116, this.mGlobalVisibleRect);
            }
            this.mLastGlobalRect.set(this.mGlobalVisibleRect);
        }
        return this.mVisibleRect;
    }

    private void calcOurVisibleRect(Rect r) {
        this.mWebView.getGlobalVisibleRect(r, this.mGlobalVisibleOffset);
        r.offset(-this.mGlobalVisibleOffset.x, -this.mGlobalVisibleOffset.y);
    }

    private void calcOurContentVisibleRect(Rect r) {
        this.calcOurVisibleRect(r);
        r.left = this.viewToContentX(r.left);
        r.top = this.viewToContentY(r.top + this.getVisibleTitleHeightImpl());
        r.right = this.viewToContentX(r.right);
        r.bottom = this.viewToContentY(r.bottom);
    }

    private void calcOurContentVisibleRectF(RectF r) {
        this.calcOurVisibleRect(this.mTempContentVisibleRect);
        this.viewToContentVisibleRect(r, this.mTempContentVisibleRect);
    }

    boolean sendViewSizeZoom(boolean force) {
        if (this.mBlockWebkitViewMessages) {
            return false;
        }
        if (this.mZoomManager.isPreventingWebkitUpdates()) {
            return false;
        }
        int viewWidth = this.getViewWidth();
        int newWidth = Math.round((float)viewWidth * this.mZoomManager.getInvScale());
        int viewHeight = this.getViewHeightWithTitle() - this.getTitleHeight();
        int newHeight = Math.round((float)viewHeight * this.mZoomManager.getInvScale());
        float heightWidthRatio = (float)viewHeight / (float)viewWidth;
        if (newWidth > this.mLastWidthSent && this.mWrapContent) {
            newHeight = 0;
            heightWidthRatio = 0.0f;
        }
        int actualViewHeight = Math.round((float)this.getViewHeight() * this.mZoomManager.getInvScale());
        if (newWidth != this.mLastWidthSent || newHeight != this.mLastHeightSent || force || actualViewHeight != this.mLastActualHeightSent) {
            ViewSizeData data = new ViewSizeData();
            data.mWidth = newWidth;
            data.mHeight = newHeight;
            data.mHeightWidthRatio = heightWidthRatio;
            data.mActualViewHeight = actualViewHeight;
            data.mTextWrapWidth = Math.round((float)viewWidth / this.mZoomManager.getTextWrapScale());
            data.mScale = this.mZoomManager.getScale();
            data.mIgnoreHeight = this.mZoomManager.isFixedLengthAnimationInProgress() && !this.mHeightCanMeasure;
            data.mAnchorX = this.mZoomManager.getDocumentAnchorX();
            data.mAnchorY = this.mZoomManager.getDocumentAnchorY();
            this.mWebViewCore.sendMessage(105, data);
            this.mLastWidthSent = newWidth;
            this.mLastHeightSent = newHeight;
            this.mLastActualHeightSent = actualViewHeight;
            this.mZoomManager.clearDocumentAnchor();
            return true;
        }
        return false;
    }

    void updateDoubleTapZoom(int doubleTapZoom) {
        this.mZoomManager.updateDoubleTapZoom(doubleTapZoom);
    }

    private int computeRealHorizontalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryWidth;
        }
        return (int)Math.floor((float)this.mContentWidth * this.mZoomManager.getScale());
    }

    @Override
    public int computeHorizontalScrollRange() {
        int range = this.computeRealHorizontalScrollRange();
        int scrollX = this.getScrollX();
        int overscrollRight = this.computeMaxScrollX();
        if (scrollX < 0) {
            range -= scrollX;
        } else if (scrollX > overscrollRight) {
            range += scrollX - overscrollRight;
        }
        return range;
    }

    @Override
    public int computeHorizontalScrollOffset() {
        return Math.max(this.getScrollX(), 0);
    }

    private int computeRealVerticalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryHeight;
        }
        return (int)Math.floor((float)this.mContentHeight * this.mZoomManager.getScale());
    }

    @Override
    public int computeVerticalScrollRange() {
        int range = this.computeRealVerticalScrollRange();
        int scrollY = this.getScrollY();
        int overscrollBottom = this.computeMaxScrollY();
        if (scrollY < 0) {
            range -= scrollY;
        } else if (scrollY > overscrollBottom) {
            range += scrollY - overscrollBottom;
        }
        return range;
    }

    @Override
    public int computeVerticalScrollOffset() {
        return Math.max(this.getScrollY() - this.getTitleHeight(), 0);
    }

    @Override
    public int computeVerticalScrollExtent() {
        return this.getViewHeight();
    }

    @Override
    public void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        if (this.getScrollY() < 0) {
            t -= this.getScrollY();
        }
        scrollBar.setBounds(l, t + this.getVisibleTitleHeightImpl(), r, b);
        scrollBar.draw(canvas);
    }

    @Override
    public void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (this.mTouchMode == 10) {
            this.scrollEditText(scrollX, scrollY);
            return;
        }
        if (this.mTouchMode == 9) {
            this.scrollLayerTo(scrollX, scrollY);
            this.animateHandles();
            return;
        }
        this.mInOverScrollMode = false;
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        if (maxX == 0) {
            scrollX = this.pinLocX(scrollX);
        } else if (scrollX < 0 || scrollX > maxX) {
            this.mInOverScrollMode = true;
        }
        if (scrollY < 0 || scrollY > maxY) {
            this.mInOverScrollMode = true;
        }
        int oldX = this.getScrollX();
        int oldY = this.getScrollY();
        this.mWebViewPrivate.super_scrollTo(scrollX, scrollY);
        this.animateHandles();
        if (this.mOverScrollGlow != null) {
            this.mOverScrollGlow.pullGlow(this.getScrollX(), this.getScrollY(), oldX, oldY, maxX, maxY);
        }
    }

    @Override
    public String getUrl() {
        WebHistoryItemClassic h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? ((WebHistoryItem)h).getUrl() : null;
    }

    @Override
    public String getOriginalUrl() {
        WebHistoryItemClassic h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? ((WebHistoryItem)h).getOriginalUrl() : null;
    }

    @Override
    public String getTitle() {
        WebHistoryItemClassic h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? ((WebHistoryItem)h).getTitle() : null;
    }

    @Override
    public Bitmap getFavicon() {
        WebHistoryItemClassic h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? ((WebHistoryItem)h).getFavicon() : null;
    }

    @Override
    public String getTouchIconUrl() {
        WebHistoryItemClassic h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTouchIconUrl() : null;
    }

    @Override
    public int getProgress() {
        return this.mCallbackProxy.getProgress();
    }

    @Override
    public int getContentHeight() {
        return this.mContentHeight;
    }

    @Override
    public int getContentWidth() {
        return this.mContentWidth;
    }

    public int getPageBackgroundColor() {
        if (this.mNativeClass == 0) {
            return -1;
        }
        return this.nativeGetBackgroundColor(this.mNativeClass);
    }

    @Override
    public void pauseTimers() {
        this.mWebViewCore.sendMessage(109);
    }

    @Override
    public void resumeTimers() {
        this.mWebViewCore.sendMessage(110);
    }

    @Override
    public void onPause() {
        if (!this.mIsPaused) {
            this.mIsPaused = true;
            this.mWebViewCore.sendMessage(143);
            if (this.mHTML5VideoViewProxy != null) {
                this.mHTML5VideoViewProxy.pauseAndDispatch();
            }
            if (this.mNativeClass != 0) {
                WebViewClassic.nativeSetPauseDrawing(this.mNativeClass, true);
            }
            this.cancelDialogs();
            WebCoreThreadWatchdog.pause();
        }
    }

    @Override
    public void onWindowVisibilityChanged(int visibility) {
        this.updateDrawingState();
    }

    void updateDrawingState() {
        if (this.mNativeClass == 0 || this.mIsPaused) {
            return;
        }
        if (this.mWebView.getWindowVisibility() != 0) {
            WebViewClassic.nativeSetPauseDrawing(this.mNativeClass, true);
        } else if (this.mWebView.getVisibility() != 0) {
            WebViewClassic.nativeSetPauseDrawing(this.mNativeClass, true);
        } else {
            WebViewClassic.nativeSetPauseDrawing(this.mNativeClass, false);
        }
    }

    @Override
    public void onResume() {
        if (this.mIsPaused) {
            this.mIsPaused = false;
            this.mWebViewCore.sendMessage(144);
            if (this.mNativeClass != 0) {
                WebViewClassic.nativeSetPauseDrawing(this.mNativeClass, false);
            }
        }
        WebCoreThreadWatchdog.resume();
    }

    @Override
    public boolean isPaused() {
        return this.mIsPaused;
    }

    @Override
    public void freeMemory() {
        this.mWebViewCore.sendMessage(145);
    }

    @Override
    public void clearCache(boolean includeDiskFiles) {
        this.mWebViewCore.sendMessage(111, includeDiskFiles ? 1 : 0, 0);
    }

    @Override
    public void clearFormData() {
        if (this.mAutoCompletePopup != null) {
            this.mAutoCompletePopup.clearAdapter();
        }
    }

    @Override
    public void clearHistory() {
        this.mCallbackProxy.getBackForwardList().setClearPending();
        this.mWebViewCore.sendMessage(112);
    }

    @Override
    public void clearSslPreferences() {
        this.mWebViewCore.sendMessage(150);
    }

    @Override
    public WebBackForwardListClassic copyBackForwardList() {
        return this.mCallbackProxy.getBackForwardList().clone();
    }

    @Override
    public void setFindListener(WebView.FindListener listener) {
        this.mFindListener = listener;
    }

    @Override
    public void findNext(boolean forward) {
        if (0 == this.mNativeClass) {
            return;
        }
        if (this.mFindRequest != null) {
            this.mWebViewCore.sendMessage(222, forward ? 1 : 0, this.mFindRequest);
        }
    }

    @Override
    public int findAll(String find) {
        return this.findAllBody(find, false);
    }

    @Override
    public void findAllAsync(String find) {
        this.findAllBody(find, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findAllBody(String find, boolean isAsync) {
        if (0 == this.mNativeClass) {
            return 0;
        }
        this.mFindRequest = null;
        if (find == null) {
            return 0;
        }
        this.mWebViewCore.removeMessages(221);
        this.mFindRequest = new WebViewCore.FindAllRequest(find);
        if (isAsync) {
            this.mWebViewCore.sendMessage(221, this.mFindRequest);
            return 0;
        }
        WebViewCore.FindAllRequest findAllRequest = this.mFindRequest;
        synchronized (findAllRequest) {
            try {
                this.mWebViewCore.sendMessageAtFrontOfQueue(221, this.mFindRequest);
                while (this.mFindRequest.mMatchCount == -1) {
                    this.mFindRequest.wait();
                }
            }
            catch (InterruptedException e) {
                return 0;
            }
            return this.mFindRequest.mMatchCount;
        }
    }

    @Override
    public boolean showFindDialog(String text, boolean showIme) {
        FindActionModeCallback callback = new FindActionModeCallback(this.mContext);
        if (this.mWebView.getParent() == null || this.mWebView.startActionMode(callback) == null) {
            return false;
        }
        this.mCachedOverlappingActionModeHeight = -1;
        this.mFindCallback = callback;
        this.setFindIsUp(true);
        this.mFindCallback.setWebView(this);
        if (showIme) {
            this.mFindCallback.showSoftInput();
        } else if (text != null) {
            this.mFindCallback.setText(text);
            this.mFindCallback.findAll();
            return true;
        }
        if (text == null) {
            String string2 = text = this.mFindRequest == null ? null : this.mFindRequest.mSearchText;
        }
        if (text != null) {
            this.mFindCallback.setText(text);
            this.mFindCallback.findAll();
        }
        return true;
    }

    private void setFindIsUp(boolean isUp) {
        this.mFindIsUp = isUp;
    }

    public static String findAddress(String addr) {
        return WebViewClassic.findAddress(addr, false);
    }

    public static String findAddress(String addr, boolean caseInsensitive) {
        return WebViewCore.nativeFindAddress(addr, caseInsensitive);
    }

    @Override
    public void clearMatches() {
        if (this.mNativeClass == 0) {
            return;
        }
        this.mWebViewCore.removeMessages(221);
        this.mWebViewCore.sendMessage(221, null);
    }

    void notifyFindDialogDismissed() {
        this.mFindCallback = null;
        this.mCachedOverlappingActionModeHeight = -1;
        if (this.mWebViewCore == null) {
            return;
        }
        this.clearMatches();
        this.setFindIsUp(false);
        this.pinScrollTo(this.getScrollX(), this.getScrollY(), false, 0);
        this.invalidate();
    }

    @Override
    public void documentHasImages(Message response) {
        if (response == null) {
            return;
        }
        this.mWebViewCore.sendMessage(120, response);
    }

    public void stopScroll() {
        this.mScroller.forceFinished(true);
        this.mLastVelocity = 0.0f;
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            this.invalidate();
            if (!this.mScroller.isFinished()) {
                int rangeX = this.computeMaxScrollX();
                int rangeY = this.computeMaxScrollY();
                int overflingDistance = this.mOverflingDistance;
                if (this.mTouchMode == 9) {
                    oldX = this.mScrollingLayerRect.left;
                    oldY = this.mScrollingLayerRect.top;
                    rangeX = this.mScrollingLayerRect.right;
                    rangeY = this.mScrollingLayerRect.bottom;
                    overflingDistance = 0;
                } else if (this.mTouchMode == 10) {
                    oldX = this.getTextScrollX();
                    oldY = this.getTextScrollY();
                    rangeX = this.getMaxTextScrollX();
                    rangeY = this.getMaxTextScrollY();
                    overflingDistance = 0;
                }
                this.mWebViewPrivate.overScrollBy(x - oldX, y - oldY, oldX, oldY, rangeX, rangeY, overflingDistance, overflingDistance, false);
                if (this.mOverScrollGlow != null) {
                    this.mOverScrollGlow.absorbGlow(x, y, oldX, oldY, rangeX, rangeY);
                }
            } else {
                if (this.mTouchMode == 9) {
                    this.scrollLayerTo(x, y);
                } else if (this.mTouchMode == 10) {
                    this.scrollEditText(x, y);
                } else {
                    this.setScrollXRaw(x);
                    this.setScrollYRaw(y);
                }
                this.abortAnimation();
                this.nativeSetIsScrolling(false);
                if (!this.mBlockWebkitViewMessages) {
                    WebViewCore.resumePriority();
                    if (!this.mSelectingText) {
                        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    }
                }
                if (oldX != this.getScrollX() || oldY != this.getScrollY()) {
                    this.sendOurVisibleRect();
                }
            }
        } else {
            this.mWebViewPrivate.super_computeScroll();
        }
    }

    private void scrollLayerTo(int x, int y) {
        int dx = this.mScrollingLayerRect.left - x;
        int dy = this.mScrollingLayerRect.top - y;
        if (dx == 0 && dy == 0 || this.mNativeClass == 0) {
            return;
        }
        if (this.mSelectingText) {
            if (this.mSelectCursorBaseLayerId == this.mCurrentScrollingLayerId) {
                this.mSelectCursorBase.offset(dx, dy);
                this.mSelectCursorBaseTextQuad.offset(dx, dy);
            }
            if (this.mSelectCursorExtentLayerId == this.mCurrentScrollingLayerId) {
                this.mSelectCursorExtent.offset(dx, dy);
                this.mSelectCursorExtentTextQuad.offset(dx, dy);
            }
        }
        if (this.mAutoCompletePopup != null && this.mCurrentScrollingLayerId == this.mEditTextLayerId) {
            this.mEditTextContentBounds.offset(dx, dy);
            this.mAutoCompletePopup.resetRect();
        }
        this.nativeScrollLayer(this.mNativeClass, this.mCurrentScrollingLayerId, x, y);
        this.mScrollingLayerRect.left = x;
        this.mScrollingLayerRect.top = y;
        this.mWebViewCore.sendMessage(198, this.mCurrentScrollingLayerId, this.mScrollingLayerRect);
        this.mWebViewPrivate.onScrollChanged(this.getScrollX(), this.getScrollY(), this.getScrollX(), this.getScrollY());
        this.invalidate();
    }

    private static int computeDuration(int dx, int dy) {
        int distance = Math.max(Math.abs(dx), Math.abs(dy));
        int duration = distance * 1000 / 480;
        return Math.min(duration, 750);
    }

    private boolean pinScrollBy(int dx, int dy, boolean animate, int animationDuration) {
        return this.pinScrollTo(this.getScrollX() + dx, this.getScrollY() + dy, animate, animationDuration);
    }

    private boolean pinScrollTo(int x, int y, boolean animate, int animationDuration) {
        this.abortAnimation();
        x = this.pinLocX(x);
        y = this.pinLocY(y);
        int dx = x - this.getScrollX();
        int dy = y - this.getScrollY();
        if ((dx | dy) == 0) {
            return false;
        }
        if (animate) {
            this.mScroller.startScroll(this.getScrollX(), this.getScrollY(), dx, dy, animationDuration > 0 ? animationDuration : WebViewClassic.computeDuration(dx, dy));
            this.invalidate();
        } else {
            this.mWebView.scrollTo(x, y);
        }
        return true;
    }

    private boolean setContentScrollBy(int cx, int cy, boolean animate) {
        if (this.mDrawHistory) {
            return false;
        }
        cx = this.contentToViewDimension(cx);
        cy = this.contentToViewDimension(cy);
        if (this.mHeightCanMeasure) {
            if (cy != 0) {
                Rect tempRect = new Rect();
                this.calcOurVisibleRect(tempRect);
                tempRect.offset(cx, cy);
                this.mWebView.requestRectangleOnScreen(tempRect);
            }
            return cy == 0 && cx != 0 && this.pinScrollBy(cx, 0, animate, 0);
        }
        return this.pinScrollBy(cx, cy, animate, 0);
    }

    void onPageStarted(String url) {
        this.mWebView.setCertificate(null);
        if (this.isAccessibilityInjectionEnabled()) {
            this.getAccessibilityInjector().onPageStarted(url);
        }
        this.mIsEditingText = false;
    }

    void onPageFinished(String url) {
        this.mZoomManager.onPageFinished(url);
        if (this.isAccessibilityInjectionEnabled()) {
            this.getAccessibilityInjector().onPageFinished(url);
        }
    }

    private void contentScrollTo(int cx, int cy, boolean animate) {
        if (this.mDrawHistory) {
            return;
        }
        int vx = this.contentToViewX(cx);
        int vy = this.contentToViewY(cy);
        this.pinScrollTo(vx, vy, animate, 0);
    }

    private void contentSizeChanged(boolean updateLayout) {
        if ((this.mContentWidth | this.mContentHeight) == 0) {
            return;
        }
        if (this.mHeightCanMeasure) {
            if (this.mWebView.getMeasuredHeight() != this.contentToViewDimension(this.mContentHeight) || updateLayout) {
                this.mWebView.requestLayout();
            }
        } else if (this.mWidthCanMeasure) {
            if (this.mWebView.getMeasuredWidth() != this.contentToViewDimension(this.mContentWidth) || updateLayout) {
                this.mWebView.requestLayout();
            }
        } else {
            this.sendViewSizeZoom(false);
        }
    }

    @Override
    public void setWebViewClient(WebViewClient client) {
        this.mCallbackProxy.setWebViewClient(client);
    }

    public WebViewClient getWebViewClient() {
        return this.mCallbackProxy.getWebViewClient();
    }

    @Override
    public void setDownloadListener(DownloadListener listener) {
        this.mCallbackProxy.setDownloadListener(listener);
    }

    @Override
    public void setWebChromeClient(WebChromeClient client) {
        this.mCallbackProxy.setWebChromeClient(client);
    }

    public WebChromeClient getWebChromeClient() {
        return this.mCallbackProxy.getWebChromeClient();
    }

    public void setWebBackForwardListClient(WebBackForwardListClient client) {
        this.mCallbackProxy.setWebBackForwardListClient(client);
    }

    public WebBackForwardListClient getWebBackForwardListClient() {
        return this.mCallbackProxy.getWebBackForwardListClient();
    }

    @Override
    @Deprecated
    public void setPictureListener(WebView.PictureListener listener) {
        this.mPictureListener = listener;
    }

    public void externalRepresentation(Message callback) {
        this.mWebViewCore.sendMessage(160, callback);
    }

    public void documentAsText(Message callback) {
        this.mWebViewCore.sendMessage(161, callback);
    }

    @Override
    public void addJavascriptInterface(Object object, String name) {
        if (object == null) {
            return;
        }
        WebViewCore.JSInterfaceData arg = new WebViewCore.JSInterfaceData();
        arg.mObject = object;
        arg.mInterfaceName = name;
        arg.mRequireAnnotation = this.mContext.getApplicationInfo().targetSdkVersion >= 17;
        this.mWebViewCore.sendMessage(138, arg);
    }

    @Override
    public void removeJavascriptInterface(String interfaceName) {
        if (this.mWebViewCore != null) {
            WebViewCore.JSInterfaceData arg = new WebViewCore.JSInterfaceData();
            arg.mInterfaceName = interfaceName;
            this.mWebViewCore.sendMessage(149, arg);
        }
    }

    @Override
    public WebSettingsClassic getSettings() {
        return this.mWebViewCore != null ? this.mWebViewCore.getSettings() : null;
    }

    @Deprecated
    public static synchronized PluginList getPluginList() {
        return new PluginList();
    }

    @Deprecated
    public void refreshPlugins(boolean reloadOpenPages) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private void drawContent(Canvas canvas) {
        boolean animateScroll;
        if (this.mDrawHistory) {
            canvas.scale(this.mZoomManager.getScale(), this.mZoomManager.getScale());
            canvas.drawPicture(this.mHistoryPicture);
            return;
        }
        if (this.mNativeClass == 0) {
            return;
        }
        boolean animateZoom = this.mZoomManager.isFixedLengthAnimationInProgress();
        boolean bl = animateScroll = !(this.mScroller.isFinished() && this.mVelocityTracker == null || this.mTouchMode == 3 && this.mHeldMotionless == 2);
        if (this.mTouchMode == 3) {
            if (this.mHeldMotionless == 1) {
                this.mPrivateHandler.removeMessages(8);
                this.mHeldMotionless = 0;
            }
            if (this.mHeldMotionless == 0) {
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(8), 100L);
                this.mHeldMotionless = 1;
            }
        }
        int saveCount = canvas.save();
        if (animateZoom) {
            this.mZoomManager.animateZoom(canvas);
        } else if (!canvas.isHardwareAccelerated()) {
            canvas.scale(this.mZoomManager.getScale(), this.mZoomManager.getScale());
        }
        boolean UIAnimationsRunning = false;
        if (this.mNativeClass != 0 && !canvas.isHardwareAccelerated() && this.nativeEvaluateLayersAnimations(this.mNativeClass)) {
            UIAnimationsRunning = true;
            this.mWebViewCore.sendMessage(196);
            this.invalidate();
        }
        int extras = 0;
        if (!this.mFindIsUp && this.mShowTextSelectionExtra) {
            extras = 1;
        }
        this.calcOurContentVisibleRectF(this.mVisibleContentRect);
        if (canvas.isHardwareAccelerated()) {
            Rect invScreenRect = this.mIsWebViewVisible ? this.mInvScreenRect : null;
            Rect screenRect = this.mIsWebViewVisible ? this.mScreenRect : null;
            int functor = this.nativeCreateDrawGLFunction(this.mNativeClass, invScreenRect, screenRect, this.mVisibleContentRect, this.getScale(), extras);
            ((HardwareCanvas)canvas).callDrawGLFunction(functor);
            if (this.mHardwareAccelSkia != this.getSettings().getHardwareAccelSkiaEnabled()) {
                this.mHardwareAccelSkia = this.getSettings().getHardwareAccelSkiaEnabled();
                this.nativeUseHardwareAccelSkia(this.mHardwareAccelSkia);
            }
        } else {
            DrawFilter df = null;
            if (this.mZoomManager.isZoomAnimating() || UIAnimationsRunning) {
                df = this.mZoomFilter;
            } else if (animateScroll) {
                df = this.mScrollFilter;
            }
            canvas.setDrawFilter(df);
            this.nativeDraw(canvas, this.mVisibleContentRect, this.mBackgroundColor, extras);
            canvas.setDrawFilter(null);
        }
        canvas.restoreToCount(saveCount);
        this.drawTextSelectionHandles(canvas);
        if (extras == 2 && this.mTouchMode == 4) {
            this.mTouchMode = 5;
        }
    }

    private void drawOverScrollBackground(Canvas canvas) {
        if (mOverScrollBackground == null) {
            mOverScrollBackground = new Paint();
            Bitmap bm = BitmapFactory.decodeResource(this.mContext.getResources(), 17302894);
            mOverScrollBackground.setShader(new BitmapShader(bm, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
            mOverScrollBorder = new Paint();
            mOverScrollBorder.setStyle(Paint.Style.STROKE);
            mOverScrollBorder.setStrokeWidth(0.0f);
            mOverScrollBorder.setColor(-4473925);
        }
        int top = 0;
        int right = this.computeRealHorizontalScrollRange();
        int bottom = top + this.computeRealVerticalScrollRange();
        canvas.save();
        canvas.translate(this.getScrollX(), this.getScrollY());
        canvas.clipRect(-this.getScrollX(), top - this.getScrollY(), right - this.getScrollX(), bottom - this.getScrollY(), Region.Op.DIFFERENCE);
        canvas.drawPaint(mOverScrollBackground);
        canvas.restore();
        canvas.drawRect(-1.0f, top - 1, right, bottom, mOverScrollBorder);
        canvas.clipRect(0, top, right, bottom);
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (this.inFullScreenMode()) {
            return;
        }
        if (this.mNativeClass == 0) {
            canvas.drawColor(this.mBackgroundColor);
            return;
        }
        if ((this.mContentWidth | this.mContentHeight) == 0 && this.mHistoryPicture == null) {
            canvas.drawColor(this.mBackgroundColor);
            return;
        }
        if (canvas.isHardwareAccelerated()) {
            this.mZoomManager.setHardwareAccelerated();
        } else {
            this.mWebViewCore.resumeWebKitDraw();
        }
        int saveCount = canvas.save();
        if (this.mInOverScrollMode && !this.getSettings().getUseWebViewBackgroundForOverscrollBackground()) {
            this.drawOverScrollBackground(canvas);
        }
        canvas.translate(0.0f, this.getTitleHeight());
        this.drawContent(canvas);
        canvas.restoreToCount(saveCount);
        this.mWebViewCore.signalRepaintDone();
        if (this.mOverScrollGlow != null && this.mOverScrollGlow.drawEdgeGlows(canvas)) {
            this.invalidate();
        }
        if (this.mFocusTransition != null) {
            this.mFocusTransition.draw(canvas);
        } else if (this.shouldDrawHighlightRect()) {
            RegionIterator iter = new RegionIterator(this.mTouchHighlightRegion);
            Rect r = new Rect();
            while (iter.next(r)) {
                canvas.drawRect(r, this.mTouchHightlightPaint);
            }
        }
        if (this.getSettings().getNavDump() && (this.mTouchHighlightX | this.mTouchHighlightY) != 0) {
            if (this.mTouchCrossHairColor == null) {
                this.mTouchCrossHairColor = new Paint();
                this.mTouchCrossHairColor.setColor(-65536);
            }
            canvas.drawLine(this.mTouchHighlightX - this.mNavSlop, this.mTouchHighlightY - this.mNavSlop, this.mTouchHighlightX + this.mNavSlop + 1, this.mTouchHighlightY + this.mNavSlop + 1, this.mTouchCrossHairColor);
            canvas.drawLine(this.mTouchHighlightX + this.mNavSlop + 1, this.mTouchHighlightY - this.mNavSlop, this.mTouchHighlightX - this.mNavSlop, this.mTouchHighlightY + this.mNavSlop + 1, this.mTouchCrossHairColor);
        }
    }

    private void removeTouchHighlight() {
        this.setTouchHighlightRects(null);
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.height == -2) {
            this.mWrapContent = true;
        }
        this.mWebViewPrivate.super_setLayoutParams(params);
    }

    @Override
    public boolean performLongClick() {
        if (this.mWebView.getParent() == null) {
            return false;
        }
        ScaleGestureDetector detector = this.mZoomManager.getScaleGestureDetector();
        if (detector != null && detector.isInProgress()) {
            return false;
        }
        if (this.mSelectingText) {
            return false;
        }
        if (this.mWebViewPrivate.super_performLongClick()) {
            return true;
        }
        boolean isSelecting = this.selectText();
        if (isSelecting) {
            this.mWebView.performHapticFeedback(0);
        } else if (this.focusCandidateIsEditableText()) {
            this.mSelectCallback = new SelectActionModeCallback();
            this.mSelectCallback.setWebView(this);
            this.mSelectCallback.setTextSelected(false);
            this.mWebView.startActionMode(this.mSelectCallback);
        }
        return isSelecting;
    }

    public boolean selectText() {
        int x = this.viewToContentX(this.mLastTouchX + this.getScrollX());
        int y = this.viewToContentY(this.mLastTouchY + this.getScrollY());
        return this.selectText(x, y);
    }

    boolean selectText(int x, int y) {
        if (this.mWebViewCore == null) {
            return false;
        }
        this.mWebViewCore.sendMessage(214, x, y);
        return true;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.mCachedOverlappingActionModeHeight = -1;
        if (this.mSelectingText && this.mOrientation != newConfig.orientation) {
            this.selectionDone();
        }
        this.mOrientation = newConfig.orientation;
        if (this.mWebViewCore != null && !this.mBlockWebkitViewMessages) {
            this.mWebViewCore.sendMessage(134);
        }
    }

    void setBaseLayer(int layer, boolean showVisualIndicator, boolean isPictureAfterFirstLayout) {
        if (this.mNativeClass == 0) {
            return;
        }
        int scrollingLayer = this.mTouchMode == 9 ? this.mCurrentScrollingLayerId : 0;
        boolean queueFull = this.nativeSetBaseLayer(this.mNativeClass, layer, showVisualIndicator, isPictureAfterFirstLayout, scrollingLayer);
        if (queueFull) {
            this.mWebViewCore.pauseWebKitDraw();
        } else {
            this.mWebViewCore.resumeWebKitDraw();
        }
        if (this.mHTML5VideoViewProxy != null) {
            this.mHTML5VideoViewProxy.setBaseLayer(layer);
        }
    }

    int getBaseLayer() {
        if (this.mNativeClass == 0) {
            return 0;
        }
        return this.nativeGetBaseLayer(this.mNativeClass);
    }

    private void onZoomAnimationStart() {
    }

    private void onZoomAnimationEnd() {
        this.mPrivateHandler.sendEmptyMessage(146);
    }

    void onFixedLengthZoomAnimationStart() {
        WebViewCore.pauseUpdatePicture(this.getWebViewCore());
        this.onZoomAnimationStart();
    }

    void onFixedLengthZoomAnimationEnd() {
        if (!this.mBlockWebkitViewMessages && !this.mSelectingText) {
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
        }
        this.onZoomAnimationEnd();
    }

    private void startSelectingText() {
        this.mSelectingText = true;
        this.mShowTextSelectionExtra = true;
        this.animateHandles();
    }

    private void animateHandle(boolean canShow, ObjectAnimator animator2, Point selectionPoint, int selectionLayerId, SelectionHandleAlpha alpha) {
        int targetValue;
        boolean isVisible = canShow && this.mSelectingText && (this.mSelectionStarted && this.mSelectDraggingCursor == selectionPoint || this.isHandleVisible(selectionPoint, selectionLayerId));
        int n = targetValue = isVisible ? 255 : 0;
        if (targetValue != alpha.getTargetAlpha()) {
            alpha.setTargetAlpha(targetValue);
            animator2.setIntValues(targetValue);
            animator2.setDuration(150L);
            animator2.start();
        }
    }

    private void animateHandles() {
        boolean canShowBase = this.mSelectingText;
        boolean canShowExtent = this.mSelectingText && !this.mIsCaretSelection;
        this.animateHandle(canShowBase, this.mBaseHandleAlphaAnimator, this.mSelectCursorBase, this.mSelectCursorBaseLayerId, this.mBaseAlpha);
        this.animateHandle(canShowExtent, this.mExtentHandleAlphaAnimator, this.mSelectCursorExtent, this.mSelectCursorExtentLayerId, this.mExtentAlpha);
    }

    private void endSelectingText() {
        this.mSelectingText = false;
        this.mShowTextSelectionExtra = false;
        this.animateHandles();
    }

    private void ensureSelectionHandles() {
        if (this.mSelectHandleCenter == null) {
            this.mSelectHandleCenter = this.mContext.getResources().getDrawable(17302986).mutate();
            this.mSelectHandleLeft = this.mContext.getResources().getDrawable(17302985).mutate();
            this.mSelectHandleRight = this.mContext.getResources().getDrawable(17302987).mutate();
            this.mSelectOffset = new Point(0, -this.mSelectHandleLeft.getIntrinsicHeight());
        }
    }

    private void drawHandle(Point point, int handleId, Rect bounds, int alpha, Canvas canvas) {
        int offset;
        int height;
        int width;
        Drawable drawable2;
        boolean isLeft = WebViewClassic.nativeIsHandleLeft(this.mNativeClass, handleId);
        if (isLeft) {
            drawable2 = this.mSelectHandleLeft;
            width = this.mSelectHandleLeft.getIntrinsicWidth();
            height = this.mSelectHandleLeft.getIntrinsicHeight();
            offset = width * 3 / 4;
        } else {
            drawable2 = this.mSelectHandleRight;
            width = this.mSelectHandleRight.getIntrinsicWidth();
            height = this.mSelectHandleRight.getIntrinsicHeight();
            offset = width / 4;
        }
        int x = this.contentToViewDimension(point.x);
        int y = this.contentToViewDimension(point.y);
        bounds.set(x - offset, y, x - offset + width, y + height);
        drawable2.setBounds(bounds);
        drawable2.setAlpha(alpha);
        drawable2.draw(canvas);
    }

    private void drawTextSelectionHandles(Canvas canvas) {
        if (this.mBaseAlpha.getAlpha() == 0 && this.mExtentAlpha.getAlpha() == 0) {
            return;
        }
        this.ensureSelectionHandles();
        if (this.mIsCaretSelection) {
            int x = this.contentToViewDimension(this.mSelectCursorBase.x) - this.mSelectHandleCenter.getIntrinsicWidth() / 2;
            int y = this.contentToViewDimension(this.mSelectCursorBase.y);
            this.mSelectHandleBaseBounds.set(x, y, x + this.mSelectHandleCenter.getIntrinsicWidth(), y + this.mSelectHandleCenter.getIntrinsicHeight());
            this.mSelectHandleCenter.setBounds(this.mSelectHandleBaseBounds);
            this.mSelectHandleCenter.setAlpha(this.mBaseAlpha.getAlpha());
            this.mSelectHandleCenter.draw(canvas);
        } else {
            this.drawHandle(this.mSelectCursorBase, 0, this.mSelectHandleBaseBounds, this.mBaseAlpha.getAlpha(), canvas);
            this.drawHandle(this.mSelectCursorExtent, 1, this.mSelectHandleExtentBounds, this.mExtentAlpha.getAlpha(), canvas);
        }
    }

    private boolean isHandleVisible(Point selectionPoint, int layerId) {
        boolean isVisible = true;
        if (this.mIsEditingText) {
            isVisible = this.mEditTextContentBounds.contains(selectionPoint.x, selectionPoint.y);
        }
        if (isVisible) {
            isVisible = WebViewClassic.nativeIsPointVisible(this.mNativeClass, layerId, selectionPoint.x, selectionPoint.y);
        }
        return isVisible;
    }

    private void getSelectionHandles(int[] handles) {
        handles[0] = this.mSelectCursorBase.x;
        handles[1] = this.mSelectCursorBase.y;
        handles[2] = this.mSelectCursorExtent.x;
        handles[3] = this.mSelectCursorExtent.y;
    }

    boolean drawHistory() {
        return this.mDrawHistory;
    }

    int getHistoryPictureWidth() {
        return this.mHistoryPicture != null ? this.mHistoryPicture.getWidth() : 0;
    }

    void switchOutDrawHistory() {
        if (null == this.mWebViewCore) {
            return;
        }
        if (this.mDrawHistory && (this.getProgress() == 100 || this.nativeHasContent())) {
            this.mDrawHistory = false;
            this.mHistoryPicture = null;
            this.invalidate();
            int oldScrollX = this.getScrollX();
            int oldScrollY = this.getScrollY();
            this.setScrollXRaw(this.pinLocX(this.getScrollX()));
            this.setScrollYRaw(this.pinLocY(this.getScrollY()));
            if (oldScrollX != this.getScrollX() || oldScrollY != this.getScrollY()) {
                this.mWebViewPrivate.onScrollChanged(this.getScrollX(), this.getScrollY(), oldScrollX, oldScrollY);
            } else {
                this.sendOurVisibleRect();
            }
        }
    }

    void deleteSelection(int start, int end) {
        ++this.mTextGeneration;
        WebViewCore.TextSelectionData data = new WebViewCore.TextSelectionData(start, end, 0);
        this.mWebViewCore.sendMessage(122, this.mTextGeneration, 0, data);
    }

    void setSelection(int start, int end) {
        if (this.mWebViewCore != null) {
            this.mWebViewCore.sendMessage(113, start, end);
        }
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.mInputConnection == null) {
            this.mInputConnection = new WebViewInputConnection();
            this.mAutoCompletePopup = new AutoCompletePopup(this, this.mInputConnection);
        }
        this.mInputConnection.setupEditorInfo(outAttrs);
        return this.mInputConnection;
    }

    private void relocateAutoCompletePopup() {
        if (this.mAutoCompletePopup != null) {
            this.mAutoCompletePopup.resetRect();
            this.mAutoCompletePopup.setText(this.mInputConnection.getEditable());
        }
    }

    private void displaySoftKeyboard(boolean isTextView) {
        boolean zoom;
        InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
        boolean bl = zoom = this.mZoomManager.getScale() < this.mZoomManager.getDefaultScale();
        if (zoom) {
            this.mZoomManager.setZoomCenter(this.mLastTouchX, this.mLastTouchY);
            this.mZoomManager.setZoomScale(this.mZoomManager.getDefaultScale(), false);
        }
        imm.showSoftInput(this.mWebView, 0);
    }

    private void hideSoftKeyboard() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null && imm.isActive(this.mWebView)) {
            imm.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
        }
    }

    void requestFormData(String name, int nodePointer, boolean autoFillable, boolean autoComplete) {
        if (this.mWebViewCore.getSettings().getSaveFormData()) {
            Message update = this.mPrivateHandler.obtainMessage(6);
            update.arg1 = nodePointer;
            RequestFormData updater = new RequestFormData(name, this.getUrl(), update, autoFillable, autoComplete);
            Thread t = new Thread(updater);
            t.start();
        }
    }

    public void dumpDisplayTree() {
        this.nativeDumpDisplayTree(this.getUrl());
    }

    public void dumpDomTree(boolean toFile) {
        this.mWebViewCore.sendMessage(170, toFile ? 1 : 0, 0);
    }

    public void dumpRenderTree(boolean toFile) {
        this.mWebViewCore.sendMessage(171, toFile ? 1 : 0, 0);
    }

    public void setUseMockDeviceOrientation() {
        this.mWebViewCore.sendMessage(191);
    }

    public void setUseMockGeolocation() {
        this.mWebViewCore.sendMessage(226);
    }

    public void setMockGeolocationPosition(double latitude, double longitude, double accuracy) {
        this.mWebViewCore.setMockGeolocationPosition(latitude, longitude, accuracy);
    }

    public void setMockGeolocationError(int code, String message) {
        this.mWebViewCore.setMockGeolocationError(code, message);
    }

    public void setMockGeolocationPermission(boolean allow) {
        this.mWebViewCore.setMockGeolocationPermission(allow);
    }

    public void setMockDeviceOrientation(boolean canProvideAlpha, double alpha, boolean canProvideBeta, double beta, boolean canProvideGamma, double gamma) {
        this.mWebViewCore.setMockDeviceOrientation(canProvideAlpha, alpha, canProvideBeta, beta, canProvideGamma, gamma);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        if (this.mBlockWebkitViewMessages) {
            return false;
        }
        if (keyCode == 0 && event.getCharacters() != null) {
            this.sendBatchableInputMessage(103, 0, 0, event);
            this.sendBatchableInputMessage(104, 0, 0, event);
            return true;
        }
        return false;
    }

    private boolean isEnterActionKey(int keyCode) {
        return keyCode == 23 || keyCode == 66 || keyCode == 160;
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (this.mAutoCompletePopup != null) {
            return this.mAutoCompletePopup.onKeyPreIme(keyCode, event);
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mIsCaretSelection) {
            this.selectionDone();
        }
        if (this.mBlockWebkitViewMessages) {
            return false;
        }
        if (event.isCtrlPressed()) {
            return false;
        }
        if (this.mNativeClass == 0) {
            return false;
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (this.isAccessibilityInjectionEnabled() && this.getAccessibilityInjector().handleKeyEventIfNecessary(event)) {
            return true;
        }
        if (keyCode == 92) {
            if (event.hasNoModifiers()) {
                this.pageUp(false);
                return true;
            }
            if (event.hasModifiers(2)) {
                this.pageUp(true);
                return true;
            }
        }
        if (keyCode == 93) {
            if (event.hasNoModifiers()) {
                this.pageDown(false);
                return true;
            }
            if (event.hasModifiers(2)) {
                this.pageDown(true);
                return true;
            }
        }
        if (keyCode == 122 && event.hasNoModifiers()) {
            this.pageUp(true);
            return true;
        }
        if (keyCode == 123 && event.hasNoModifiers()) {
            this.pageDown(true);
            return true;
        }
        if (keyCode >= 19 && keyCode <= 22) {
            this.switchOutDrawHistory();
        }
        if (this.isEnterActionKey(keyCode)) {
            this.switchOutDrawHistory();
            if (event.getRepeatCount() == 0) {
                if (this.mSelectingText) {
                    return true;
                }
                this.mGotCenterDown = true;
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(114), 1000L);
            }
        }
        if (this.getSettings().getNavDump()) {
            switch (keyCode) {
                case 11: {
                    this.dumpDisplayTree();
                    break;
                }
                case 12: 
                case 13: {
                    this.dumpDomTree(keyCode == 12);
                    break;
                }
                case 14: 
                case 15: {
                    this.dumpRenderTree(keyCode == 14);
                }
            }
        }
        this.sendKeyEvent(event);
        return true;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mBlockWebkitViewMessages) {
            return false;
        }
        if (this.mNativeClass == 0) {
            return false;
        }
        if (keyCode == 5 && this.mInitialHitTestResult != null && this.mInitialHitTestResult.getType() == 2) {
            String text = this.mInitialHitTestResult.getExtra();
            Intent intent = new Intent("android.intent.action.DIAL", Uri.parse(text));
            this.mContext.startActivity(intent);
            return true;
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (this.isAccessibilityInjectionEnabled() && this.getAccessibilityInjector().handleKeyEventIfNecessary(event)) {
            return true;
        }
        if (this.isEnterActionKey(keyCode)) {
            this.mPrivateHandler.removeMessages(114);
            this.mGotCenterDown = false;
            if (this.mSelectingText) {
                this.copySelection();
                this.selectionDone();
                return true;
            }
        }
        this.sendKeyEvent(event);
        return true;
    }

    private boolean startSelectActionMode() {
        this.mSelectCallback = new SelectActionModeCallback();
        this.mSelectCallback.setTextSelected(!this.mIsCaretSelection);
        this.mSelectCallback.setWebView(this);
        if (this.mWebView.startActionMode(this.mSelectCallback) == null) {
            this.selectionDone();
            return false;
        }
        this.mWebView.performHapticFeedback(0);
        return true;
    }

    private void showPasteWindow() {
        ClipboardManager cm = (ClipboardManager)this.mContext.getSystemService("clipboard");
        if (cm.hasPrimaryClip()) {
            Point cursorPoint = new Point(this.contentToViewX(this.mSelectCursorBase.x), this.contentToViewY(this.mSelectCursorBase.y));
            Point cursorTop = this.calculateBaseCaretTop();
            cursorTop.set(this.contentToViewX(cursorTop.x), this.contentToViewY(cursorTop.y));
            int[] location = new int[2];
            this.mWebView.getLocationInWindow(location);
            int offsetX = location[0] - this.getScrollX();
            int offsetY = location[1] - this.getScrollY();
            cursorPoint.offset(offsetX, offsetY);
            cursorTop.offset(offsetX, offsetY);
            if (this.mPasteWindow == null) {
                this.mPasteWindow = new PastePopupWindow();
            }
            this.mPasteWindow.show(cursorPoint, cursorTop, location[0], location[1]);
        }
    }

    private static float scaleAlongSegment(int x, int y, PointF a, PointF b) {
        float abX = b.x - a.x;
        float abY = b.y - a.y;
        float ab2 = abX * abX + abY * abY;
        float apX = (float)x - a.x;
        float apY = (float)y - a.y;
        float abDotAP = apX * abX + apY * abY;
        float scale = abDotAP / ab2;
        return scale;
    }

    private Point calculateBaseCaretTop() {
        return WebViewClassic.calculateCaretTop(this.mSelectCursorBase, this.mSelectCursorBaseTextQuad);
    }

    private Point calculateDraggingCaretTop() {
        return WebViewClassic.calculateCaretTop(this.mSelectDraggingCursor, this.mSelectDraggingTextQuad);
    }

    private static Point calculateCaretTop(Point base, QuadF quad) {
        float scale = WebViewClassic.scaleAlongSegment(base.x, base.y, quad.p4, quad.p3);
        int x = Math.round(WebViewClassic.scaleCoordinate(scale, quad.p1.x, quad.p2.x));
        int y = Math.round(WebViewClassic.scaleCoordinate(scale, quad.p1.y, quad.p2.y));
        return new Point(x, y);
    }

    private void hidePasteButton() {
        if (this.mPasteWindow != null) {
            this.mPasteWindow.hide();
        }
    }

    private void syncSelectionCursors() {
        this.mSelectCursorBaseLayerId = WebViewClassic.nativeGetHandleLayerId(this.mNativeClass, 0, this.mSelectCursorBase, this.mSelectCursorBaseTextQuad);
        this.mSelectCursorExtentLayerId = WebViewClassic.nativeGetHandleLayerId(this.mNativeClass, 1, this.mSelectCursorExtent, this.mSelectCursorExtentTextQuad);
    }

    private boolean setupWebkitSelect() {
        this.syncSelectionCursors();
        if (!this.mIsCaretSelection && !this.startSelectActionMode()) {
            this.selectionDone();
            return false;
        }
        this.startSelectingText();
        this.mTouchMode = 3;
        return true;
    }

    private void updateWebkitSelection(boolean isSnapped) {
        int handleId = this.mSelectDraggingCursor == this.mSelectCursorBase ? 0 : 1;
        int x = this.mSelectDraggingCursor.x;
        int y = this.mSelectDraggingCursor.y;
        if (isSnapped) {
            Point top = this.calculateDraggingCaretTop();
            x = Math.round((top.x + x) / 2);
            y = Math.round((top.y + y) / 2);
        }
        this.mWebViewCore.removeMessages(213);
        this.mWebViewCore.sendMessageAtFrontOfQueue(213, x, y, handleId);
    }

    private void resetCaretTimer() {
        this.mPrivateHandler.removeMessages(144);
        if (!this.mSelectionStarted) {
            this.mPrivateHandler.sendEmptyMessageDelayed(144, 3000L);
        }
    }

    public void selectAll() {
        this.mWebViewCore.sendMessage(215);
    }

    void selectionDone() {
        if (this.mSelectingText) {
            this.hidePasteButton();
            this.endSelectingText();
            if (this.mSelectCallback != null) {
                this.mSelectCallback.finish();
                this.mSelectCallback = null;
            }
            this.invalidate();
            this.mAutoScrollX = 0;
            this.mAutoScrollY = 0;
            this.mSentAutoScrollMessage = false;
        }
    }

    public boolean copySelection() {
        boolean copiedSomething = false;
        String selection = this.getSelection();
        if (selection != null && selection != "") {
            Toast.makeText(this.mContext, 17040282, 0).show();
            copiedSomething = true;
            ClipboardManager cm = (ClipboardManager)this.mContext.getSystemService("clipboard");
            cm.setText(selection);
            int[] handles = new int[4];
            this.getSelectionHandles(handles);
            this.mWebViewCore.sendMessage(210, handles);
        }
        this.invalidate();
        return copiedSomething;
    }

    public void cutSelection() {
        this.copySelection();
        int[] handles = new int[4];
        this.getSelectionHandles(handles);
        this.mWebViewCore.sendMessage(211, handles);
    }

    public void pasteFromClipboard() {
        ClipboardManager cm = (ClipboardManager)this.mContext.getSystemService("clipboard");
        ClipData clipData = cm.getPrimaryClip();
        if (clipData != null) {
            ClipData.Item clipItem = clipData.getItemAt(0);
            CharSequence pasteText = clipItem.getText();
            if (this.mInputConnection != null) {
                this.mInputConnection.replaceSelection(pasteText);
            }
        }
    }

    String getSelection() {
        if (this.mNativeClass == 0) {
            return "";
        }
        return this.nativeGetSelection();
    }

    @Override
    public void onAttachedToWindow() {
        if (this.mWebView.hasWindowFocus()) {
            this.setActive(true);
        }
        if (this.isAccessibilityInjectionEnabled()) {
            this.getAccessibilityInjector().toggleAccessibilityFeedback(true);
        }
        this.updateHwAccelerated();
    }

    @Override
    public void onDetachedFromWindow() {
        this.clearHelpers();
        this.mZoomManager.dismissZoomPicker();
        if (this.mWebView.hasWindowFocus()) {
            this.setActive(false);
        }
        if (this.isAccessibilityInjectionEnabled()) {
            this.getAccessibilityInjector().toggleAccessibilityFeedback(false);
        }
        this.updateHwAccelerated();
        this.ensureFunctorDetached();
    }

    @Override
    public void onVisibilityChanged(View changedView, int visibility) {
        if (visibility != 0 && this.mZoomManager != null) {
            this.mZoomManager.dismissZoomPicker();
        }
        this.updateDrawingState();
    }

    void setActive(boolean active) {
        if (active) {
            if (this.mWebView.hasFocus()) {
                this.mDrawCursorRing = true;
                this.setFocusControllerActive(true);
            } else {
                this.mDrawCursorRing = false;
                this.setFocusControllerActive(false);
            }
        } else {
            if (!this.mZoomManager.isZoomPickerVisible()) {
                this.mDrawCursorRing = false;
            }
            this.mKeysPressed.clear();
            this.mPrivateHandler.removeMessages(4);
            this.mTouchMode = 7;
            this.setFocusControllerActive(false);
        }
        this.invalidate();
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.setActive(hasWindowFocus);
        if (hasWindowFocus) {
            JWebCoreJavaBridge.setActiveWebView(this);
            if (this.mPictureUpdatePausedForFocusChange) {
                WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                this.mPictureUpdatePausedForFocusChange = false;
            }
        } else {
            JWebCoreJavaBridge.removeActiveWebView(this);
            WebSettingsClassic settings = this.getSettings();
            if (settings != null && ((WebSettings)settings).enableSmoothTransition() && this.mWebViewCore != null && !WebViewCore.isUpdatePicturePaused(this.mWebViewCore)) {
                WebViewCore.pauseUpdatePicture(this.mWebViewCore);
                this.mPictureUpdatePausedForFocusChange = true;
            }
        }
    }

    void setFocusControllerActive(boolean active) {
        if (this.mWebViewCore == null) {
            return;
        }
        this.mWebViewCore.sendMessage(142, active ? 1 : 0, 0);
        if (active && this.mListBoxMessage != null) {
            this.mWebViewCore.sendMessage(this.mListBoxMessage);
            this.mListBoxMessage = null;
        }
    }

    @Override
    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused) {
            this.mDrawCursorRing = true;
            this.setFocusControllerActive(true);
        } else {
            this.mDrawCursorRing = false;
            this.setFocusControllerActive(false);
            this.mKeysPressed.clear();
        }
        if (!this.mTouchHighlightRegion.isEmpty()) {
            this.mWebView.invalidate(this.mTouchHighlightRegion.getBounds());
        }
    }

    void updateRectsForGL() {
        boolean visible = this.mWebView.getGlobalVisibleRect(this.mTempVisibleRect, this.mTempVisibleRectOffset);
        this.mInvScreenRect.set(this.mTempVisibleRect);
        if (visible) {
            View rootView = this.mWebView.getRootView();
            int rootViewHeight = rootView.getHeight();
            this.mScreenRect.set(this.mInvScreenRect);
            int savedWebViewBottom = this.mInvScreenRect.bottom;
            this.mInvScreenRect.bottom = rootViewHeight - this.mInvScreenRect.top - this.getVisibleTitleHeightImpl();
            this.mInvScreenRect.top = rootViewHeight - savedWebViewBottom;
            this.mIsWebViewVisible = true;
        } else {
            this.mIsWebViewVisible = false;
        }
        this.mTempVisibleRect.offset(-this.mTempVisibleRectOffset.x, -this.mTempVisibleRectOffset.y);
        this.viewToContentVisibleRect(this.mVisibleContentRect, this.mTempVisibleRect);
        this.nativeUpdateDrawGLFunction(this.mNativeClass, this.mIsWebViewVisible ? this.mInvScreenRect : null, this.mIsWebViewVisible ? this.mScreenRect : null, this.mVisibleContentRect, this.getScale());
    }

    private void viewToContentVisibleRect(RectF contentRect, Rect viewRect) {
        contentRect.left = this.viewToContentXf(viewRect.left) / this.mWebView.getScaleX();
        contentRect.top = this.viewToContentYf(viewRect.top + this.getVisibleTitleHeightImpl()) / this.mWebView.getScaleY();
        contentRect.right = this.viewToContentXf(viewRect.right) / this.mWebView.getScaleX();
        contentRect.bottom = this.viewToContentYf(viewRect.bottom) / this.mWebView.getScaleY();
    }

    @Override
    public boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = this.mWebViewPrivate.super_setFrame(left, top, right, bottom);
        if (!changed && this.mHeightCanMeasure) {
            this.sendViewSizeZoom(false);
        }
        this.updateRectsForGL();
        return changed;
    }

    @Override
    public void onSizeChanged(int w, int h, int ow, int oh) {
        int newMaxViewportWidth = (int)((float)Math.max(w, h) / this.mZoomManager.getDefaultMinZoomScale());
        if (newMaxViewportWidth > sMaxViewportWidth) {
            sMaxViewportWidth = newMaxViewportWidth;
        }
        this.mZoomManager.onSizeChanged(w, h, ow, oh);
        if (this.mLoadedPicture != null && this.mDelaySetPicture == null) {
            this.setNewPicture(this.mLoadedPicture, false);
        }
        if (this.mIsEditingText) {
            this.scrollEditIntoView();
        }
        this.relocateAutoCompletePopup();
    }

    private void scrollEditIntoView() {
        Rect visibleRect = new Rect(this.viewToContentX(this.getScrollX()), this.viewToContentY(this.getScrollY()), this.viewToContentX(this.getScrollX() + this.getWidth()), this.viewToContentY(this.getScrollY() + this.getViewHeightWithTitle()));
        if (visibleRect.contains(this.mEditTextContentBounds)) {
            return;
        }
        this.syncSelectionCursors();
        WebViewClassic.nativeFindMaxVisibleRect(this.mNativeClass, this.mEditTextLayerId, visibleRect);
        int buffer = Math.max(1, this.viewToContentDimension(10));
        Rect showRect = new Rect(Math.max(0, this.mEditTextContentBounds.left - buffer), Math.max(0, this.mEditTextContentBounds.top - buffer), this.mEditTextContentBounds.right + buffer, this.mEditTextContentBounds.bottom + buffer);
        Point caretTop = this.calculateBaseCaretTop();
        if (visibleRect.width() < this.mEditTextContentBounds.width()) {
            if (this.mSelectCursorBase.x < caretTop.x) {
                showRect.left = Math.max(0, this.mSelectCursorBase.x - buffer);
                showRect.right = caretTop.x + buffer;
            } else {
                showRect.left = Math.max(0, caretTop.x - buffer);
                showRect.right = this.mSelectCursorBase.x + buffer;
            }
        }
        if (visibleRect.height() < this.mEditTextContentBounds.height()) {
            if (this.mSelectCursorBase.y > caretTop.y) {
                showRect.top = Math.max(0, caretTop.y - buffer);
                showRect.bottom = this.mSelectCursorBase.y + buffer;
            } else {
                showRect.top = Math.max(0, this.mSelectCursorBase.y - buffer);
                showRect.bottom = caretTop.y + buffer;
            }
        }
        if (visibleRect.contains(showRect)) {
            return;
        }
        int scrollX = this.viewToContentX(this.getScrollX());
        if (visibleRect.left > showRect.left) {
            scrollX += showRect.left - visibleRect.left;
        } else if (visibleRect.right < showRect.right) {
            scrollX += showRect.right - visibleRect.right;
        }
        int scrollY = this.viewToContentY(this.getScrollY());
        if (visibleRect.top > showRect.top) {
            scrollY += showRect.top - visibleRect.top;
        } else if (visibleRect.bottom < showRect.bottom) {
            scrollY += showRect.bottom - visibleRect.bottom;
        }
        this.contentScrollTo(scrollX, scrollY, false);
    }

    @Override
    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (!this.mInOverScrollMode) {
            this.sendOurVisibleRect();
            int titleHeight = this.getTitleHeight();
            if (Math.max(titleHeight - t, 0) != Math.max(titleHeight - oldt, 0)) {
                this.sendViewSizeZoom(false);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mKeysPressed.add(event.getKeyCode());
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                int location = this.mKeysPressed.indexOf(event.getKeyCode());
                if (location == -1) {
                    return false;
                }
                this.mKeysPressed.remove(location);
                break;
            }
        }
        return this.mWebViewPrivate.super_dispatchKeyEvent(event);
    }

    private boolean inFullScreenMode() {
        return this.mFullScreenHolder != null;
    }

    private void dismissFullScreenMode() {
        if (this.inFullScreenMode()) {
            this.mFullScreenHolder.hide();
            this.mFullScreenHolder = null;
            this.invalidate();
        }
    }

    void onPinchToZoomAnimationStart() {
        this.cancelTouch();
        this.onZoomAnimationStart();
    }

    void onPinchToZoomAnimationEnd(ScaleGestureDetector detector) {
        this.onZoomAnimationEnd();
        this.mTouchMode = 8;
        this.mConfirmMove = true;
        this.startTouch(detector.getFocusX(), detector.getFocusY(), this.mLastTouchTime);
    }

    private void startScrollingLayer(float x, float y) {
        if (this.mNativeClass == 0) {
            return;
        }
        int contentX = this.viewToContentX((int)x + this.getScrollX());
        int contentY = this.viewToContentY((int)y + this.getScrollY());
        this.mCurrentScrollingLayerId = this.nativeScrollableLayer(this.mNativeClass, contentX, contentY, this.mScrollingLayerRect, this.mScrollingLayerBounds);
        if (this.mCurrentScrollingLayerId != 0) {
            this.mTouchMode = 9;
        }
    }

    @Override
    public boolean onHoverEvent(MotionEvent event) {
        if (this.mNativeClass == 0) {
            return false;
        }
        int x = this.viewToContentX((int)event.getX() + this.getScrollX());
        int y = this.viewToContentY((int)event.getY() + this.getScrollY());
        this.mWebViewCore.sendMessage(135, x, y);
        this.mWebViewPrivate.super_onHoverEvent(event);
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mNativeClass == 0 || !this.mWebView.isClickable() && !this.mWebView.isLongClickable()) {
            return false;
        }
        if (this.mInputDispatcher == null) {
            return false;
        }
        if (this.mWebView.isFocusable() && this.mWebView.isFocusableInTouchMode() && !this.mWebView.isFocused()) {
            this.mWebView.requestFocus();
        }
        if (this.mInputDispatcher.postPointerEvent(ev, this.getScrollX(), this.getScrollY() - this.getTitleHeight(), this.mZoomManager.getInvScale())) {
            this.mInputDispatcher.dispatchUiEvents();
            return true;
        }
        Log.w(LOGTAG, "mInputDispatcher rejected the event!");
        return false;
    }

    private float calculateDragAngle(int dx, int dy) {
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        return (float)Math.atan2(dy, dx);
    }

    private void handleTouchEventCommon(MotionEvent event, int action, int x, int y) {
        ScaleGestureDetector detector = this.mZoomManager.getScaleGestureDetector();
        long eventTime = event.getEventTime();
        x = Math.min(x, this.getViewWidth() - 1);
        y = Math.min(y, this.getViewHeightWithTitle() - 1);
        int deltaX = this.mLastTouchX - x;
        int deltaY = this.mLastTouchY - y;
        int contentX = this.viewToContentX(x + this.getScrollX());
        int contentY = this.viewToContentY(y + this.getScrollY());
        switch (action) {
            case 0: {
                this.mConfirmMove = false;
                if (!this.mEditTextScroller.isFinished()) {
                    this.mEditTextScroller.abortAnimation();
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.mTouchMode = 2;
                    this.mConfirmMove = true;
                    this.nativeSetIsScrolling(false);
                } else if (this.mPrivateHandler.hasMessages(5)) {
                    this.mPrivateHandler.removeMessages(5);
                    this.removeTouchHighlight();
                    this.mTouchMode = deltaX * deltaX + deltaY * deltaY < this.mDoubleTapSlopSquare ? 6 : 1;
                } else {
                    this.mTouchMode = 1;
                    if (mLogEvent && eventTime - this.mLastTouchUpTime < 1000L) {
                        EventLog.writeEvent(70102, eventTime - this.mLastTouchUpTime, eventTime);
                    }
                    this.mSelectionStarted = false;
                    if (this.mSelectingText) {
                        this.ensureSelectionHandles();
                        int shiftedY = y - this.getTitleHeight() + this.getScrollY();
                        int shiftedX = x + this.getScrollX();
                        if (this.mSelectHandleBaseBounds.contains(shiftedX, shiftedY)) {
                            this.mSelectionStarted = true;
                            this.mSelectDraggingCursor = this.mSelectCursorBase;
                            this.mSelectDraggingTextQuad = this.mSelectCursorBaseTextQuad;
                            if (this.mIsCaretSelection) {
                                this.mPrivateHandler.removeMessages(144);
                                this.hidePasteButton();
                            }
                        } else if (this.mSelectHandleExtentBounds.contains(shiftedX, shiftedY)) {
                            this.mSelectionStarted = true;
                            this.mSelectDraggingCursor = this.mSelectCursorExtent;
                            this.mSelectDraggingTextQuad = this.mSelectCursorExtentTextQuad;
                        } else if (this.mIsCaretSelection) {
                            this.selectionDone();
                        }
                    }
                }
                if (!(this.mSelectingText || this.mTouchMode != 1 && this.mTouchMode != 6)) {
                    this.mPrivateHandler.sendEmptyMessageDelayed(3, 300L);
                    this.mPrivateHandler.sendEmptyMessageDelayed(4, 1000L);
                }
                this.startTouch(x, y, eventTime);
                if (!this.mIsEditingText) break;
                this.mTouchInEditText = this.mEditTextContentBounds.contains(contentX, contentY);
                break;
            }
            case 2: {
                if (!this.mConfirmMove && deltaX * deltaX + deltaY * deltaY >= this.mTouchSlopSquare) {
                    this.mPrivateHandler.removeMessages(3);
                    this.mPrivateHandler.removeMessages(4);
                    this.mConfirmMove = true;
                    if (this.mTouchMode == 6) {
                        this.mTouchMode = 1;
                    }
                    this.removeTouchHighlight();
                }
                if (this.mSelectingText && this.mSelectionStarted) {
                    ViewParent parent = this.mWebView.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    if (deltaX == 0 && deltaY == 0) break;
                    int handleX = contentX + this.viewToContentDimension(this.mSelectOffset.x);
                    int handleY = contentY + this.viewToContentDimension(this.mSelectOffset.y);
                    this.mSelectDraggingCursor.set(handleX, handleY);
                    boolean inCursorText = this.mSelectDraggingTextQuad.containsPoint(handleX, handleY);
                    boolean inEditBounds = this.mEditTextContentBounds.contains(handleX, handleY);
                    if (this.mIsEditingText && !inEditBounds) {
                        this.beginScrollEdit();
                    } else {
                        this.endScrollEdit();
                    }
                    boolean snapped = false;
                    if (inCursorText || this.mIsEditingText && !inEditBounds) {
                        this.snapDraggingCursor();
                        snapped = true;
                    }
                    this.updateWebkitSelection(snapped);
                    if (!inCursorText && this.mIsEditingText && inEditBounds) {
                        this.snapDraggingCursor();
                    }
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    this.invalidate();
                    break;
                }
                if (this.mTouchMode == 7) break;
                if (this.mVelocityTracker == null) {
                    Log.e(LOGTAG, "Got null mVelocityTracker when  mTouchMode = " + this.mTouchMode);
                } else {
                    this.mVelocityTracker.addMovement(event);
                }
                if (this.mTouchMode != 3 && this.mTouchMode != 9 && this.mTouchMode != 10) {
                    if (!this.mConfirmMove) break;
                    this.mAverageAngle = this.calculateDragAngle(deltaX, deltaY);
                    if (detector == null || !detector.isInProgress()) {
                        if (this.mAverageAngle < 0.25f) {
                            this.mSnapScrollMode = 2;
                            this.mSnapPositive = deltaX > 0;
                            this.mAverageAngle = 0.0f;
                        } else if (this.mAverageAngle > 1.25f) {
                            this.mSnapScrollMode = 4;
                            this.mSnapPositive = deltaY > 0;
                            this.mAverageAngle = 2.0f;
                        }
                    }
                    this.mTouchMode = 3;
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    deltaX = 0;
                    deltaY = 0;
                    this.startScrollingLayer(x, y);
                    this.startDrag();
                }
                boolean keepScrollBarsVisible = false;
                if (deltaX == 0 && deltaY == 0) {
                    keepScrollBarsVisible = true;
                    break;
                }
                this.mAverageAngle += (this.calculateDragAngle(deltaX, deltaY) - this.mAverageAngle) / 5.0f;
                if (this.mSnapScrollMode != 0) {
                    if (this.mSnapScrollMode == 4 && this.mAverageAngle < 0.95f) {
                        this.mSnapScrollMode = 0;
                    }
                    if (this.mSnapScrollMode == 2 && this.mAverageAngle > 0.4f) {
                        this.mSnapScrollMode = 0;
                    }
                } else if (this.mAverageAngle < 0.25f) {
                    this.mSnapScrollMode = 2;
                    this.mSnapPositive = deltaX > 0;
                    this.mAverageAngle = (this.mAverageAngle + 0.0f) / 2.0f;
                } else if (this.mAverageAngle > 1.25f) {
                    this.mSnapScrollMode = 4;
                    this.mSnapPositive = deltaY > 0;
                    this.mAverageAngle = (this.mAverageAngle + 2.0f) / 2.0f;
                }
                if (this.mSnapScrollMode != 0) {
                    if ((this.mSnapScrollMode & 2) == 2) {
                        deltaY = 0;
                    } else {
                        deltaX = 0;
                    }
                }
                if (deltaX * deltaX + deltaY * deltaY > this.mTouchSlopSquare) {
                    this.mHeldMotionless = 0;
                } else {
                    this.mHeldMotionless = 2;
                    keepScrollBarsVisible = true;
                }
                this.mLastTouchTime = eventTime;
                boolean allDrag = this.doDrag(deltaX, deltaY);
                if (allDrag) {
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    break;
                }
                int contentDeltaX = (int)Math.floor((float)deltaX * this.mZoomManager.getInvScale());
                int roundedDeltaX = this.contentToViewDimension(contentDeltaX);
                int contentDeltaY = (int)Math.floor((float)deltaY * this.mZoomManager.getInvScale());
                int roundedDeltaY = this.contentToViewDimension(contentDeltaY);
                this.mLastTouchX -= roundedDeltaX;
                this.mLastTouchY -= roundedDeltaY;
                break;
            }
            case 1: {
                if (this.mIsEditingText && this.mSelectionStarted) {
                    this.endScrollEdit();
                    this.mPrivateHandler.sendEmptyMessageDelayed(153, 16L);
                    if (!this.mConfirmMove && this.mIsCaretSelection) {
                        this.showPasteWindow();
                        this.stopTouch();
                        break;
                    }
                }
                this.mLastTouchUpTime = eventTime;
                if (this.mSentAutoScrollMessage) {
                    this.mAutoScrollY = 0;
                    this.mAutoScrollX = 0;
                }
                switch (this.mTouchMode) {
                    case 6: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        this.mTouchMode = 7;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (!this.mConfirmMove) {
                            if (this.mSelectingText) {
                                if (this.mSelectionStarted) break;
                                this.selectionDone();
                                break;
                            }
                            if (this.mTouchMode != 1 || !this.canZoomIn() && !this.canZoomOut()) break;
                            this.mPrivateHandler.sendEmptyMessageDelayed(5, ViewConfiguration.getDoubleTapTimeout());
                            break;
                        }
                    }
                    case 3: 
                    case 9: 
                    case 10: {
                        this.mPrivateHandler.removeMessages(8);
                        if (eventTime - this.mLastTouchTime <= 250L) {
                            if (this.mVelocityTracker == null) {
                                Log.e(LOGTAG, "Got null mVelocityTracker");
                            } else {
                                this.mVelocityTracker.addMovement(event);
                            }
                            this.mHeldMotionless = 3;
                            this.doFling();
                            break;
                        }
                        if (this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY())) {
                            this.invalidate();
                        }
                        this.mHeldMotionless = 2;
                        this.invalidate();
                    }
                    case 2: {
                        this.mLastVelocity = 0.0f;
                        WebViewCore.resumePriority();
                        if (this.mSelectingText) break;
                        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    }
                }
                this.stopTouch();
                break;
            }
            case 3: {
                if (this.mTouchMode == 3) {
                    this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY());
                    this.invalidate();
                }
                this.cancelTouch();
            }
        }
    }

    private static float getTextScrollSpeed(int coordinate, int min, int max) {
        if (coordinate < min) {
            return (float)(coordinate - min) * 0.01f;
        }
        if (coordinate >= max) {
            return (float)(coordinate - max + 1) * 0.01f;
        }
        return 0.0f;
    }

    private static int getSelectionCoordinate(int coordinate, int min, int max) {
        return Math.max(Math.min(coordinate, max), min);
    }

    private void beginScrollEdit() {
        if (this.mLastEditScroll == 0L) {
            this.mLastEditScroll = SystemClock.uptimeMillis() - 16L;
            this.scrollEditWithCursor();
        }
    }

    private void scrollDraggedSelectionHandleIntoView() {
        if (this.mSelectDraggingCursor == null) {
            return;
        }
        int x = this.mSelectDraggingCursor.x;
        int y = this.mSelectDraggingCursor.y;
        if (!this.mEditTextContentBounds.contains(x, y)) {
            int left = Math.min(0, x - this.mEditTextContentBounds.left - 10);
            int right = Math.max(0, x - this.mEditTextContentBounds.right + 10);
            int deltaX = left + right;
            int above = Math.min(0, y - this.mEditTextContentBounds.top - 10);
            int below = Math.max(0, y - this.mEditTextContentBounds.bottom + 10);
            int deltaY = above + below;
            if (deltaX != 0 || deltaY != 0) {
                int scrollX = this.getTextScrollX() + deltaX;
                int scrollY = this.getTextScrollY() + deltaY;
                scrollX = WebViewClassic.clampBetween(scrollX, 0, this.getMaxTextScrollX());
                scrollY = WebViewClassic.clampBetween(scrollY, 0, this.getMaxTextScrollY());
                this.scrollEditText(scrollX, scrollY);
            }
        }
    }

    private void endScrollEdit() {
        this.mLastEditScroll = 0L;
    }

    private static int clampBetween(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    private static int getTextScrollDelta(float speed, long deltaT) {
        float distance = speed * (float)deltaT;
        int intDistance = (int)Math.floor(distance);
        float probability = distance - (float)intDistance;
        if (Math.random() < (double)probability) {
            ++intDistance;
        }
        return intDistance;
    }

    private void scrollEditWithCursor() {
        if (this.mLastEditScroll != 0L) {
            int x = this.viewToContentX(this.mLastTouchX + this.getScrollX() + this.mSelectOffset.x);
            float scrollSpeedX = WebViewClassic.getTextScrollSpeed(x, this.mEditTextContentBounds.left, this.mEditTextContentBounds.right);
            int y = this.viewToContentY(this.mLastTouchY + this.getScrollY() + this.mSelectOffset.y);
            float scrollSpeedY = WebViewClassic.getTextScrollSpeed(y, this.mEditTextContentBounds.top, this.mEditTextContentBounds.bottom);
            if (scrollSpeedX == 0.0f && scrollSpeedY == 0.0f) {
                this.endScrollEdit();
            } else {
                long currentTime = SystemClock.uptimeMillis();
                long timeSinceLastUpdate = currentTime - this.mLastEditScroll;
                int deltaX = WebViewClassic.getTextScrollDelta(scrollSpeedX, timeSinceLastUpdate);
                int deltaY = WebViewClassic.getTextScrollDelta(scrollSpeedY, timeSinceLastUpdate);
                int scrollX = this.getTextScrollX() + deltaX;
                scrollX = WebViewClassic.clampBetween(scrollX, 0, this.getMaxTextScrollX());
                int scrollY = this.getTextScrollY() + deltaY;
                scrollY = WebViewClassic.clampBetween(scrollY, 0, this.getMaxTextScrollY());
                this.mLastEditScroll = currentTime;
                if (scrollX == this.getTextScrollX() && scrollY == this.getTextScrollY()) {
                    this.mPrivateHandler.sendEmptyMessageDelayed(149, 16L);
                } else {
                    int selectionX = WebViewClassic.getSelectionCoordinate(x, this.mEditTextContentBounds.left, this.mEditTextContentBounds.right);
                    int selectionY = WebViewClassic.getSelectionCoordinate(y, this.mEditTextContentBounds.top, this.mEditTextContentBounds.bottom);
                    int oldX = this.mSelectDraggingCursor.x;
                    int oldY = this.mSelectDraggingCursor.y;
                    this.mSelectDraggingCursor.set(selectionX, selectionY);
                    this.updateWebkitSelection(false);
                    this.scrollEditText(scrollX, scrollY);
                    this.mSelectDraggingCursor.set(oldX, oldY);
                }
            }
        }
    }

    private void startTouch(float x, float y, long eventTime) {
        this.mStartTouchX = this.mLastTouchX = Math.round(x);
        this.mStartTouchY = this.mLastTouchY = Math.round(y);
        this.mLastTouchTime = eventTime;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mSnapScrollMode = 0;
    }

    private void startDrag() {
        WebViewCore.reducePriority();
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        this.nativeSetIsScrolling(true);
        if (this.mHorizontalScrollBarMode != 1 || this.mVerticalScrollBarMode != 1) {
            this.mZoomManager.invokeZoomPicker();
        }
    }

    private boolean doDrag(int deltaX, int deltaY) {
        boolean allDrag = true;
        if ((deltaX | deltaY) != 0) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int rangeX = this.computeMaxScrollX();
            int rangeY = this.computeMaxScrollY();
            int contentX = (int)Math.floor((float)deltaX * this.mZoomManager.getInvScale());
            int contentY = (int)Math.floor((float)deltaY * this.mZoomManager.getInvScale());
            this.mTouchMode = 3;
            if (this.mIsEditingText && this.mTouchInEditText && this.canTextScroll(deltaX, deltaY)) {
                oldX = this.getTextScrollX();
                rangeX = this.getMaxTextScrollX();
                deltaX = contentX;
                oldY = this.getTextScrollY();
                rangeY = this.getMaxTextScrollY();
                deltaY = contentY;
                this.mTouchMode = 10;
                allDrag = false;
            } else if (this.mCurrentScrollingLayerId != 0) {
                int maxX = this.mScrollingLayerRect.right;
                int maxY = this.mScrollingLayerRect.bottom;
                int resultX = WebViewClassic.clampBetween(maxX, 0, this.mScrollingLayerRect.left + contentX);
                int resultY = WebViewClassic.clampBetween(maxY, 0, this.mScrollingLayerRect.top + contentY);
                if (resultX != this.mScrollingLayerRect.left || resultY != this.mScrollingLayerRect.top || (contentX | contentY) == 0) {
                    this.mTouchMode = 9;
                    deltaX = contentX;
                    deltaY = contentY;
                    oldX = this.mScrollingLayerRect.left;
                    oldY = this.mScrollingLayerRect.top;
                    rangeX = maxX;
                    rangeY = maxY;
                    allDrag = false;
                }
            }
            if (this.mOverScrollGlow != null) {
                this.mOverScrollGlow.setOverScrollDeltas(deltaX, deltaY);
            }
            this.mWebViewPrivate.overScrollBy(deltaX, deltaY, oldX, oldY, rangeX, rangeY, this.mOverscrollDistance, this.mOverscrollDistance, true);
            if (this.mOverScrollGlow != null && this.mOverScrollGlow.isAnimating()) {
                this.invalidate();
            }
        }
        this.mZoomManager.keepZoomPickerVisible();
        return allDrag;
    }

    private void stopTouch() {
        if (this.mScroller.isFinished() && !this.mSelectingText && (this.mTouchMode == 3 || this.mTouchMode == 9)) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            this.nativeSetIsScrolling(false);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mOverScrollGlow != null) {
            this.mOverScrollGlow.releaseAll();
        }
        if (this.mSelectingText) {
            this.mSelectionStarted = false;
            this.syncSelectionCursors();
            if (this.mIsCaretSelection) {
                this.resetCaretTimer();
            }
            this.invalidate();
        }
    }

    private void cancelTouch() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (!(this.mTouchMode != 3 && this.mTouchMode != 9 || this.mSelectingText)) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            this.nativeSetIsScrolling(false);
        }
        this.mPrivateHandler.removeMessages(3);
        this.mPrivateHandler.removeMessages(4);
        this.mPrivateHandler.removeMessages(8);
        this.removeTouchHighlight();
        this.mHeldMotionless = 2;
        this.mTouchMode = 7;
    }

    private void snapDraggingCursor() {
        float scale = WebViewClassic.scaleAlongSegment(this.mSelectDraggingCursor.x, this.mSelectDraggingCursor.y, this.mSelectDraggingTextQuad.p4, this.mSelectDraggingTextQuad.p3);
        scale = Math.max(0.0f, scale);
        scale = Math.min(scale, 1.0f);
        float newX = WebViewClassic.scaleCoordinate(scale, this.mSelectDraggingTextQuad.p4.x, this.mSelectDraggingTextQuad.p3.x);
        float newY = WebViewClassic.scaleCoordinate(scale, this.mSelectDraggingTextQuad.p4.y, this.mSelectDraggingTextQuad.p3.y);
        int x = Math.round(newX);
        int y = Math.round(newY);
        if (this.mIsEditingText) {
            x = WebViewClassic.clampBetween(x, this.mEditTextContentBounds.left, this.mEditTextContentBounds.right);
            y = WebViewClassic.clampBetween(y, this.mEditTextContentBounds.top, this.mEditTextContentBounds.bottom);
        }
        this.mSelectDraggingCursor.set(x, y);
    }

    private static float scaleCoordinate(float scale, float coord1, float coord2) {
        float diff = coord2 - coord1;
        return coord1 + scale * diff;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    float hscroll;
                    float vscroll;
                    if ((event.getMetaState() & 1) != 0) {
                        vscroll = 0.0f;
                        hscroll = event.getAxisValue(9);
                    } else {
                        vscroll = -event.getAxisValue(9);
                        hscroll = event.getAxisValue(10);
                    }
                    if (hscroll == 0.0f && vscroll == 0.0f) break;
                    int vdelta = (int)(vscroll * this.mWebViewPrivate.getVerticalScrollFactor());
                    int hdelta = (int)(hscroll * this.mWebViewPrivate.getHorizontalScrollFactor());
                    this.abortAnimation();
                    int oldTouchMode = this.mTouchMode;
                    this.startScrollingLayer(event.getX(), event.getY());
                    this.doDrag(hdelta, vdelta);
                    this.mTouchMode = oldTouchMode;
                    return true;
                }
            }
        }
        return this.mWebViewPrivate.super_onGenericMotionEvent(event);
    }

    @Override
    public void setMapTrackballToArrowKeys(boolean setMap) {
        this.mMapTrackballToArrowKeys = setMap;
    }

    void resetTrackballTime() {
        this.mTrackballLastTime = 0L;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        long time = ev.getEventTime();
        if ((ev.getMetaState() & 2) != 0) {
            if (ev.getY() > 0.0f) {
                this.pageDown(true);
            }
            if (ev.getY() < 0.0f) {
                this.pageUp(true);
            }
            return true;
        }
        if (ev.getAction() == 0) {
            if (this.mSelectingText) {
                return true;
            }
            this.mTrackballDown = true;
            if (this.mNativeClass == 0) {
                return false;
            }
            if (this.mWebView.isInTouchMode()) {
                this.mWebView.requestFocusFromTouch();
            }
            return false;
        }
        if (ev.getAction() == 1) {
            this.mPrivateHandler.removeMessages(114);
            this.mTrackballDown = false;
            this.mTrackballUpTime = time;
            if (this.mSelectingText) {
                this.copySelection();
                this.selectionDone();
                return true;
            }
            return false;
        }
        if (this.mMapTrackballToArrowKeys && (ev.getMetaState() & 1) == 0 || AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return false;
        }
        if (this.mTrackballDown) {
            return true;
        }
        if (time - this.mTrackballUpTime < 200L) {
            return true;
        }
        this.switchOutDrawHistory();
        if (time - this.mTrackballLastTime > 200L) {
            this.mTrackballFirstTime = time;
            this.mTrackballYMove = 0;
            this.mTrackballXMove = 0;
        }
        this.mTrackballLastTime = time;
        this.mTrackballRemainsX += ev.getX();
        this.mTrackballRemainsY += ev.getY();
        this.doTrackball(time, ev.getMetaState());
        return true;
    }

    private int scaleTrackballX(float xRate, int width) {
        int xMove;
        int nextXMove = xMove = (int)(xRate / 400.0f * (float)width);
        if (xMove > 0) {
            if (xMove > this.mTrackballXMove) {
                xMove -= this.mTrackballXMove;
            }
        } else if (xMove < this.mTrackballXMove) {
            xMove -= this.mTrackballXMove;
        }
        this.mTrackballXMove = nextXMove;
        return xMove;
    }

    private int scaleTrackballY(float yRate, int height) {
        int yMove;
        int nextYMove = yMove = (int)(yRate / 400.0f * (float)height);
        if (yMove > 0) {
            if (yMove > this.mTrackballYMove) {
                yMove -= this.mTrackballYMove;
            }
        } else if (yMove < this.mTrackballYMove) {
            yMove -= this.mTrackballYMove;
        }
        this.mTrackballYMove = nextYMove;
        return yMove;
    }

    private int keyCodeToSoundsEffect(int keyCode) {
        switch (keyCode) {
            case 19: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 1;
            }
        }
        return 0;
    }

    private void doTrackball(long time, int metaState) {
        int elapsed = (int)(this.mTrackballLastTime - this.mTrackballFirstTime);
        if (elapsed == 0) {
            elapsed = 200;
        }
        float xRate = this.mTrackballRemainsX * 1000.0f / (float)elapsed;
        float yRate = this.mTrackballRemainsY * 1000.0f / (float)elapsed;
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeight();
        float ax = Math.abs(xRate);
        float ay = Math.abs(yRate);
        float maxA = Math.max(ax, ay);
        int width = this.mContentWidth - viewWidth;
        int height = this.mContentHeight - viewHeight;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        ax = Math.abs(this.mTrackballRemainsX * 3.0f);
        ay = Math.abs(this.mTrackballRemainsY * 3.0f);
        maxA = Math.max(ax, ay);
        int count = Math.max(0, (int)maxA);
        int oldScrollX = this.getScrollX();
        int oldScrollY = this.getScrollY();
        if (count > 0) {
            int selectKeyCode = ax < ay ? (this.mTrackballRemainsY < 0.0f ? 19 : 20) : (this.mTrackballRemainsX < 0.0f ? 21 : 22);
            count = Math.min(count, 10);
            if (this.mNativeClass != 0) {
                for (int i = 0; i < count; ++i) {
                    this.letPageHandleNavKey(selectKeyCode, time, true, metaState);
                }
                this.letPageHandleNavKey(selectKeyCode, time, false, metaState);
            }
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
        }
        if (count >= 5) {
            int xMove = this.scaleTrackballX(xRate, width);
            int yMove = this.scaleTrackballY(yRate, height);
            if (Math.abs(this.getScrollX() - oldScrollX) > Math.abs(xMove)) {
                xMove = 0;
            }
            if (Math.abs(this.getScrollY() - oldScrollY) > Math.abs(yMove)) {
                yMove = 0;
            }
            if (xMove != 0 || yMove != 0) {
                this.pinScrollBy(xMove, yMove, true, 0);
            }
        }
    }

    int computeMaxScrollX() {
        return Math.max(this.computeRealHorizontalScrollRange() - this.getViewWidth(), 0);
    }

    int computeMaxScrollY() {
        return Math.max(this.computeRealVerticalScrollRange() + this.getTitleHeight() - this.getViewHeightWithTitle(), 0);
    }

    boolean updateScrollCoordinates(int x, int y) {
        int oldX = this.getScrollX();
        int oldY = this.getScrollY();
        this.setScrollXRaw(x);
        this.setScrollYRaw(y);
        if (oldX != this.getScrollX() || oldY != this.getScrollY()) {
            this.mWebViewPrivate.onScrollChanged(this.getScrollX(), this.getScrollY(), oldX, oldY);
            return true;
        }
        return false;
    }

    @Override
    public void flingScroll(int vx, int vy) {
        this.mScroller.fling(this.getScrollX(), this.getScrollY(), vx, vy, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY(), this.mOverflingDistance, this.mOverflingDistance);
        this.invalidate();
    }

    private void doFling() {
        if (this.mVelocityTracker == null) {
            return;
        }
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFling);
        int vx = (int)this.mVelocityTracker.getXVelocity();
        int vy = (int)this.mVelocityTracker.getYVelocity();
        int scrollX = this.getScrollX();
        int scrollY = this.getScrollY();
        int overscrollDistance = this.mOverscrollDistance;
        int overflingDistance = this.mOverflingDistance;
        if (this.mTouchMode == 9) {
            scrollX = this.mScrollingLayerRect.left;
            scrollY = this.mScrollingLayerRect.top;
            maxX = this.mScrollingLayerRect.right;
            maxY = this.mScrollingLayerRect.bottom;
            overflingDistance = 0;
            overscrollDistance = 0;
        } else if (this.mTouchMode == 10) {
            scrollX = this.getTextScrollX();
            scrollY = this.getTextScrollY();
            maxX = this.getMaxTextScrollX();
            maxY = this.getMaxTextScrollY();
            overflingDistance = 0;
            overscrollDistance = 0;
        }
        if (this.mSnapScrollMode != 0) {
            if ((this.mSnapScrollMode & 2) == 2) {
                vy = 0;
            } else {
                vx = 0;
            }
        }
        if (maxX == 0 && vy == 0 || maxY == 0 && vx == 0) {
            WebViewCore.resumePriority();
            if (!this.mSelectingText) {
                WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            }
            if (this.mScroller.springBack(scrollX, scrollY, 0, maxX, 0, maxY)) {
                this.invalidate();
            }
            return;
        }
        float currentVelocity = this.mScroller.getCurrVelocity();
        float velocity = (float)Math.hypot(vx, vy);
        if (this.mLastVelocity > 0.0f && currentVelocity > 0.0f && velocity > this.mLastVelocity * 0.2f) {
            float deltaR = (float)Math.abs(Math.atan2(this.mLastVelY, this.mLastVelX) - Math.atan2(vy, vx));
            float circle = (float)Math.PI * 2;
            if (deltaR > 5.6548667f || deltaR < 0.62831855f) {
                vx = (int)((float)vx + currentVelocity * this.mLastVelX / this.mLastVelocity);
                vy = (int)((float)vy + currentVelocity * this.mLastVelY / this.mLastVelocity);
                velocity = (float)Math.hypot(vx, vy);
            }
        }
        if ((scrollX == 0 || scrollX == maxX) && Math.abs(vx) < Math.abs(vy)) {
            vx = 0;
        }
        if ((scrollY == 0 || scrollY == maxY) && Math.abs(vy) < Math.abs(vx)) {
            vy = 0;
        }
        if (overscrollDistance < overflingDistance) {
            if (vx > 0 && scrollX == -overscrollDistance || vx < 0 && scrollX == maxX + overscrollDistance) {
                vx = 0;
            }
            if (vy > 0 && scrollY == -overscrollDistance || vy < 0 && scrollY == maxY + overscrollDistance) {
                vy = 0;
            }
        }
        this.mLastVelX = vx;
        this.mLastVelY = vy;
        this.mLastVelocity = velocity;
        this.mScroller.fling(scrollX, scrollY, -vx, -vy, 0, maxX, 0, maxY, maxX == 0 ? 0 : overflingDistance, overflingDistance);
        this.invalidate();
    }

    @Override
    @Deprecated
    public View getZoomControls() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return null;
        }
        return this.mZoomManager.getExternalZoomPicker();
    }

    void dismissZoomControl() {
        this.mZoomManager.dismissZoomPicker();
    }

    float getDefaultZoomScale() {
        return this.mZoomManager.getDefaultScale();
    }

    float getZoomOverviewScale() {
        return this.mZoomManager.getZoomOverviewScale();
    }

    @Override
    public boolean canZoomIn() {
        return this.mZoomManager.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        return this.mZoomManager.canZoomOut();
    }

    @Override
    public boolean zoomIn() {
        return this.mZoomManager.zoomIn();
    }

    @Override
    public boolean zoomOut() {
        return this.mZoomManager.zoomOut();
    }

    boolean isRectFitOnScreen(Rect rect) {
        int rectWidth = rect.width();
        int rectHeight = rect.height();
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeightWithTitle();
        float scale = Math.min((float)viewWidth / (float)rectWidth, (float)viewHeight / (float)rectHeight);
        return !this.mZoomManager.willScaleTriggerZoom(scale = this.mZoomManager.computeScaleWithLimits(scale)) && this.contentToViewX(rect.left) >= this.getScrollX() && this.contentToViewX(rect.right) <= this.getScrollX() + viewWidth && this.contentToViewY(rect.top) >= this.getScrollY() && this.contentToViewY(rect.bottom) <= this.getScrollY() + viewHeight;
    }

    void centerFitRect(Rect rect) {
        int rectWidth = rect.width();
        int rectHeight = rect.height();
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeightWithTitle();
        float scale = Math.min((float)viewWidth / (float)rectWidth, (float)viewHeight / (float)rectHeight);
        if (!this.mZoomManager.willScaleTriggerZoom(scale = this.mZoomManager.computeScaleWithLimits(scale))) {
            this.pinScrollTo(this.contentToViewX(rect.left + rectWidth / 2) - viewWidth / 2, this.contentToViewY(rect.top + rectHeight / 2) - viewHeight / 2, true, 0);
        } else {
            float actualScale = this.mZoomManager.getScale();
            float oldScreenX = (float)rect.left * actualScale - (float)this.getScrollX();
            float rectViewX = (float)rect.left * scale;
            float rectViewWidth = (float)rectWidth * scale;
            float newMaxWidth = (float)this.mContentWidth * scale;
            float newScreenX = ((float)viewWidth - rectViewWidth) / 2.0f;
            if (newScreenX > rectViewX) {
                newScreenX = rectViewX;
            } else if (newScreenX > newMaxWidth - rectViewX - rectViewWidth) {
                newScreenX = (float)viewWidth - (newMaxWidth - rectViewX);
            }
            float zoomCenterX = (oldScreenX * scale - newScreenX * actualScale) / (scale - actualScale);
            float oldScreenY = (float)rect.top * actualScale + (float)this.getTitleHeight() - (float)this.getScrollY();
            float rectViewY = (float)rect.top * scale + (float)this.getTitleHeight();
            float rectViewHeight = (float)rectHeight * scale;
            float newMaxHeight = (float)this.mContentHeight * scale + (float)this.getTitleHeight();
            float newScreenY = ((float)viewHeight - rectViewHeight) / 2.0f;
            if (newScreenY > rectViewY) {
                newScreenY = rectViewY;
            } else if (newScreenY > newMaxHeight - rectViewY - rectViewHeight) {
                newScreenY = (float)viewHeight - (newMaxHeight - rectViewY);
            }
            float zoomCenterY = (oldScreenY * scale - newScreenY * actualScale) / (scale - actualScale);
            this.mZoomManager.setZoomCenter(zoomCenterX, zoomCenterY);
            this.mZoomManager.startZoomAnimation(scale, false);
        }
    }

    private void overrideLoading(String url) {
        this.mCallbackProxy.uiOverrideUrlLoading(url);
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.mWebViewCore == null) {
            return false;
        }
        if (this.mFindIsUp) {
            return false;
        }
        boolean result = false;
        result = this.mWebViewPrivate.super_requestFocus(direction, previouslyFocusedRect);
        if (this.mWebViewCore.getSettings().getNeedInitialFocus() && !this.mWebView.isInTouchMode()) {
            int fakeKeyDirection = 0;
            switch (direction) {
                case 33: {
                    fakeKeyDirection = 19;
                    break;
                }
                case 130: {
                    fakeKeyDirection = 20;
                    break;
                }
                case 17: {
                    fakeKeyDirection = 21;
                    break;
                }
                case 66: {
                    fakeKeyDirection = 22;
                    break;
                }
                default: {
                    return result;
                }
            }
            this.mWebViewCore.sendMessage(224, fakeKeyDirection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int measuredHeight = heightSize;
        int measuredWidth = widthSize;
        int contentHeight = this.contentToViewDimension(this.mContentHeight);
        int contentWidth = this.contentToViewDimension(this.mContentWidth);
        if (heightMode != 0x40000000) {
            this.mHeightCanMeasure = true;
            measuredHeight = contentHeight;
            if (heightMode == Integer.MIN_VALUE && measuredHeight > heightSize) {
                measuredHeight = heightSize;
                this.mHeightCanMeasure = false;
                measuredHeight |= 0x1000000;
            }
        } else {
            this.mHeightCanMeasure = false;
        }
        if (this.mNativeClass != 0) {
            this.nativeSetHeightCanMeasure(this.mHeightCanMeasure);
        }
        if (widthMode == 0) {
            this.mWidthCanMeasure = true;
            measuredWidth = contentWidth;
        } else {
            if (measuredWidth < contentWidth) {
                measuredWidth |= 0x1000000;
            }
            this.mWidthCanMeasure = false;
        }
        WebViewClassic webViewClassic = this;
        synchronized (webViewClassic) {
            this.mWebViewPrivate.setMeasuredDimension(measuredWidth, measuredHeight);
        }
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (this.mZoomManager.isFixedLengthAnimationInProgress()) {
            return false;
        }
        rect.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        Rect content = new Rect(this.viewToContentX(this.getScrollX()), this.viewToContentY(this.getScrollY()), this.viewToContentX(this.getScrollX() + this.getWidth() - this.mWebView.getVerticalScrollbarWidth()), this.viewToContentY(this.getScrollY() + this.getViewHeightWithTitle()));
        int screenTop = this.contentToViewY(content.top);
        int screenBottom = this.contentToViewY(content.bottom);
        int height = screenBottom - screenTop;
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom) {
            int oneThirdOfScreenHeight = height / 3;
            scrollYDelta = rect.height() > 2 * oneThirdOfScreenHeight ? rect.top - screenTop : rect.top - (screenTop + oneThirdOfScreenHeight);
        } else if (rect.top < screenTop) {
            scrollYDelta = rect.top - screenTop;
        }
        int screenLeft = this.contentToViewX(content.left);
        int screenRight = this.contentToViewX(content.right);
        int width = screenRight - screenLeft;
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
        } else if (rect.left < screenLeft) {
            scrollXDelta -= screenLeft - rect.left;
        }
        if ((scrollYDelta | scrollXDelta) != 0) {
            return this.pinScrollBy(scrollXDelta, scrollYDelta, !immediate, 0);
        }
        return false;
    }

    void replaceTextfieldText(int oldStart, int oldEnd, String replace, int newStart, int newEnd) {
        WebViewCore.ReplaceTextData arg = new WebViewCore.ReplaceTextData();
        arg.mReplace = replace;
        arg.mNewStart = newStart;
        arg.mNewEnd = newEnd;
        ++this.mTextGeneration;
        arg.mTextGeneration = this.mTextGeneration;
        this.sendBatchableInputMessage(114, oldStart, oldEnd, arg);
    }

    void passToJavaScript(String currentText, KeyEvent event) {
        if (this.mWebViewCore == null) {
            return;
        }
        WebViewCore.JSKeyData arg = new WebViewCore.JSKeyData();
        arg.mEvent = event;
        arg.mCurrentText = currentText;
        ++this.mTextGeneration;
        this.mWebViewCore.sendMessage(115, this.mTextGeneration, 0, arg);
        this.mWebViewCore.removeMessages(128);
        this.mWebViewCore.sendMessageDelayed(128, null, 1000L);
    }

    public synchronized WebViewCore getWebViewCore() {
        return this.mWebViewCore;
    }

    private boolean canTextScroll(int directionX, int directionY) {
        boolean canScrollX;
        int scrollX = this.getTextScrollX();
        int scrollY = this.getTextScrollY();
        int maxScrollX = this.getMaxTextScrollX();
        int maxScrollY = this.getMaxTextScrollY();
        boolean bl = directionX > 0 ? scrollX < maxScrollX : (canScrollX = scrollX > 0);
        boolean canScrollY = directionY > 0 ? scrollY < maxScrollY : scrollY > 0;
        return canScrollX || canScrollY;
    }

    private int getTextScrollX() {
        return -this.mEditTextContent.left;
    }

    private int getTextScrollY() {
        return -this.mEditTextContent.top;
    }

    private int getMaxTextScrollX() {
        return Math.max(0, this.mEditTextContent.width() - this.mEditTextContentBounds.width());
    }

    private int getMaxTextScrollY() {
        return Math.max(0, this.mEditTextContent.height() - this.mEditTextContentBounds.height());
    }

    private void setHitTestTypeFromUrl(String url) {
        String substr = null;
        if (url.startsWith(SCHEME_GEO)) {
            this.mInitialHitTestResult.setType(3);
            substr = url.substring(SCHEME_GEO.length());
        } else if (url.startsWith(SCHEME_TEL)) {
            this.mInitialHitTestResult.setType(2);
            substr = url.substring(SCHEME_TEL.length());
        } else if (url.startsWith(SCHEME_MAILTO)) {
            this.mInitialHitTestResult.setType(4);
            substr = url.substring(SCHEME_MAILTO.length());
        } else {
            this.mInitialHitTestResult.setType(7);
            this.mInitialHitTestResult.setExtra(url);
            return;
        }
        try {
            this.mInitialHitTestResult.setExtra(URLDecoder.decode(substr, "UTF-8"));
        }
        catch (Throwable e) {
            Log.w(LOGTAG, "Failed to decode URL! " + substr, e);
            this.mInitialHitTestResult.setType(0);
        }
    }

    private void setHitTestResult(WebViewCore.WebKitHitTest hit) {
        if (hit == null) {
            this.mInitialHitTestResult = null;
            return;
        }
        this.mInitialHitTestResult = new WebView.HitTestResult();
        if (hit.mLinkUrl != null) {
            this.setHitTestTypeFromUrl(hit.mLinkUrl);
            if (hit.mImageUrl != null && this.mInitialHitTestResult.getType() == 7) {
                this.mInitialHitTestResult.setType(8);
                this.mInitialHitTestResult.setExtra(hit.mImageUrl);
            }
        } else if (hit.mImageUrl != null) {
            this.mInitialHitTestResult.setType(5);
            this.mInitialHitTestResult.setExtra(hit.mImageUrl);
        } else if (hit.mEditable) {
            this.mInitialHitTestResult.setType(9);
        } else if (hit.mIntentUrl != null) {
            this.setHitTestTypeFromUrl(hit.mIntentUrl);
        }
    }

    private boolean shouldDrawHighlightRect() {
        if (this.mFocusedNode == null || this.mInitialHitTestResult == null) {
            return false;
        }
        if (this.mTouchHighlightRegion.isEmpty()) {
            return false;
        }
        if (this.mFocusedNode.mHasFocus && !this.mWebView.isInTouchMode()) {
            return this.mDrawCursorRing && !this.mFocusedNode.mEditable;
        }
        if (this.mFocusedNode.mHasFocus && this.mFocusedNode.mEditable) {
            return false;
        }
        return this.mShowTapHighlight;
    }

    private boolean shouldAnimateTo(WebViewCore.WebKitHitTest hit) {
        return false;
    }

    private void setTouchHighlightRects(WebViewCore.WebKitHitTest hit) {
        Rect[] rects;
        FocusTransitionDrawable transition = null;
        if (this.shouldAnimateTo(hit)) {
            transition = new FocusTransitionDrawable(this);
        }
        Rect[] rectArray = rects = hit != null ? hit.mTouchRects : null;
        if (!this.mTouchHighlightRegion.isEmpty()) {
            this.mWebView.invalidate(this.mTouchHighlightRegion.getBounds());
            if (transition != null) {
                transition.mPreviousRegion = new Region(this.mTouchHighlightRegion);
            }
            this.mTouchHighlightRegion.setEmpty();
        }
        if (rects != null) {
            this.mTouchHightlightPaint.setColor(hit.mTapHighlightColor);
            for (Rect rect : rects) {
                Rect viewRect = this.contentToViewRect(rect);
                if (viewRect.width() >= this.getWidth() >> 1 && viewRect.height() >= this.getHeight() >> 1) continue;
                this.mTouchHighlightRegion.union(viewRect);
            }
            this.mWebView.invalidate(this.mTouchHighlightRegion.getBounds());
            if (transition != null && transition.mPreviousRegion != null) {
                transition.mNewRegion = new Region(this.mTouchHighlightRegion);
                this.mFocusTransition = transition;
                ObjectAnimator animator2 = ObjectAnimator.ofFloat(this.mFocusTransition, "progress", 1.0f);
                animator2.start();
            }
        }
    }

    protected void pageSwapCallback(boolean notifyAnimationStarted) {
        this.mWebViewCore.resumeWebKitDraw();
        if (notifyAnimationStarted) {
            this.mWebViewCore.sendMessage(196);
        }
        if (this.mWebView instanceof PageSwapDelegate) {
            ((PageSwapDelegate)((Object)this.mWebView)).onPageSwapOccurred(notifyAnimationStarted);
        }
        if (this.mPictureListener != null) {
            this.mPictureListener.onNewPicture(this.getWebView(), this.capturePicture());
        }
    }

    void setNewPicture(WebViewCore.DrawData draw, boolean updateBaseLayer) {
        boolean isPictureAfterFirstLayout;
        if (this.mNativeClass == 0) {
            if (this.mDelaySetPicture != null) {
                throw new IllegalStateException("Tried to setNewPicture with a delay picture already set! (memory leak)");
            }
            this.mDelaySetPicture = draw;
            return;
        }
        WebViewCore.ViewState viewState = draw.mViewState;
        boolean bl = isPictureAfterFirstLayout = viewState != null;
        if (updateBaseLayer) {
            this.setBaseLayer(draw.mBaseLayer, this.getSettings().getShowVisualIndicator(), isPictureAfterFirstLayout);
        }
        Point viewSize = draw.mViewSize;
        boolean updateLayout = viewSize.x == this.mLastWidthSent && viewSize.y == this.mLastHeightSent;
        this.mSendScrollEvent = false;
        this.recordNewContentSize(draw.mContentSize.x, draw.mContentSize.y, updateLayout);
        if (isPictureAfterFirstLayout) {
            this.mLastWidthSent = 0;
            this.mZoomManager.onFirstLayout(draw);
            int scrollX = viewState.mShouldStartScrolledRight ? this.getContentWidth() : viewState.mScrollX;
            int scrollY = viewState.mScrollY;
            this.contentScrollTo(scrollX, scrollY, false);
            if (!this.mDrawHistory) {
                this.hideSoftKeyboard();
            }
        }
        this.mSendScrollEvent = true;
        int functor = 0;
        boolean forceInval = isPictureAfterFirstLayout;
        ViewRootImpl viewRoot = this.mWebView.getViewRootImpl();
        if (this.mWebView.isHardwareAccelerated() && this.mWebView.getLayerType() != 1 && viewRoot != null && (functor = this.nativeGetDrawGLFunction(this.mNativeClass)) != 0) {
            forceInval |= !viewRoot.attachFunctor(functor);
        }
        if (functor == 0 || forceInval || this.mWebView.getLayerType() != 0) {
            this.mWebView.invalidate();
        }
        if (this.mZoomManager.onNewPicture(draw)) {
            this.invalidate();
        }
        if (isPictureAfterFirstLayout) {
            this.mViewManager.postReadyToDrawAll();
        }
        this.scrollEditWithCursor();
        if (!(this.mPictureListener == null || this.mWebView.isHardwareAccelerated() && this.mWebView.getLayerType() != 1)) {
            this.mPictureListener.onNewPicture(this.getWebView(), this.capturePicture());
        }
    }

    private void updateTextSelectionFromMessage(int nodePointer, int textGeneration, WebViewCore.TextSelectionData data) {
        if (textGeneration == this.mTextGeneration && this.mInputConnection != null && this.mFieldPointer == nodePointer) {
            this.mInputConnection.setSelection(data.mStart, data.mEnd);
        }
        WebViewClassic.nativeSetTextSelection(this.mNativeClass, data.mSelectTextPtr);
        if (data.mSelectionReason == 1 || !this.mSelectingText && data.mStart != data.mEnd && data.mSelectionReason != 2) {
            this.selectionDone();
            this.mShowTextSelectionExtra = true;
            this.invalidate();
            return;
        }
        if (data.mSelectTextPtr != 0 && (data.mStart != data.mEnd || this.mFieldPointer == nodePointer && this.mFieldPointer != 0 || nodePointer == 0 && data.mStart == 0 && data.mEnd == 0)) {
            this.mIsEditingText = this.mFieldPointer == nodePointer && nodePointer != 0;
            boolean bl = this.mIsCaretSelection = data.mStart == data.mEnd && nodePointer != 0;
            if (this.mIsCaretSelection && (this.mInputConnection == null || this.mInputConnection.getEditable().length() == 0)) {
                this.selectionDone();
            } else {
                if (!this.mSelectingText) {
                    this.setupWebkitSelect();
                } else {
                    this.syncSelectionCursors();
                }
                this.animateHandles();
                if (this.mIsCaretSelection) {
                    this.resetCaretTimer();
                }
            }
        } else {
            this.selectionDone();
        }
        this.invalidate();
    }

    private void scrollEditText(int scrollX, int scrollY) {
        float maxScrollX = this.getMaxTextScrollX();
        float scrollPercentX = (float)scrollX / maxScrollX;
        this.mEditTextContent.offsetTo(-scrollX, -scrollY);
        this.mWebViewCore.removeMessages(99);
        this.mWebViewCore.sendMessage(99, 0, scrollY, Float.valueOf(scrollPercentX));
        this.animateHandles();
    }

    private void beginTextBatch() {
        this.mIsBatchingTextChanges = true;
    }

    private void commitTextBatch() {
        if (this.mWebViewCore != null) {
            this.mWebViewCore.sendMessages(this.mBatchedTextChanges);
        }
        this.mBatchedTextChanges.clear();
        this.mIsBatchingTextChanges = false;
    }

    void sendBatchableInputMessage(int what, int arg1, int arg2, Object obj) {
        if (this.mWebViewCore == null) {
            return;
        }
        Message message = Message.obtain(null, what, arg1, arg2, obj);
        if (this.mIsBatchingTextChanges) {
            this.mBatchedTextChanges.add(message);
        } else {
            this.mWebViewCore.sendMessage(message);
        }
    }

    void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selectedArray));
    }

    void requestListBox(String[] array2, int[] enabledArray, int selection) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selection));
    }

    private int getScaledMaxXScroll() {
        int width;
        if (!this.mHeightCanMeasure) {
            width = this.getViewWidth() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            width = visRect.width() / 2;
        }
        return this.viewToContentX(width);
    }

    private int getScaledMaxYScroll() {
        int height;
        if (!this.mHeightCanMeasure) {
            height = this.getViewHeight() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            height = visRect.height() / 2;
        }
        return Math.round((float)height * this.mZoomManager.getInvScale());
    }

    private void viewInvalidate() {
        this.invalidate();
    }

    private void letPageHandleNavKey(int keyCode, long time, boolean down, int metaState) {
        int keyEventAction = down ? 0 : 1;
        KeyEvent event = new KeyEvent(time, time, keyEventAction, keyCode, 1, metaState & 1 | metaState & 2 | metaState & 4, -1, 0, 0);
        this.sendKeyEvent(event);
    }

    private void sendKeyEvent(KeyEvent event) {
        int direction = 0;
        switch (event.getKeyCode()) {
            case 20: {
                direction = 130;
                break;
            }
            case 19: {
                direction = 33;
                break;
            }
            case 21: {
                direction = 17;
                break;
            }
            case 22: {
                direction = 66;
                break;
            }
            case 61: {
                int n = direction = event.isShiftPressed() ? 1 : 2;
            }
        }
        if (direction != 0 && this.mWebView.focusSearch(direction) == null) {
            direction = 0;
        }
        int eventHubAction = 104;
        if (event.getAction() == 0) {
            eventHubAction = 103;
            int sound = this.keyCodeToSoundsEffect(event.getKeyCode());
            if (sound != 0) {
                this.mWebView.playSoundEffect(sound);
            }
        }
        this.sendBatchableInputMessage(eventHubAction, direction, 0, event);
    }

    @Override
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.mWebViewCore.sendMessage(126, color2);
    }

    public void setHTML5VideoViewProxy(HTML5VideoViewProxy proxy) {
        this.mHTML5VideoViewProxy = proxy;
    }

    public void setTouchInterval(int interval) {
        this.mCurrentTouchInterval = interval;
    }

    private void copyToClipboard(String text) {
        ClipboardManager cm = (ClipboardManager)this.mContext.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText(this.getTitle(), text);
        cm.setPrimaryClip(clip);
    }

    void autoFillForm(int autoFillQueryId) {
        this.mPrivateHandler.obtainMessage(148, autoFillQueryId, 0).sendToTarget();
    }

    ViewManager getViewManager() {
        return this.mViewManager;
    }

    protected void contentInvalidateAll() {
        if (this.mWebViewCore != null && !this.mBlockWebkitViewMessages) {
            this.mWebViewCore.sendMessage(175);
        }
    }

    public void discardAllTextures() {
        this.nativeDiscardAllTextures();
    }

    @Override
    public void setLayerType(int layerType, Paint paint) {
        this.updateHwAccelerated();
    }

    private void updateHwAccelerated() {
        if (this.mNativeClass == 0) {
            return;
        }
        boolean hwAccelerated = false;
        if (this.mWebView.isHardwareAccelerated() && this.mWebView.getLayerType() != 1) {
            hwAccelerated = true;
        }
        int result = WebViewClassic.nativeSetHwAccelerated(this.mNativeClass, hwAccelerated);
        if (this.mWebViewCore != null && !this.mBlockWebkitViewMessages && result != 0) {
            this.mWebViewCore.contentDraw();
        }
    }

    public void tileProfilingStart() {
        this.nativeTileProfilingStart();
    }

    public float tileProfilingStop() {
        return this.nativeTileProfilingStop();
    }

    public void tileProfilingClear() {
        this.nativeTileProfilingClear();
    }

    public int tileProfilingNumFrames() {
        return this.nativeTileProfilingNumFrames();
    }

    public int tileProfilingNumTilesInFrame(int frame) {
        return this.nativeTileProfilingNumTilesInFrame(frame);
    }

    public int tileProfilingGetInt(int frame, int tile, String key) {
        return this.nativeTileProfilingGetInt(frame, tile, key);
    }

    public float tileProfilingGetFloat(int frame, int tile, String key) {
        return this.nativeTileProfilingGetFloat(frame, tile, key);
    }

    boolean focusCandidateIsEditableText() {
        if (this.mFocusedNode != null) {
            return this.mFocusedNode.mEditable;
        }
        return false;
    }

    private void postInvalidate() {
        this.mWebView.postInvalidate();
    }

    public static void setShouldMonitorWebCoreThread() {
        WebViewCore.setShouldMonitorWebCoreThread();
    }

    @Override
    public void dumpViewHierarchyWithProperties(BufferedWriter out, int level) {
        int layer = this.getBaseLayer();
        if (layer != 0) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ViewStateSerializer.dumpLayerHierarchy(layer, stream, level);
                stream.close();
                byte[] buf = stream.toByteArray();
                out.write(new String(buf, "ascii"));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public View findHierarchyView(String className, int hashCode) {
        if (this.mNativeClass == 0) {
            return null;
        }
        Picture pic = new Picture();
        if (!this.nativeDumpLayerContentToPicture(this.mNativeClass, className, hashCode, pic)) {
            return null;
        }
        return new PictureWrapperView(this.getContext(), pic, this.mWebView);
    }

    private void nativeCreate(int n, String string2, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeCreate(ILjava/lang/String;Z)V", true, this);
    }

    private void nativeDebugDump() {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeDebugDump()V", true, this);
    }

    private static void nativeDestroy(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeDestroy(I)V", true, null);
    }

    private void nativeDraw(Canvas canvas, RectF rectF, int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeDraw(Landroid/graphics/Canvas;Landroid/graphics/RectF;II)V", true, this);
    }

    private void nativeDumpDisplayTree(String string2) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeDumpDisplayTree(Ljava/lang/String;)V", true, this);
    }

    private boolean nativeEvaluateLayersAnimations(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeEvaluateLayersAnimations(I)Z", true, this) != 0;
    }

    private int nativeCreateDrawGLFunction(int n, Rect rect, Rect rect2, RectF rectF, float f, int n2) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeCreateDrawGLFunction(ILandroid/graphics/Rect;Landroid/graphics/Rect;Landroid/graphics/RectF;FI)I", true, this);
    }

    private int nativeGetDrawGLFunction(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeGetDrawGLFunction(I)I", true, this);
    }

    private void nativeUpdateDrawGLFunction(int n, Rect rect, Rect rect2, RectF rectF, float f) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeUpdateDrawGLFunction(ILandroid/graphics/Rect;Landroid/graphics/Rect;Landroid/graphics/RectF;F)V", true, this);
    }

    private String nativeGetSelection() {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewClassic#nativeGetSelection()Ljava/lang/String;", true, this);
    }

    private void nativeSetHeightCanMeasure(boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeSetHeightCanMeasure(Z)V", true, this);
    }

    private boolean nativeSetBaseLayer(int n, int n2, boolean bl, boolean bl2, int n3) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeSetBaseLayer(IIZZI)Z", true, this) != 0;
    }

    private int nativeGetBaseLayer(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeGetBaseLayer(I)I", true, this);
    }

    private void nativeCopyBaseContentToPicture(Picture picture) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeCopyBaseContentToPicture(Landroid/graphics/Picture;)V", true, this);
    }

    private boolean nativeDumpLayerContentToPicture(int n, String string2, int n2, Picture picture) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeDumpLayerContentToPicture(ILjava/lang/String;ILandroid/graphics/Picture;)Z", true, this) != 0;
    }

    private boolean nativeHasContent() {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeHasContent()Z", true, this) != 0;
    }

    private void nativeStopGL(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeStopGL(I)V", true, this);
    }

    private void nativeDiscardAllTextures() {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeDiscardAllTextures()V", true, this);
    }

    private void nativeTileProfilingStart() {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeTileProfilingStart()V", true, this);
    }

    private float nativeTileProfilingStop() {
        return OverrideMethod.invokeF("android.webkit.WebViewClassic#nativeTileProfilingStop()F", true, this);
    }

    private void nativeTileProfilingClear() {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeTileProfilingClear()V", true, this);
    }

    private int nativeTileProfilingNumFrames() {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeTileProfilingNumFrames()I", true, this);
    }

    private int nativeTileProfilingNumTilesInFrame(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeTileProfilingNumTilesInFrame(I)I", true, this);
    }

    private int nativeTileProfilingGetInt(int n, int n2, String string2) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeTileProfilingGetInt(IILjava/lang/String;)I", true, this);
    }

    private float nativeTileProfilingGetFloat(int n, int n2, String string2) {
        return OverrideMethod.invokeF("android.webkit.WebViewClassic#nativeTileProfilingGetFloat(IILjava/lang/String;)F", true, this);
    }

    private void nativeUseHardwareAccelSkia(boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeUseHardwareAccelSkia(Z)V", true, this);
    }

    private int nativeScrollableLayer(int n, int n2, int n3, Rect rect, Rect rect2) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeScrollableLayer(IIILandroid/graphics/Rect;Landroid/graphics/Rect;)I", true, this);
    }

    private boolean nativeScrollLayer(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeScrollLayer(IIII)Z", true, this) != 0;
    }

    private void nativeSetIsScrolling(boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeSetIsScrolling(Z)V", true, this);
    }

    private int nativeGetBackgroundColor(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeGetBackgroundColor(I)I", true, this);
    }

    boolean nativeSetProperty(String string2, String string3) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeSetProperty(Ljava/lang/String;Ljava/lang/String;)Z", true, this) != 0;
    }

    String nativeGetProperty(String string2) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewClassic#nativeGetProperty(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    private static void nativeOnTrimMemory(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeOnTrimMemory(I)V", true, null);
    }

    private static void nativeSetPauseDrawing(int n, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeSetPauseDrawing(IZ)V", true, null);
    }

    private static void nativeSetTextSelection(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeSetTextSelection(II)V", true, null);
    }

    private static int nativeGetHandleLayerId(int n, int n2, Point point, QuadF quadF) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeGetHandleLayerId(IILandroid/graphics/Point;Landroid/webkit/QuadF;)I", true, null);
    }

    private static void nativeMapLayerRect(int n, int n2, Rect rect) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeMapLayerRect(IILandroid/graphics/Rect;)V", true, null);
    }

    private static int nativeSetHwAccelerated(int n, boolean bl) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeSetHwAccelerated(IZ)I", true, null);
    }

    private static void nativeFindMaxVisibleRect(int n, int n2, Rect rect) {
        OverrideMethod.invokeV("android.webkit.WebViewClassic#nativeFindMaxVisibleRect(IILandroid/graphics/Rect;)V", true, null);
    }

    private static boolean nativeIsHandleLeft(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeIsHandleLeft(II)Z", true, null) != 0;
    }

    private static boolean nativeIsPointVisible(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.webkit.WebViewClassic#nativeIsPointVisible(IIII)Z", true, null) != 0;
    }

    static {
        HandlerPrivateDebugString = new String[]{"REMEMBER_PASSWORD", "NEVER_REMEMBER_PASSWORD", "SWITCH_TO_SHORTPRESS", "SWITCH_TO_LONGPRESS", "RELEASE_SINGLE_TAP", "REQUEST_FORM_DATA", "RESUME_WEBCORE_PRIORITY", "DRAG_HELD_MOTIONLESS", "", "PREVENT_DEFAULT_TIMEOUT", "SCROLL_SELECT_TEXT"};
        HandlerPackageDebugString = new String[]{"SCROLL_TO_MSG_ID", "102", "103", "104", "NEW_PICTURE_MSG_ID", "UPDATE_TEXT_ENTRY_MSG_ID", "WEBCORE_INITIALIZED_MSG_ID", "UPDATE_TEXTFIELD_TEXT_MSG_ID", "UPDATE_ZOOM_RANGE", "UNHANDLED_NAV_KEY", "CLEAR_TEXT_ENTRY", "UPDATE_TEXT_SELECTION_MSG_ID", "SHOW_RECT_MSG_ID", "LONG_PRESS_CENTER", "PREVENT_TOUCH_ID", "WEBCORE_NEED_TOUCH_EVENTS", "INVAL_RECT_MSG_ID", "REQUEST_KEYBOARD", "DO_MOTION_UP", "SHOW_FULLSCREEN", "HIDE_FULLSCREEN", "DOM_FOCUS_CHANGED", "REPLACE_BASE_CONTENT", "RETURN_LABEL", "UPDATE_MATCH_COUNT", "CENTER_FIT_RECT", "REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID", "SET_SCROLLBAR_MODES", "SELECTION_STRING_CHANGED", "SET_TOUCH_HIGHLIGHT_RECTS", "SAVE_WEBARCHIVE_FINISHED", "SET_AUTOFILLABLE", "AUTOFILL_COMPLETE", "SELECT_AT", "SCREEN_ON", "ENTER_FULLSCREEN_VIDEO", "UPDATE_SELECTION", "UPDATE_ZOOM_DENSITY"};
        sMaxViewportWidth = 980;
        mLogEvent = true;
        sNotificationsEnabled = true;
        sPackageInstallationReceiverAdded = false;
        sGoogleApps = new HashSet<String>();
        sGoogleApps.add("com.google.android.youtube");
    }

    private static class PictureWrapperView
    extends View {
        Picture mPicture;
        WebView mWebView;

        public PictureWrapperView(Context context, Picture picture, WebView parent) {
            super(context);
            this.mPicture = picture;
            this.mWebView = parent;
            this.setWillNotDraw(false);
            this.setRight(this.mPicture.getWidth());
            this.setBottom(this.mPicture.getHeight());
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawPicture(this.mPicture);
        }

        public boolean post(Runnable action) {
            return this.mWebView.post(action);
        }
    }

    private class InvokeListBox
    implements Runnable {
        private boolean mMultiple;
        private int[] mSelectedArray;
        private int mSelection;
        private Container[] mContainers;

        private InvokeListBox(String[] array2, int[] enabled, int[] selected) {
            this.mMultiple = true;
            this.mSelectedArray = selected;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container();
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        private InvokeListBox(String[] array2, int[] enabled, int selection) {
            this.mSelection = selection;
            this.mMultiple = false;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container();
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        public void run() {
            if (WebViewClassic.this.mWebViewCore == null || WebViewClassic.this.getWebView().getWindowToken() == null || WebViewClassic.this.getWebView().getViewRootImpl() == null) {
                return;
            }
            final ListView listView = (ListView)LayoutInflater.from(WebViewClassic.this.mContext).inflate(17367235, null);
            final MyArrayListAdapter adapter = new MyArrayListAdapter();
            AlertDialog.Builder b = new AlertDialog.Builder(WebViewClassic.this.mContext).setView(listView).setCancelable(true).setInverseBackgroundForced(true);
            if (this.mMultiple) {
                b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        WebViewClassic.this.mWebViewCore.sendMessage(123, adapter.getCount(), 0, listView.getCheckedItemPositions());
                    }
                });
                b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        WebViewClassic.this.mWebViewCore.sendMessage(124, -2, 0);
                    }
                });
            }
            WebViewClassic.this.mListBoxDialog = b.create();
            listView.setAdapter(adapter);
            listView.setFocusableInTouchMode(true);
            listView.setTextFilterEnabled(!this.mMultiple);
            if (this.mMultiple) {
                listView.setChoiceMode(2);
                int length = this.mSelectedArray.length;
                for (int i = 0; i < length; ++i) {
                    listView.setItemChecked(this.mSelectedArray[i], true);
                }
            } else {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    @Override
                    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        WebViewClassic.this.mListBoxMessage = Message.obtain(null, 124, (int)id2, 0);
                        if (WebViewClassic.this.mListBoxDialog != null) {
                            WebViewClassic.this.mListBoxDialog.dismiss();
                            WebViewClassic.this.mListBoxDialog = null;
                        }
                    }
                });
                if (this.mSelection != -1) {
                    listView.setSelection(this.mSelection);
                    listView.setChoiceMode(1);
                    listView.setItemChecked(this.mSelection, true);
                    SingleDataSetObserver observer = new SingleDataSetObserver(adapter.getItemId(this.mSelection), listView, adapter);
                    adapter.registerDataSetObserver(observer);
                }
            }
            WebViewClassic.this.mListBoxDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    WebViewClassic.this.mWebViewCore.sendMessage(124, -2, 0);
                    WebViewClassic.this.mListBoxDialog = null;
                }
            });
            WebViewClassic.this.mListBoxDialog.show();
        }

        private class SingleDataSetObserver
        extends DataSetObserver {
            private long mCheckedId;
            private ListView mListView;
            private Adapter mAdapter;

            public SingleDataSetObserver(long id2, ListView l, Adapter a) {
                this.mCheckedId = id2;
                this.mListView = l;
                this.mAdapter = a;
            }

            public void onChanged() {
                int position = this.mListView.getCheckedItemPosition();
                long id2 = this.mAdapter.getItemId(position);
                if (this.mCheckedId != id2) {
                    this.mListView.clearChoices();
                    int count = this.mAdapter.getCount();
                    for (int i = 0; i < count; ++i) {
                        if (this.mAdapter.getItemId(i) != this.mCheckedId) continue;
                        this.mListView.setItemChecked(i, true);
                        break;
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MyArrayListAdapter
        extends ArrayAdapter<Container> {
            public MyArrayListAdapter() {
                super(WebViewClassic.this.mContext, InvokeListBox.this.mMultiple ? 17367059 : 17367272, InvokeListBox.this.mContainers);
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                convertView = super.getView(position, null, parent);
                Container c = this.item(position);
                if (c != null && 1 != c.mEnabled) {
                    LinearLayout layout2 = new LinearLayout(WebViewClassic.this.mContext);
                    layout2.setOrientation(1);
                    if (position > 0) {
                        View dividerTop = new View(WebViewClassic.this.mContext);
                        dividerTop.setBackgroundResource(17301522);
                        layout2.addView(dividerTop);
                    }
                    if (-1 == c.mEnabled) {
                        if (InvokeListBox.this.mMultiple) {
                            Assert.assertTrue((boolean)(convertView instanceof CheckedTextView));
                            ((CheckedTextView)convertView).setCheckMarkDrawable(null);
                        }
                    } else {
                        convertView.setEnabled(false);
                    }
                    layout2.addView(convertView);
                    if (position < this.getCount() - 1) {
                        View dividerBottom = new View(WebViewClassic.this.mContext);
                        dividerBottom.setBackgroundResource(17301522);
                        layout2.addView(dividerBottom);
                    }
                    return layout2;
                }
                return convertView;
            }

            @Override
            public boolean hasStableIds() {
                return false;
            }

            private Container item(int position) {
                if (position < 0 || position >= this.getCount()) {
                    return null;
                }
                return (Container)this.getItem(position);
            }

            @Override
            public long getItemId(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return -1L;
                }
                return item.mId;
            }

            @Override
            public boolean areAllItemsEnabled() {
                return false;
            }

            @Override
            public boolean isEnabled(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return false;
                }
                return 1 == item.mEnabled;
            }
        }

        private class Container {
            static final int OPTGROUP = -1;
            static final int OPTION_DISABLED = 0;
            static final int OPTION_ENABLED = 1;
            String mString;
            int mEnabled;
            int mId;

            private Container() {
            }

            public String toString() {
                return this.mString;
            }
        }
    }

    public static interface PageSwapDelegate {
        public void onPageSwapOccurred(boolean var1);
    }

    static class FocusTransitionDrawable
    extends Drawable {
        Region mPreviousRegion;
        Region mNewRegion;
        float mProgress = 0.0f;
        WebViewClassic mWebView;
        Paint mPaint;
        int mMaxAlpha;
        Point mTranslate;

        public FocusTransitionDrawable(WebViewClassic view) {
            this.mWebView = view;
            this.mPaint = new Paint(this.mWebView.mTouchHightlightPaint);
            this.mMaxAlpha = this.mPaint.getAlpha();
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public void setAlpha(int alpha) {
        }

        public int getOpacity() {
            return 0;
        }

        public void setProgress(float p) {
            this.mProgress = p;
            if (this.mWebView.mFocusTransition == this) {
                if (this.mProgress == 1.0f) {
                    this.mWebView.mFocusTransition = null;
                }
                this.mWebView.invalidate();
            }
        }

        public float getProgress() {
            return this.mProgress;
        }

        public void draw(Canvas canvas) {
            if (this.mTranslate == null) {
                Rect bounds = this.mPreviousRegion.getBounds();
                Point from = new Point(bounds.centerX(), bounds.centerY());
                this.mNewRegion.getBounds(bounds);
                Point to = new Point(bounds.centerX(), bounds.centerY());
                this.mTranslate = new Point(from.x - to.x, from.y - to.y);
            }
            int alpha = (int)(this.mProgress * (float)this.mMaxAlpha);
            RegionIterator iter = new RegionIterator(this.mPreviousRegion);
            Rect r = new Rect();
            this.mPaint.setAlpha(this.mMaxAlpha - alpha);
            float tx = (float)this.mTranslate.x * this.mProgress;
            float ty = (float)this.mTranslate.y * this.mProgress;
            int save = canvas.save(1);
            canvas.translate(-tx, -ty);
            while (iter.next(r)) {
                canvas.drawRect(r, this.mPaint);
            }
            canvas.restoreToCount(save);
            iter = new RegionIterator(this.mNewRegion);
            r = new Rect();
            this.mPaint.setAlpha(alpha);
            save = canvas.save(1);
            tx = (float)this.mTranslate.x - tx;
            ty = (float)this.mTranslate.y - ty;
            canvas.translate(tx, ty);
            while (iter.next(r)) {
                canvas.drawRect(r, this.mPaint);
            }
            canvas.restoreToCount(save);
        }
    }

    class PrivateHandler
    extends Handler
    implements WebViewInputDispatcher.UiCallbacks {
        PrivateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (WebViewClassic.this.mWebViewCore == null) {
                return;
            }
            if (WebViewClassic.this.mBlockWebkitViewMessages && msg.what != 107) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    WebViewClassic.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), msg.getData().getString("username"), msg.getData().getString("password"));
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 2: {
                    WebViewClassic.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), null, null);
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 11: {
                    if (WebViewClassic.this.mAutoScrollX == 0 && WebViewClassic.this.mAutoScrollY == 0) {
                        WebViewClassic.this.mSentAutoScrollMessage = false;
                        break;
                    }
                    if (WebViewClassic.this.mCurrentScrollingLayerId == 0) {
                        WebViewClassic.this.pinScrollBy(WebViewClassic.this.mAutoScrollX, WebViewClassic.this.mAutoScrollY, true, 0);
                    } else {
                        WebViewClassic.this.scrollLayerTo(((WebViewClassic)WebViewClassic.this).mScrollingLayerRect.left + WebViewClassic.this.mAutoScrollX, ((WebViewClassic)WebViewClassic.this).mScrollingLayerRect.top + WebViewClassic.this.mAutoScrollY);
                    }
                    this.sendEmptyMessageDelayed(11, 16L);
                    break;
                }
                case 101: {
                    InputMethodManager imm;
                    if (msg.arg2 == 1 && ((imm = InputMethodManager.peekInstance()) == null || !imm.isAcceptingText() || !imm.isActive(WebViewClassic.this.mWebView))) break;
                    Point p = (Point)msg.obj;
                    WebViewClassic.this.contentScrollTo(p.x, p.y, msg.arg1 == 1);
                    break;
                }
                case 109: {
                    WebViewCore.ViewState viewState = (WebViewCore.ViewState)msg.obj;
                    WebViewClassic.this.mZoomManager.updateZoomRange(viewState, WebViewClassic.this.getViewWidth(), viewState.mScrollX);
                    break;
                }
                case 139: {
                    float density = ((Float)msg.obj).floatValue();
                    WebViewClassic.this.mZoomManager.updateDefaultZoomDensity(density);
                    break;
                }
                case 105: {
                    WebViewCore.DrawData draw = (WebViewCore.DrawData)msg.obj;
                    WebViewClassic.this.setNewPicture(draw, true);
                    break;
                }
                case 107: {
                    String drawableDir = BrowserFrame.getRawResFilename(3, WebViewClassic.this.mContext);
                    WebViewClassic.this.nativeCreate(msg.arg1, drawableDir, ActivityManager.isHighEndGfx());
                    if (WebViewClassic.this.mDelaySetPicture != null) {
                        WebViewClassic.this.setNewPicture(WebViewClassic.this.mDelaySetPicture, true);
                        WebViewClassic.this.mDelaySetPicture = null;
                    }
                    if (WebViewClassic.this.mIsPaused) {
                        WebViewClassic.nativeSetPauseDrawing(WebViewClassic.this.mNativeClass, true);
                    }
                    WebViewClassic.this.mInputDispatcher = new WebViewInputDispatcher(this, WebViewClassic.this.mWebViewCore.getInputDispatcherCallbacks());
                    break;
                }
                case 108: {
                    if (msg.arg2 != WebViewClassic.this.mTextGeneration) break;
                    String text = (String)msg.obj;
                    if (null == text) {
                        text = "";
                    }
                    if (WebViewClassic.this.mInputConnection == null || WebViewClassic.this.mFieldPointer != msg.arg1) break;
                    WebViewClassic.this.mInputConnection.setTextAndKeepSelection(text);
                    break;
                }
                case 112: {
                    WebViewClassic.this.updateTextSelectionFromMessage(msg.arg1, msg.arg2, (WebViewCore.TextSelectionData)msg.obj);
                    break;
                }
                case 110: {
                    int direction = msg.arg1;
                    View focusSearch = WebViewClassic.this.mWebView.focusSearch(direction);
                    if (focusSearch == null || focusSearch == WebViewClassic.this.mWebView) break;
                    focusSearch.requestFocus();
                    break;
                }
                case 111: {
                    WebViewClassic.this.hideSoftKeyboard();
                    break;
                }
                case 117: {
                    Rect r = (Rect)msg.obj;
                    if (r == null) {
                        WebViewClassic.this.invalidate();
                        break;
                    }
                    WebViewClassic.this.viewInvalidate(r.left, r.top, r.right, r.bottom);
                    break;
                }
                case 6: {
                    if (WebViewClassic.this.mFieldPointer != msg.arg1) break;
                    ArrayAdapter adapter = (ArrayAdapter)msg.obj;
                    WebViewClassic.this.mAutoCompletePopup.setAdapter(adapter);
                    break;
                }
                case 114: {
                    WebViewClassic.this.mGotCenterDown = false;
                    WebViewClassic.this.mTrackballDown = false;
                    WebViewClassic.this.mWebView.performLongClick();
                    break;
                }
                case 116: {
                    WebViewClassic.this.mInputDispatcher.setWebKitWantsTouchEvents(msg.arg1 != 0);
                    break;
                }
                case 118: {
                    if (msg.arg1 == 0) {
                        WebViewClassic.this.hideSoftKeyboard();
                        break;
                    }
                    WebViewClassic.this.displaySoftKeyboard(false);
                    break;
                }
                case 8: {
                    WebViewClassic.this.mHeldMotionless = 2;
                    WebViewClassic.this.invalidate();
                    break;
                }
                case 136: {
                    WebViewClassic.this.mWebView.setKeepScreenOn(msg.arg1 == 1);
                    break;
                }
                case 140: {
                    if (WebViewClassic.this.mHTML5VideoViewProxy == null) break;
                    WebViewClassic.this.mHTML5VideoViewProxy.exitFullScreenVideo();
                    break;
                }
                case 120: {
                    View view = (View)msg.obj;
                    int orientation = msg.arg1;
                    int npp = msg.arg2;
                    if (WebViewClassic.this.inFullScreenMode()) {
                        Log.w(WebViewClassic.LOGTAG, "Should not have another full screen.");
                        WebViewClassic.this.dismissFullScreenMode();
                    }
                    WebViewClassic.this.mFullScreenHolder = new PluginFullScreenHolder(WebViewClassic.this, orientation, npp);
                    WebViewClassic.this.mFullScreenHolder.setContentView(view);
                    WebViewClassic.this.mFullScreenHolder.show();
                    WebViewClassic.this.invalidate();
                    break;
                }
                case 121: {
                    WebViewClassic.this.dismissFullScreenMode();
                    break;
                }
                case 113: {
                    WebViewCore.ShowRectData data = (WebViewCore.ShowRectData)msg.obj;
                    int left = WebViewClassic.this.contentToViewX(data.mLeft);
                    int width = WebViewClassic.this.contentToViewDimension(data.mWidth);
                    int maxWidth = WebViewClassic.this.contentToViewDimension(data.mContentWidth);
                    int viewWidth = WebViewClassic.this.getViewWidth();
                    int x = (int)((float)left + data.mXPercentInDoc * (float)width - data.mXPercentInView * (float)viewWidth);
                    x = Math.max(0, Math.min(maxWidth, x + viewWidth) - viewWidth);
                    int top = WebViewClassic.this.contentToViewY(data.mTop);
                    int height = WebViewClassic.this.contentToViewDimension(data.mHeight);
                    int maxHeight = WebViewClassic.this.contentToViewDimension(data.mContentHeight);
                    int viewHeight = WebViewClassic.this.getViewHeight();
                    int y = (int)((float)top + data.mYPercentInDoc * (float)height - data.mYPercentInView * (float)viewHeight);
                    y = Math.max(0, Math.min(maxHeight, y + viewHeight) - viewHeight);
                    y = Math.max(0, y - WebViewClassic.this.getVisibleTitleHeightImpl());
                    WebViewClassic.this.mWebView.scrollTo(x, y);
                    break;
                }
                case 127: {
                    WebViewClassic.this.centerFitRect((Rect)msg.obj);
                    break;
                }
                case 129: {
                    WebViewClassic.this.mHorizontalScrollBarMode = msg.arg1;
                    WebViewClassic.this.mVerticalScrollBarMode = msg.arg2;
                    break;
                }
                case 130: {
                    if (!WebViewClassic.this.isAccessibilityInjectionEnabled()) break;
                    WebViewClassic.this.getAccessibilityInjector().handleSelectionChangedIfNecessary((String)msg.obj);
                    break;
                }
                case 147: {
                    boolean bl = WebViewClassic.this.mIsEditingText = msg.arg1 == WebViewClassic.this.mFieldPointer;
                    if (WebViewClassic.this.mAutoCompletePopup != null && !WebViewClassic.this.mIsEditingText) {
                        WebViewClassic.this.mAutoCompletePopup.clearAdapter();
                    }
                }
                case 131: {
                    WebViewCore.WebKitHitTest hit = (WebViewCore.WebKitHitTest)msg.obj;
                    WebViewClassic.this.mFocusedNode = hit;
                    WebViewClassic.this.setTouchHighlightRects(hit);
                    WebViewClassic.this.setHitTestResult(hit);
                    break;
                }
                case 132: {
                    SaveWebArchiveMessage saveMessage = (SaveWebArchiveMessage)msg.obj;
                    if (saveMessage.mCallback == null) break;
                    saveMessage.mCallback.onReceiveValue(saveMessage.mResultFile);
                    break;
                }
                case 133: {
                    WebViewClassic.this.mAutoFillData = (WebViewCore.AutoFillData)msg.obj;
                    if (WebViewClassic.this.mInputConnection == null) break;
                    WebViewClassic.this.mInputConnection.setAutoFillable(WebViewClassic.this.mAutoFillData.getQueryId());
                    WebViewClassic.this.mAutoCompletePopup.setAutoFillQueryId(WebViewClassic.this.mAutoFillData.getQueryId());
                    break;
                }
                case 134: {
                    if (WebViewClassic.this.mAutoCompletePopup == null) break;
                    ArrayList pastEntries = new ArrayList();
                    WebViewClassic.this.mAutoCompletePopup.setAdapter(new ArrayAdapter(WebViewClassic.this.mContext, 17367270, pastEntries));
                    break;
                }
                case 141: {
                    WebViewClassic.this.copyToClipboard((String)msg.obj);
                    break;
                }
                case 142: {
                    if (WebViewClassic.this.mInputConnection == null) break;
                    WebViewCore.TextFieldInitData initData = (WebViewCore.TextFieldInitData)msg.obj;
                    WebViewClassic.this.mTextGeneration = 0;
                    WebViewClassic.this.mFieldPointer = initData.mFieldPointer;
                    WebViewClassic.this.mInputConnection.initEditorInfo(initData);
                    WebViewClassic.this.mInputConnection.setTextAndKeepSelection(initData.mText);
                    WebViewClassic.this.mEditTextContentBounds.set(initData.mContentBounds);
                    WebViewClassic.this.mEditTextLayerId = initData.mNodeLayerId;
                    WebViewClassic.nativeMapLayerRect(WebViewClassic.this.mNativeClass, WebViewClassic.this.mEditTextLayerId, WebViewClassic.this.mEditTextContentBounds);
                    WebViewClassic.this.mEditTextContent.set(initData.mClientRect);
                    WebViewClassic.this.relocateAutoCompletePopup();
                    break;
                }
                case 143: {
                    String text = (String)msg.obj;
                    int start = msg.arg1;
                    int end = msg.arg2;
                    int cursorPosition = start + text.length();
                    WebViewClassic.this.replaceTextfieldText(start, end, text, cursorPosition, cursorPosition);
                    WebViewClassic.this.selectionDone();
                    break;
                }
                case 126: {
                    int matchIndex;
                    int matchCount;
                    WebViewCore.FindAllRequest request = (WebViewCore.FindAllRequest)msg.obj;
                    if (request == null) {
                        if (WebViewClassic.this.mFindCallback == null) break;
                        WebViewClassic.this.mFindCallback.updateMatchCount(0, 0, true);
                        break;
                    }
                    if (request != WebViewClassic.this.mFindRequest) break;
                    WebViewCore.FindAllRequest findAllRequest = WebViewClassic.this.mFindRequest;
                    synchronized (findAllRequest) {
                        matchCount = request.mMatchCount;
                        matchIndex = request.mMatchIndex;
                    }
                    if (WebViewClassic.this.mFindCallback != null) {
                        WebViewClassic.this.mFindCallback.updateMatchCount(matchIndex, matchCount, false);
                    }
                    if (WebViewClassic.this.mFindListener == null) break;
                    WebViewClassic.this.mFindListener.onFindResultReceived(matchIndex, matchCount, true);
                    break;
                }
                case 144: {
                    if (!WebViewClassic.this.mIsCaretSelection) break;
                    WebViewClassic.this.selectionDone();
                    break;
                }
                case 145: {
                    WebViewClassic.this.sendBatchableInputMessage(223, msg.arg1, 0, null);
                    break;
                }
                case 146: {
                    WebViewClassic.this.relocateAutoCompletePopup();
                    break;
                }
                case 148: {
                    WebViewClassic.this.mWebViewCore.sendMessage(192, msg.arg1, 0);
                    break;
                }
                case 150: {
                    if (msg.arg1 != WebViewClassic.this.mFieldPointer) break;
                    WebViewClassic.this.mEditTextContent.set((Rect)msg.obj);
                    break;
                }
                case 151: {
                    if (WebViewClassic.this.mSelectingText || !WebViewClassic.this.mIsEditingText || !WebViewClassic.this.mIsCaretSelection) break;
                    WebViewClassic.this.setupWebkitSelect();
                    WebViewClassic.this.resetCaretTimer();
                    WebViewClassic.this.showPasteWindow();
                    break;
                }
                case 152: {
                    WebViewClassic.this.mEditTextContentBounds.set((Rect)msg.obj);
                    WebViewClassic.nativeMapLayerRect(WebViewClassic.this.mNativeClass, WebViewClassic.this.mEditTextLayerId, WebViewClassic.this.mEditTextContentBounds);
                    break;
                }
                case 149: {
                    WebViewClassic.this.scrollEditWithCursor();
                    break;
                }
                case 153: {
                    WebViewClassic.this.scrollDraggedSelectionHandleIntoView();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        public Looper getUiLooper() {
            return this.getLooper();
        }

        public void dispatchUiEvent(MotionEvent event, int eventType, int flags) {
            WebViewClassic.this.onHandleUiEvent(event, eventType, flags);
        }

        public Context getContext() {
            return WebViewClassic.this.getContext();
        }

        public boolean shouldInterceptTouchEvent(MotionEvent event) {
            if (!WebViewClassic.this.mSelectingText) {
                return false;
            }
            WebViewClassic.this.ensureSelectionHandles();
            int y = Math.round(event.getY() - (float)WebViewClassic.this.getTitleHeight() + (float)WebViewClassic.this.getScrollY());
            int x = Math.round(event.getX() + (float)WebViewClassic.this.getScrollX());
            boolean isPressingHandle = WebViewClassic.this.mIsCaretSelection ? WebViewClassic.this.mSelectHandleCenter.getBounds().contains(x, y) : WebViewClassic.this.mSelectHandleBaseBounds.contains(x, y) || WebViewClassic.this.mSelectHandleExtentBounds.contains(x, y);
            return isPressingHandle;
        }

        public void showTapHighlight(boolean show) {
            if (WebViewClassic.this.mShowTapHighlight != show) {
                WebViewClassic.this.mShowTapHighlight = show;
                WebViewClassic.this.invalidate();
            }
        }

        public void clearPreviousHitTest() {
            WebViewClassic.this.setHitTestResult(null);
        }
    }

    private class RequestFormData
    implements Runnable {
        private String mName;
        private String mUrl;
        private Message mUpdateMessage;
        private boolean mAutoFillable;
        private boolean mAutoComplete;
        private WebSettingsClassic mWebSettings;

        public RequestFormData(String name, String url, Message msg, boolean autoFillable, boolean autoComplete) {
            this.mName = name;
            this.mUrl = WebTextView.urlForAutoCompleteData(url);
            this.mUpdateMessage = msg;
            this.mAutoFillable = autoFillable;
            this.mAutoComplete = autoComplete;
            this.mWebSettings = WebViewClassic.this.getSettings();
        }

        public void run() {
            ArrayList<String> pastEntries = new ArrayList<String>();
            if (this.mAutoFillable) {
                if (this.mWebSettings != null && this.mWebSettings.getAutoFillProfile() != null) {
                    pastEntries.add(((Object)WebViewClassic.this.mWebView.getResources().getText(17040198)).toString() + " " + WebViewClassic.this.mAutoFillData.getPreviewString());
                    WebViewClassic.this.mAutoCompletePopup.setIsAutoFillProfileSet(true);
                } else {
                    pastEntries.add(((Object)WebViewClassic.this.mWebView.getResources().getText(17040199)).toString());
                    WebViewClassic.this.mAutoCompletePopup.setIsAutoFillProfileSet(false);
                }
            }
            if (this.mAutoComplete) {
                pastEntries.addAll(WebViewClassic.this.mDatabase.getFormData(this.mUrl, this.mName));
            }
            if (pastEntries.size() > 0) {
                ArrayAdapter adapter;
                this.mUpdateMessage.obj = adapter = new ArrayAdapter(WebViewClassic.this.mContext, 17367270, pastEntries);
                this.mUpdateMessage.sendToTarget();
            }
        }
    }

    private class SelectionHandleAlpha {
        private int mAlpha = 0;
        private int mTargetAlpha = 0;

        private SelectionHandleAlpha() {
        }

        public void setAlpha(int alpha) {
            this.mAlpha = alpha;
            WebViewClassic.this.invalidate();
        }

        public int getAlpha() {
            return this.mAlpha;
        }

        public void setTargetAlpha(int alpha) {
            this.mTargetAlpha = alpha;
        }

        public int getTargetAlpha() {
            return this.mTargetAlpha;
        }
    }

    static class ViewSizeData {
        int mWidth;
        int mHeight;
        float mHeightWidthRatio;
        int mActualViewHeight;
        int mTextWrapWidth;
        int mAnchorX;
        int mAnchorY;
        float mScale;
        boolean mIgnoreHeight;

        ViewSizeData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SaveWebArchiveMessage {
        final String mBasename;
        final boolean mAutoname;
        final ValueCallback<String> mCallback;
        String mResultFile;

        SaveWebArchiveMessage(String basename, boolean autoname, ValueCallback<String> callback) {
            this.mBasename = basename;
            this.mAutoname = autoname;
            this.mCallback = callback;
        }
    }

    private static class DestroyNativeRunnable
    implements Runnable {
        private int mNativePtr;

        public DestroyNativeRunnable(int nativePtr) {
            this.mNativePtr = nativePtr;
        }

        public void run() {
            WebViewClassic.nativeDestroy(this.mNativePtr);
        }
    }

    public static interface TitleBarDelegate {
        public int getTitleHeight();

        public void onSetEmbeddedTitleBar(View var1);
    }

    private static class PackageListener
    extends BroadcastReceiver {
        private PackageListener() {
        }

        public void onReceive(Context context, Intent intent) {
            PluginManager pm;
            String action = intent.getAction();
            String packageName = intent.getData().getSchemeSpecificPart();
            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
            if ("android.intent.action.PACKAGE_REMOVED".equals(action) && replacing) {
                return;
            }
            if (sGoogleApps.contains(packageName)) {
                if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                    WebViewCore.sendStaticMessage(185, packageName);
                } else {
                    WebViewCore.sendStaticMessage(186, packageName);
                }
            }
            if ((pm = PluginManager.getInstance(context)).containsPluginPermissionAndSignatures(packageName)) {
                pm.refreshPlugins("android.intent.action.PACKAGE_ADDED".equals(action));
            }
        }
    }

    private static class ProxyReceiver
    extends BroadcastReceiver {
        private ProxyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                WebViewClassic.handleProxyBroadcast(intent);
            }
        }
    }

    private static class TrustStorageListener
    extends BroadcastReceiver {
        private TrustStorageListener() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.security.STORAGE_CHANGED")) {
                WebViewClassic.handleCertTrustChanged();
            }
        }
    }

    static class Factory
    implements WebViewFactoryProvider,
    WebViewFactoryProvider.Statics {
        Factory() {
        }

        public String findAddress(String addr) {
            return WebViewClassic.findAddress(addr);
        }

        public void setPlatformNotificationsEnabled(boolean enable) {
            if (enable) {
                WebViewClassic.enablePlatformNotifications();
            } else {
                WebViewClassic.disablePlatformNotifications();
            }
        }

        public WebViewFactoryProvider.Statics getStatics() {
            return this;
        }

        public WebViewProvider createWebView(WebView webView, WebView.PrivateAccess privateAccess) {
            return new WebViewClassic(webView, privateAccess);
        }

        public GeolocationPermissions getGeolocationPermissions() {
            return GeolocationPermissionsClassic.getInstance();
        }

        public CookieManager getCookieManager() {
            return CookieManagerClassic.getInstance();
        }

        public WebIconDatabase getWebIconDatabase() {
            return WebIconDatabaseClassic.getInstance();
        }

        public WebStorage getWebStorage() {
            return WebStorageClassic.getInstance();
        }

        public WebViewDatabase getWebViewDatabase(Context context) {
            return WebViewDatabaseClassic.getInstance(context);
        }

        public String getDefaultUserAgent(Context context) {
            return WebSettingsClassic.getDefaultUserAgentForLocale(context, Locale.getDefault());
        }
    }

    static class FocusNodeHref {
        static final String TITLE = "title";
        static final String URL = "url";
        static final String SRC = "src";

        FocusNodeHref() {
        }
    }

    private static class OnTrimMemoryListener
    implements ComponentCallbacks2 {
        private static OnTrimMemoryListener sInstance = null;

        static void init(Context c) {
            if (sInstance == null) {
                sInstance = new OnTrimMemoryListener(c.getApplicationContext());
            }
        }

        private OnTrimMemoryListener(Context c) {
            c.registerComponentCallbacks(this);
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }

        public void onTrimMemory(int level) {
            if (level > 20) {
                HTML5VideoInline.cleanupSurfaceTexture();
                HTML5VideoView.release();
            }
            WebViewClassic.nativeOnTrimMemory(level);
        }
    }

    private class PastePopupWindow
    extends PopupWindow
    implements View.OnClickListener {
        private ViewGroup mContentView;
        private TextView mPasteTextView;

        public PastePopupWindow() {
            super(WebViewClassic.this.mContext, null, 16843464);
            this.setClippingEnabled(true);
            LinearLayout linearLayout = new LinearLayout(WebViewClassic.this.mContext);
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17302982);
            LayoutInflater inflater = (LayoutInflater)WebViewClassic.this.mContext.getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mPasteTextView = (TextView)inflater.inflate(17367252, null);
            this.mPasteTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mPasteTextView);
            this.mPasteTextView.setText(17039371);
            this.mPasteTextView.setOnClickListener(this);
            this.setContentView(this.mContentView);
        }

        public void show(Point cursorBottom, Point cursorTop, int windowLeft, int windowTop) {
            this.measureContent();
            int width = this.mContentView.getMeasuredWidth();
            int height = this.mContentView.getMeasuredHeight();
            int y = cursorTop.y - height;
            int x = cursorTop.x - width / 2;
            if (y < windowTop) {
                WebViewClassic.this.ensureSelectionHandles();
                y = cursorBottom.y + WebViewClassic.this.mSelectHandleCenter.getIntrinsicHeight();
                x = cursorBottom.x - width / 2;
            }
            if (x < windowLeft) {
                x = windowLeft;
            }
            if (!this.isShowing()) {
                this.showAtLocation(WebViewClassic.this.mWebView, 0, x, y);
            }
            this.update(x, y, width, height);
        }

        public void hide() {
            this.dismiss();
        }

        public void onClick(View view) {
            WebViewClassic.this.pasteFromClipboard();
            WebViewClassic.this.selectionDone();
        }

        protected void measureContent() {
            DisplayMetrics displayMetrics = WebViewClassic.this.mContext.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }
    }

    class WebViewInputConnection
    extends BaseInputConnection {
        private KeyCharacterMap mKeyCharacterMap;
        private boolean mIsKeySentByMe;
        private int mInputType;
        private int mImeOptions;
        private String mHint;
        private int mMaxLength;
        private boolean mIsAutoFillable;
        private boolean mIsAutoCompleteEnabled;
        private String mName;
        private int mBatchLevel;

        public WebViewInputConnection() {
            super(WebViewClassic.this.mWebView, true);
        }

        public void setAutoFillable(int queryId) {
            this.mIsAutoFillable = WebViewClassic.this.getSettings().getAutoFillEnabled() && queryId != -1;
            int variation = this.mInputType & 0xFF0;
            if (variation != 224 && (this.mIsAutoFillable || this.mIsAutoCompleteEnabled) && this.mName != null && this.mName.length() > 0) {
                WebViewClassic.this.requestFormData(this.mName, WebViewClassic.this.mFieldPointer, this.mIsAutoFillable, this.mIsAutoCompleteEnabled);
            }
        }

        public boolean beginBatchEdit() {
            if (this.mBatchLevel == 0) {
                WebViewClassic.this.beginTextBatch();
            }
            ++this.mBatchLevel;
            return false;
        }

        public boolean endBatchEdit() {
            --this.mBatchLevel;
            if (this.mBatchLevel == 0) {
                WebViewClassic.this.commitTextBatch();
            }
            return false;
        }

        public boolean getIsAutoFillable() {
            return this.mIsAutoFillable;
        }

        public boolean sendKeyEvent(KeyEvent event) {
            if (!this.mIsKeySentByMe) {
                if (event.getAction() == 1) {
                    if (event.getKeyCode() == 67) {
                        return this.deleteSurroundingText(1, 0);
                    }
                    if (event.getKeyCode() == 112) {
                        return this.deleteSurroundingText(0, 1);
                    }
                    if (event.getUnicodeChar() != 0) {
                        String newComposingText = Character.toString((char)event.getUnicodeChar());
                        return this.commitText(newComposingText, 1);
                    }
                } else if (event.getAction() == 0 && (event.getKeyCode() == 67 || event.getKeyCode() == 112 || event.getUnicodeChar() != 0)) {
                    return true;
                }
            }
            return super.sendKeyEvent(event);
        }

        public void setTextAndKeepSelection(CharSequence text) {
            Editable editable = this.getEditable();
            int selectionStart = Selection.getSelectionStart(editable);
            int selectionEnd = Selection.getSelectionEnd(editable);
            text = this.limitReplaceTextByMaxLength(text, editable.length());
            editable.replace(0, editable.length(), text);
            this.restartInput();
            selectionStart = Math.min(selectionStart, editable.length());
            selectionEnd = Math.min(selectionEnd, editable.length());
            this.setSelection(selectionStart, selectionEnd);
            this.finishComposingText();
        }

        public void replaceSelection(CharSequence text) {
            Editable editable = this.getEditable();
            int selectionStart = Selection.getSelectionStart(editable);
            int selectionEnd = Selection.getSelectionEnd(editable);
            text = this.limitReplaceTextByMaxLength(text, selectionEnd - selectionStart);
            this.setNewText(selectionStart, selectionEnd, text);
            editable.replace(selectionStart, selectionEnd, text);
            this.restartInput();
            int newCaret = selectionStart + text.length();
            this.setSelection(newCaret, newCaret);
        }

        public boolean setComposingText(CharSequence text, int newCursorPosition) {
            Editable editable = this.getEditable();
            int start = WebViewInputConnection.getComposingSpanStart(editable);
            int end = WebViewInputConnection.getComposingSpanEnd(editable);
            if (start < 0 || end < 0) {
                start = Selection.getSelectionStart(editable);
                end = Selection.getSelectionEnd(editable);
            }
            if (end < start) {
                int temp = end;
                end = start;
                start = temp;
            }
            CharSequence limitedText = this.limitReplaceTextByMaxLength(text, end - start);
            this.setNewText(start, end, limitedText);
            if (limitedText != text) {
                newCursorPosition -= text.length() - limitedText.length();
            }
            super.setComposingText(limitedText, newCursorPosition);
            this.updateSelection();
            if (limitedText != text) {
                int lastCaret = start + limitedText.length();
                this.finishComposingText();
                this.setSelection(lastCaret, lastCaret);
            }
            return true;
        }

        public boolean commitText(CharSequence text, int newCursorPosition) {
            this.setComposingText(text, newCursorPosition);
            this.finishComposingText();
            return true;
        }

        public boolean deleteSurroundingText(int leftLength, int rightLength) {
            int startDelete;
            int endDelete;
            int b;
            Editable content = this.getEditable();
            int a = Selection.getSelectionStart(content);
            if (a > (b = Selection.getSelectionEnd(content))) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            int ca = WebViewInputConnection.getComposingSpanStart(content);
            int cb = WebViewInputConnection.getComposingSpanEnd(content);
            if (cb < ca) {
                int tmp = ca;
                ca = cb;
                cb = tmp;
            }
            if (ca != -1 && cb != -1) {
                if (ca < a) {
                    a = ca;
                }
                if (cb > b) {
                    b = cb;
                }
            }
            if ((endDelete = Math.min(content.length(), b + rightLength)) > b) {
                this.setNewText(b, endDelete, "");
            }
            if ((startDelete = Math.max(0, a - leftLength)) < a) {
                this.setNewText(startDelete, a, "");
            }
            return super.deleteSurroundingText(leftLength, rightLength);
        }

        public boolean performEditorAction(int editorAction) {
            boolean handled = true;
            switch (editorAction) {
                case 5: {
                    WebViewClassic.this.mWebView.requestFocus(2);
                    break;
                }
                case 7: {
                    WebViewClassic.this.mWebView.requestFocus(1);
                    break;
                }
                case 6: {
                    WebViewClassic.this.hideSoftKeyboard();
                    break;
                }
                case 2: 
                case 3: {
                    WebViewClassic.this.hideSoftKeyboard();
                    String text = this.getEditable().toString();
                    WebViewClassic.this.passToJavaScript(text, new KeyEvent(0, 66));
                    WebViewClassic.this.passToJavaScript(text, new KeyEvent(1, 66));
                    break;
                }
                default: {
                    handled = super.performEditorAction(editorAction);
                }
            }
            return handled;
        }

        public void initEditorInfo(WebViewCore.TextFieldInitData initData) {
            int type = initData.mType;
            int inputType = 161;
            int imeOptions = 0x12000000;
            if (!initData.mIsSpellCheckEnabled) {
                inputType |= 0x80000;
            }
            if (1 != type) {
                if (initData.mIsTextFieldNext) {
                    imeOptions |= 0x8000000;
                }
                if (initData.mIsTextFieldPrev) {
                    imeOptions |= 0x4000000;
                }
            }
            int action = 2;
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    inputType |= 0x2C000;
                    action = 1;
                    break;
                }
                case 2: {
                    inputType |= 0xE0;
                    break;
                }
                case 3: {
                    action = 3;
                    break;
                }
                case 4: {
                    inputType = 209;
                    break;
                }
                case 5: {
                    inputType = 12290;
                    break;
                }
                case 6: {
                    inputType = 3;
                    break;
                }
                case 7: {
                    inputType |= 0x10;
                    break;
                }
            }
            this.mHint = initData.mLabel;
            this.mInputType = inputType;
            this.mImeOptions = imeOptions |= action;
            this.mMaxLength = initData.mMaxLength;
            this.mIsAutoCompleteEnabled = initData.mIsAutoCompleteEnabled;
            this.mName = initData.mName;
            WebViewClassic.this.mAutoCompletePopup.clearAdapter();
        }

        public void setupEditorInfo(EditorInfo outAttrs) {
            outAttrs.inputType = this.mInputType;
            outAttrs.imeOptions = this.mImeOptions;
            outAttrs.hintText = this.mHint;
            outAttrs.initialCapsMode = this.getCursorCapsMode(1);
            Editable editable = this.getEditable();
            int selectionStart = Selection.getSelectionStart(editable);
            int selectionEnd = Selection.getSelectionEnd(editable);
            if (selectionStart < 0 || selectionEnd < 0) {
                selectionEnd = selectionStart = editable.length();
            }
            outAttrs.initialSelStart = selectionStart;
            outAttrs.initialSelEnd = selectionEnd;
        }

        public boolean setSelection(int start, int end) {
            boolean result = super.setSelection(start, end);
            this.updateSelection();
            return result;
        }

        public boolean setComposingRegion(int start, int end) {
            boolean result = super.setComposingRegion(start, end);
            this.updateSelection();
            return result;
        }

        private void updateSelection() {
            Editable editable = this.getEditable();
            int selectionStart = Selection.getSelectionStart(editable);
            int selectionEnd = Selection.getSelectionEnd(editable);
            int composingStart = WebViewInputConnection.getComposingSpanStart(editable);
            int composingEnd = WebViewInputConnection.getComposingSpanEnd(editable);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.updateSelection(WebViewClassic.this.mWebView, selectionStart, selectionEnd, composingStart, composingEnd);
            }
        }

        private void setNewText(int start, int end, CharSequence text) {
            int selectionEnd;
            this.mIsKeySentByMe = true;
            Editable editable = this.getEditable();
            CharSequence original = editable.subSequence(start, end);
            boolean isCharacterAdd = false;
            boolean isCharacterDelete = false;
            int textLength = text.length();
            int originalLength = original.length();
            int selectionStart = Selection.getSelectionStart(editable);
            if (selectionStart == (selectionEnd = Selection.getSelectionEnd(editable))) {
                if (textLength > originalLength) {
                    isCharacterAdd = textLength == originalLength + 1 && TextUtils.regionMatches(text, 0, original, 0, originalLength);
                } else if (originalLength > textLength) {
                    boolean bl = isCharacterDelete = textLength == originalLength - 1 && TextUtils.regionMatches(text, 0, original, 0, textLength);
                }
            }
            if (isCharacterAdd) {
                this.sendCharacter(text.charAt(textLength - 1));
            } else if (isCharacterDelete) {
                this.sendKey(67);
            } else if (textLength != originalLength || !TextUtils.regionMatches(text, 0, original, 0, textLength)) {
                Message replaceMessage = WebViewClassic.this.mPrivateHandler.obtainMessage(143, start, end, ((Object)text).toString());
                WebViewClassic.this.mPrivateHandler.sendMessage(replaceMessage);
            }
            if (WebViewClassic.this.mAutoCompletePopup != null) {
                StringBuilder newText = new StringBuilder();
                newText.append(editable.subSequence(0, start));
                newText.append(text);
                newText.append(editable.subSequence(end, editable.length()));
                WebViewClassic.this.mAutoCompletePopup.setText(newText.toString());
            }
            this.mIsKeySentByMe = false;
        }

        private void sendCharacter(char c) {
            if (this.mKeyCharacterMap == null) {
                this.mKeyCharacterMap = KeyCharacterMap.load(-1);
            }
            char[] chars = new char[]{c};
            KeyEvent[] events = this.mKeyCharacterMap.getEvents(chars);
            if (events != null) {
                for (KeyEvent event : events) {
                    this.sendKeyEvent(event);
                }
            } else {
                Message msg = WebViewClassic.this.mPrivateHandler.obtainMessage(145, c, 0);
                WebViewClassic.this.mPrivateHandler.sendMessage(msg);
            }
        }

        private void sendKey(int keyCode) {
            long eventTime = SystemClock.uptimeMillis();
            this.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, keyCode, 0, 0, -1, 0, 2));
            this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, keyCode, 0, 0, -1, 0, 2));
        }

        private CharSequence limitReplaceTextByMaxLength(CharSequence text, int numReplaced) {
            Editable editable;
            int maxReplace;
            if (this.mMaxLength > 0 && (maxReplace = this.mMaxLength - (editable = this.getEditable()).length() + numReplaced) < text.length()) {
                maxReplace = Math.max(maxReplace, 0);
                text = text.subSequence(0, maxReplace);
            }
            return text;
        }

        private void restartInput() {
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.restartInput(WebViewClassic.this.mWebView);
            }
        }
    }
}

