/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSecurityPermissions {
    public static final int WHICH_PERSONAL = 1;
    public static final int WHICH_DEVICE = 2;
    public static final int WHICH_NEW = 4;
    public static final int WHICH_ALL = 65535;
    private static final String TAG = "AppSecurityPermissions";
    private static final boolean localLOGV = false;
    private Context mContext;
    private LayoutInflater mInflater;
    private PackageManager mPm;
    private PackageInfo mInstalledPackageInfo;
    private final Map<String, MyPermissionGroupInfo> mPermGroups = new HashMap<String, MyPermissionGroupInfo>();
    private final List<MyPermissionGroupInfo> mPermGroupsList = new ArrayList<MyPermissionGroupInfo>();
    private final PermissionGroupInfoComparator mPermGroupComparator;
    private final PermissionInfoComparator mPermComparator;
    private List<MyPermissionInfo> mPermsList;
    private CharSequence mNewPermPrefix;
    private Drawable mNormalIcon;
    private Drawable mDangerousIcon;

    public AppSecurityPermissions(Context context, List<PermissionInfo> permList) {
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.loadResources();
        this.mPermComparator = new PermissionInfoComparator();
        this.mPermGroupComparator = new PermissionGroupInfoComparator();
        for (PermissionInfo pi : permList) {
            this.mPermsList.add(new MyPermissionInfo(pi));
        }
        this.setPermissions(this.mPermsList);
    }

    public AppSecurityPermissions(Context context, String packageName) {
        PackageInfo pkgInfo;
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.loadResources();
        this.mPermComparator = new PermissionInfoComparator();
        this.mPermGroupComparator = new PermissionGroupInfoComparator();
        this.mPermsList = new ArrayList<MyPermissionInfo>();
        HashSet<MyPermissionInfo> permSet = new HashSet<MyPermissionInfo>();
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Couldn't retrieve permissions for package:" + packageName);
            return;
        }
        if (pkgInfo.applicationInfo != null && pkgInfo.applicationInfo.uid != -1) {
            this.getAllUsedPermissions(pkgInfo.applicationInfo.uid, permSet);
        }
        for (MyPermissionInfo tmpInfo : permSet) {
            this.mPermsList.add(tmpInfo);
        }
        this.setPermissions(this.mPermsList);
    }

    public AppSecurityPermissions(Context context, PackageInfo info) {
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.loadResources();
        this.mPermComparator = new PermissionInfoComparator();
        this.mPermGroupComparator = new PermissionGroupInfoComparator();
        this.mPermsList = new ArrayList<MyPermissionInfo>();
        HashSet<MyPermissionInfo> permSet = new HashSet<MyPermissionInfo>();
        if (info == null) {
            return;
        }
        PackageInfo installedPkgInfo = null;
        if (info.requestedPermissions != null) {
            try {
                installedPkgInfo = this.mPm.getPackageInfo(info.packageName, 4096);
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
            this.extractPerms(info, permSet, installedPkgInfo);
        }
        if (info.sharedUserId != null) {
            try {
                int sharedUid = this.mPm.getUidForSharedUser(info.sharedUserId);
                this.getAllUsedPermissions(sharedUid, permSet);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, "Could'nt retrieve shared user id for:" + info.packageName);
            }
        }
        for (MyPermissionInfo tmpInfo : permSet) {
            this.mPermsList.add(tmpInfo);
        }
        this.setPermissions(this.mPermsList);
    }

    private void loadResources() {
        this.mNewPermPrefix = this.mContext.getText(17040435);
        this.mNormalIcon = this.mContext.getResources().getDrawable(17302367);
        this.mDangerousIcon = this.mContext.getResources().getDrawable(17302191);
    }

    public static View getPermissionItemView(Context context, CharSequence grpName, CharSequence description, boolean dangerous) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        Drawable icon = context.getResources().getDrawable(dangerous ? 17302191 : 17302367);
        return AppSecurityPermissions.getPermissionItemViewOld(context, inflater, grpName, description, dangerous, icon);
    }

    public PackageInfo getInstalledPackageInfo() {
        return this.mInstalledPackageInfo;
    }

    private void getAllUsedPermissions(int sharedUid, Set<MyPermissionInfo> permSet) {
        String[] sharedPkgList = this.mPm.getPackagesForUid(sharedUid);
        if (sharedPkgList == null || sharedPkgList.length == 0) {
            return;
        }
        for (String sharedPkg : sharedPkgList) {
            this.getPermissionsForPackage(sharedPkg, permSet);
        }
    }

    private void getPermissionsForPackage(String packageName, Set<MyPermissionInfo> permSet) {
        PackageInfo pkgInfo;
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Couldn't retrieve permissions for package:" + packageName);
            return;
        }
        if (pkgInfo != null && pkgInfo.requestedPermissions != null) {
            this.extractPerms(pkgInfo, permSet, pkgInfo);
        }
    }

    private void extractPerms(PackageInfo info, Set<MyPermissionInfo> permSet, PackageInfo installedPkgInfo) {
        String[] strList = info.requestedPermissions;
        int[] flagsList = info.requestedPermissionsFlags;
        if (strList == null || strList.length == 0) {
            return;
        }
        this.mInstalledPackageInfo = installedPkgInfo;
        for (int i = 0; i < strList.length; ++i) {
            String permName = strList[i];
            if (installedPkgInfo != null && info == installedPkgInfo && (flagsList[i] & 2) == 0) continue;
            try {
                MyPermissionGroupInfo group;
                int existingFlags;
                PermissionInfo tmpPermInfo = this.mPm.getPermissionInfo(permName, 0);
                if (tmpPermInfo == null) continue;
                int existingIndex = -1;
                if (installedPkgInfo != null && installedPkgInfo.requestedPermissions != null) {
                    for (int j = 0; j < installedPkgInfo.requestedPermissions.length; ++j) {
                        if (!permName.equals(installedPkgInfo.requestedPermissions[j])) continue;
                        existingIndex = j;
                        break;
                    }
                }
                int n = existingFlags = existingIndex >= 0 ? installedPkgInfo.requestedPermissionsFlags[existingIndex] : 0;
                if (!this.isDisplayablePermission(tmpPermInfo, flagsList[i], existingFlags)) continue;
                String origGroupName = tmpPermInfo.group;
                String groupName = origGroupName;
                if (groupName == null) {
                    tmpPermInfo.group = groupName = tmpPermInfo.packageName;
                }
                if ((group = this.mPermGroups.get(groupName)) == null) {
                    PermissionGroupInfo grp = null;
                    if (origGroupName != null) {
                        grp = this.mPm.getPermissionGroupInfo(origGroupName, 0);
                    }
                    if (grp != null) {
                        group = new MyPermissionGroupInfo(grp);
                    } else {
                        tmpPermInfo.group = tmpPermInfo.packageName;
                        group = this.mPermGroups.get(tmpPermInfo.group);
                        if (group == null) {
                            group = new MyPermissionGroupInfo(tmpPermInfo);
                        }
                        group = new MyPermissionGroupInfo(tmpPermInfo);
                    }
                    this.mPermGroups.put(tmpPermInfo.group, group);
                }
                boolean newPerm = installedPkgInfo != null && (existingFlags & 2) == 0;
                MyPermissionInfo myPerm = new MyPermissionInfo(tmpPermInfo);
                myPerm.mNewReqFlags = flagsList[i];
                myPerm.mExistingReqFlags = existingFlags;
                myPerm.mNew = newPerm;
                permSet.add(myPerm);
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.i(TAG, "Ignoring unknown permission:" + permName);
            }
        }
    }

    public int getPermissionCount() {
        return this.getPermissionCount(65535);
    }

    private List<MyPermissionInfo> getPermissionList(MyPermissionGroupInfo grp, int which) {
        if (which == 4) {
            return grp.mNewPermissions;
        }
        if (which == 1) {
            return grp.mPersonalPermissions;
        }
        if (which == 2) {
            return grp.mDevicePermissions;
        }
        return grp.mAllPermissions;
    }

    public int getPermissionCount(int which) {
        int N = 0;
        for (int i = 0; i < this.mPermGroupsList.size(); ++i) {
            N += this.getPermissionList(this.mPermGroupsList.get(i), which).size();
        }
        return N;
    }

    public View getPermissionsView() {
        return this.getPermissionsView(65535);
    }

    public View getPermissionsView(int which) {
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        LinearLayout permsView = (LinearLayout)this.mInflater.inflate(17367085, null);
        LinearLayout displayList = (LinearLayout)permsView.findViewById(16908911);
        View noPermsView = permsView.findViewById(16908910);
        this.displayPermissions(this.mPermGroupsList, displayList, which);
        if (displayList.getChildCount() <= 0) {
            noPermsView.setVisibility(0);
        }
        return permsView;
    }

    private void displayPermissions(List<MyPermissionGroupInfo> groups, LinearLayout permListView, int which) {
        permListView.removeAllViews();
        int spacing = (int)(8.0f * this.mContext.getResources().getDisplayMetrics().density);
        for (int i = 0; i < groups.size(); ++i) {
            MyPermissionGroupInfo grp = groups.get(i);
            List<MyPermissionInfo> perms = this.getPermissionList(grp, which);
            for (int j = 0; j < perms.size(); ++j) {
                MyPermissionInfo perm = perms.get(j);
                PermissionItemView view = this.getPermissionItemView(grp, perm, j == 0, which != 4 ? this.mNewPermPrefix : null);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
                if (j == 0) {
                    lp.topMargin = spacing;
                }
                if (j == grp.mAllPermissions.size() - 1) {
                    lp.bottomMargin = spacing;
                }
                if (permListView.getChildCount() == 0) {
                    lp.topMargin *= 2;
                }
                permListView.addView((View)view, lp);
            }
        }
    }

    private PermissionItemView getPermissionItemView(MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix) {
        return AppSecurityPermissions.getPermissionItemView(this.mContext, this.mInflater, grp, perm, first, newPermPrefix);
    }

    private static PermissionItemView getPermissionItemView(Context context, LayoutInflater inflater, MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix) {
        PermissionItemView permView = (PermissionItemView)inflater.inflate((perm.flags & 1) != 0 ? 17367083 : 17367082, null);
        permView.setPermission(grp, perm, first, newPermPrefix);
        return permView;
    }

    private static View getPermissionItemViewOld(Context context, LayoutInflater inflater, CharSequence grpName, CharSequence permList, boolean dangerous, Drawable icon) {
        View permView = inflater.inflate(17367084, null);
        TextView permGrpView = (TextView)permView.findViewById(16908908);
        TextView permDescView = (TextView)permView.findViewById(16908909);
        ImageView imgView = (ImageView)permView.findViewById(16908904);
        imgView.setImageDrawable(icon);
        if (grpName != null) {
            permGrpView.setText(grpName);
            permDescView.setText(permList);
        } else {
            permGrpView.setText(permList);
            permDescView.setVisibility(8);
        }
        return permView;
    }

    private boolean isDisplayablePermission(PermissionInfo pInfo, int newReqFlags, int existingReqFlags) {
        int base = pInfo.protectionLevel & 0xF;
        if (base == 1 || base == 0) {
            return true;
        }
        return (existingReqFlags & 2) != 0 && (pInfo.protectionLevel & 0x20) != 0;
    }

    private void addPermToList(List<MyPermissionInfo> permList, MyPermissionInfo pInfo) {
        int idx;
        if (pInfo.mLabel == null) {
            pInfo.mLabel = pInfo.loadLabel(this.mPm);
        }
        if ((idx = Collections.binarySearch(permList, pInfo, this.mPermComparator)) < 0) {
            idx = -idx - 1;
            permList.add(idx, pInfo);
        }
    }

    private void setPermissions(List<MyPermissionInfo> permList) {
        if (permList != null) {
            for (MyPermissionInfo pInfo : permList) {
                MyPermissionGroupInfo group;
                if (!this.isDisplayablePermission(pInfo, pInfo.mNewReqFlags, pInfo.mExistingReqFlags) || (group = this.mPermGroups.get(pInfo.group)) == null) continue;
                pInfo.mLabel = pInfo.loadLabel(this.mPm);
                this.addPermToList(group.mAllPermissions, pInfo);
                if (pInfo.mNew) {
                    this.addPermToList(group.mNewPermissions, pInfo);
                }
                if ((group.flags & 1) != 0) {
                    this.addPermToList(group.mPersonalPermissions, pInfo);
                    continue;
                }
                this.addPermToList(group.mDevicePermissions, pInfo);
            }
        }
        for (MyPermissionGroupInfo pgrp : this.mPermGroups.values()) {
            if (pgrp.labelRes != 0 || pgrp.nonLocalizedLabel != null) {
                pgrp.mLabel = pgrp.loadLabel(this.mPm);
            } else {
                try {
                    ApplicationInfo app = this.mPm.getApplicationInfo(pgrp.packageName, 0);
                    pgrp.mLabel = app.loadLabel(this.mPm);
                }
                catch (PackageManager.NameNotFoundException e) {
                    pgrp.mLabel = pgrp.loadLabel(this.mPm);
                }
            }
            this.mPermGroupsList.add(pgrp);
        }
        Collections.sort(this.mPermGroupsList, this.mPermGroupComparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PermissionInfoComparator
    implements Comparator<MyPermissionInfo> {
        private final Collator sCollator = Collator.getInstance();

        PermissionInfoComparator() {
        }

        @Override
        public int compare(MyPermissionInfo a, MyPermissionInfo b) {
            return this.sCollator.compare(a.mLabel, b.mLabel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PermissionGroupInfoComparator
    implements Comparator<MyPermissionGroupInfo> {
        private final Collator sCollator = Collator.getInstance();

        PermissionGroupInfoComparator() {
        }

        @Override
        public int compare(MyPermissionGroupInfo a, MyPermissionGroupInfo b) {
            if (((a.flags ^ b.flags) & 1) != 0) {
                return (a.flags & 1) != 0 ? -1 : 1;
            }
            if (a.priority != b.priority) {
                return a.priority > b.priority ? -1 : 1;
            }
            return this.sCollator.compare(a.mLabel, b.mLabel);
        }
    }

    public static class PermissionItemView
    extends LinearLayout
    implements View.OnClickListener {
        MyPermissionGroupInfo mGroup;
        MyPermissionInfo mPerm;
        AlertDialog mDialog;

        public PermissionItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.setClickable(true);
        }

        public void setPermission(MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix) {
            this.mGroup = grp;
            this.mPerm = perm;
            ImageView permGrpIcon = (ImageView)this.findViewById(16908904);
            TextView permNameView = (TextView)this.findViewById(16908905);
            PackageManager pm = this.getContext().getPackageManager();
            Drawable icon = null;
            if (first) {
                icon = grp.loadGroupIcon(pm);
            }
            CharSequence label = perm.mLabel;
            if (perm.mNew && newPermPrefix != null) {
                SpannableStringBuilder builder = new SpannableStringBuilder();
                Parcel parcel = Parcel.obtain();
                TextUtils.writeToParcel(newPermPrefix, parcel, 0);
                parcel.setDataPosition(0);
                CharSequence newStr = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                parcel.recycle();
                builder.append(newStr);
                builder.append(label);
                label = builder;
            }
            permGrpIcon.setImageDrawable(icon);
            permNameView.setText(label);
            this.setOnClickListener(this);
        }

        public void onClick(View v) {
            if (this.mGroup != null && this.mPerm != null) {
                if (this.mDialog != null) {
                    this.mDialog.dismiss();
                }
                PackageManager pm = this.getContext().getPackageManager();
                AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
                builder.setTitle(this.mGroup.mLabel);
                if (this.mPerm.descriptionRes != 0) {
                    builder.setMessage(this.mPerm.loadDescription(pm));
                } else {
                    CharSequence appName;
                    try {
                        ApplicationInfo app = pm.getApplicationInfo(this.mPerm.packageName, 0);
                        appName = app.loadLabel(pm);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        appName = this.mPerm.packageName;
                    }
                    StringBuilder sbuilder = new StringBuilder(128);
                    sbuilder.append(this.getContext().getString(17040436, appName));
                    sbuilder.append("\n\n");
                    sbuilder.append(this.mPerm.name);
                    builder.setMessage(sbuilder.toString());
                }
                builder.setCancelable(true);
                builder.setIcon(this.mGroup.loadGroupIcon(pm));
                this.mDialog = builder.show();
                this.mDialog.setCanceledOnTouchOutside(true);
            }
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mDialog != null) {
                this.mDialog.dismiss();
            }
        }
    }

    static class MyPermissionInfo
    extends PermissionInfo {
        CharSequence mLabel;
        int mNewReqFlags;
        int mExistingReqFlags;
        boolean mNew;

        MyPermissionInfo() {
        }

        MyPermissionInfo(PermissionInfo info) {
            super(info);
        }

        MyPermissionInfo(MyPermissionInfo info) {
            super(info);
            this.mNewReqFlags = info.mNewReqFlags;
            this.mExistingReqFlags = info.mExistingReqFlags;
            this.mNew = info.mNew;
        }
    }

    static class MyPermissionGroupInfo
    extends PermissionGroupInfo {
        CharSequence mLabel;
        final ArrayList<MyPermissionInfo> mNewPermissions = new ArrayList();
        final ArrayList<MyPermissionInfo> mPersonalPermissions = new ArrayList();
        final ArrayList<MyPermissionInfo> mDevicePermissions = new ArrayList();
        final ArrayList<MyPermissionInfo> mAllPermissions = new ArrayList();

        MyPermissionGroupInfo(PermissionInfo perm) {
            this.name = perm.packageName;
            this.packageName = perm.packageName;
        }

        MyPermissionGroupInfo(PermissionGroupInfo info) {
            super(info);
        }

        public Drawable loadGroupIcon(PackageManager pm) {
            if (this.icon != 0) {
                return this.loadIcon(pm);
            }
            try {
                ApplicationInfo appInfo = pm.getApplicationInfo(this.packageName, 0);
                return appInfo.loadIcon(pm);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }
    }
}

