/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentingPrintWriter
extends PrintWriter {
    private final String mIndent;
    private StringBuilder mBuilder = new StringBuilder();
    private char[] mCurrent;
    private boolean mEmptyLine = true;

    public IndentingPrintWriter(Writer writer, String indent) {
        super(writer);
        this.mIndent = indent;
    }

    public void increaseIndent() {
        this.mBuilder.append(this.mIndent);
        this.mCurrent = null;
    }

    public void decreaseIndent() {
        this.mBuilder.delete(0, this.mIndent.length());
        this.mCurrent = null;
    }

    public void printPair(String key, Object value) {
        this.print(key + "=" + String.valueOf(value) + " ");
    }

    public void write(char[] buf, int offset, int count) {
        int bufferEnd = offset + count;
        int lineStart = offset;
        int lineEnd = offset;
        while (lineEnd < bufferEnd) {
            char ch;
            if ((ch = buf[lineEnd++]) != '\n') continue;
            this.writeIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
            lineStart = lineEnd;
            this.mEmptyLine = true;
        }
        if (lineStart != lineEnd) {
            this.writeIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
        }
    }

    private void writeIndent() {
        if (this.mEmptyLine) {
            this.mEmptyLine = false;
            if (this.mBuilder.length() != 0) {
                if (this.mCurrent == null) {
                    this.mCurrent = this.mBuilder.toString().toCharArray();
                }
                super.write(this.mCurrent, 0, this.mCurrent.length);
            }
        }
    }
}

