/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Binder;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.widget.ILockSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class LockSettingsService
extends ILockSettings.Stub {
    private final DatabaseHelper mOpenHelper;
    private static final String TAG = "LockSettingsService";
    private static final String TABLE = "locksettings";
    private static final String COLUMN_KEY = "name";
    private static final String COLUMN_USERID = "user";
    private static final String COLUMN_VALUE = "value";
    private static final String[] COLUMNS_FOR_QUERY = new String[]{"value"};
    private static final String SYSTEM_DIRECTORY = "/system/";
    private static final String LOCK_PATTERN_FILE = "gesture.key";
    private static final String LOCK_PASSWORD_FILE = "password.key";
    private final Context mContext;
    private static final String[] VALID_SETTINGS = new String[]{"lockscreen.lockedoutpermanently", "lockscreen.lockoutattemptdeadline", "lockscreen.patterneverchosen", "lockscreen.password_type", "lockscreen.password_type_alternate", "lockscreen.password_salt", "lockscreen.disabled", "lockscreen.options", "lockscreen.biometric_weak_fallback", "lockscreen.biometricweakeverchosen", "lockscreen.power_button_instantly_locks", "lockscreen.passwordhistory", "lock_pattern_autolock", "lock_biometric_weak_flags", "lock_pattern_visible_pattern", "lock_pattern_tactile_feedback_enabled"};

    public LockSettingsService(Context context) {
        this.mContext = context;
        this.mOpenHelper = new DatabaseHelper(this.mContext);
    }

    public void systemReady() {
        this.migrateOldData();
    }

    private void migrateOldData() {
        try {
            if (this.getString("migrated", null, 0) != null) {
                return;
            }
            ContentResolver cr = this.mContext.getContentResolver();
            for (String validSetting : VALID_SETTINGS) {
                String value = Settings.Secure.getString(cr, validSetting);
                if (value == null) continue;
                this.setString(validSetting, value, 0);
            }
            this.setString("migrated", "true", 0);
            Slog.i(TAG, "Migrated lock settings to new location");
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to migrate old data");
        }
    }

    private static void checkWritePermission(int userId) {
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) != 1000) {
            throw new SecurityException("uid=" + callingUid + " not authorized to write lock settings");
        }
    }

    private static void checkPasswordReadPermission(int userId) {
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) != 1000) {
            throw new SecurityException("uid=" + callingUid + " not authorized to read lock password");
        }
    }

    private static void checkReadPermission(int userId) {
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) != 1000 && UserHandle.getUserId(callingUid) != userId) {
            throw new SecurityException("uid=" + callingUid + " not authorized to read settings of user " + userId);
        }
    }

    public void setBoolean(String key, boolean value, int userId) throws RemoteException {
        LockSettingsService.checkWritePermission(userId);
        this.writeToDb(key, value ? "1" : "0", userId);
    }

    public void setLong(String key, long value, int userId) throws RemoteException {
        LockSettingsService.checkWritePermission(userId);
        this.writeToDb(key, Long.toString(value), userId);
    }

    public void setString(String key, String value, int userId) throws RemoteException {
        LockSettingsService.checkWritePermission(userId);
        this.writeToDb(key, value, userId);
    }

    public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
        String value = this.readFromDb(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : value.equals("1") || value.equals("true");
    }

    public long getLong(String key, long defaultValue, int userId) throws RemoteException {
        String value = this.readFromDb(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : Long.parseLong(value);
    }

    public String getString(String key, String defaultValue, int userId) throws RemoteException {
        return this.readFromDb(key, defaultValue, userId);
    }

    private String getLockPatternFilename(int userId) {
        String dataSystemDirectory = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
        if (userId == 0) {
            return dataSystemDirectory + LOCK_PATTERN_FILE;
        }
        return new File(Environment.getUserSystemDirectory(userId), LOCK_PATTERN_FILE).getAbsolutePath();
    }

    private String getLockPasswordFilename(int userId) {
        String dataSystemDirectory = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
        if (userId == 0) {
            return dataSystemDirectory + LOCK_PASSWORD_FILE;
        }
        return new File(Environment.getUserSystemDirectory(userId), LOCK_PASSWORD_FILE).getAbsolutePath();
    }

    public boolean havePassword(int userId) throws RemoteException {
        return new File(this.getLockPasswordFilename(userId)).length() > 0L;
    }

    public boolean havePattern(int userId) throws RemoteException {
        return new File(this.getLockPatternFilename(userId)).length() > 0L;
    }

    public void setLockPattern(byte[] hash, int userId) throws RemoteException {
        LockSettingsService.checkWritePermission(userId);
        this.writeFile(this.getLockPatternFilename(userId), hash);
    }

    public boolean checkPattern(byte[] hash, int userId) throws RemoteException {
        LockSettingsService.checkPasswordReadPermission(userId);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.getLockPatternFilename(userId), "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            return Arrays.equals(stored, hash);
        }
        catch (FileNotFoundException fnfe) {
            Slog.e(TAG, "Cannot read file " + fnfe);
            return true;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Cannot read file " + ioe);
            return true;
        }
    }

    public void setLockPassword(byte[] hash, int userId) throws RemoteException {
        LockSettingsService.checkWritePermission(userId);
        this.writeFile(this.getLockPasswordFilename(userId), hash);
    }

    public boolean checkPassword(byte[] hash, int userId) throws RemoteException {
        LockSettingsService.checkPasswordReadPermission(userId);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.getLockPasswordFilename(userId), "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            return Arrays.equals(stored, hash);
        }
        catch (FileNotFoundException fnfe) {
            Slog.e(TAG, "Cannot read file " + fnfe);
            return true;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Cannot read file " + ioe);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(int userId) {
        LockSettingsService.checkWritePermission(userId);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        try {
            File file = new File(this.getLockPasswordFilename(userId));
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(this.getLockPatternFilename(userId))).exists()) {
                file.delete();
            }
            db.beginTransaction();
            db.delete(TABLE, "user='" + userId + "'", null);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    private void writeFile(String name, byte[] hash) {
        try {
            RandomAccessFile raf = new RandomAccessFile(name, "rw");
            if (hash == null || hash.length == 0) {
                raf.setLength(0L);
            } else {
                raf.write(hash, 0, hash.length);
            }
            raf.close();
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Error writing to file " + ioe);
        }
    }

    private void writeToDb(String key, String value, int userId) {
        this.writeToDb(this.mOpenHelper.getWritableDatabase(), key, value, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDb(SQLiteDatabase db, String key, String value, int userId) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_KEY, key);
        cv.put(COLUMN_USERID, userId);
        cv.put(COLUMN_VALUE, value);
        db.beginTransaction();
        try {
            db.delete(TABLE, "name=? AND user=?", new String[]{key, Integer.toString(userId)});
            db.insert(TABLE, null, cv);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    private String readFromDb(String key, String defaultValue, int userId) {
        String result = defaultValue;
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = db.query(TABLE, COLUMNS_FOR_QUERY, "user=? AND name=?", new String[]{Integer.toString(userId), key}, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                result = cursor.getString(0);
            }
            cursor.close();
        }
        return result;
    }

    class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final String TAG = "LockSettingsDB";
        private static final String DATABASE_NAME = "locksettings.db";
        private static final int DATABASE_VERSION = 1;

        public DatabaseHelper(Context context) {
            super(context, DATABASE_NAME, null, 1);
            this.setWriteAheadLoggingEnabled(true);
        }

        private void createTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE locksettings (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT,user INTEGER,value TEXT);");
        }

        public void onCreate(SQLiteDatabase db) {
            this.createTable(db);
            this.initializeDefaults(db);
        }

        private void initializeDefaults(SQLiteDatabase db) {
            boolean lockScreenDisable = SystemProperties.getBoolean("ro.lockscreen.disable.default", false);
            if (lockScreenDisable) {
                LockSettingsService.this.writeToDb(db, "lockscreen.disabled", "1", 0);
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int currentVersion) {
        }
    }
}

