/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import com.android.internal.util.ArrayUtils;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseWeakArray<E> {
    private static final Object DELETED_REF = new Object();
    private static final WeakReference<?> DELETED = new WeakReference<Object>(DELETED_REF);
    private boolean mGarbage = false;
    private int[] mKeys;
    private WeakReference<?>[] mValues;
    private int mSize;

    public SparseWeakArray() {
        this(10);
    }

    public SparseWeakArray(int n) {
        n = ArrayUtils.idealIntArraySize(n);
        this.mKeys = new int[n];
        this.mValues = new WeakReference[n];
        this.mSize = 0;
    }

    public E get(int n) {
        return this.get(n, null);
    }

    public E get(int n, E e) {
        int n2 = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 < 0 || this.mValues[n2] == DELETED || this.mValues[n2].get() == null) {
            return e;
        }
        return (E)this.mValues[n2].get();
    }

    public void delete(int n) {
        int n2 = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0 && this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int n) {
        this.delete(n);
    }

    public void removeAt(int n) {
        if (this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    private void gc() {
        WeakReference<?> weakReference;
        int n;
        int n2 = this.mSize;
        int n3 = 0;
        int[] nArray = this.mKeys;
        WeakReference<?>[] weakReferenceArray = this.mValues;
        for (n = 0; n < n2; ++n) {
            weakReference = weakReferenceArray[n];
            if (weakReference == DELETED || weakReference.get() == null) continue;
            if (n != n3) {
                nArray[n3] = nArray[n];
                weakReferenceArray[n3] = weakReference;
            }
            ++n3;
        }
        this.mGarbage = false;
        this.mSize = n3;
        n = ArrayUtils.idealIntArraySize(this.mSize);
        if (n < this.mKeys.length) {
            weakReference = (WeakReference<?>)new int[n];
            WeakReference[] weakReferenceArray2 = new WeakReference[n];
            System.arraycopy(this.mKeys, 0, weakReference, 0, n);
            System.arraycopy(this.mValues, 0, weakReferenceArray2, 0, n);
            this.mKeys = (int[])weakReference;
            this.mValues = weakReferenceArray2;
        }
    }

    public void put(int n, E e) {
        int n2 = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0) {
            this.mValues[n2] = new WeakReference<E>(e);
        } else {
            if ((n2 ^= 0xFFFFFFFF) < this.mSize && (this.mValues[n2] == DELETED || this.mValues[n2].get() == null)) {
                this.mKeys[n2] = n;
                this.mValues[n2] = new WeakReference<E>(e);
                return;
            }
            if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
                this.gc();
                n2 = ~SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, n);
            }
            if (this.mSize >= this.mKeys.length) {
                int n3 = ArrayUtils.idealIntArraySize(this.mSize + 1);
                int[] nArray = new int[n3];
                WeakReference[] weakReferenceArray = new WeakReference[n3];
                System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, weakReferenceArray, 0, this.mValues.length);
                this.mKeys = nArray;
                this.mValues = weakReferenceArray;
            }
            if (this.mSize - n2 != 0) {
                System.arraycopy(this.mKeys, n2, this.mKeys, n2 + 1, this.mSize - n2);
                System.arraycopy(this.mValues, n2, this.mValues, n2 + 1, this.mSize - n2);
            }
            this.mKeys[n2] = n;
            this.mValues[n2] = new WeakReference<E>(e);
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n].get();
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = new WeakReference<E>(e);
    }

    public int indexOfKey(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, n);
    }

    public int indexOfValue(E e) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != e) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        int n = this.mSize;
        WeakReference<?>[] weakReferenceArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            weakReferenceArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int n, E e) {
        int n2;
        if (this.mSize != 0 && n <= this.mKeys[this.mSize - 1]) {
            this.put(n, e);
            return;
        }
        if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
            this.gc();
        }
        if ((n2 = this.mSize) >= this.mKeys.length) {
            int n3 = ArrayUtils.idealIntArraySize(n2 + 1);
            int[] nArray = new int[n3];
            WeakReference[] weakReferenceArray = new WeakReference[n3];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, weakReferenceArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = weakReferenceArray;
        }
        this.mKeys[n2] = n;
        this.mValues[n2] = new WeakReference<E>(e);
        this.mSize = n2 + 1;
    }

    private boolean hasReclaimedRefs() {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != null) continue;
            return true;
        }
        return false;
    }

    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n - 1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        if (n4 == n + n2) {
            return ~(n + n2);
        }
        if (nArray[n4] == n3) {
            return n4;
        }
        return ~n4;
    }
}

