/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DexPathList {
    private static final String DEX_SUFFIX = ".dex";
    private static final String JAR_SUFFIX = ".jar";
    private static final String ZIP_SUFFIX = ".zip";
    private static final String APK_SUFFIX = ".apk";
    private final ClassLoader definingContext;
    private final Element[] dexElements;
    private final File[] nativeLibraryDirectories;

    public DexPathList(ClassLoader definingContext, String dexPath, String libraryPath, File optimizedDirectory) {
        if (definingContext == null) {
            throw new NullPointerException("definingContext == null");
        }
        if (dexPath == null) {
            throw new NullPointerException("dexPath == null");
        }
        if (optimizedDirectory != null) {
            if (!optimizedDirectory.exists()) {
                throw new IllegalArgumentException("optimizedDirectory doesn't exist: " + optimizedDirectory);
            }
            if (!optimizedDirectory.canRead() || !optimizedDirectory.canWrite()) {
                throw new IllegalArgumentException("optimizedDirectory not readable/writable: " + optimizedDirectory);
            }
        }
        this.definingContext = definingContext;
        this.dexElements = DexPathList.makeDexElements(DexPathList.splitDexPath(dexPath), optimizedDirectory);
        this.nativeLibraryDirectories = DexPathList.splitLibraryPath(libraryPath);
    }

    private static ArrayList<File> splitDexPath(String path) {
        return DexPathList.splitPaths(path, null, false);
    }

    private static File[] splitLibraryPath(String path) {
        ArrayList<File> result = DexPathList.splitPaths(path, System.getProperty("java.library.path", "."), true);
        return result.toArray(new File[result.size()]);
    }

    private static ArrayList<File> splitPaths(String path1, String path2, boolean wantDirectories) {
        ArrayList<File> result = new ArrayList<File>();
        DexPathList.splitAndAdd(path1, wantDirectories, result);
        DexPathList.splitAndAdd(path2, wantDirectories, result);
        return result;
    }

    private static void splitAndAdd(String path, boolean wantDirectories, ArrayList<File> resultList) {
        String[] strings;
        if (path == null) {
            return;
        }
        for (String s : strings = path.split(Pattern.quote(File.pathSeparator))) {
            File file = new File(s);
            if (!file.exists() || !file.canRead() || (wantDirectories ? !file.isDirectory() : !file.isFile())) continue;
            resultList.add(file);
        }
    }

    private static Element[] makeDexElements(ArrayList<File> files, File optimizedDirectory) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (File file : files) {
            File zip = null;
            DexFile dex = null;
            String name = file.getName();
            if (name.endsWith(DEX_SUFFIX)) {
                try {
                    dex = DexPathList.loadDexFile(file, optimizedDirectory);
                }
                catch (IOException ex) {
                    System.logE((String)("Unable to load dex file: " + file), (Throwable)ex);
                }
            } else if (name.endsWith(APK_SUFFIX) || name.endsWith(JAR_SUFFIX) || name.endsWith(ZIP_SUFFIX)) {
                zip = file;
                try {
                    dex = DexPathList.loadDexFile(file, optimizedDirectory);
                }
                catch (IOException ignored) {}
            } else {
                System.logW((String)("Unknown file type for: " + file));
            }
            if (zip == null && dex == null) continue;
            elements.add(new Element(file, zip, dex));
        }
        return elements.toArray(new Element[elements.size()]);
    }

    private static DexFile loadDexFile(File file, File optimizedDirectory) throws IOException {
        if (optimizedDirectory == null) {
            return new DexFile(file);
        }
        String optimizedPath = DexPathList.optimizedPathFor(file, optimizedDirectory);
        return DexFile.loadDex(file.getPath(), optimizedPath, 0);
    }

    private static String optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(DEX_SUFFIX)) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + DEX_SUFFIX;
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(DEX_SUFFIX);
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    public Class findClass(String name) {
        for (Element element : this.dexElements) {
            Class clazz;
            DexFile dex = element.dexFile;
            if (dex == null || (clazz = dex.loadClassBinaryName(name, this.definingContext)) == null) continue;
            return clazz;
        }
        return null;
    }

    public URL findResource(String name) {
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Element element : this.dexElements) {
            URL url = element.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public String findLibrary(String libraryName) {
        String fileName = System.mapLibraryName(libraryName);
        for (File directory : this.nativeLibraryDirectories) {
            File file = new File(directory, fileName);
            if (!file.exists() || !file.isFile() || !file.canRead()) continue;
            return file.getPath();
        }
        return null;
    }

    static class Element {
        private final File file;
        private final File zip;
        private final DexFile dexFile;
        private ZipFile zipFile;
        private boolean init;

        public Element(File file, File zip, DexFile dexFile) {
            this.file = file;
            this.zip = zip;
            this.dexFile = dexFile;
        }

        public synchronized void maybeInit() {
            if (this.init) {
                return;
            }
            this.init = true;
            if (this.zip == null) {
                return;
            }
            try {
                this.zipFile = new ZipFile(this.zip);
            }
            catch (IOException ioe) {
                System.logE((String)("Unable to open zip file: " + this.file), (Throwable)ioe);
                this.zipFile = null;
            }
        }

        public URL findResource(String name) {
            this.maybeInit();
            if (this.zipFile == null || this.zipFile.getEntry(name) == null) {
                return null;
            }
            try {
                return new URL("jar:" + this.file.toURL() + "!/" + name);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

