/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.LinkedHashSet;
import java.util.Locale;
import libcore.icu.ICU_Delegate;
import libcore.icu.LocaleData;

public class ICU {
    private static String[] isoLanguages;
    private static String[] isoCountries;
    private static Locale[] availableLocalesCache;
    public static final int U_ZERO_ERROR = 0;
    public static final int U_INVALID_CHAR_FOUND = 10;
    public static final int U_TRUNCATED_CHAR_FOUND = 11;
    public static final int U_ILLEGAL_CHAR_FOUND = 12;
    public static final int U_BUFFER_OVERFLOW_ERROR = 15;

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = ICU.getISOLanguagesNative();
        }
        return (String[])isoLanguages.clone();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = ICU.getISOCountriesNative();
        }
        return (String[])isoCountries.clone();
    }

    public static Locale localeFromString(String localeName) {
        int first = localeName.indexOf(95);
        int second = localeName.indexOf(95, first + 1);
        if (first == -1) {
            return new Locale(localeName);
        }
        if (second == -1) {
            return new Locale(localeName.substring(0, first), localeName.substring(first + 1));
        }
        return new Locale(localeName.substring(0, first), localeName.substring(first + 1, second), localeName.substring(second + 1));
    }

    public static Locale[] localesFromStrings(String[] localeNames) {
        LinkedHashSet<Locale> set = new LinkedHashSet<Locale>();
        for (String localeName : localeNames) {
            set.add(ICU.localeFromString(localeName));
        }
        return set.toArray(new Locale[set.size()]);
    }

    public static Locale[] getAvailableLocales() {
        if (availableLocalesCache == null) {
            availableLocalesCache = ICU.localesFromStrings(ICU.getAvailableLocalesNative());
        }
        return (Locale[])availableLocalesCache.clone();
    }

    public static Locale[] getAvailableBreakIteratorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableBreakIteratorLocalesNative());
    }

    public static Locale[] getAvailableCalendarLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCalendarLocalesNative());
    }

    public static Locale[] getAvailableCollatorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCollatorLocalesNative());
    }

    public static Locale[] getAvailableDateFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableDateFormatLocalesNative());
    }

    public static Locale[] getAvailableDateFormatSymbolsLocales() {
        return ICU.getAvailableDateFormatLocales();
    }

    public static Locale[] getAvailableDecimalFormatSymbolsLocales() {
        return ICU.getAvailableNumberFormatLocales();
    }

    public static Locale[] getAvailableNumberFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableNumberFormatLocalesNative());
    }

    @LayoutlibDelegate
    public static String getIcuVersion() {
        return ICU_Delegate.getIcuVersion();
    }

    @LayoutlibDelegate
    public static String getUnicodeVersion() {
        return ICU_Delegate.getUnicodeVersion();
    }

    @LayoutlibDelegate
    public static String toLowerCase(String string2, String string3) {
        return ICU_Delegate.toLowerCase(string2, string3);
    }

    @LayoutlibDelegate
    public static String toUpperCase(String string2, String string3) {
        return ICU_Delegate.toUpperCase(string2, string3);
    }

    public static boolean U_FAILURE(int error) {
        return error > 0;
    }

    @LayoutlibDelegate
    private static String[] getAvailableBreakIteratorLocalesNative() {
        return ICU_Delegate.getAvailableBreakIteratorLocalesNative();
    }

    @LayoutlibDelegate
    private static String[] getAvailableCalendarLocalesNative() {
        return ICU_Delegate.getAvailableCalendarLocalesNative();
    }

    @LayoutlibDelegate
    private static String[] getAvailableCollatorLocalesNative() {
        return ICU_Delegate.getAvailableCollatorLocalesNative();
    }

    @LayoutlibDelegate
    private static String[] getAvailableDateFormatLocalesNative() {
        return ICU_Delegate.getAvailableDateFormatLocalesNative();
    }

    @LayoutlibDelegate
    private static String[] getAvailableLocalesNative() {
        return ICU_Delegate.getAvailableLocalesNative();
    }

    @LayoutlibDelegate
    private static String[] getAvailableNumberFormatLocalesNative() {
        return ICU_Delegate.getAvailableNumberFormatLocalesNative();
    }

    @LayoutlibDelegate
    public static String[] getAvailableCurrencyCodes() {
        return ICU_Delegate.getAvailableCurrencyCodes();
    }

    @LayoutlibDelegate
    public static String getCurrencyCode(String string2) {
        return ICU_Delegate.getCurrencyCode(string2);
    }

    @LayoutlibDelegate
    public static String getCurrencyDisplayName(String string2, String string3) {
        return ICU_Delegate.getCurrencyDisplayName(string2, string3);
    }

    @LayoutlibDelegate
    public static int getCurrencyFractionDigits(String string2) {
        return ICU_Delegate.getCurrencyFractionDigits(string2);
    }

    @LayoutlibDelegate
    public static String getCurrencySymbol(String string2, String string3) {
        return ICU_Delegate.getCurrencySymbol(string2, string3);
    }

    @LayoutlibDelegate
    public static String getDisplayCountryNative(String string2, String string3) {
        return ICU_Delegate.getDisplayCountryNative(string2, string3);
    }

    @LayoutlibDelegate
    public static String getDisplayLanguageNative(String string2, String string3) {
        return ICU_Delegate.getDisplayLanguageNative(string2, string3);
    }

    @LayoutlibDelegate
    public static String getDisplayVariantNative(String string2, String string3) {
        return ICU_Delegate.getDisplayVariantNative(string2, string3);
    }

    @LayoutlibDelegate
    public static String getISO3CountryNative(String string2) {
        return ICU_Delegate.getISO3CountryNative(string2);
    }

    @LayoutlibDelegate
    public static String getISO3LanguageNative(String string2) {
        return ICU_Delegate.getISO3LanguageNative(string2);
    }

    @LayoutlibDelegate
    public static String addLikelySubtags(String string2) {
        return ICU_Delegate.addLikelySubtags(string2);
    }

    @LayoutlibDelegate
    public static String getScript(String string2) {
        return ICU_Delegate.getScript(string2);
    }

    @LayoutlibDelegate
    private static String[] getISOLanguagesNative() {
        return ICU_Delegate.getISOLanguagesNative();
    }

    @LayoutlibDelegate
    private static String[] getISOCountriesNative() {
        return ICU_Delegate.getISOCountriesNative();
    }

    @LayoutlibDelegate
    static boolean initLocaleDataImpl(String string2, LocaleData localeData) {
        return ICU_Delegate.initLocaleDataImpl(string2, localeData);
    }
}

