/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.io.IOException;
import java.nio.charset.Charsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimeZone;
import libcore.io.BufferIterator;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.MemoryMappedFile;
import libcore.util.ZoneInfo;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class ZoneInfoDB {
    private static final String ZONE_DIRECTORY_NAME = System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/";
    private static final String ZONE_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.dat";
    private static final String INDEX_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.idx";
    private static final Object LOCK = new Object();
    private static final String VERSION = ZoneInfoDB.readVersion();
    private static final MemoryMappedFile ALL_ZONE_DATA = ZoneInfoDB.mapData();
    private static String[] ids;
    private static int[] byteOffsets;
    private static int[] rawUtcOffsets;

    private ZoneInfoDB() {
    }

    private static String readVersion() {
        try {
            byte[] bytes = IoUtils.readFileAsByteArray(ZONE_DIRECTORY_NAME + "zoneinfo.version");
            return new String(bytes, 0, bytes.length, Charsets.ISO_8859_1).trim();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static MemoryMappedFile mapData() {
        try {
            return MemoryMappedFile.mmapRO(ZONE_FILE_NAME);
        }
        catch (ErrnoException errnoException) {
            throw new AssertionError((Object)errnoException);
        }
    }

    private static void readIndex() {
        MemoryMappedFile mappedFile = null;
        try {
            try {
                mappedFile = MemoryMappedFile.mmapRO(INDEX_FILE_NAME);
                ZoneInfoDB.readIndex(mappedFile);
            }
            catch (Exception ex) {
                throw new AssertionError((Object)ex);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            IoUtils.closeQuietly(mappedFile);
            throw throwable;
        }
        IoUtils.closeQuietly(mappedFile);
    }

    private static void readIndex(MemoryMappedFile mappedFile) throws ErrnoException, IOException {
        BufferIterator it = mappedFile.bigEndianIterator();
        int SIZEOF_TZNAME = 40;
        int SIZEOF_TZINT = 4;
        byte[] idBytes = new byte[40];
        int numEntries = (int)mappedFile.size() / 52;
        char[] idChars = new char[numEntries * 40];
        int[] idEnd = new int[numEntries];
        int idOffset = 0;
        byteOffsets = new int[numEntries];
        rawUtcOffsets = new int[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            it.readByteArray(idBytes, 0, idBytes.length);
            ZoneInfoDB.byteOffsets[i] = it.readInt();
            int length = it.readInt();
            if (length < 44) {
                throw new AssertionError((Object)"length in index file < sizeof(tzhead)");
            }
            ZoneInfoDB.rawUtcOffsets[i] = it.readInt();
            int len = idBytes.length;
            for (int j = 0; j < len && idBytes[j] != 0; ++j) {
                idChars[idOffset++] = (char)(idBytes[j] & 0xFF);
            }
            idEnd[i] = idOffset;
        }
        String allIds = new String(idChars, 0, idOffset);
        ids = new String[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            ZoneInfoDB.ids[i] = allIds.substring(i == 0 ? 0 : idEnd[i - 1], idEnd[i]);
        }
    }

    public static TimeZone makeTimeZone(String id2) throws IOException {
        int index = Arrays.binarySearch(ids, id2);
        if (index < 0) {
            return null;
        }
        BufferIterator data = ALL_ZONE_DATA.bigEndianIterator();
        data.skip(byteOffsets[index]);
        if (data.readInt() != 1415211366) {
            return null;
        }
        data.skip(28);
        int tzh_timecnt = data.readInt();
        int tzh_typecnt = data.readInt();
        data.skip(4);
        int[] transitions = new int[tzh_timecnt];
        data.readIntArray(transitions, 0, transitions.length);
        byte[] type = new byte[tzh_timecnt];
        data.readByteArray(type, 0, type.length);
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = data.readInt();
            isDsts[i] = data.readByte();
            data.skip(1);
        }
        return new ZoneInfo(id2, transitions, type, gmtOffsets, isDsts);
    }

    public static String[] getAvailableIDs() {
        return (String[])ids.clone();
    }

    public static String[] getAvailableIDs(int rawOffset) {
        ArrayList<String> matches = new ArrayList<String>();
        int end = rawUtcOffsets.length;
        for (int i = 0; i < end; ++i) {
            if (rawUtcOffsets[i] != rawOffset) continue;
            matches.add(ids[i]);
        }
        return matches.toArray(new String[matches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone getSystemDefault() {
        Object object = LOCK;
        synchronized (object) {
            String zoneName;
            TimezoneGetter tzGetter = TimezoneGetter.getInstance();
            String string2 = zoneName = tzGetter != null ? tzGetter.getId() : null;
            if (zoneName != null) {
                zoneName = zoneName.trim();
            }
            if (zoneName == null || zoneName.isEmpty()) {
                zoneName = "localtime";
            }
            return TimeZone.getTimeZone(zoneName);
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    static {
        ZoneInfoDB.readIndex();
    }
}

