/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import org.apache.harmony.xnet.provider.jsse.AbstractSessionContext;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;

public class OpenSSLSessionImpl
implements SSLSession {
    private long creationTime = 0L;
    long lastAccessedTime = 0L;
    final X509Certificate[] localCertificates;
    final X509Certificate[] peerCertificates;
    private boolean isValid = true;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private volatile javax.security.cert.X509Certificate[] peerCertificateChain;
    protected int sslSessionNativePointer;
    private String peerHost;
    private int peerPort = -1;
    private String cipherSuite;
    private String protocol;
    private AbstractSessionContext sessionContext;
    private byte[] id;

    protected OpenSSLSessionImpl(int sslSessionNativePointer, X509Certificate[] localCertificates, X509Certificate[] peerCertificates, String peerHost, int peerPort, AbstractSessionContext sessionContext) {
        this.sslSessionNativePointer = sslSessionNativePointer;
        this.localCertificates = localCertificates;
        this.peerCertificates = peerCertificates;
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.sessionContext = sessionContext;
    }

    OpenSSLSessionImpl(byte[] derData, String peerHost, int peerPort, X509Certificate[] peerCertificates, AbstractSessionContext sessionContext) throws IOException {
        this(NativeCrypto.d2i_SSL_SESSION(derData), null, peerCertificates, peerHost, peerPort, sessionContext);
        if (this.sslSessionNativePointer == 0) {
            throw new IOException("Invalid session data");
        }
    }

    public byte[] getId() {
        if (this.id == null) {
            this.resetId();
        }
        return this.id;
    }

    void resetId() {
        this.id = NativeCrypto.SSL_SESSION_session_id(this.sslSessionNativePointer);
    }

    byte[] getEncoded() {
        return NativeCrypto.i2d_SSL_SESSION(this.sslSessionNativePointer);
    }

    public long getCreationTime() {
        if (this.creationTime == 0L) {
            this.creationTime = NativeCrypto.SSL_SESSION_get_time(this.sslSessionNativePointer);
        }
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime == 0L ? this.getCreationTime() : this.lastAccessedTime;
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public int getPacketBufferSize() {
        return 18437;
    }

    public Principal getLocalPrincipal() {
        if (this.localCertificates != null && this.localCertificates.length > 0) {
            return this.localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        javax.security.cert.X509Certificate[] result = this.peerCertificateChain;
        if (result == null) {
            result = this.createPeerCertificateChain();
            this.peerCertificateChain = result;
        }
        return result;
    }

    private javax.security.cert.X509Certificate[] createPeerCertificateChain() throws SSLPeerUnverifiedException {
        try {
            javax.security.cert.X509Certificate[] chain = new javax.security.cert.X509Certificate[this.peerCertificates.length];
            for (int i = 0; i < this.peerCertificates.length; ++i) {
                byte[] encoded = this.peerCertificates[i].getEncoded();
                chain[i] = javax.security.cert.X509Certificate.getInstance(encoded);
            }
            return chain;
        }
        catch (CertificateEncodingException e) {
            SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
            exception.initCause(exception);
            throw exception;
        }
        catch (CertificateException e) {
            SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
            exception.initCause(exception);
            throw exception;
        }
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return this.peerCertificates;
    }

    private void checkPeerCertificatesPresent() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null || this.peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return this.peerCertificates[0].getSubjectX500Principal();
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            String name = NativeCrypto.SSL_SESSION_cipher(this.sslSessionNativePointer);
            this.cipherSuite = NativeCrypto.OPENSSL_TO_STANDARD_CIPHER_SUITES.get(name);
            if (this.cipherSuite == null) {
                this.cipherSuite = name;
            }
        }
        return this.cipherSuite;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = NativeCrypto.SSL_SESSION_get_version(this.sslSessionNativePointer);
        }
        return this.protocol;
    }

    public SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public boolean isValid() {
        AbstractSessionContext context = this.sessionContext;
        if (this.isValid && context != null && context.getSessionTimeout() != 0 && this.getCreationTime() + (long)(context.getSessionTimeout() * 1000) < System.currentTimeMillis()) {
            this.isValid = false;
        }
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
        this.sessionContext = null;
    }

    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.values.get(name);
    }

    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name == null || value == null");
        }
        Object old = this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Object old = this.values.remove(name);
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NativeCrypto.SSL_SESSION_free(this.sslSessionNativePointer);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

