/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import libcore.io.IoUtils;
import libcore.util.Objects;
import org.apache.harmony.security.x501.Name;
import org.apache.harmony.security.x509.AuthorityKeyIdentifier;
import org.apache.harmony.security.x509.GeneralName;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.SubjectKeyIdentifier;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedCertificateStore {
    private static final String PREFIX_SYSTEM = "system:";
    private static final String PREFIX_USER = "user:";
    private static final File CA_CERTS_DIR_SYSTEM;
    private static final File CA_CERTS_DIR_ADDED;
    private static final File CA_CERTS_DIR_DELETED;
    private static final CertificateFactory CERT_FACTORY;
    private final File systemDir;
    private final File addedDir;
    private final File deletedDir;

    public static boolean isSystem(String alias) {
        return alias.startsWith(PREFIX_SYSTEM);
    }

    public static boolean isUser(String alias) {
        return alias.startsWith(PREFIX_USER);
    }

    public TrustedCertificateStore() {
        this(CA_CERTS_DIR_SYSTEM, CA_CERTS_DIR_ADDED, CA_CERTS_DIR_DELETED);
    }

    public TrustedCertificateStore(File systemDir, File addedDir, File deletedDir) {
        this.systemDir = systemDir;
        this.addedDir = addedDir;
        this.deletedDir = deletedDir;
    }

    public Certificate getCertificate(String alias) {
        return this.getCertificate(alias, false);
    }

    public Certificate getCertificate(String alias, boolean includeDeletedSystem) {
        File file = this.fileForAlias(alias);
        if (file == null || TrustedCertificateStore.isUser(alias) && this.isTombstone(file)) {
            return null;
        }
        X509Certificate cert = this.readCertificate(file);
        if (cert == null || TrustedCertificateStore.isSystem(alias) && !includeDeletedSystem && this.isDeletedSystemCertificate(cert)) {
            return null;
        }
        return cert;
    }

    private File fileForAlias(String alias) {
        File file;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        if (TrustedCertificateStore.isSystem(alias)) {
            file = new File(this.systemDir, alias.substring(PREFIX_SYSTEM.length()));
        } else if (TrustedCertificateStore.isUser(alias)) {
            file = new File(this.addedDir, alias.substring(PREFIX_USER.length()));
        } else {
            return null;
        }
        if (!file.exists() || this.isTombstone(file)) {
            return null;
        }
        return file;
    }

    private boolean isTombstone(File file) {
        return file.length() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate readCertificate(File file) {
        X509Certificate x509Certificate;
        if (!file.isFile()) {
            return null;
        }
        BufferedInputStream is = null;
        try {
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                x509Certificate = (X509Certificate)CERT_FACTORY.generateCertificate(is);
                Object var6_6 = null;
            }
            catch (IOException e) {
                X509Certificate x509Certificate2 = null;
                Object var6_7 = null;
                IoUtils.closeQuietly(is);
                return x509Certificate2;
            }
            catch (CertificateException e) {
                X509Certificate x509Certificate3 = null;
                Object var6_8 = null;
                IoUtils.closeQuietly(is);
                return x509Certificate3;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            IoUtils.closeQuietly(is);
            throw throwable;
        }
        IoUtils.closeQuietly(is);
        return x509Certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCertificate(File file, X509Certificate cert) throws IOException, CertificateException {
        File dir = file.getParentFile();
        dir.mkdirs();
        dir.setReadable(true, false);
        dir.setExecutable(true, false);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(cert.getEncoded());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IoUtils.closeQuietly(os);
            throw throwable;
        }
        IoUtils.closeQuietly(os);
        file.setReadable(true, false);
    }

    private boolean isDeletedSystemCertificate(X509Certificate x) {
        return this.getCertificateFile(this.deletedDir, x).exists();
    }

    public Date getCreationDate(String alias) {
        if (!this.containsAlias(alias)) {
            return null;
        }
        File file = this.fileForAlias(alias);
        if (file == null) {
            return null;
        }
        long time = file.lastModified();
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    public Set<String> aliases() {
        HashSet<String> result = new HashSet<String>();
        this.addAliases(result, PREFIX_USER, this.addedDir);
        this.addAliases(result, PREFIX_SYSTEM, this.systemDir);
        return result;
    }

    public Set<String> userAliases() {
        HashSet<String> result = new HashSet<String>();
        this.addAliases(result, PREFIX_USER, this.addedDir);
        return result;
    }

    private void addAliases(Set<String> result, String prefix, File dir) {
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (String filename : files) {
            String alias = prefix + filename;
            if (!this.containsAlias(alias)) continue;
            result.add(alias);
        }
    }

    public Set<String> allSystemAliases() {
        HashSet<String> result = new HashSet<String>();
        String[] files = this.systemDir.list();
        if (files == null) {
            return result;
        }
        for (String filename : files) {
            String alias = PREFIX_SYSTEM + filename;
            if (!this.containsAlias(alias, true)) continue;
            result.add(alias);
        }
        return result;
    }

    public boolean containsAlias(String alias) {
        return this.containsAlias(alias, false);
    }

    private boolean containsAlias(String alias, boolean includeDeletedSystem) {
        return this.getCertificate(alias, includeDeletedSystem) != null;
    }

    public String getCertificateAlias(Certificate c) {
        if (c == null || !(c instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x = (X509Certificate)c;
        File user = this.getCertificateFile(this.addedDir, x);
        if (user.exists()) {
            return PREFIX_USER + user.getName();
        }
        if (this.isDeletedSystemCertificate(x)) {
            return null;
        }
        File system = this.getCertificateFile(this.systemDir, x);
        if (system.exists()) {
            return PREFIX_SYSTEM + system.getName();
        }
        return null;
    }

    public boolean isUserAddedCertificate(X509Certificate cert) {
        return this.getCertificateFile(this.addedDir, cert).exists();
    }

    private File getCertificateFile(File dir, final X509Certificate x) {
        CertSelector selector = new CertSelector(){

            public boolean match(X509Certificate cert) {
                return cert.equals(x);
            }
        };
        return this.findCert(dir, x.getSubjectX500Principal(), selector, File.class);
    }

    public boolean isTrustAnchor(final X509Certificate c) {
        CertSelector selector = new CertSelector(){

            public boolean match(X509Certificate ca) {
                return ca.getPublicKey().equals(c.getPublicKey());
            }
        };
        boolean user = this.findCert(this.addedDir, c.getSubjectX500Principal(), selector, Boolean.class);
        if (user) {
            return true;
        }
        X509Certificate system = this.findCert(this.systemDir, c.getSubjectX500Principal(), selector, X509Certificate.class);
        return system != null && !this.isDeletedSystemCertificate(system);
    }

    public X509Certificate findIssuer(final X509Certificate c) {
        CertSelector selector = new CertSelector(){

            public boolean match(X509Certificate ca) {
                try {
                    c.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        X500Principal issuer = c.getIssuerX500Principal();
        X509Certificate user = this.findCert(this.addedDir, issuer, selector, X509Certificate.class);
        if (user != null) {
            return user;
        }
        X509Certificate system = this.findCert(this.systemDir, issuer, selector, X509Certificate.class);
        if (system != null && !this.isDeletedSystemCertificate(system)) {
            return system;
        }
        return null;
    }

    private static AuthorityKeyIdentifier getAuthorityKeyIdentifier(X509Certificate cert) {
        byte[] akidBytes = cert.getExtensionValue("2.5.29.35");
        if (akidBytes == null) {
            return null;
        }
        try {
            return AuthorityKeyIdentifier.decode(akidBytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static SubjectKeyIdentifier getSubjectKeyIdentifier(X509Certificate cert) {
        byte[] skidBytes = cert.getExtensionValue("2.5.29.14");
        if (skidBytes == null) {
            return null;
        }
        try {
            return SubjectKeyIdentifier.decode(skidBytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isSelfSignedCertificate(X509Certificate cert) {
        if (!Objects.equal(cert.getSubjectX500Principal(), cert.getIssuerX500Principal())) {
            return false;
        }
        AuthorityKeyIdentifier akid = TrustedCertificateStore.getAuthorityKeyIdentifier(cert);
        if (akid != null) {
            SubjectKeyIdentifier skid;
            byte[] akidKeyId = akid.getKeyIdentifier();
            if (akidKeyId != null && !Arrays.equals(akidKeyId, (skid = TrustedCertificateStore.getSubjectKeyIdentifier(cert)).getKeyIdentifier())) {
                return false;
            }
            BigInteger akidSerial = akid.getAuthorityCertSerialNumber();
            if (akidSerial != null && !akidSerial.equals(cert.getSerialNumber())) {
                return false;
            }
            GeneralNames possibleIssuerNames = akid.getAuthorityCertIssuer();
            if (possibleIssuerNames != null) {
                GeneralName issuerName = null;
                for (GeneralName possibleName : possibleIssuerNames.getNames()) {
                    if (possibleName.getTag() != 4) continue;
                    issuerName = possibleName;
                    break;
                }
                if (issuerName != null) {
                    String issuerCanonical = ((Name)issuerName.getName()).getName("CANONICAL");
                    try {
                        String subjectCanonical = new Name(cert.getSubjectX500Principal().getEncoded()).getName("CANONICAL");
                        if (!issuerCanonical.equals(subjectCanonical)) {
                            return false;
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    public List<X509Certificate> getCertificateChain(X509Certificate leaf) {
        X509Certificate issuer;
        X509Certificate cert;
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(leaf);
        int i = 0;
        while (!TrustedCertificateStore.isSelfSignedCertificate(cert = (X509Certificate)chain.get(i)) && (issuer = this.findIssuer(cert)) != null) {
            chain.add(issuer);
            ++i;
        }
        return chain;
    }

    private <T> T findCert(File dir, X500Principal subject, CertSelector selector, Class<T> desiredReturnType) {
        String hash = this.hash(subject);
        int index = 0;
        while (true) {
            X509Certificate cert;
            File file;
            if (!(file = this.file(dir, hash, index)).isFile()) {
                if (desiredReturnType == Boolean.class) {
                    return (T)Boolean.FALSE;
                }
                if (desiredReturnType == File.class) {
                    return (T)file;
                }
                return null;
            }
            if (!this.isTombstone(file) && (cert = this.readCertificate(file)) != null && selector.match(cert)) {
                if (desiredReturnType == X509Certificate.class) {
                    return (T)cert;
                }
                if (desiredReturnType == Boolean.class) {
                    return (T)Boolean.TRUE;
                }
                if (desiredReturnType == File.class) {
                    return (T)file;
                }
                throw new AssertionError();
            }
            ++index;
        }
    }

    private String hash(X500Principal name) {
        int hash = NativeCrypto.X509_NAME_hash_old(name);
        return IntegralToString.intToHexString(hash, false, 8);
    }

    private File file(File dir, String hash, int index) {
        return new File(dir, hash + '.' + index);
    }

    public void installCertificate(X509Certificate cert) throws IOException, CertificateException {
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        File system = this.getCertificateFile(this.systemDir, cert);
        if (system.exists()) {
            File deleted = this.getCertificateFile(this.deletedDir, cert);
            if (deleted.exists()) {
                if (!deleted.delete()) {
                    throw new IOException("Could not remove " + deleted);
                }
                return;
            }
            return;
        }
        File user = this.getCertificateFile(this.addedDir, cert);
        if (user.exists()) {
            return;
        }
        this.writeCertificate(user, cert);
    }

    public void deleteCertificateEntry(String alias) throws IOException, CertificateException {
        if (alias == null) {
            return;
        }
        File file = this.fileForAlias(alias);
        if (file == null) {
            return;
        }
        if (TrustedCertificateStore.isSystem(alias)) {
            X509Certificate cert = this.readCertificate(file);
            if (cert == null) {
                return;
            }
            File deleted = this.getCertificateFile(this.deletedDir, cert);
            if (deleted.exists()) {
                return;
            }
            this.writeCertificate(deleted, cert);
            return;
        }
        if (TrustedCertificateStore.isUser(alias)) {
            new FileOutputStream(file).close();
            this.removeUnnecessaryTombstones(alias);
            return;
        }
    }

    private void removeUnnecessaryTombstones(String alias) throws IOException {
        File file;
        int lastTombstoneIndex;
        if (!TrustedCertificateStore.isUser(alias)) {
            throw new AssertionError((Object)alias);
        }
        int dotIndex = alias.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new AssertionError((Object)alias);
        }
        String hash = alias.substring(PREFIX_USER.length(), dotIndex);
        if (this.file(this.addedDir, hash, (lastTombstoneIndex = Integer.parseInt(alias.substring(dotIndex + 1))) + 1).exists()) {
            return;
        }
        while (lastTombstoneIndex >= 0 && this.isTombstone(file = this.file(this.addedDir, hash, lastTombstoneIndex))) {
            if (!file.delete()) {
                throw new IOException("Could not remove " + file);
            }
            --lastTombstoneIndex;
        }
    }

    static {
        String ANDROID_ROOT = System.getenv("ANDROID_ROOT");
        String ANDROID_DATA = System.getenv("ANDROID_DATA");
        CA_CERTS_DIR_SYSTEM = new File(ANDROID_ROOT + "/etc/security/cacerts");
        CA_CERTS_DIR_ADDED = new File(ANDROID_DATA + "/misc/keychain/cacerts-added");
        CA_CERTS_DIR_DELETED = new File(ANDROID_DATA + "/misc/keychain/cacerts-removed");
        try {
            CERT_FACTORY = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static interface CertSelector {
        public boolean match(X509Certificate var1);
    }
}

