/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.AccountMonitorListener;
import android.accounts.AccountsServiceConstants;
import android.accounts.IAccountsService;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.database.SQLException;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;

public class AccountMonitor
extends BroadcastReceiver
implements ServiceConnection {
    public final Context mContext;
    public final AccountMonitorListener mListener;
    public boolean mClosed = false;
    public int pending = 0;

    public AccountMonitor(Context context, AccountMonitorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.mContext = context;
        this.mListener = listener;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.accounts.LOGIN_ACCOUNTS_CHANGED");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        this.mContext.registerReceiver(this, intentFilter);
        this.notifyListener();
    }

    public void onReceive(Context context, Intent intent) {
        this.notifyListener();
    }

    public void onServiceConnected(ComponentName className, IBinder service) {
        new AccountUpdater(service).start();
    }

    public void onServiceDisconnected(ComponentName className) {
    }

    public synchronized void notifyListener() {
        if (this.pending == 0 && !this.mContext.bindService(AccountsServiceConstants.SERVICE_INTENT, this, 1)) {
            Log.w("AccountMonitor", "Couldn't connect to " + AccountsServiceConstants.SERVICE_INTENT + " (Missing service?)");
        }
        ++this.pending;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public synchronized void close() {
        if (!this.mClosed) {
            this.mContext.unregisterReceiver(this);
            this.mClosed = true;
        }
    }

    public class AccountUpdater
    extends Thread {
        public IBinder mService;

        public AccountUpdater(IBinder service) {
            this.mService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Process.setThreadPriority(10);
            IAccountsService accountsService = IAccountsService.Stub.asInterface(this.mService);
            String[] accounts = null;
            while (true) {
                try {
                    accounts = accountsService.getAccounts();
                }
                catch (RemoteException e) {
                    Log.w("AccountMonitor", "Remote exception when getting accounts", e);
                    return;
                }
                AccountMonitor e = AccountMonitor.this;
                synchronized (e) {
                    --AccountMonitor.this.pending;
                    if (AccountMonitor.this.pending == 0) {
                        break;
                    }
                }
            }
            AccountMonitor.this.mContext.unbindService(AccountMonitor.this);
            try {
                AccountMonitor.this.mListener.onAccountsUpdated(accounts);
            }
            catch (SQLException e) {
                Log.e("AccountMonitor", "Can't update accounts", e);
            }
        }
    }
}

