/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.ISearchManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.server.search.SearchableInfo;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CursorAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import android.widget.WrapperListAdapter;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDialog
extends Dialog
implements AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener {
    public static final String LOG_TAG = "SearchDialog";
    public static final int DBG_LOG_TIMING = 0;
    public static final int DBG_JAM_THREADING = 0;
    public IntentFilter mCloseDialogsFilter;
    public IntentFilter mPackageFilter;
    public static final String INSTANCE_KEY_COMPONENT = "comp";
    public static final String INSTANCE_KEY_APPDATA = "data";
    public static final String INSTANCE_KEY_GLOBALSEARCH = "glob";
    public static final String INSTANCE_KEY_DISPLAY_QUERY = "dQry";
    public static final String INSTANCE_KEY_DISPLAY_SEL_START = "sel1";
    public static final String INSTANCE_KEY_DISPLAY_SEL_END = "sel2";
    public static final String INSTANCE_KEY_USER_QUERY = "uQry";
    public static final String INSTANCE_KEY_SUGGESTION_QUERY = "sQry";
    public static final String INSTANCE_KEY_SELECTED_ELEMENT = "slEl";
    public static final int INSTANCE_SELECTED_BUTTON = -2;
    public static final int INSTANCE_SELECTED_QUERY = -1;
    public TextView mBadgeLabel;
    public AutoCompleteTextView mSearchTextField;
    public Button mGoButton;
    public ImageButton mVoiceButton;
    public ComponentName mLaunchComponent;
    public Bundle mAppSearchData;
    public boolean mGlobalSearchMode;
    public Context mActivityContext;
    public SearchableInfo mSearchable;
    public String mUserQuery = null;
    public int mUserQuerySelStart;
    public int mUserQuerySelEnd;
    public boolean mLeaveJammedQueryOnRefocus = false;
    public String mPreviousSuggestionQuery = null;
    public int mPresetSelection = -1;
    public String mSuggestionAction = null;
    public Uri mSuggestionData = null;
    public String mSuggestionQuery = null;
    public Intent mVoiceWebSearchIntent;
    public Intent mVoiceAppSearchIntent;
    public SuggestionsAdapter mSuggestionsAdapter;
    public TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int after) {
            SearchDialog.this.updateWidgetState();
            if (SearchDialog.this.mSuggestionsAdapter != null && !SearchDialog.this.mSuggestionsAdapter.getNonUserQuery()) {
                SearchDialog.this.mPreviousSuggestionQuery = ((Object)s).toString();
                SearchDialog.this.mUserQuery = SearchDialog.this.mSearchTextField.getText().toString();
                SearchDialog.this.mUserQuerySelStart = SearchDialog.this.mSearchTextField.getSelectionStart();
                SearchDialog.this.mUserQuerySelEnd = SearchDialog.this.mSearchTextField.getSelectionEnd();
            }
        }

        public void afterTextChanged(Editable s) {
        }
    };
    public static final String[] ONE_LINE_FROM = new String[]{"suggest_text_1"};
    public static final String[] ONE_LINE_ICONS_FROM = new String[]{"suggest_text_1", "suggest_icon_1", "suggest_icon_2"};
    public static final String[] TWO_LINE_FROM = new String[]{"suggest_text_1", "suggest_text_2"};
    public static final String[] TWO_LINE_ICONS_FROM = new String[]{"suggest_text_1", "suggest_text_2", "suggest_icon_1", "suggest_icon_2"};
    public static final int[] ONE_LINE_TO = new int[]{16908308};
    public static final int[] ONE_LINE_ICONS_TO = new int[]{16908308, 16908295, 16908296};
    public static final int[] TWO_LINE_TO = new int[]{16908308, 16908309};
    public static final int[] TWO_LINE_ICONS_TO = new int[]{16908308, 16908309, 16908295, 16908296};
    public View.OnKeyListener mButtonsKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (SearchDialog.this.mSearchable != null) {
                return SearchDialog.this.refocusingKeyListener(v, keyCode, event);
            }
            return false;
        }
    };
    public View.OnClickListener mGoButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SearchDialog.this.mSearchable != null) {
                SearchDialog.this.launchQuerySearch(0, null);
            }
        }
    };
    public View.OnClickListener mVoiceButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                if (SearchDialog.this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                    SearchDialog.this.getContext().startActivity(SearchDialog.this.mVoiceWebSearchIntent);
                    SearchDialog.this.dismiss();
                } else if (SearchDialog.this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                    Intent appSearchIntent = SearchDialog.this.createVoiceAppSearchIntent(SearchDialog.this.mVoiceAppSearchIntent);
                    SearchDialog.this.getContext().startActivity(appSearchIntent);
                    SearchDialog.this.dismiss();
                }
            }
            catch (ActivityNotFoundException e) {
                Log.w(SearchDialog.LOG_TAG, "Could not find voice search activity");
            }
        }
    };
    public View.OnKeyListener mTextKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4) {
                SearchDialog.this.cancel();
                return true;
            }
            if (SearchDialog.this.mSearchable != null && TextUtils.getTrimmedLength(SearchDialog.this.mSearchTextField.getText()) > 0) {
                if (SearchDialog.this.mSearchTextField.isPopupShowing() && SearchDialog.this.mSearchTextField.getListSelection() != -1) {
                    return SearchDialog.this.onSuggestionsKey(v, keyCode, event);
                }
                switch (keyCode) {
                    case 66: {
                        if (event.getAction() != 1) break;
                        v.cancelLongPress();
                        SearchDialog.this.launchQuerySearch(0, null);
                        return true;
                    }
                    case 20: {
                        SearchDialog.this.mUserQuery = SearchDialog.this.mSearchTextField.getText().toString();
                        SearchDialog.this.mUserQuerySelStart = SearchDialog.this.mSearchTextField.getSelectionStart();
                        SearchDialog.this.mUserQuerySelEnd = SearchDialog.this.mSearchTextField.getSelectionEnd();
                        break;
                    }
                    default: {
                        SearchableInfo.ActionKeyInfo actionKey;
                        if (event.getAction() != 0 || (actionKey = SearchDialog.this.mSearchable.findActionKey(keyCode)) == null || actionKey.mQueryActionMsg == null) break;
                        SearchDialog.this.launchQuerySearch(keyCode, actionKey.mQueryActionMsg);
                        return true;
                    }
                }
            }
            return false;
        }
    };
    public BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action)) {
                SearchDialog.this.cancel();
            } else if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                SearchDialog.this.onPackageListChange();
            }
        }
    };
    public AtomicLong mLastLogTime = new AtomicLong(SystemClock.uptimeMillis());

    public SearchDialog(Context context) {
        super(context, 16973949);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window theWindow = this.getWindow();
        theWindow.setGravity(55);
        this.setContentView(17367121);
        theWindow.setLayout(-1, -2);
        WindowManager.LayoutParams lp = theWindow.getAttributes();
        lp.setTitle("Search Dialog");
        lp.softInputMode = 4;
        theWindow.setAttributes(lp);
        this.mBadgeLabel = (TextView)this.findViewById(16908742);
        this.mSearchTextField = (AutoCompleteTextView)this.findViewById(16908744);
        this.mGoButton = (Button)this.findViewById(16908745);
        this.mVoiceButton = (ImageButton)this.findViewById(16908746);
        this.mSearchTextField.addTextChangedListener(this.mTextWatcher);
        this.mSearchTextField.setOnKeyListener(this.mTextKeyListener);
        this.mGoButton.setOnClickListener(this.mGoButtonClickListener);
        this.mGoButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mVoiceButton.setOnClickListener(this.mVoiceButtonClickListener);
        this.mVoiceButton.setOnKeyListener(this.mButtonsKeyListener);
        this.mBadgeLabel.setVisibility(8);
        this.setCanceledOnTouchOutside(true);
        this.mCloseDialogsFilter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mPackageFilter = new IntentFilter();
        this.mPackageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        this.mPackageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        this.mPackageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        this.mPackageFilter.addDataScheme("package");
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
    }

    public boolean show(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData, boolean globalSearch) {
        if (this.isShowing()) {
            return true;
        }
        ISearchManager sms = ISearchManager.Stub.asInterface(ServiceManager.getService("search"));
        try {
            this.mSearchable = sms.getSearchableInfo(componentName, globalSearch);
        }
        catch (RemoteException e) {
            this.mSearchable = null;
        }
        if (this.mSearchable == null) {
            return false;
        }
        super.show();
        this.setupSearchableInfo();
        this.mLaunchComponent = componentName;
        this.mAppSearchData = appSearchData;
        this.mGlobalSearchMode = globalSearch;
        this.getContext().registerReceiver(this.mBroadcastReceiver, this.mCloseDialogsFilter);
        this.getContext().registerReceiver(this.mBroadcastReceiver, this.mPackageFilter);
        this.mSearchTextField.setOnItemClickListener(this);
        this.mSearchTextField.setOnItemSelectedListener(this);
        if (initialQuery == null) {
            initialQuery = "";
        }
        if (this.mSearchable.getSuggestAuthority() == null) {
            this.mSuggestionsAdapter = null;
            this.mSearchTextField.setAdapter(this.mSuggestionsAdapter);
            this.mSearchTextField.setText(initialQuery);
        } else {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this.mSearchable, this.mSearchTextField);
            this.mSearchTextField.setAdapter(this.mSuggestionsAdapter);
            this.mSuggestionsAdapter.setNonUserQuery(false);
            this.mSearchTextField.setText(initialQuery);
        }
        if (selectInitialQuery) {
            this.mSearchTextField.selectAll();
        } else {
            this.mSearchTextField.setSelection(initialQuery.length());
        }
        return true;
    }

    @Override
    public void show() {
    }

    @Override
    public void onStop() {
        super.onStop();
        this.setOnCancelListener(null);
        this.setOnDismissListener(null);
        try {
            this.getContext().unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.changeCursor(null);
        }
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mSuggestionAction = null;
        this.mSuggestionData = null;
        this.mSuggestionQuery = null;
        this.mActivityContext = null;
        this.mPreviousSuggestionQuery = null;
        this.mUserQuery = null;
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putBoolean(INSTANCE_KEY_GLOBALSEARCH, this.mGlobalSearchMode);
        bundle.putString(INSTANCE_KEY_DISPLAY_QUERY, this.mSearchTextField.getText().toString());
        bundle.putInt(INSTANCE_KEY_DISPLAY_SEL_START, this.mSearchTextField.getSelectionStart());
        bundle.putInt(INSTANCE_KEY_DISPLAY_SEL_END, this.mSearchTextField.getSelectionEnd());
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        bundle.putString(INSTANCE_KEY_SUGGESTION_QUERY, this.mPreviousSuggestionQuery);
        int selectedElement = -1;
        if (this.mGoButton.isFocused()) {
            selectedElement = -2;
        } else if (this.mSearchTextField.isPopupShowing()) {
            selectedElement = 0;
        }
        bundle.putInt(INSTANCE_KEY_SELECTED_ELEMENT, selectedElement);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        ComponentName launchComponent = (ComponentName)savedInstanceState.getParcelable(INSTANCE_KEY_COMPONENT);
        Bundle appSearchData = savedInstanceState.getBundle(INSTANCE_KEY_APPDATA);
        boolean globalSearch = savedInstanceState.getBoolean(INSTANCE_KEY_GLOBALSEARCH);
        String displayQuery = savedInstanceState.getString(INSTANCE_KEY_DISPLAY_QUERY);
        int querySelStart = savedInstanceState.getInt(INSTANCE_KEY_DISPLAY_SEL_START, -1);
        int querySelEnd = savedInstanceState.getInt(INSTANCE_KEY_DISPLAY_SEL_END, -1);
        String userQuery = savedInstanceState.getString(INSTANCE_KEY_USER_QUERY);
        int selectedElement = savedInstanceState.getInt(INSTANCE_KEY_SELECTED_ELEMENT);
        String suggestionQuery = savedInstanceState.getString(INSTANCE_KEY_SUGGESTION_QUERY);
        if (!this.show(suggestionQuery, false, launchComponent, appSearchData, globalSearch)) {
            return;
        }
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setNonUserQuery(true);
        }
        this.mSearchTextField.setText(displayQuery);
        switch (selectedElement) {
            case -2: {
                this.mGoButton.setEnabled(true);
                this.mGoButton.setFocusable(true);
                this.mGoButton.requestFocus();
                break;
            }
            case -1: {
                if (querySelStart < 0 || querySelEnd < 0) break;
                this.mSearchTextField.requestFocus();
                this.mSearchTextField.setSelection(querySelStart, querySelEnd);
                break;
            }
            default: {
                this.mPresetSelection = selectedElement;
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.isShowing()) {
            this.updateSearchButton();
            this.updateSearchBadge();
            this.updateQueryHint();
        }
    }

    public void setupSearchableInfo() {
        if (this.mSearchable != null) {
            this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
            this.updateSearchButton();
            this.updateSearchBadge();
            this.updateQueryHint();
            this.updateVoiceButton();
            int inputType = this.mSearchable.getInputType();
            if ((inputType & 0xF) == 1) {
                inputType &= 0xFFFEFFFF;
                if (this.mSearchable.getSuggestAuthority() != null) {
                    inputType |= 0x10000;
                }
            }
            this.mSearchTextField.setInputType(inputType);
            this.mSearchTextField.setImeOptions(this.mSearchable.getImeOptions());
        }
    }

    public void onPackageListChange() {
        this.cancel();
    }

    public void updateSearchButton() {
        String textLabel = null;
        Drawable iconLabel = null;
        int textId = this.mSearchable.getSearchButtonText();
        if (textId != 0) {
            textLabel = this.mActivityContext.getResources().getString(textId);
        } else {
            iconLabel = this.getContext().getResources().getDrawable(17301848);
        }
        this.mGoButton.setText(textLabel);
        this.mGoButton.setCompoundDrawablesWithIntrinsicBounds(iconLabel, null, null, null);
    }

    public void updateSearchBadge() {
        int visibility = 8;
        Drawable icon = null;
        String text = null;
        if (this.mSearchable.mBadgeIcon) {
            icon = this.mActivityContext.getResources().getDrawable(this.mSearchable.getIconId());
            visibility = 0;
        } else if (this.mSearchable.mBadgeLabel) {
            text = ((Object)this.mActivityContext.getResources().getText(this.mSearchable.getLabelId())).toString();
            visibility = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        this.mBadgeLabel.setText(text);
        this.mBadgeLabel.setVisibility(visibility);
    }

    public void updateQueryHint() {
        if (this.isShowing()) {
            int hintId;
            String hint = null;
            if (this.mSearchable != null && (hintId = this.mSearchable.getHintId()) != 0) {
                hint = this.mActivityContext.getString(hintId);
            }
            this.mSearchTextField.setHint(hint);
        }
    }

    public void updateVoiceButton() {
        int visibility = 8;
        if (this.mSearchable.getVoiceSearchEnabled()) {
            ResolveInfo ri;
            Intent testIntent = null;
            if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                testIntent = this.mVoiceWebSearchIntent;
            } else if (this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                testIntent = this.mVoiceAppSearchIntent;
            }
            if (testIntent != null && (ri = this.getContext().getPackageManager().resolveActivity(testIntent, 65536)) != null) {
                visibility = 0;
            }
        }
        this.mVoiceButton.setVisibility(visibility);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.cancel();
                return true;
            }
            case 84: {
                if (TextUtils.getTrimmedLength(this.mSearchTextField.getText()) != 0) {
                    this.launchQuerySearch(0, null);
                } else {
                    this.cancel();
                }
                return true;
            }
        }
        SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
        if (actionKey != null && actionKey.mQueryActionMsg != null) {
            this.launchQuerySearch(keyCode, actionKey.mQueryActionMsg);
            return true;
        }
        return false;
    }

    public void updateWidgetState() {
        boolean enabled = TextUtils.getTrimmedLength(this.mSearchTextField.getText()) != 0;
        this.mGoButton.setEnabled(enabled);
        this.mGoButton.setFocusable(enabled);
    }

    public static CursorAdapter getSuggestionsAdapter(AdapterView<?> adapterView) {
        CursorAdapter result = null;
        if (adapterView != null) {
            Object ad = adapterView.getAdapter();
            if (ad instanceof CursorAdapter) {
                result = (CursorAdapter)ad;
            } else if (ad instanceof WrapperListAdapter) {
                result = (CursorAdapter)((WrapperListAdapter)ad).getWrappedAdapter();
            }
        }
        return result;
    }

    public Intent createVoiceAppSearchIntent(Intent baseIntent) {
        Intent queryIntent = new Intent("android.intent.action.SEARCH");
        queryIntent.setComponent(this.mSearchable.mSearchActivity);
        PendingIntent pending = PendingIntent.getActivity(this.getContext(), 0, queryIntent, 0x40000000);
        Bundle queryExtras = new Bundle();
        if (this.mAppSearchData != null) {
            queryExtras.putBundle("app_data", this.mAppSearchData);
        }
        Intent voiceIntent = new Intent(baseIntent);
        String languageModel = "free_form";
        String prompt = null;
        String language = null;
        int maxResults = 1;
        Resources resources = this.mActivityContext.getResources();
        if (this.mSearchable.getVoiceLanguageModeId() != 0) {
            languageModel = resources.getString(this.mSearchable.getVoiceLanguageModeId());
        }
        if (this.mSearchable.getVoicePromptTextId() != 0) {
            prompt = resources.getString(this.mSearchable.getVoicePromptTextId());
        }
        if (this.mSearchable.getVoiceLanguageId() != 0) {
            language = resources.getString(this.mSearchable.getVoiceLanguageId());
        }
        if (this.mSearchable.getVoiceMaxResults() != 0) {
            maxResults = this.mSearchable.getVoiceMaxResults();
        }
        voiceIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", languageModel);
        voiceIntent.putExtra("android.speech.extra.PROMPT", prompt);
        voiceIntent.putExtra("android.speech.extra.LANGUAGE", language);
        voiceIntent.putExtra("android.speech.extra.MAX_RESULTS", maxResults);
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pending);
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", queryExtras);
        return voiceIntent;
    }

    public boolean onSuggestionsKey(View v, int keyCode, KeyEvent event) {
        boolean handled = false;
        if (this.mSearchable != null) {
            handled = this.doSuggestionsKey(v, keyCode, event);
        }
        return handled;
    }

    public boolean refocusingKeyListener(View v, int keyCode, KeyEvent event) {
        boolean handled = false;
        if (!event.isSystem() && keyCode != 19 && keyCode != 20 && keyCode != 21 && keyCode != 22 && keyCode != 23) {
            this.mLeaveJammedQueryOnRefocus = true;
            if (this.mSearchTextField.requestFocus()) {
                handled = this.mSearchTextField.dispatchKeyEvent(event);
            }
            this.mLeaveJammedQueryOnRefocus = false;
        }
        return handled;
    }

    @Override
    public void cancel() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.cancel();
    }

    public void launchQuerySearch(int actionKey, String actionMsg) {
        String query = this.mSearchTextField.getText().toString();
        Bundle appData = this.mAppSearchData;
        SearchableInfo si = this.mSearchable;
        this.dismiss();
        this.sendLaunchIntent("android.intent.action.SEARCH", null, query, appData, actionKey, actionMsg, si);
    }

    public boolean doSuggestionsKey(View v, int keyCode, KeyEvent event) {
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (event.getAction() == 0) {
            String actionMsg;
            Cursor c;
            int position;
            if (keyCode == 66 || keyCode == 84) {
                int position2 = this.mSearchTextField.getListSelection();
                return this.launchSuggestion(this.mSuggestionsAdapter, position2);
            }
            if (keyCode == 21 || keyCode == 22) {
                int selPoint = keyCode == 21 ? 0 : this.mSearchTextField.length();
                this.mSearchTextField.setSelection(selPoint);
                this.mSearchTextField.setListSelection(0);
                this.mSearchTextField.clearListSelection();
                return true;
            }
            if (keyCode == 19 && 0 == this.mSearchTextField.getListSelection()) {
                this.jamSuggestionQuery(false, null, -1);
                return false;
            }
            SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
            if (actionKey != null && (actionKey.mSuggestActionMsg != null || actionKey.mSuggestActionMsgColumn != null) && (position = this.mSearchTextField.getListSelection()) >= 0 && (c = this.mSuggestionsAdapter.getCursor()).moveToPosition(position) && (actionMsg = this.getActionKeyMessage(c, actionKey)) != null && actionMsg.length() > 0) {
                this.setupSuggestionIntent(c, this.mSearchable);
                String query = this.mSearchTextField.getText().toString();
                Bundle appData = this.mAppSearchData;
                SearchableInfo si = this.mSearchable;
                String suggestionAction = this.mSuggestionAction;
                Uri suggestionData = this.mSuggestionData;
                String suggestionQuery = this.mSuggestionQuery;
                this.dismiss();
                this.sendLaunchIntent(suggestionAction, suggestionData, suggestionQuery, appData, keyCode, actionMsg, si);
                return true;
            }
        }
        return false;
    }

    public void jamSuggestionQuery(boolean jamQuery, AdapterView<?> parent, int position) {
        if (this.mSearchable == null) {
            return;
        }
        this.mSuggestionsAdapter.setNonUserQuery(true);
        if (jamQuery) {
            CursorAdapter ca = SearchDialog.getSuggestionsAdapter(parent);
            Cursor c = ca.getCursor();
            if (c.moveToPosition(position)) {
                this.setupSuggestionIntent(c, this.mSearchable);
                String jamText = null;
                if (this.mSuggestionQuery != null) {
                    jamText = this.mSuggestionQuery;
                } else if (this.mSearchable.mQueryRewriteFromData && this.mSuggestionData != null) {
                    jamText = this.mSuggestionData.toString();
                } else if (this.mSearchable.mQueryRewriteFromText) {
                    try {
                        int column = c.getColumnIndexOrThrow("suggest_text_1");
                        jamText = c.getString(column);
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (jamText != null) {
                    this.mSearchTextField.setText(jamText);
                    this.mSearchTextField.setSelection(jamText.length());
                }
            }
        } else {
            this.mSearchTextField.setText(this.mUserQuery);
            try {
                this.mSearchTextField.setSelection(this.mUserQuerySelStart, this.mUserQuerySelEnd);
            }
            catch (IndexOutOfBoundsException e) {
                Log.e(LOG_TAG, "Caught IndexOutOfBoundsException while setting selection.  start=" + this.mUserQuerySelStart + " end=" + this.mUserQuerySelEnd + " text=\"" + this.mUserQuery + "\"");
                this.mSearchTextField.selectAll();
            }
        }
    }

    public void sendLaunchIntent(String action, Uri data, String query, Bundle appData, int actionKey, String actionMsg, SearchableInfo si) {
        Intent launcher = new Intent(action);
        if (query != null) {
            launcher.putExtra("query", query);
        }
        if (data != null) {
            launcher.setData(data);
        }
        if (appData != null) {
            launcher.putExtra("app_data", appData);
        }
        if (actionKey != 0) {
            launcher.putExtra("action_key", actionKey);
            launcher.putExtra("action_msg", actionMsg);
        }
        launcher.setComponent(si.mSearchActivity);
        this.getContext().startActivity(launcher);
    }

    public boolean launchSuggestion(CursorAdapter ca, int position) {
        Cursor c = ca.getCursor();
        if (c != null && c.moveToPosition(position)) {
            this.setupSuggestionIntent(c, this.mSearchable);
            Bundle appData = this.mAppSearchData;
            SearchableInfo si = this.mSearchable;
            String suggestionAction = this.mSuggestionAction;
            Uri suggestionData = this.mSuggestionData;
            String suggestionQuery = this.mSuggestionQuery;
            this.dismiss();
            this.sendLaunchIntent(suggestionAction, suggestionData, suggestionQuery, appData, 0, null, si);
            return true;
        }
        return false;
    }

    public void setupSuggestionIntent(Cursor c, SearchableInfo si) {
        try {
            String query;
            String id2;
            String rowData;
            String action;
            this.mSuggestionAction = null;
            int mColumn = c.getColumnIndex("suggest_intent_action");
            if (mColumn >= 0 && (action = c.getString(mColumn)) != null) {
                this.mSuggestionAction = action;
            }
            if (this.mSuggestionAction == null) {
                this.mSuggestionAction = si.getSuggestIntentAction();
            }
            if (this.mSuggestionAction == null) {
                this.mSuggestionAction = "android.intent.action.SEARCH";
            }
            String data = null;
            mColumn = c.getColumnIndex("suggest_intent_data");
            if (mColumn >= 0 && (rowData = c.getString(mColumn)) != null) {
                data = rowData;
            }
            if (data == null) {
                data = si.getSuggestIntentData();
            }
            if (data != null && (mColumn = c.getColumnIndex("suggest_intent_data_id")) >= 0 && (id2 = c.getString(mColumn)) != null) {
                data = data + "/" + Uri.encode(id2);
            }
            this.mSuggestionData = data == null ? null : Uri.parse(data);
            this.mSuggestionQuery = null;
            mColumn = c.getColumnIndex("suggest_intent_query");
            if (mColumn >= 0 && (query = c.getString(mColumn)) != null) {
                this.mSuggestionQuery = query;
            }
        }
        catch (RuntimeException e) {
            int rowNum;
            try {
                rowNum = c.getPosition();
            }
            catch (RuntimeException e2) {
                rowNum = -1;
            }
            Log.w(LOG_TAG, "Search Suggestions cursor at row " + rowNum + " returned exception" + e.toString());
        }
    }

    public String getActionKeyMessage(Cursor c, SearchableInfo.ActionKeyInfo actionKey) {
        String result = null;
        String column = actionKey.mSuggestActionMsgColumn;
        if (column != null) {
            try {
                int colId = c.getColumnIndexOrThrow(column);
                result = c.getString(colId);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = actionKey.mSuggestActionMsg;
        }
        return result;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.launchSuggestion(this.mSuggestionsAdapter, position);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.jamSuggestionQuery(true, parent, position);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    public void dbgLogTiming(String caller) {
        long millis = SystemClock.uptimeMillis();
        long oldTime = this.mLastLogTime.getAndSet(millis);
        long delta = millis - oldTime;
        String report = millis + " (+" + delta + ") ticks for Search keystroke in " + caller;
        Log.d(LOG_TAG, report);
    }

    public static class SuggestionsAdapter
    extends SimpleCursorAdapter {
        public final String TAG = "SuggestionsAdapter";
        public SearchableInfo mSearchable;
        public Resources mProviderResources;
        public WeakReference<Cursor> mRecentCursor = new WeakReference<Object>(null);
        public boolean mNonUserQuery = false;
        public AutoCompleteTextView mParentView;

        public SuggestionsAdapter(Context context, SearchableInfo searchable, AutoCompleteTextView actv) {
            super(context, -1, null, null, null);
            this.mSearchable = searchable;
            this.mParentView = actv;
            Context activityContext = this.mSearchable.getActivityContext(this.mContext);
            Context providerContext = this.mSearchable.getProviderContext(this.mContext, activityContext);
            this.mProviderResources = providerContext.getResources();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setNonUserQuery(boolean nonUserQuery) {
            SuggestionsAdapter suggestionsAdapter = this;
            synchronized (suggestionsAdapter) {
                this.mNonUserQuery = nonUserQuery;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getNonUserQuery() {
            SuggestionsAdapter suggestionsAdapter = this;
            synchronized (suggestionsAdapter) {
                return this.mNonUserQuery;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
            String query = constraint == null ? "" : ((Object)constraint).toString();
            Cursor c = null;
            SuggestionsAdapter suggestionsAdapter = this;
            synchronized (suggestionsAdapter) {
                if (this.mNonUserQuery) {
                    c = (Cursor)this.mRecentCursor.get();
                    this.mNonUserQuery = false;
                }
            }
            if (c == null) {
                c = this.getSuggestions(this.mSearchable, query);
                suggestionsAdapter = this;
                synchronized (suggestionsAdapter) {
                    this.mRecentCursor = new WeakReference<Cursor>(c);
                }
            }
            return c;
        }

        public void changeCursor(Cursor c) {
            boolean has2Lines;
            if (c == null || c.getCount() == 0) {
                this.changeCursorAndColumns(null, null, null);
                if (c != null) {
                    c.close();
                }
                return;
            }
            int colId = c.getColumnIndex("_id");
            int col1 = c.getColumnIndex("suggest_text_1");
            int col2 = c.getColumnIndex("suggest_text_2");
            int colIc1 = c.getColumnIndex("suggest_icon_1");
            int colIc2 = c.getColumnIndex("suggest_icon_2");
            boolean minimal = colId >= 0 && col1 >= 0;
            boolean hasIcons = colIc1 >= 0 && colIc2 >= 0;
            boolean bl = has2Lines = col2 >= 0;
            if (minimal) {
                int[] to;
                String[] from;
                int layout2;
                if (hasIcons) {
                    if (has2Lines) {
                        layout2 = 17367126;
                        from = TWO_LINE_ICONS_FROM;
                        to = TWO_LINE_ICONS_TO;
                    } else {
                        layout2 = 17367125;
                        from = ONE_LINE_ICONS_FROM;
                        to = ONE_LINE_ICONS_TO;
                    }
                } else if (has2Lines) {
                    layout2 = 17367124;
                    from = TWO_LINE_FROM;
                    to = TWO_LINE_TO;
                } else {
                    layout2 = 17367123;
                    from = ONE_LINE_FROM;
                    to = ONE_LINE_TO;
                }
                this.mParentView.resetListAndClearViews();
                this.changeCursorAndColumns(c, from, to);
                this.setViewResource(layout2);
            } else {
                Log.w(SearchDialog.LOG_TAG, "Suggestions cursor discarded due to missing required columns.");
                this.changeCursorAndColumns(null, null, null);
                c.close();
            }
            if (colIc1 >= 0 != colIc2 >= 0) {
                Log.w(SearchDialog.LOG_TAG, "Suggestion icon column(s) discarded, must be 0 or 2 columns.");
            }
        }

        public CharSequence convertToString(Cursor cursor) {
            String query;
            int column;
            String result = null;
            if (cursor != null && (column = cursor.getColumnIndex("suggest_intent_query")) >= 0 && (query = cursor.getString(column)) != null) {
                result = query;
            }
            return result;
        }

        public Cursor getSuggestions(SearchableInfo searchable, String query) {
            Cursor cursor = null;
            if (searchable.getSuggestAuthority() != null) {
                try {
                    StringBuilder uriStr = new StringBuilder("content://");
                    uriStr.append(searchable.getSuggestAuthority());
                    String contentPath = searchable.getSuggestPath();
                    if (contentPath != null) {
                        uriStr.append('/');
                        uriStr.append(contentPath);
                    }
                    uriStr.append("/search_suggest_query");
                    String[] selArgs = null;
                    if (searchable.getSuggestSelection() != null) {
                        selArgs = new String[]{query};
                    } else {
                        uriStr.append('/');
                        uriStr.append(Uri.encode(query));
                    }
                    cursor = this.mContext.getContentResolver().query(Uri.parse(uriStr.toString()), null, searchable.getSuggestSelection(), selArgs, null);
                }
                catch (RuntimeException e) {
                    Log.w("SuggestionsAdapter", "Search Suggestions query returned exception " + e.toString());
                    cursor = null;
                }
            }
            return cursor;
        }

        public void setViewImage(ImageView v, String value) {
            Drawable img = null;
            try {
                int resID = Integer.parseInt(value);
                if (resID != 0) {
                    img = this.mProviderResources.getDrawable(resID);
                }
            }
            catch (NumberFormatException nfe) {
            }
            catch (Resources.NotFoundException e2) {
                // empty catch block
            }
            v.setImageDrawable(img);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            try {
                return super.getView(position, convertView, parent);
            }
            catch (RuntimeException e) {
                Log.w("SuggestionsAdapter", "Search Suggestions cursor returned exception " + e.toString());
                View v = this.newView(this.mContext, this.mCursor, parent);
                if (v != null) {
                    TextView tv = (TextView)v.findViewById(16908308);
                    tv.setText(e.toString());
                }
                return v;
            }
        }
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        public SearchAutoComplete(Context context) {
            super(null);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public void replaceText(CharSequence text) {
        }

        public boolean enoughToFilter() {
            return true;
        }
    }
}

