/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ISearchManager;
import android.app.SearchDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.ServiceManager;

public class SearchManager
implements DialogInterface.OnDismissListener,
DialogInterface.OnCancelListener {
    public static final char MENU_KEY = 's';
    public static final int MENU_KEYCODE = 47;
    public static final String QUERY = "query";
    public static final String APP_DATA = "app_data";
    public static final String SOURCE = "source";
    public static final String ACTION_KEY = "action_key";
    public static final String ACTION_MSG = "action_msg";
    public static final String SUGGEST_URI_PATH_QUERY = "search_suggest_query";
    public static final String SUGGEST_MIME_TYPE = "vnd.android.cursor.dir/vnd.android.search.suggest";
    public static final String SUGGEST_COLUMN_FORMAT = "suggest_format";
    public static final String SUGGEST_COLUMN_TEXT_1 = "suggest_text_1";
    public static final String SUGGEST_COLUMN_TEXT_2 = "suggest_text_2";
    public static final String SUGGEST_COLUMN_ICON_1 = "suggest_icon_1";
    public static final String SUGGEST_COLUMN_ICON_2 = "suggest_icon_2";
    public static final String SUGGEST_COLUMN_INTENT_ACTION = "suggest_intent_action";
    public static final String SUGGEST_COLUMN_INTENT_DATA = "suggest_intent_data";
    public static final String SUGGEST_COLUMN_INTENT_DATA_ID = "suggest_intent_data_id";
    public static final String SUGGEST_COLUMN_QUERY = "suggest_intent_query";
    public final Context mContext;
    public final Handler mHandler;
    public SearchDialog mSearchDialog;
    public OnDismissListener mDismissListener = null;
    public OnCancelListener mCancelListener = null;
    public static ISearchManager mService = ISearchManager.Stub.asInterface(ServiceManager.getService("search"));

    public SearchManager(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
    }

    public void startSearch(String initialQuery, boolean selectInitialQuery, ComponentName launchActivity, Bundle appSearchData, boolean globalSearch) {
        if (this.mSearchDialog == null) {
            this.mSearchDialog = new SearchDialog(this.mContext);
        }
        this.mSearchDialog.show(initialQuery, selectInitialQuery, launchActivity, appSearchData, globalSearch);
        this.mSearchDialog.setOnCancelListener(this);
        this.mSearchDialog.setOnDismissListener(this);
    }

    public void stopSearch() {
        if (this.mSearchDialog != null) {
            this.mSearchDialog.cancel();
        }
    }

    public boolean isVisible() {
        if (this.mSearchDialog != null) {
            return this.mSearchDialog.isShowing();
        }
        return false;
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    public void onDismiss(DialogInterface dialog) {
        if (dialog == this.mSearchDialog && this.mDismissListener != null) {
            this.mDismissListener.onDismiss();
        }
    }

    public void setOnCancelListener(OnCancelListener listener) {
        this.mCancelListener = listener;
    }

    public void onCancel(DialogInterface dialog) {
        if (dialog == this.mSearchDialog && this.mCancelListener != null) {
            this.mCancelListener.onCancel();
        }
    }

    public void saveSearchDialog(Bundle outState, String key) {
        if (this.mSearchDialog != null && this.mSearchDialog.isShowing()) {
            Bundle searchDialogState = this.mSearchDialog.onSaveInstanceState();
            outState.putBundle(key, searchDialogState);
        }
    }

    public void restoreSearchDialog(Bundle inState, String key) {
        Bundle searchDialogState = inState.getBundle(key);
        if (searchDialogState != null) {
            if (this.mSearchDialog == null) {
                this.mSearchDialog = new SearchDialog(this.mContext);
            }
            this.mSearchDialog.onRestoreInstanceState(searchDialogState);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mSearchDialog != null && this.mSearchDialog.isShowing()) {
            this.mSearchDialog.onConfigurationChanged(newConfig);
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

