/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.ISyncAdapter;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorNative;
import android.database.BulkCursorToCursorAdaptor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.io.FileNotFoundException;

public class ContentProviderProxy
implements IContentProvider {
    public IBinder mRemote;

    public ContentProviderProxy(IBinder remote) {
        this.mRemote = remote;
    }

    public IBinder asBinder() {
        return this.mRemote;
    }

    public IBulkCursor bulkQuery(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder, IContentObserver observer, CursorWindow window) throws RemoteException {
        int i;
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        int length = 0;
        if (projection != null) {
            length = projection.length;
        }
        data.writeInt(length);
        for (i = 0; i < length; ++i) {
            data.writeString(projection[i]);
        }
        data.writeString(selection);
        length = selectionArgs != null ? selectionArgs.length : 0;
        data.writeInt(length);
        for (i = 0; i < length; ++i) {
            data.writeString(selectionArgs[i]);
        }
        data.writeString(sortOrder);
        data.writeStrongBinder(observer.asBinder());
        window.writeToParcel(data, 0);
        this.mRemote.transact(1, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        IBulkCursor bulkCursor = null;
        IBinder bulkCursorBinder = reply.readStrongBinder();
        if (bulkCursorBinder != null) {
            bulkCursor = BulkCursorNative.asInterface(bulkCursorBinder);
        }
        data.recycle();
        reply.recycle();
        return bulkCursor;
    }

    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        CursorWindow window = new CursorWindow(false);
        BulkCursorToCursorAdaptor adaptor = new BulkCursorToCursorAdaptor();
        IBulkCursor bulkCursor = this.bulkQuery(url, projection, selection, selectionArgs, sortOrder, adaptor.getObserver(), window);
        if (bulkCursor == null) {
            return null;
        }
        adaptor.set(bulkCursor);
        return adaptor;
    }

    public String getType(Uri url) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        this.mRemote.transact(2, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        String out = reply.readString();
        data.recycle();
        reply.recycle();
        return out;
    }

    public Uri insert(Uri url, ContentValues values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        values.writeToParcel(data, 0);
        this.mRemote.transact(3, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        Uri out = Uri.CREATOR.createFromParcel(reply);
        data.recycle();
        reply.recycle();
        return out;
    }

    public int bulkInsert(Uri url, ContentValues[] values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeTypedArray(values, 0);
        this.mRemote.transact(13, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    public int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeString(selection);
        data.writeStringArray(selectionArgs);
        this.mRemote.transact(4, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        values.writeToParcel(data, 0);
        data.writeString(selection);
        data.writeStringArray(selectionArgs);
        this.mRemote.transact(10, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        int count = reply.readInt();
        data.recycle();
        reply.recycle();
        return count;
    }

    public ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeString(mode);
        this.mRemote.transact(14, data, reply, 0);
        DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
        int has = reply.readInt();
        ParcelFileDescriptor fd = has != 0 ? reply.readFileDescriptor() : null;
        data.recycle();
        reply.recycle();
        return fd;
    }

    public AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        url.writeToParcel(data, 0);
        data.writeString(mode);
        this.mRemote.transact(15, data, reply, 0);
        DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
        int has = reply.readInt();
        AssetFileDescriptor fd = has != 0 ? AssetFileDescriptor.CREATOR.createFromParcel(reply) : null;
        data.recycle();
        reply.recycle();
        return fd;
    }

    public ISyncAdapter getSyncAdapter() throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken("android.content.IContentProvider");
        this.mRemote.transact(11, data, reply, 0);
        DatabaseUtils.readExceptionFromParcel(reply);
        ISyncAdapter syncAdapter = ISyncAdapter.Stub.asInterface(reply.readStrongBinder());
        data.recycle();
        reply.recycle();
        return syncAdapter;
    }
}

