/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.ContentServiceNative;
import android.content.Context;
import android.content.IContentService;
import android.content.SyncManager;
import android.database.IContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ContentService
extends ContentServiceNative {
    public static final String TAG = "ContentService";
    public Context mContext;
    public boolean mFactoryTest;
    public final ObserverNode mRootNode = new ObserverNode("");
    public SyncManager mSyncManager = null;
    public final Object mSyncManagerLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncManager getSyncManager() {
        Object object = this.mSyncManagerLock;
        synchronized (object) {
            try {
                if (this.mSyncManager == null) {
                    this.mSyncManager = new SyncManager(this.mContext, this.mFactoryTest);
                }
            }
            catch (SQLiteException e) {
                Log.e(TAG, "Can't create SyncManager", e);
            }
            return this.mSyncManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "caller doesn't have the DUMP permission");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            if (this.mSyncManager == null) {
                pw.println("No SyncManager created!  (Disk full?)");
            } else {
                this.mSyncManager.dump(fd, pw);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    public ContentService(Context context, boolean factoryTest) {
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.getSyncManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, IContentObserver observer) {
        if (observer == null || uri == null) {
            throw new IllegalArgumentException("You must pass a valid uri and observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.addObserver(uri, observer, notifyForDescendents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterContentObserver(IContentObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("You must pass a valid observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.removeObserver(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "Notifying update of " + uri + " from observer " + observer + ", syncToNetwork " + syncToNetwork);
        }
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager;
            ArrayList<ObserverCall> calls = new ArrayList<ObserverCall>();
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                this.mRootNode.collectObservers(uri, 0, observer, observerWantsSelfNotifications, calls);
            }
            int numCalls = calls.size();
            for (int i = 0; i < numCalls; ++i) {
                ObserverCall oc = calls.get(i);
                try {
                    oc.mObserver.onChange(oc.mSelfNotify);
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Notified " + oc.mObserver + " of " + "update at " + uri);
                    continue;
                }
                catch (RemoteException ex) {
                    ObserverNode observerNode2 = this.mRootNode;
                    synchronized (observerNode2) {
                        Log.w(TAG, "Found dead observer, removing");
                        IBinder binder = oc.mObserver.asBinder();
                        ArrayList list = oc.mNode.mObservers;
                        int numList = list.size();
                        for (int j = 0; j < numList; ++j) {
                            ObserverNode.ObserverEntry oe = (ObserverNode.ObserverEntry)list.get(j);
                            if (oe.observer.asBinder() != binder) continue;
                            list.remove(j);
                            --j;
                            --numList;
                        }
                        continue;
                    }
                }
            }
            if (syncToNetwork && (syncManager = this.getSyncManager()) != null) {
                syncManager.scheduleLocalSync(uri);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSync(Uri url, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.startSync(url, extras);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSync(Uri uri) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.clearScheduledSyncOperations(uri);
                syncManager.cancelActiveSync(uri);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    public static IContentService main(Context context, boolean factoryTest) {
        ContentService service = new ContentService(context, factoryTest);
        ServiceManager.addService("content", service);
        return service;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObserverNode {
        public static final int INSERT_TYPE = 0;
        public static final int UPDATE_TYPE = 1;
        public static final int DELETE_TYPE = 2;
        public String mName;
        public ArrayList<ObserverNode> mChildren = new ArrayList();
        public ArrayList<ObserverEntry> mObservers = new ArrayList();

        public ObserverNode(String name) {
            this.mName = name;
        }

        public String getUriSegment(Uri uri, int index) {
            if (uri != null) {
                if (index == 0) {
                    return uri.getAuthority();
                }
                return uri.getPathSegments().get(index - 1);
            }
            return null;
        }

        public int countUriSegments(Uri uri) {
            if (uri == null) {
                return 0;
            }
            return uri.getPathSegments().size() + 1;
        }

        public void addObserver(Uri uri, IContentObserver observer, boolean notifyForDescendents) {
            this.addObserver(uri, 0, observer, notifyForDescendents);
        }

        public void addObserver(Uri uri, int index, IContentObserver observer, boolean notifyForDescendents) {
            if (index == this.countUriSegments(uri)) {
                this.mObservers.add(new ObserverEntry(observer, notifyForDescendents));
                return;
            }
            String segment = this.getUriSegment(uri, index);
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (!node.mName.equals(segment)) continue;
                node.addObserver(uri, index + 1, observer, notifyForDescendents);
                return;
            }
            ObserverNode node = new ObserverNode(segment);
            this.mChildren.add(node);
            node.addObserver(uri, index + 1, observer, notifyForDescendents);
        }

        public boolean removeObserver(IContentObserver observer) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                boolean empty = this.mChildren.get(i).removeObserver(observer);
                if (!empty) continue;
                this.mChildren.remove(i);
                --i;
                --size;
            }
            IBinder observerBinder = observer.asBinder();
            size = this.mObservers.size();
            for (int i = 0; i < size; ++i) {
                ObserverEntry entry = this.mObservers.get(i);
                if (entry.observer.asBinder() != observerBinder) continue;
                this.mObservers.remove(i);
                observerBinder.unlinkToDeath(entry, 0);
                break;
            }
            return this.mChildren.size() == 0 && this.mObservers.size() == 0;
        }

        public void collectMyObservers(Uri uri, boolean leaf, IContentObserver observer, boolean selfNotify, ArrayList<ObserverCall> calls) {
            int N = this.mObservers.size();
            IBinder observerBinder = observer == null ? null : observer.asBinder();
            for (int i = 0; i < N; ++i) {
                ObserverEntry entry = this.mObservers.get(i);
                if (entry.observer.asBinder() == observerBinder && !selfNotify || !leaf && (leaf || !entry.notifyForDescendents)) continue;
                calls.add(new ObserverCall(this, entry.observer, selfNotify));
            }
        }

        public void collectObservers(Uri uri, int index, IContentObserver observer, boolean selfNotify, ArrayList<ObserverCall> calls) {
            String segment = null;
            int segmentCount = this.countUriSegments(uri);
            if (index >= segmentCount) {
                this.collectMyObservers(uri, true, observer, selfNotify, calls);
            } else if (index < segmentCount) {
                segment = this.getUriSegment(uri, index);
                this.collectMyObservers(uri, false, observer, selfNotify, calls);
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (segment != null && !node.mName.equals(segment)) continue;
                node.collectObservers(uri, index + 1, observer, selfNotify, calls);
                if (segment != null) break;
            }
        }

        public class ObserverEntry
        implements IBinder.DeathRecipient {
            public IContentObserver observer;
            public boolean notifyForDescendents;

            public ObserverEntry(IContentObserver o, boolean n) {
                this.observer = o;
                this.notifyForDescendents = n;
                try {
                    this.observer.asBinder().linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.binderDied();
                }
            }

            public void binderDied() {
                ObserverNode.this.removeObserver(this.observer);
            }
        }
    }

    public static class ObserverCall {
        public final ObserverNode mNode;
        public final IContentObserver mObserver;
        public final boolean mSelfNotify;

        public ObserverCall(ObserverNode node, IContentObserver observer, boolean selfNotify) {
            this.mNode = node;
            this.mObserver = observer;
            this.mSelfNotify = selfNotify;
        }
    }
}

