/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentServiceProxy;
import android.content.IContentService;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ServiceManager;
import android.util.Log;

public abstract class ContentServiceNative
extends Binder
implements IContentService {
    public static IContentService gDefault;

    public ContentServiceNative() {
        this.attachInterface(this, "android.content.IContentService");
    }

    public static IContentService asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IContentService in = (IContentService)obj.queryLocalInterface("android.content.IContentService");
        if (in != null) {
            return in;
        }
        return new ContentServiceProxy(obj);
    }

    public static IContentService getDefault() {
        if (gDefault != null) {
            return gDefault;
        }
        IBinder b = ServiceManager.getService("content");
        gDefault = ContentServiceNative.asInterface(b);
        return gDefault;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) {
        try {
            switch (code) {
                case 5038: {
                    data.readString();
                    Uri uri = Uri.parse(data.readString());
                    this.notifyChange(uri, null, false, false);
                    return true;
                }
                case 2: {
                    Uri uri = Uri.CREATOR.createFromParcel(data);
                    boolean notifyForDescendents = data.readInt() != 0;
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    this.registerContentObserver(uri, notifyForDescendents, observer);
                    return true;
                }
                case 3: {
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    this.unregisterContentObserver(observer);
                    return true;
                }
                case 4: {
                    Uri uri = Uri.CREATOR.createFromParcel(data);
                    IContentObserver observer = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    boolean observerWantsSelfNotifications = data.readInt() != 0;
                    boolean syncToNetwork = data.readInt() != 0;
                    this.notifyChange(uri, observer, observerWantsSelfNotifications, syncToNetwork);
                    return true;
                }
                case 5: {
                    Uri url = null;
                    int hasUrl = data.readInt();
                    if (hasUrl != 0) {
                        url = Uri.CREATOR.createFromParcel(data);
                    }
                    this.startSync(url, data.readBundle());
                    return true;
                }
                case 6: {
                    Uri url = null;
                    int hasUrl = data.readInt();
                    if (hasUrl != 0) {
                        url = Uri.CREATOR.createFromParcel(data);
                    }
                    this.cancelSync(url);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }
        catch (Exception e) {
            Log.e("ContentServiceNative", "Caught exception in transact", e);
            return false;
        }
    }

    public IBinder asBinder() {
        return this;
    }
}

