/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.IContentService;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;

public class ContentServiceProxy
implements IContentService {
    public IBinder mRemote;

    public ContentServiceProxy(IBinder remote) {
        this.mRemote = remote;
    }

    public IBinder asBinder() {
        return this.mRemote;
    }

    public void registerContentObserver(Uri uri, boolean notifyForDescendents, IContentObserver observer) throws RemoteException {
        Parcel data = Parcel.obtain();
        uri.writeToParcel(data, 0);
        data.writeInt(notifyForDescendents ? 1 : 0);
        data.writeStrongInterface(observer);
        this.mRemote.transact(2, data, null, 0);
        data.recycle();
    }

    public void unregisterContentObserver(IContentObserver observer) throws RemoteException {
        Parcel data = Parcel.obtain();
        data.writeStrongInterface(observer);
        this.mRemote.transact(3, data, null, 0);
        data.recycle();
    }

    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork) throws RemoteException {
        Parcel data = Parcel.obtain();
        uri.writeToParcel(data, 0);
        data.writeStrongInterface(observer);
        data.writeInt(observerWantsSelfNotifications ? 1 : 0);
        data.writeInt(syncToNetwork ? 1 : 0);
        this.mRemote.transact(4, data, null, 1);
        data.recycle();
    }

    public void startSync(Uri url, Bundle extras) throws RemoteException {
        Parcel data = Parcel.obtain();
        if (url == null) {
            data.writeInt(0);
        } else {
            data.writeInt(1);
            url.writeToParcel(data, 0);
        }
        extras.writeToParcel(data, 0);
        this.mRemote.transact(5, data, null, 1);
        data.recycle();
    }

    public void cancelSync(Uri url) throws RemoteException {
        Parcel data = Parcel.obtain();
        if (url == null) {
            data.writeInt(0);
        } else {
            data.writeInt(1);
            url.writeToParcel(data, 0);
        }
        this.mRemote.transact(6, data, null, 1);
        data.recycle();
    }
}

