/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SyncManager;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.Sync;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SyncStorageEngine {
    public static final String TAG = "SyncManager";
    public static final String DATABASE_NAME = "syncmanager.db";
    public static final int DATABASE_VERSION = 10;
    public static final int STATS = 1;
    public static final int STATS_ID = 2;
    public static final int HISTORY = 3;
    public static final int HISTORY_ID = 4;
    public static final int SETTINGS = 5;
    public static final int PENDING = 7;
    public static final int ACTIVE = 8;
    public static final int STATUS = 9;
    public static final UriMatcher sURLMatcher = new UriMatcher(-1);
    public static final HashMap<String, String> HISTORY_PROJECTION_MAP;
    public static final HashMap<String, String> PENDING_PROJECTION_MAP;
    public static final HashMap<String, String> ACTIVE_PROJECTION_MAP;
    public static final HashMap<String, String> STATUS_PROJECTION_MAP;
    public final Context mContext;
    public final SQLiteOpenHelper mOpenHelper;
    public static SyncStorageEngine sSyncStorageEngine;
    public static final String[] STATS_ACCOUNT_PROJECTION;
    public static final int MAX_HISTORY_EVENTS_TO_KEEP = 5000;
    public static final String SELECT_INITIAL_FAILURE_TIME_QUERY_STRING = "SELECT min(a) FROM (  SELECT initialFailureTime AS a   FROM status   WHERE stats_id=? AND a IS NOT NULL     UNION   SELECT ? AS a )";
    public static final long MILLIS_IN_4WEEKS = 2419200000L;

    public SyncStorageEngine(Context context) {
        this.mContext = context;
        this.mOpenHelper = new DatabaseHelper(context);
        sSyncStorageEngine = this;
    }

    public static SyncStorageEngine newTestInstance(Context context) {
        return new SyncStorageEngine(context);
    }

    public static void init(Context context) {
        if (sSyncStorageEngine != null) {
            throw new IllegalStateException("already initialized");
        }
        sSyncStorageEngine = new SyncStorageEngine(context);
    }

    public static SyncStorageEngine getSingleton() {
        if (sSyncStorageEngine == null) {
            throw new IllegalStateException("not initialized");
        }
        return sSyncStorageEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDatabaseCleanup(String[] accounts) {
        HashSet<String> currentAccounts = new HashSet<String>();
        for (String account : accounts) {
            currentAccounts.add(account);
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Cursor cursor = db.query("stats", STATS_ACCOUNT_PROJECTION, null, null, "account", null, null);
        try {
            while (cursor.moveToNext()) {
                String account = cursor.getString(0);
                if (TextUtils.isEmpty(account) || currentAccounts.contains(account)) continue;
                String where = "account=?";
                int numDeleted = db.delete("stats", where, new String[]{account});
                Log.d(TAG, "deleted " + numDeleted + " records from stats table" + " for account " + account);
            }
        }
        finally {
            cursor.close();
        }
    }

    public void setActiveSync(SyncManager.ActiveSyncContext activeSyncContext) {
        if (activeSyncContext != null) {
            this.updateActiveSync(activeSyncContext.mSyncOperation.account, activeSyncContext.mSyncOperation.authority, activeSyncContext.mStartTime);
        } else {
            this.updateActiveSync(null, null, null);
        }
    }

    public int updateActiveSync(String account, String authority, Long startTime) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("account", account);
        values.put("authority", authority);
        values.put("startTime", startTime);
        int numChanges = db.update("active", values, null, null);
        if (numChanges > 0) {
            this.mContext.getContentResolver().notifyChange(Sync.Active.CONTENT_URI, null);
        }
        return numChanges;
    }

    public Cursor query(Uri url, String[] projectionIn, String selection, String[] selectionArgs, String sort) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sURLMatcher.match(url);
        String groupBy = null;
        switch (match) {
            case 1: {
                qb.setTables("stats");
                break;
            }
            case 2: {
                qb.setTables("stats");
                qb.appendWhere("_id=");
                qb.appendWhere(url.getPathSegments().get(1));
                break;
            }
            case 3: {
                qb.setTables("stats, history");
                qb.setProjectionMap(HISTORY_PROJECTION_MAP);
                qb.appendWhere("stats._id = history.stats_id");
                break;
            }
            case 8: {
                qb.setTables("active");
                qb.setProjectionMap(ACTIVE_PROJECTION_MAP);
                qb.appendWhere("account is not null");
                break;
            }
            case 7: {
                qb.setTables("pending");
                qb.setProjectionMap(PENDING_PROJECTION_MAP);
                groupBy = "account, authority";
                break;
            }
            case 9: {
                qb.setTables("stats, status");
                qb.setProjectionMap(STATUS_PROJECTION_MAP);
                qb.appendWhere("stats._id = status.stats_id");
                break;
            }
            case 4: {
                qb.setTables("stats, history");
                qb.setProjectionMap(HISTORY_PROJECTION_MAP);
                qb.appendWhere("stats._id = history.stats_id");
                qb.appendWhere("AND history._id=");
                qb.appendWhere(url.getPathSegments().get(1));
                break;
            }
            case 5: {
                qb.setTables("settings");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL " + url);
            }
        }
        if (match == 5) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        } else {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor c = qb.query(db, projectionIn, selection, selectionArgs, groupBy, null, sort);
        c.setNotificationUri(this.mContext.getContentResolver(), url);
        return c;
    }

    public Uri insert(boolean callerIsTheProvider, Uri url, ContentValues values) {
        long rowID;
        String table;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sURLMatcher.match(url);
        SyncStorageEngine.checkCaller(callerIsTheProvider, match);
        switch (match) {
            case 5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
                table = "settings";
                rowID = db.replace(table, null, values);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL " + url);
            }
        }
        if (rowID > 0L) {
            this.mContext.getContentResolver().notifyChange(url, null);
            return Uri.parse("content://sync/" + table + "/" + rowID);
        }
        return null;
    }

    public static void checkCaller(boolean callerIsTheProvider, int match) {
        if (callerIsTheProvider && match != 5) {
            throw new UnsupportedOperationException("only the settings are modifiable via the ContentProvider interface");
        }
    }

    public int delete(boolean callerIsTheProvider, Uri url, String where, String[] whereArgs) {
        int numRows;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sURLMatcher.match(url);
        switch (match) {
            case 5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
                numRows = db.delete("settings", where, whereArgs);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot delete URL: " + url);
            }
        }
        if (numRows > 0) {
            this.mContext.getContentResolver().notifyChange(url, null);
        }
        return numRows;
    }

    public int update(boolean callerIsTheProvider, Uri url, ContentValues initialValues, String where, String[] whereArgs) {
        switch (sURLMatcher.match(url)) {
            case 5: {
                throw new UnsupportedOperationException("updating url " + url + " is not allowed, use insert instead");
            }
        }
        throw new UnsupportedOperationException("Cannot update URL: " + url);
    }

    public String getType(Uri url) {
        int match = sURLMatcher.match(url);
        switch (match) {
            case 5: {
                return "vnd.android.cursor.dir/sync-settings";
            }
        }
        throw new IllegalArgumentException("Unknown URL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insertIntoPending(ContentValues values) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        try {
            db.beginTransaction();
            long rowId = db.insert("pending", "account", values);
            if (rowId < 0L) {
                Uri uri = null;
                return uri;
            }
            String account = values.getAsString("account");
            String authority = values.getAsString("authority");
            long statsId = this.createStatsRowIfNecessary(account, authority);
            this.createStatusRowIfNecessary(statsId);
            values.clear();
            values.put("pending", 1);
            int numUpdatesStatus = db.update("status", values, "stats_id=" + statsId, null);
            db.setTransactionSuccessful();
            this.mContext.getContentResolver().notifyChange(Sync.Pending.CONTENT_URI, null);
            if (numUpdatesStatus > 0) {
                this.mContext.getContentResolver().notifyChange(Sync.Status.CONTENT_URI, null);
            }
            Uri uri = ContentUris.withAppendedId(Sync.Pending.CONTENT_URI, rowId);
            return uri;
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteFromPending(long rowId) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            boolean isPending;
            String authority;
            String account;
            Cursor c = db.query("pending", new String[]{"account", "authority"}, "_id=" + rowId, null, null, null, null);
            try {
                if (c.getCount() != 1) {
                    int n = 0;
                    return n;
                }
                c.moveToNext();
                account = c.getString(0);
                authority = c.getString(1);
            }
            finally {
                c.close();
            }
            db.delete("pending", "_id=" + rowId, null);
            String[] accountAuthorityWhereArgs = new String[]{account, authority};
            boolean bl = isPending = 0L < DatabaseUtils.longForQuery(db, "SELECT COUNT(*) FROM PENDING WHERE account=? AND authority=?", accountAuthorityWhereArgs);
            if (!isPending) {
                long statsId = this.createStatsRowIfNecessary(account, authority);
                db.execSQL("UPDATE status SET pending=0 WHERE stats_id=" + statsId);
            }
            db.setTransactionSuccessful();
            this.mContext.getContentResolver().notifyChange(Sync.Pending.CONTENT_URI, null);
            if (!isPending) {
                this.mContext.getContentResolver().notifyChange(Sync.Status.CONTENT_URI, null);
            }
            int n = 1;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clearPending() {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            int numChanges = db.delete("pending", null, null);
            if (numChanges > 0) {
                db.execSQL("UPDATE status SET pending=0");
                this.mContext.getContentResolver().notifyChange(Sync.Pending.CONTENT_URI, null);
                this.mContext.getContentResolver().notifyChange(Sync.Status.CONTENT_URI, null);
            }
            db.setTransactionSuccessful();
            int n = numChanges;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public Cursor getPendingSyncsCursor(String[] projection) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        return db.query("pending", projection, null, null, null, null, null);
    }

    public boolean purgeOldHistoryEvents(long now) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int numDeletes = db.delete("history", "eventTime<" + (now - 2419200000L), null);
        if (Log.isLoggable(TAG, 2) && numDeletes > 0) {
            Log.v(TAG, "deleted " + numDeletes + " old event(s) from the sync history");
        }
        return (numDeletes += db.delete("history", "eventTime < (select min(eventTime) from (select eventTime from history order by eventTime desc limit ?))", new String[]{String.valueOf(5000)})) > 0;
    }

    public long insertStartSyncEvent(String account, String authority, long now, int source) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        long statsId = this.createStatsRowIfNecessary(account, authority);
        this.purgeOldHistoryEvents(now);
        ContentValues values = new ContentValues();
        values.put("stats_id", statsId);
        values.put("eventTime", now);
        values.put("source", source);
        values.put("event", 0);
        long rowId = db.insert("history", null, values);
        this.mContext.getContentResolver().notifyChange(Sync.History.CONTENT_URI, null);
        this.mContext.getContentResolver().notifyChange(Sync.Status.CONTENT_URI, null);
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSyncEvent(long historyId, long elapsedTime, String resultMessage, long downstreamActivity, long upstreamActivity) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            ContentValues values = new ContentValues();
            values.put("elapsedTime", elapsedTime);
            values.put("event", 1);
            values.put("mesg", resultMessage);
            values.put("downstreamActivity", downstreamActivity);
            values.put("upstreamActivity", upstreamActivity);
            int count = db.update("history", values, "_id=?", new String[]{Long.toString(historyId)});
            if (count > 0) {
                int source = (int)DatabaseUtils.longForQuery(db, "SELECT source FROM history WHERE _id=" + historyId, null);
                long eventTime = DatabaseUtils.longForQuery(db, "SELECT eventTime FROM history WHERE _id=" + historyId, null);
                long statsId = DatabaseUtils.longForQuery(db, "SELECT stats_id FROM history WHERE _id=" + historyId, null);
                this.createStatusRowIfNecessary(statsId);
                StringBuilder sb = new StringBuilder();
                ArrayList<String> bindArgs = new ArrayList<String>();
                sb.append("UPDATE status SET");
                sb.append(" numSyncs=numSyncs+1");
                sb.append(", totalElapsedTime=totalElapsedTime+" + elapsedTime);
                switch (source) {
                    case 1: {
                        sb.append(", numSourceLocal=numSourceLocal+1");
                        break;
                    }
                    case 2: {
                        sb.append(", numSourcePoll=numSourcePoll+1");
                        break;
                    }
                    case 3: {
                        sb.append(", numSourceUser=numSourceUser+1");
                        break;
                    }
                    case 0: {
                        sb.append(", numSourceServer=numSourceServer+1");
                    }
                }
                String statsIdString = String.valueOf(statsId);
                long lastSyncTime = eventTime + elapsedTime;
                if ("success".equals(resultMessage)) {
                    sb.append(", lastSuccessTime=" + lastSyncTime);
                    sb.append(", lastSuccessSource=" + source);
                    sb.append(", lastFailureTime=null");
                    sb.append(", lastFailureSource=null");
                    sb.append(", lastFailureMesg=null");
                    sb.append(", initialFailureTime=null");
                } else if (!"canceled".equals(resultMessage)) {
                    sb.append(", lastFailureTime=" + lastSyncTime);
                    sb.append(", lastFailureSource=" + source);
                    sb.append(", lastFailureMesg=?");
                    bindArgs.add(resultMessage);
                    long initialFailureTime = DatabaseUtils.longForQuery(db, SELECT_INITIAL_FAILURE_TIME_QUERY_STRING, new String[]{statsIdString, String.valueOf(lastSyncTime)});
                    sb.append(", initialFailureTime=" + initialFailureTime);
                }
                sb.append(" WHERE stats_id=?");
                bindArgs.add(statsIdString);
                db.execSQL(sb.toString(), bindArgs.toArray());
                db.setTransactionSuccessful();
                this.mContext.getContentResolver().notifyChange(Sync.History.CONTENT_URI, null);
                this.mContext.getContentResolver().notifyChange(Sync.Status.CONTENT_URI, null);
            }
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInitialSyncFailureTime() {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor c = db.rawQuery("SELECT initialFailureTime, s1.value, s2.value FROM status LEFT JOIN stats ON status.stats_id=stats._id LEFT JOIN settings as s1 ON 'sync_provider_' || authority=s1.name LEFT JOIN settings as s2 ON s2.name='listen_for_tickles' where initialFailureTime is not null   AND lastFailureMesg!=6  AND lastFailureMesg!=2  AND lastFailureMesg!=1  AND authority!='subscribedfeeds'  ORDER BY initialFailureTime", null);
        try {
            while (c.moveToNext()) {
                String allEnabledString;
                String providerEnabledString = c.getString(1);
                if (providerEnabledString != null && !Boolean.parseBoolean(providerEnabledString) || (allEnabledString = c.getString(2)) != null && !Boolean.parseBoolean(allEnabledString)) continue;
                long l = c.getLong(0);
                return l;
            }
        }
        finally {
            c.close();
        }
        return 0L;
    }

    public void createStatusRowIfNecessary(long statsId) {
        boolean statusExists;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        boolean bl = statusExists = 0L != DatabaseUtils.longForQuery(db, "SELECT count(*) FROM status WHERE stats_id=" + statsId, null);
        if (!statusExists) {
            ContentValues values = new ContentValues();
            values.put("stats_id", statsId);
            db.insert("status", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createStatsRowIfNecessary(String account, String authority) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        StringBuilder where = new StringBuilder();
        where.append("account= ?");
        where.append(" and authority= ?");
        Cursor cursor = this.query(Sync.Stats.CONTENT_URI, Sync.Stats.SYNC_STATS_PROJECTION, where.toString(), new String[]{account, authority}, null);
        try {
            long id2;
            if (cursor.moveToFirst()) {
                id2 = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
            } else {
                ContentValues values = new ContentValues();
                values.put("account", account);
                values.put("authority", authority);
                id2 = db.insert("stats", null, values);
            }
            long l = id2;
            return l;
        }
        finally {
            cursor.close();
        }
    }

    static {
        sSyncStorageEngine = null;
        sURLMatcher.addURI("sync", "stats", 1);
        sURLMatcher.addURI("sync", "stats/#", 2);
        sURLMatcher.addURI("sync", "history", 3);
        sURLMatcher.addURI("sync", "history/#", 4);
        sURLMatcher.addURI("sync", "settings", 5);
        sURLMatcher.addURI("sync", "status", 9);
        sURLMatcher.addURI("sync", "active", 8);
        sURLMatcher.addURI("sync", "pending", 7);
        HashMap<String, String> map = new HashMap<String, String>();
        PENDING_PROJECTION_MAP = map;
        map.put("_id", "_id");
        map.put("account", "account");
        map.put("authority", "authority");
        map = new HashMap();
        ACTIVE_PROJECTION_MAP = map;
        map.put("_id", "_id");
        map.put("account", "account");
        map.put("authority", "authority");
        map.put("startTime", "startTime");
        map = new HashMap();
        HISTORY_PROJECTION_MAP = map;
        map.put("_id", "history._id as _id");
        map.put("account", "stats.account as account");
        map.put("authority", "stats.authority as authority");
        map.put("event", "event");
        map.put("eventTime", "eventTime");
        map.put("elapsedTime", "elapsedTime");
        map.put("source", "source");
        map.put("upstreamActivity", "upstreamActivity");
        map.put("downstreamActivity", "downstreamActivity");
        map.put("mesg", "mesg");
        map = new HashMap();
        STATUS_PROJECTION_MAP = map;
        map.put("_id", "status._id as _id");
        map.put("account", "stats.account as account");
        map.put("authority", "stats.authority as authority");
        map.put("totalElapsedTime", "totalElapsedTime");
        map.put("numSyncs", "numSyncs");
        map.put("numSourceLocal", "numSourceLocal");
        map.put("numSourcePoll", "numSourcePoll");
        map.put("numSourceServer", "numSourceServer");
        map.put("numSourceUser", "numSourceUser");
        map.put("lastSuccessSource", "lastSuccessSource");
        map.put("lastSuccessTime", "lastSuccessTime");
        map.put("lastFailureSource", "lastFailureSource");
        map.put("lastFailureTime", "lastFailureTime");
        map.put("lastFailureMesg", "lastFailureMesg");
        map.put("pending", "pending");
        STATS_ACCOUNT_PROJECTION = new String[]{"account"};
    }

    public class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context) {
            super(context, SyncStorageEngine.DATABASE_NAME, null, 10);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE pending (_id INTEGER PRIMARY KEY,authority TEXT NOT NULL,account TEXT NOT NULL,extras BLOB NOT NULL,source INTEGER NOT NULL);");
            db.execSQL("CREATE TABLE stats (_id INTEGER PRIMARY KEY,account TEXT, authority TEXT, syncdata TEXT, UNIQUE (account, authority));");
            db.execSQL("CREATE TABLE history (_id INTEGER PRIMARY KEY,stats_id INTEGER,eventTime INTEGER,elapsedTime INTEGER,source INTEGER,event INTEGER,upstreamActivity INTEGER,downstreamActivity INTEGER,mesg TEXT);");
            db.execSQL("CREATE TABLE status (_id INTEGER PRIMARY KEY,stats_id INTEGER NOT NULL,totalElapsedTime INTEGER NOT NULL DEFAULT 0,numSyncs INTEGER NOT NULL DEFAULT 0,numSourcePoll INTEGER NOT NULL DEFAULT 0,numSourceServer INTEGER NOT NULL DEFAULT 0,numSourceLocal INTEGER NOT NULL DEFAULT 0,numSourceUser INTEGER NOT NULL DEFAULT 0,lastSuccessTime INTEGER,lastSuccessSource INTEGER,lastFailureTime INTEGER,lastFailureSource INTEGER,lastFailureMesg STRING,initialFailureTime INTEGER,pending INTEGER NOT NULL DEFAULT 0);");
            db.execSQL("CREATE TABLE active (_id INTEGER PRIMARY KEY,authority TEXT,account TEXT,startTime INTEGER);");
            db.execSQL("CREATE INDEX historyEventTime ON history (eventTime)");
            db.execSQL("CREATE TABLE settings (name TEXT PRIMARY KEY,value TEXT);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (oldVersion == 9 && newVersion == 10) {
                Log.w(SyncStorageEngine.TAG, "Upgrading database from version " + oldVersion + " to " + newVersion + ", which will preserve old data");
                db.execSQL("ALTER TABLE status ADD COLUMN initialFailureTime INTEGER");
                return;
            }
            Log.w(SyncStorageEngine.TAG, "Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data");
            db.execSQL("DROP TABLE IF EXISTS pending");
            db.execSQL("DROP TABLE IF EXISTS stats");
            db.execSQL("DROP TABLE IF EXISTS history");
            db.execSQL("DROP TABLE IF EXISTS settings");
            db.execSQL("DROP TABLE IF EXISTS active");
            db.execSQL("DROP TABLE IF EXISTS status");
            this.onCreate(db);
        }

        public void onOpen(SQLiteDatabase db) {
            if (!db.isReadOnly()) {
                db.delete("active", null, null);
                db.insert("active", "account", null);
            }
        }
    }
}

