/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.PluralRules;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import org.xmlpull.v1.XmlPullParserException;

public class Resources {
    public static final String TAG = "Resources";
    public static final boolean DEBUG_LOAD = false;
    public static final boolean DEBUG_CONFIG = false;
    public static final boolean TRACE_FOR_PRELOAD = false;
    public static final int sSdkVersion = SystemProperties.getInt("ro.build.version.sdk", 0);
    public static final Object mSync = new Object();
    public static Resources mSystem = null;
    public static final SparseArray<Drawable.ConstantState> mPreloadedDrawables = new SparseArray();
    public static final SparseArray<ColorStateList> mPreloadedColorStateLists = new SparseArray();
    public static boolean mPreloaded;
    public final TypedValue mTmpValue = new TypedValue();
    public final SparseArray<WeakReference<Drawable.ConstantState>> mDrawableCache = new SparseArray();
    public final SparseArray<WeakReference<ColorStateList>> mColorStateListCache = new SparseArray();
    public boolean mPreloading;
    public TypedArray mCachedStyledAttributes = null;
    public int mLastCachedXmlBlockIndex = -1;
    public final int[] mCachedXmlBlockIds = new int[]{0, 0, 0, 0};
    public final XmlBlock[] mCachedXmlBlocks = new XmlBlock[4];
    public final AssetManager mAssets;
    public final Configuration mConfiguration = new Configuration();
    public final DisplayMetrics mMetrics = new DisplayMetrics();
    public PluralRules mPluralRule;

    public Resources(AssetManager assets, DisplayMetrics metrics, Configuration config) {
        this.mAssets = assets;
        this.mConfiguration.setToDefaults();
        this.mMetrics.setToDefaults();
        this.updateConfiguration(config, metrics);
        assets.ensureStringBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getSystem() {
        Object object = mSync;
        synchronized (object) {
            Resources ret = mSystem;
            if (ret == null) {
                mSystem = ret = new Resources();
            }
            return ret;
        }
    }

    public CharSequence getText(int id2) throws NotFoundException {
        CharSequence res = this.mAssets.getResourceText(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    public CharSequence getQuantityText(int id2, int quantity) throws NotFoundException {
        PluralRules rule = this.getPluralRule();
        CharSequence res = this.mAssets.getResourceBagText(id2, rule.attrForNumber(quantity));
        if (res != null) {
            return res;
        }
        res = this.mAssets.getResourceBagText(id2, 0x1000004);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Plural resource ID #0x" + Integer.toHexString(id2) + " quantity=" + quantity + " item=" + PluralRules.stringForQuantity(rule.quantityForNumber(quantity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralRules getPluralRule() {
        Object object = mSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                this.mPluralRule = PluralRules.ruleForLocale(this.mConfiguration.locale);
            }
            return this.mPluralRule;
        }
    }

    public String getString(int id2) throws NotFoundException {
        CharSequence res = this.getText(id2);
        if (res != null) {
            return ((Object)res).toString();
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    public String getString(int id2, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getString(id2);
        return String.format(this.mConfiguration.locale, raw2, formatArgs);
    }

    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws NotFoundException {
        String raw2 = ((Object)this.getQuantityText(id2, quantity)).toString();
        return String.format(this.mConfiguration.locale, raw2, formatArgs);
    }

    public String getQuantityString(int id2, int quantity) throws NotFoundException {
        return ((Object)this.getQuantityText(id2, quantity)).toString();
    }

    public CharSequence getText(int id2, CharSequence def) {
        CharSequence res = id2 != 0 ? this.mAssets.getResourceText(id2) : null;
        return res != null ? res : def;
    }

    public CharSequence[] getTextArray(int id2) throws NotFoundException {
        CharSequence[] res = this.mAssets.getResourceTextArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(id2));
    }

    public String[] getStringArray(int id2) throws NotFoundException {
        String[] res = this.mAssets.getResourceStringArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(id2));
    }

    public int[] getIntArray(int id2) throws NotFoundException {
        int[] res = this.mAssets.getArrayIntResource(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(id2));
    }

    public TypedArray obtainTypedArray(int id2) throws NotFoundException {
        int len = this.mAssets.getArraySize(id2);
        if (len < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        TypedArray array2 = this.getCachedStyledAttributes(len);
        array2.mLength = this.mAssets.retrieveArray(id2, array2.mData);
        array2.mIndices[0] = 0;
        return array2;
    }

    public float getDimension(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimension(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public int getDimensionPixelOffset(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimensionPixelOffset(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public int getDimensionPixelSize(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimensionPixelSize(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public float getFraction(int id2, int base, int pbase) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 6) {
                return TypedValue.complexToFraction(value.data, base, pbase);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawable(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            return this.loadDrawable(value, id2);
        }
    }

    public Movie getMovie(int id2) throws NotFoundException {
        InputStream is = this.openRawResource(id2);
        Movie movie = Movie.decodeStream(is);
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return movie;
    }

    public int getColor(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            if (value.type == 3) {
                ColorStateList csl = this.loadColorStateList(this.mTmpValue, id2);
                return csl.getDefaultColor();
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            return this.loadColorStateList(value, id2);
        }
    }

    public boolean getBoolean(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data != 0;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public int getInteger(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public XmlResourceParser getLayout(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "layout");
    }

    public XmlResourceParser getAnimation(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "anim");
    }

    public XmlResourceParser getXml(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openRawResource(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            return this.openRawResource(id2, this.mTmpValue);
        }
    }

    public InputStream openRawResource(int id2, TypedValue value) throws NotFoundException {
        this.getValue(id2, value, true);
        try {
            return this.mAssets.openNonAsset(value.assetCookie, ((Object)value.string).toString(), 2);
        }
        catch (Exception e) {
            NotFoundException rnf = new NotFoundException("File " + ((Object)value.string).toString() + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
    }

    public AssetFileDescriptor openRawResourceFd(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            try {
                return this.mAssets.openNonAssetFd(value.assetCookie, ((Object)value.string).toString());
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + ((Object)value.string).toString() + " from drawable resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
    }

    public void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    public void getValue(String name, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        int id2 = this.getIdentifier(name, "string", null);
        if (id2 != 0) {
            this.getValue(id2, outValue, resolveRefs);
            return;
        }
        throw new NotFoundException("String resource name " + name);
    }

    public Theme newTheme() {
        return new Theme();
    }

    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        int len = attrs.length;
        TypedArray array2 = this.getCachedStyledAttributes(len);
        XmlBlock.Parser parser = (XmlBlock.Parser)set;
        this.mAssets.retrieveAttributes(parser.mParseState, attrs, array2.mData, array2.mIndices);
        array2.mRsrcs = attrs;
        array2.mXml = parser;
        return array2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config, DisplayMetrics metrics) {
        Object object = this.mTmpValue;
        synchronized (object) {
            int height;
            int width;
            int configChanges = 0xFFFFFFF;
            if (config != null) {
                configChanges = this.mConfiguration.updateFrom(config);
            }
            if (metrics != null) {
                this.mMetrics.setTo(metrics);
            }
            this.mMetrics.scaledDensity = this.mMetrics.density * this.mConfiguration.fontScale;
            String locale = null;
            if (this.mConfiguration.locale != null) {
                locale = this.mConfiguration.locale.getLanguage();
                if (this.mConfiguration.locale.getCountry() != null) {
                    locale = locale + "-" + this.mConfiguration.locale.getCountry();
                }
            }
            if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                width = this.mMetrics.widthPixels;
                height = this.mMetrics.heightPixels;
            } else {
                width = this.mMetrics.heightPixels;
                height = this.mMetrics.widthPixels;
            }
            int keyboardHidden = this.mConfiguration.keyboardHidden;
            if (keyboardHidden == 1 && this.mConfiguration.hardKeyboardHidden == 2) {
                keyboardHidden = 3;
            }
            this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, locale, this.mConfiguration.orientation, this.mConfiguration.touchscreen, (int)(this.mMetrics.density * 160.0f), this.mConfiguration.keyboard, keyboardHidden, this.mConfiguration.navigation, width, height, sSdkVersion);
            int N = this.mDrawableCache.size();
            for (int i = 0; i < N; ++i) {
                Drawable.ConstantState cs2;
                WeakReference<Drawable.ConstantState> ref = this.mDrawableCache.valueAt(i);
                if (ref == null || (cs2 = (Drawable.ConstantState)ref.get()) == null || !Configuration.needNewResources(configChanges, cs2.getChangingConfigurations())) continue;
                this.mDrawableCache.setValueAt(i, null);
            }
            this.mDrawableCache.clear();
            this.mColorStateListCache.clear();
            this.flushLayoutCache();
        }
        object = mSync;
        synchronized (object) {
            if (this.mPluralRule != null) {
                this.mPluralRule = PluralRules.ruleForLocale(config.locale);
            }
        }
    }

    public static void updateSystemConfiguration(Configuration config, DisplayMetrics metrics) {
        if (mSystem != null) {
            mSystem.updateConfiguration(config, metrics);
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public int getIdentifier(String name, String defType, String defPackage) {
        try {
            return Integer.parseInt(name);
        }
        catch (Exception e) {
            return this.mAssets.getResourceIdentifier(name, defType, defPackage);
        }
    }

    public String getResourceName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public String getResourcePackageName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourcePackageName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public String getResourceTypeName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceTypeName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public String getResourceEntryName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceEntryName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public void parseBundleExtras(XmlResourceParser parser, Bundle outBundle) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("extra")) {
                this.parseBundleExtra("extra", parser, outBundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseBundleExtra(String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = this.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:value or android:resource attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs2 = v.coerceToString();
            outBundle.putCharSequence(name, cs2);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    public AssetManager getAssets() {
        return this.mAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLayoutCache() {
        int[] nArray = this.mCachedXmlBlockIds;
        synchronized (this.mCachedXmlBlockIds) {
            int num = this.mCachedXmlBlockIds.length;
            for (int i = 0; i < num; ++i) {
                this.mCachedXmlBlockIds[i] = 0;
                XmlBlock oldBlock = this.mCachedXmlBlocks[i];
                if (oldBlock != null) {
                    oldBlock.close();
                }
                this.mCachedXmlBlocks[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreloading() {
        Object object = mSync;
        synchronized (object) {
            if (mPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            mPreloaded = true;
            this.mPreloading = true;
        }
    }

    public void finishPreloading() {
        if (this.mPreloading) {
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable loadDrawable(TypedValue value, int id2) throws NotFoundException {
        int key = value.assetCookie << 24 | value.data;
        Drawable dr = this.getCachedDrawable(key);
        if (dr != null) {
            return dr;
        }
        Drawable.ConstantState cs2 = mPreloadedDrawables.get(key);
        if (cs2 != null) {
            dr = cs2.newDrawable();
        } else {
            if (value.type >= 28 && value.type <= 31) {
                dr = new ColorDrawable(value.data);
            }
            if (dr == null) {
                if (value.string == null) {
                    throw new NotFoundException("Resource is not a Drawable (color or path): " + value);
                }
                String file = ((Object)value.string).toString();
                if (file.endsWith(".xml")) {
                    try {
                        XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "drawable");
                        dr = Drawable.createFromXml(this, rp);
                        rp.close();
                    }
                    catch (Exception e) {
                        NotFoundException rnf = new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
                        rnf.initCause(e);
                        throw rnf;
                    }
                }
                try {
                    InputStream is = this.mAssets.openNonAsset(value.assetCookie, file, 3);
                    dr = Drawable.createFromResourceStream(this, value, is, file);
                    is.close();
                }
                catch (Exception e) {
                    NotFoundException rnf = new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
                    rnf.initCause(e);
                    throw rnf;
                }
            }
        }
        if (dr != null) {
            dr.setChangingConfigurations(value.changingConfigurations);
            cs2 = dr.getConstantState();
            if (cs2 != null) {
                if (this.mPreloading) {
                    mPreloadedDrawables.put(key, cs2);
                } else {
                    TypedValue typedValue = this.mTmpValue;
                    synchronized (typedValue) {
                        this.mDrawableCache.put(key, new WeakReference<Drawable.ConstantState>(cs2));
                    }
                }
            }
        }
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getCachedDrawable(int key) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            WeakReference<Drawable.ConstantState> wr = this.mDrawableCache.get(key);
            if (wr != null) {
                Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
                if (entry != null) {
                    return entry.newDrawable();
                }
                this.mDrawableCache.delete(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList loadColorStateList(TypedValue value, int id2) throws NotFoundException {
        int key = value.assetCookie << 24 | value.data;
        if (value.type >= 28 && value.type <= 31) {
            ColorStateList csl = mPreloadedColorStateLists.get(key);
            if (csl != null) {
                return csl;
            }
            csl = ColorStateList.valueOf(value.data);
            if (this.mPreloading) {
                mPreloadedColorStateLists.put(key, csl);
            }
            return csl;
        }
        ColorStateList csl = this.getCachedColorStateList(key);
        if (csl != null) {
            return csl;
        }
        csl = mPreloadedColorStateLists.get(key);
        if (csl != null) {
            return csl;
        }
        if (value.string == null) {
            throw new NotFoundException("Resource is not a ColorStateList (color or path): " + value);
        }
        String file = ((Object)value.string).toString();
        if (file.endsWith(".xml")) {
            try {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "colorstatelist");
                csl = ColorStateList.createFromXml(this, rp);
                rp.close();
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + file + " from color state list resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            throw new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        if (csl != null) {
            if (this.mPreloading) {
                mPreloadedColorStateLists.put(key, csl);
            } else {
                TypedValue typedValue = this.mTmpValue;
                synchronized (typedValue) {
                    this.mColorStateListCache.put(key, new WeakReference<ColorStateList>(csl));
                }
            }
        }
        return csl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getCachedColorStateList(int key) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            WeakReference<ColorStateList> wr = this.mColorStateListCache.get(key);
            if (wr != null) {
                ColorStateList entry = (ColorStateList)wr.get();
                if (entry != null) {
                    return entry;
                }
                this.mColorStateListCache.delete(key);
            }
        }
        return null;
    }

    public XmlResourceParser loadXmlResourceParser(int id2, String type) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 3) {
                return this.loadXmlResourceParser(((Object)value.string).toString(), id2, value.assetCookie, type);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws NotFoundException {
        if (id2 != 0) {
            try {
                int[] nArray = this.mCachedXmlBlockIds;
                synchronized (this.mCachedXmlBlockIds) {
                    int num = this.mCachedXmlBlockIds.length;
                    for (int i = 0; i < num; ++i) {
                        if (this.mCachedXmlBlockIds[i] != id2) continue;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return this.mCachedXmlBlocks[i].newParser();
                    }
                    XmlBlock block = this.mAssets.openXmlBlockAsset(assetCookie, file);
                    if (block != null) {
                        int pos = this.mLastCachedXmlBlockIndex + 1;
                        if (pos >= num) {
                            pos = 0;
                        }
                        this.mLastCachedXmlBlockIndex = pos;
                        XmlBlock oldBlock = this.mCachedXmlBlocks[pos];
                        if (oldBlock != null) {
                            oldBlock.close();
                        }
                        this.mCachedXmlBlockIds[pos] = id2;
                        this.mCachedXmlBlocks[pos] = block;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return block.newParser();
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
        {
            throw new NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedArray getCachedStyledAttributes(int len) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedArray attrs = this.mCachedStyledAttributes;
            if (attrs != null) {
                this.mCachedStyledAttributes = null;
                attrs.mLength = len;
                int fullLen = len * 5;
                if (attrs.mData.length >= fullLen) {
                    return attrs;
                }
                attrs.mData = new int[fullLen];
                attrs.mIndices = new int[1 + len];
                return attrs;
            }
            return new TypedArray(this, new int[len * 5], new int[1 + len], len);
        }
    }

    public Resources() {
        this.mAssets = AssetManager.getSystem();
        this.mConfiguration.setToDefaults();
        this.mMetrics.setToDefaults();
        this.updateConfiguration(null, null);
        this.mAssets.ensureStringBlocks();
    }

    public static /* synthetic */ TypedArray access$000(Resources x0, int x1) {
        return x0.getCachedStyledAttributes(x1);
    }

    public class Theme {
        public final AssetManager mAssets;
        public final int mTheme;

        public void applyStyle(int resid, boolean force) {
            AssetManager.applyThemeStyle(this.mTheme, resid, force);
        }

        public void setTo(Theme other) {
            AssetManager.copyTheme(this.mTheme, other.mTheme);
        }

        public TypedArray obtainStyledAttributes(int[] nArray) {
            return (TypedArray)OverrideMethod.invokeA("android.content.res.Resources$Theme#obtainStyledAttributes([I)Landroid/content/res/TypedArray;", false, this);
        }

        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            return (TypedArray)OverrideMethod.invokeA("android.content.res.Resources$Theme#obtainStyledAttributes(I[I)Landroid/content/res/TypedArray;", false, this);
        }

        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            return (TypedArray)OverrideMethod.invokeA("android.content.res.Resources$Theme#obtainStyledAttributes(Landroid/util/AttributeSet;[III)Landroid/content/res/TypedArray;", false, this);
        }

        public boolean resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            boolean got = this.mAssets.getThemeValue(this.mTheme, resid, outValue, resolveRefs);
            return got;
        }

        public void dump(int priority, String tag, String prefix) {
            AssetManager.dumpTheme(this.mTheme, priority, tag, prefix);
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        public Theme() {
            this.mAssets = Resources.this.mAssets;
            this.mTheme = this.mAssets.createTheme();
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String name) {
            super(name);
        }
    }
}

