/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlBlock;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import java.util.Arrays;

public class TypedArray {
    public final Resources mResources;
    public XmlBlock.Parser mXml;
    public int[] mRsrcs;
    public int[] mData;
    public int[] mIndices;
    public int mLength;
    public TypedValue mValue = new TypedValue();

    public int length() {
        return this.mLength;
    }

    public int getIndexCount() {
        return this.mIndices[0];
    }

    public int getIndex(int at) {
        return this.mIndices[1 + at];
    }

    public Resources getResources() {
        return this.mResources;
    }

    public CharSequence getText(int index) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index);
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            Log.w("Resources", "Converting to string: " + v);
            return v.coerceToString();
        }
        Log.w("Resources", "getString of bad type: 0x" + Integer.toHexString(type));
        return null;
    }

    public String getString(int index) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return ((Object)this.loadStringValueAt(index)).toString();
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            Log.w("Resources", "Converting to string: " + v);
            CharSequence cs2 = v.coerceToString();
            return cs2 != null ? ((Object)cs2).toString() : null;
        }
        Log.w("Resources", "getString of bad type: 0x" + Integer.toHexString(type));
        return null;
    }

    public String getNonResourceString(int index) {
        int cookie;
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 3 && (cookie = data[index + 2]) < 0) {
            return ((Object)this.mXml.getPooledString(data[index + 1])).toString();
        }
        return null;
    }

    public boolean getBoolean(int index, boolean defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1] != 0;
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            Log.w("Resources", "Converting to boolean: " + v);
            return XmlUtils.convertValueToBoolean(v.coerceToString(), defValue);
        }
        Log.w("Resources", "getBoolean of bad type: 0x" + Integer.toHexString(type));
        return defValue;
    }

    public int getInt(int index, int defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            Log.w("Resources", "Converting to int: " + v);
            return XmlUtils.convertValueToInt(v.coerceToString(), defValue);
        }
        Log.w("Resources", "getInt of bad type: 0x" + Integer.toHexString(type));
        return defValue;
    }

    public float getFloat(int index, float defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 4) {
            return Float.intBitsToFloat(data[index + 1]);
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            Log.w("Resources", "Converting to float: " + v);
            CharSequence str = v.coerceToString();
            if (str != null) {
                return Float.parseFloat(((Object)str).toString());
            }
        }
        Log.w("Resources", "getFloat of bad type: 0x" + Integer.toHexString(type));
        return defValue;
    }

    public int getColor(int index, int defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 3) {
            TypedValue value = this.mValue;
            if (this.getValueAt(index, value)) {
                ColorStateList csl = this.mResources.loadColorStateList(value, value.resourceId);
                return csl.getDefaultColor();
            }
            return defValue;
        }
        throw new UnsupportedOperationException("Can't convert to color: type=0x" + Integer.toHexString(type));
    }

    public ColorStateList getColorStateList(int index) {
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 5, value)) {
            return this.mResources.loadColorStateList(value, value.resourceId);
        }
        return null;
    }

    public int getInteger(int index, int defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        throw new UnsupportedOperationException("Can't convert to integer: type=0x" + Integer.toHexString(type));
    }

    public float getDimension(int index, float defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimension(data[index + 1], this.mResources.mMetrics);
        }
        throw new UnsupportedOperationException("Can't convert to dimension: type=0x" + Integer.toHexString(type));
    }

    public int getDimensionPixelOffset(int index, int defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelOffset(data[index + 1], this.mResources.mMetrics);
        }
        throw new UnsupportedOperationException("Can't convert to dimension: type=0x" + Integer.toHexString(type));
    }

    public int getDimensionPixelSize(int index, int defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mResources.mMetrics);
        }
        throw new UnsupportedOperationException("Can't convert to dimension: type=0x" + Integer.toHexString(type));
    }

    public int getLayoutDimension(int index, String name) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mResources.mMetrics);
        }
        throw new RuntimeException(this.getPositionDescription() + ": You must supply a " + name + " attribute.");
    }

    public int getLayoutDimension(int index, int defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mResources.mMetrics);
        }
        return defValue;
    }

    public float getFraction(int index, int base, int pbase, float defValue) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 6) {
            return TypedValue.complexToFraction(data[index + 1], base, pbase);
        }
        throw new UnsupportedOperationException("Can't convert to fraction: type=0x" + Integer.toHexString(type));
    }

    public int getResourceId(int index, int defValue) {
        int resid;
        int[] data = this.mData;
        if (data[(index *= 5) + 0] != 0 && (resid = data[index + 3]) != 0) {
            return resid;
        }
        return defValue;
    }

    public Drawable getDrawable(int index) {
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 5, value)) {
            return this.mResources.loadDrawable(value, value.resourceId);
        }
        return null;
    }

    public CharSequence[] getTextArray(int index) {
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 5, value)) {
            return this.mResources.getTextArray(value.resourceId);
        }
        return null;
    }

    public boolean getValue(int index, TypedValue outValue) {
        return this.getValueAt(index * 5, outValue);
    }

    public boolean hasValue(int index) {
        int[] data = this.mData;
        int type = data[(index *= 5) + 0];
        return type != 0;
    }

    public TypedValue peekValue(int index) {
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 5, value)) {
            return value;
        }
        return null;
    }

    public String getPositionDescription() {
        return this.mXml != null ? this.mXml.getPositionDescription() : "<internal>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        TypedValue typedValue = this.mResources.mTmpValue;
        synchronized (typedValue) {
            TypedArray cached = this.mResources.mCachedStyledAttributes;
            if (cached == null || cached.mData.length < this.mData.length) {
                this.mXml = null;
                this.mResources.mCachedStyledAttributes = this;
            }
        }
    }

    public boolean getValueAt(int index, TypedValue outValue) {
        int[] data = this.mData;
        int type = data[index + 0];
        if (type == 0) {
            return false;
        }
        outValue.type = type;
        outValue.data = data[index + 1];
        outValue.assetCookie = data[index + 2];
        outValue.resourceId = data[index + 3];
        outValue.changingConfigurations = data[index + 4];
        if (type == 3) {
            outValue.string = this.loadStringValueAt(index);
        }
        return true;
    }

    public CharSequence loadStringValueAt(int index) {
        int[] data = this.mData;
        int cookie = data[index + 2];
        if (cookie < 0) {
            if (this.mXml != null) {
                return this.mXml.getPooledString(data[index + 1]);
            }
            return null;
        }
        return this.mResources.mAssets.getPooledString(cookie, data[index + 1]);
    }

    public TypedArray(Resources resources, int[] data, int[] indices, int len) {
        this.mResources = resources;
        this.mData = data;
        this.mIndices = indices;
        this.mLength = len;
    }

    public String toString() {
        return Arrays.toString(this.mData);
    }
}

