/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.util.TypedValue;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFile(String pathName, Options opts) {
        Bitmap bm = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            bm = BitmapFactory.decodeStream(stream, null, opts);
        }
        catch (Exception e) {
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return bm;
    }

    public static Bitmap decodeFile(String pathName) {
        return BitmapFactory.decodeFile(pathName, null);
    }

    public static Bitmap decodeStream(Resources res, TypedValue value, InputStream is, Rect pad, Options opts) {
        Bitmap bm;
        if (opts == null) {
            opts = new Options();
        }
        if ((bm = BitmapFactory.decodeStream(is, pad, opts)) != null && res != null && value != null) {
            byte[] np = bm.getNinePatchChunk();
            boolean isNinePatch = np != null && NinePatch.isNinePatchChunk(np);
            int density = value.density;
            if (opts.inDensity == 0) {
                opts.inDensity = density == 0 ? 160 : density;
            }
            float scale = (float)opts.inDensity / 160.0f;
            if (opts.inScaled || isNinePatch) {
                bm.setDensityScale(1.0f);
                bm.setAutoScalingEnabled(false);
                scale = res.getDisplayMetrics().density / scale;
                if (scale != 1.0f) {
                    Bitmap oldBitmap = bm;
                    bm = Bitmap.createScaledBitmap((Bitmap)oldBitmap, (int)((int)((float)bm.getWidth() * scale + 0.5f)), (int)((int)((float)bm.getHeight() * scale + 0.5f)), (boolean)true);
                    oldBitmap.recycle();
                    if (isNinePatch) {
                        np = BitmapFactory.nativeScaleNinePatch(np, scale, pad);
                        bm.setNinePatchChunk(np);
                    }
                }
            } else {
                bm.setDensityScale(scale);
                bm.setAutoScalingEnabled(true);
            }
        }
        return bm;
    }

    public static Bitmap decodeResource(Resources res, int id2, Options opts) {
        Bitmap bm = null;
        try {
            TypedValue value = new TypedValue();
            InputStream is = res.openRawResource(id2, value);
            bm = BitmapFactory.decodeStream(res, value, is, null, opts);
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bm;
    }

    public static Bitmap decodeResource(Resources res, int id2) {
        return BitmapFactory.decodeResource(res, id2, null);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, Options opts) {
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapFactory.nativeDecodeByteArray(data, offset, length, opts);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        return BitmapFactory.decodeByteArray(data, offset, length, null);
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding, Options opts) {
        Bitmap bm;
        if (is == null) {
            return null;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 16384);
        }
        is.mark(1024);
        if (is instanceof AssetManager.AssetInputStream) {
            bm = BitmapFactory.nativeDecodeAsset(((AssetManager.AssetInputStream)is).getAssetInt(), outPadding, opts);
        } else {
            byte[] tempStorage = null;
            if (opts != null) {
                tempStorage = opts.inTempStorage;
            }
            if (tempStorage == null) {
                tempStorage = new byte[16384];
            }
            bm = BitmapFactory.nativeDecodeStream(is, tempStorage, outPadding, opts);
        }
        return bm;
    }

    public static Bitmap decodeStream(InputStream is) {
        return BitmapFactory.decodeStream(is, null, null);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, Options opts) {
        return BitmapFactory.nativeDecodeFileDescriptor(fd, outPadding, opts);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        return BitmapFactory.nativeDecodeFileDescriptor(fd, null, null);
    }

    public static Bitmap nativeDecodeStream(InputStream inputStream, byte[] byArray, Rect rect, Options options) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.BitmapFactory#nativeDecodeStream(Ljava/io/InputStream;[BLandroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", true, null);
    }

    public static Bitmap nativeDecodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, Options options) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.BitmapFactory#nativeDecodeFileDescriptor(Ljava/io/FileDescriptor;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", true, null);
    }

    public static Bitmap nativeDecodeAsset(int n, Rect rect, Options options) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.BitmapFactory#nativeDecodeAsset(ILandroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", true, null);
    }

    public static Bitmap nativeDecodeByteArray(byte[] byArray, int n, int n2, Options options) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.BitmapFactory#nativeDecodeByteArray([BIILandroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", true, null);
    }

    public static byte[] nativeScaleNinePatch(byte[] byArray, float f, Rect rect) {
        return (byte[])OverrideMethod.invokeA("android.graphics.BitmapFactory#nativeScaleNinePatch([BFLandroid/graphics/Rect;)[B", true, null);
    }

    public static class Options {
        public boolean inJustDecodeBounds;
        public int inSampleSize;
        public Bitmap.Config inPreferredConfig;
        public boolean inDither = true;
        public int inDensity = 0;
        public boolean inScaled = true;
        public int outWidth;
        public int outHeight;
        public String outMimeType;
        public byte[] inTempStorage;
        public boolean mCancel;

        public void requestCancel() {
            OverrideMethod.invokeV("android.graphics.BitmapFactory$Options#requestCancel()V", true, this);
        }

        public void requestCancelDecode() {
            this.mCancel = true;
            this.requestCancel();
        }
    }
}

