/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    public final int mNativeCanvas;
    public Bitmap mBitmap;
    public GL mGL;
    public DrawFilter mDrawFilter;
    public int mSurfaceFormat;
    public float mDensityScale = 1.0f;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    public Canvas() {
        this.mNativeCanvas = Canvas.initRaster(0);
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfRecycled(bitmap);
        this.mNativeCanvas = Canvas.initRaster(bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensityScale = bitmap.getDensityScale();
        if (this.mDensityScale == -1.0f) {
            this.mDensityScale = 1.0f;
        }
    }

    public Canvas(int nativeCanvas) {
        if (nativeCanvas == 0) {
            throw new IllegalStateException();
        }
        this.mNativeCanvas = nativeCanvas;
    }

    public Canvas(GL gl) {
        this.mNativeCanvas = Canvas.initGL();
        this.mGL = gl;
    }

    public GL getGL() {
        return this.mGL;
    }

    public static void freeGlCaches() {
        OverrideMethod.invokeV("android.graphics.Canvas#freeGlCaches()V", true, null);
    }

    public void setBitmap(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException();
        }
        if (this.mGL != null) {
            throw new RuntimeException("Can't set a bitmap device on a GL canvas");
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_setBitmap(this.mNativeCanvas, bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensityScale = bitmap.getDensityScale();
        if (this.mDensityScale == -1.0f) {
            this.mDensityScale = 1.0f;
        }
    }

    public void setViewport(int width, int height) {
        if (this.mGL != null) {
            Canvas.nativeSetViewport(this.mNativeCanvas, width, height);
        }
    }

    public boolean isOpaque() {
        return OverrideMethod.invokeI("android.graphics.Canvas#isOpaque()Z", true, this) != 0;
    }

    public int getWidth() {
        return OverrideMethod.invokeI("android.graphics.Canvas#getWidth()I", true, this);
    }

    public int getHeight() {
        return OverrideMethod.invokeI("android.graphics.Canvas#getHeight()I", true, this);
    }

    public float getDensityScale() {
        if (this.mBitmap != null) {
            return this.mBitmap.getDensityScale();
        }
        return this.mDensityScale;
    }

    public void setDensityScale(float densityScale) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensityScale(densityScale);
        }
        this.mDensityScale = densityScale;
        if (this.mDensityScale == -1.0f) {
            this.mDensityScale = 1.0f;
        }
    }

    public int save() {
        return OverrideMethod.invokeI("android.graphics.Canvas#save()I", true, this);
    }

    public int save(int n) {
        return OverrideMethod.invokeI("android.graphics.Canvas#save(I)I", true, this);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, bounds, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, left, top, right, bottom, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, bounds, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, left, top, right, bottom, alpha, saveFlags);
    }

    public void restore() {
        OverrideMethod.invokeV("android.graphics.Canvas#restore()V", true, this);
    }

    public int getSaveCount() {
        return OverrideMethod.invokeI("android.graphics.Canvas#getSaveCount()I", true, this);
    }

    public void restoreToCount(int n) {
        OverrideMethod.invokeV("android.graphics.Canvas#restoreToCount(I)V", true, this);
    }

    public void translate(float f, float f2) {
        OverrideMethod.invokeV("android.graphics.Canvas#translate(FF)V", true, this);
    }

    public void scale(float f, float f2) {
        OverrideMethod.invokeV("android.graphics.Canvas#scale(FF)V", true, this);
    }

    public void scale(float sx, float sy, float px, float py) {
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    public void rotate(float f) {
        OverrideMethod.invokeV("android.graphics.Canvas#rotate(F)V", true, this);
    }

    public void rotate(float degrees, float px, float py) {
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    public void skew(float f, float f2) {
        OverrideMethod.invokeV("android.graphics.Canvas#skew(FF)V", true, this);
    }

    public void concat(Matrix matrix) {
        Canvas.native_concat(this.mNativeCanvas, matrix.native_instance);
    }

    public void setMatrix(Matrix matrix) {
        Canvas.native_setMatrix(this.mNativeCanvas, matrix == null ? 0 : matrix.native_instance);
    }

    public void getMatrix(Matrix ctm) {
        Canvas.native_getCTM(this.mNativeCanvas, ctm.native_instance);
    }

    public Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rectF) {
        return OverrideMethod.invokeI("android.graphics.Canvas#clipRect(Landroid/graphics/RectF;)Z", true, this) != 0;
    }

    public boolean clipRect(Rect rect) {
        return OverrideMethod.invokeI("android.graphics.Canvas#clipRect(Landroid/graphics/Rect;)Z", true, this) != 0;
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.graphics.Canvas#clipRect(FFFF)Z", true, this) != 0;
    }

    public boolean clipRect(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.graphics.Canvas#clipRect(IIII)Z", true, this) != 0;
    }

    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvas, path.ni(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvas, region.ni(), op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter) {
        int nativeFilter = 0;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvas, nativeFilter);
    }

    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, rect, type.nativeInt);
    }

    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, path.ni(), type.nativeInt);
    }

    public boolean quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, left, top, right, bottom, type.nativeInt);
    }

    public boolean getClipBounds(Rect bounds) {
        return Canvas.native_getClipBounds(this.mNativeCanvas, bounds);
    }

    public Rect getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    public void drawRGB(int r, int g, int b) {
        Canvas.native_drawRGB(this.mNativeCanvas, r, g, b);
    }

    public void drawARGB(int a, int r, int g, int b) {
        Canvas.native_drawARGB(this.mNativeCanvas, a, r, g, b);
    }

    public void drawColor(int color2) {
        Canvas.native_drawColor(this.mNativeCanvas, color2);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvas, color2, mode.nativeInt);
    }

    public void drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvas, paint.mNativePaint);
    }

    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        OverrideMethod.invokeV("android.graphics.Canvas#drawPoints([FIILandroid/graphics/Paint;)V", true, this);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    public void drawPoint(float f, float f2, Paint paint) {
        OverrideMethod.invokeV("android.graphics.Canvas#drawPoint(FFLandroid/graphics/Paint;)V", true, this);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvas, startX, startY, stopX, stopY, paint.mNativePaint);
    }

    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        OverrideMethod.invokeV("android.graphics.Canvas#drawLines([FIILandroid/graphics/Paint;)V", true, this);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawRect(RectF rect, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, rect, paint.mNativePaint);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, left, top, right, bottom, paint.mNativePaint);
    }

    public void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawOval(this.mNativeCanvas, oval, paint.mNativePaint);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvas, cx, cy, radius, paint.mNativePaint);
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawArc(this.mNativeCanvas, oval, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        if (rect == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawRoundRect(this.mNativeCanvas, rect, rx, ry, paint.mNativePaint);
    }

    public void drawPath(Path path, Paint paint) {
        Canvas.native_drawPath(this.mNativeCanvas, path.ni(), paint.mNativePaint);
    }

    public static void throwIfRecycled(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), left, top, paint != null ? paint.mNativePaint : 0, bitmap.isAutoScalingEnabled(), bitmap.getDensityScale());
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0);
    }

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        Canvas.native_drawBitmap(this.mNativeCanvas, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.mNativePaint : 0);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        Canvas.nativeDrawBitmapMatrix(this.mNativeCanvas, bitmap.ni(), matrix.ni(), paint != null ? paint.mNativePaint : 0);
    }

    public static void checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, count);
        }
        Canvas.nativeDrawBitmapMesh(this.mNativeCanvas, bitmap.ni(), meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.mNativePaint : 0);
    }

    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        Canvas.checkRange(verts.length, vertOffset, vertexCount);
        if (texs != null) {
            Canvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, vertexCount);
        }
        if (indices != null) {
            Canvas.checkRange(indices.length, indexOffset, indexCount);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvas, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.mNativePaint);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, index, count, x, y, paint.mNativePaint);
    }

    public void drawText(String string2, float f, float f2, Paint paint) {
        OverrideMethod.invokeV("android.graphics.Canvas#drawText(Ljava/lang/String;FFLandroid/graphics/Paint;)V", true, this);
    }

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, start, end, x, y, paint.mNativePaint);
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvas, ((Object)text).toString(), start, end, x, y, paint.mNativePaint);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            this.drawText(buf, 0, end - start, x, y, paint);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, index, count, pos, paint.mNativePaint);
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, pos, paint.mNativePaint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawTextOnPath(this.mNativeCanvas, text, index, count, path.ni(), hOffset, vOffset, paint.mNativePaint);
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvas, text, path.ni(), hOffset, vOffset, paint.mNativePaint);
        }
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        Canvas.native_drawPicture(this.mNativeCanvas, picture.ni());
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void finalize() throws Throwable {
        super.finalize();
        Canvas.finalizer(this.mNativeCanvas);
    }

    public static int initRaster(int n) {
        return OverrideMethod.invokeI("android.graphics.Canvas#initRaster(I)I", true, null);
    }

    public static int initGL() {
        return OverrideMethod.invokeI("android.graphics.Canvas#initGL()I", true, null);
    }

    public static void native_setBitmap(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_setBitmap(II)V", true, null);
    }

    public static void nativeSetViewport(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.graphics.Canvas#nativeSetViewport(III)V", true, null);
    }

    public static int native_saveLayer(int n, RectF rectF, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_saveLayer(ILandroid/graphics/RectF;II)I", true, null);
    }

    public static int native_saveLayer(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_saveLayer(IFFFFII)I", true, null);
    }

    public static int native_saveLayerAlpha(int n, RectF rectF, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_saveLayerAlpha(ILandroid/graphics/RectF;II)I", true, null);
    }

    public static int native_saveLayerAlpha(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_saveLayerAlpha(IFFFFII)I", true, null);
    }

    public static void native_concat(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_concat(II)V", true, null);
    }

    public static void native_setMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_setMatrix(II)V", true, null);
    }

    public static boolean native_clipRect(int n, float f, float f2, float f3, float f4, int n2) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_clipRect(IFFFFI)Z", true, null) != 0;
    }

    public static boolean native_clipPath(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_clipPath(III)Z", true, null) != 0;
    }

    public static boolean native_clipRegion(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_clipRegion(III)Z", true, null) != 0;
    }

    public static void nativeSetDrawFilter(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#nativeSetDrawFilter(II)V", true, null);
    }

    public static boolean native_getClipBounds(int n, Rect rect) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_getClipBounds(ILandroid/graphics/Rect;)Z", true, null) != 0;
    }

    public static void native_getCTM(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_getCTM(II)V", true, null);
    }

    public static boolean native_quickReject(int n, RectF rectF, int n2) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_quickReject(ILandroid/graphics/RectF;I)Z", true, null) != 0;
    }

    public static boolean native_quickReject(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_quickReject(III)Z", true, null) != 0;
    }

    public static boolean native_quickReject(int n, float f, float f2, float f3, float f4, int n2) {
        return OverrideMethod.invokeI("android.graphics.Canvas#native_quickReject(IFFFFI)Z", true, null) != 0;
    }

    public static void native_drawRGB(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawRGB(IIII)V", true, null);
    }

    public static void native_drawARGB(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawARGB(IIIII)V", true, null);
    }

    public static void native_drawColor(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawColor(II)V", true, null);
    }

    public static void native_drawColor(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawColor(III)V", true, null);
    }

    public static void native_drawPaint(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawPaint(II)V", true, null);
    }

    public static void native_drawLine(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawLine(IFFFFI)V", true, null);
    }

    public static void native_drawRect(int n, RectF rectF, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawRect(ILandroid/graphics/RectF;I)V", true, null);
    }

    public static void native_drawRect(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawRect(IFFFFI)V", true, null);
    }

    public static void native_drawOval(int n, RectF rectF, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawOval(ILandroid/graphics/RectF;I)V", true, null);
    }

    public static void native_drawCircle(int n, float f, float f2, float f3, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawCircle(IFFFI)V", true, null);
    }

    public static void native_drawArc(int n, RectF rectF, float f, float f2, boolean bl, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawArc(ILandroid/graphics/RectF;FFZI)V", true, null);
    }

    public static void native_drawRoundRect(int n, RectF rectF, float f, float f2, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawRoundRect(ILandroid/graphics/RectF;FFI)V", true, null);
    }

    public static void native_drawPath(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawPath(III)V", true, null);
    }

    public void native_drawBitmap(int n, int n2, float f, float f2, int n3, boolean bl, float f3) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawBitmap(IIFFIZF)V", true, this);
    }

    public void native_drawBitmap(int n, int n2, Rect rect, RectF rectF, int n3) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawBitmap(IILandroid/graphics/Rect;Landroid/graphics/RectF;I)V", true, this);
    }

    public static void native_drawBitmap(int n, int n2, Rect rect, Rect rect2, int n3) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawBitmap(IILandroid/graphics/Rect;Landroid/graphics/Rect;I)V", true, null);
    }

    public static void native_drawBitmap(int n, int[] nArray, int n2, int n3, float f, float f2, int n4, int n5, boolean bl, int n6) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawBitmap(I[IIIFFIIZI)V", true, null);
    }

    public static void nativeDrawBitmapMatrix(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.graphics.Canvas#nativeDrawBitmapMatrix(IIII)V", true, null);
    }

    public static void nativeDrawBitmapMesh(int n, int n2, int n3, int n4, float[] fArray, int n5, int[] nArray, int n6, int n7) {
        OverrideMethod.invokeV("android.graphics.Canvas#nativeDrawBitmapMesh(IIII[FI[III)V", true, null);
    }

    public static void nativeDrawVertices(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2, int n5, int[] nArray, int n6, short[] sArray, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.graphics.Canvas#nativeDrawVertices(III[FI[FI[II[SIII)V", true, null);
    }

    public static void native_drawText(int n, char[] cArray, int n2, int n3, float f, float f2, int n4) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawText(I[CIIFFI)V", true, null);
    }

    public static void native_drawText(int n, String string2, int n2, int n3, float f, float f2, int n4) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawText(ILjava/lang/String;IIFFI)V", true, null);
    }

    public static void native_drawPosText(int n, char[] cArray, int n2, int n3, float[] fArray, int n4) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawPosText(I[CII[FI)V", true, null);
    }

    public static void native_drawPosText(int n, String string2, float[] fArray, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawPosText(ILjava/lang/String;[FI)V", true, null);
    }

    public static void native_drawTextOnPath(int n, char[] cArray, int n2, int n3, int n4, float f, float f2, int n5) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawTextOnPath(I[CIIIFFI)V", true, null);
    }

    public static void native_drawTextOnPath(int n, String string2, int n2, float f, float f2, int n3) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawTextOnPath(ILjava/lang/String;IFFI)V", true, null);
    }

    public static void native_drawPicture(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.Canvas#native_drawPicture(II)V", true, null);
    }

    public static void finalizer(int n) {
        OverrideMethod.invokeV("android.graphics.Canvas#finalizer(I)V", true, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        public final int nativeInt;

        public VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeType {
        BW(0),
        AA(1);

        public final int nativeInt;

        public EdgeType(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

