/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.RectF;
import android.graphics._Original_Matrix;
import java.awt.geom.AffineTransform;

public class Matrix
extends _Original_Matrix {
    float[] mValues = new float[9];
    private static final int kIdentity_Mask = 0;
    private static final int kTranslate_Mask = 1;
    private static final int kScale_Mask = 2;
    private static final int kAffine_Mask = 4;
    private static final int kPerspective_Mask = 8;
    private static final int kRectStaysRect_Mask = 16;
    private static final int kUnknown_Mask = 128;
    private static final int kAllMasks = 31;
    private static final int kTranslate_Shift = 0;
    private static final int kScale_Shift = 1;
    private static final int kAffine_Shift = 2;
    private static final int kPerspective_Shift = 3;
    private static final int kRectStaysRect_Shift = 4;

    public Matrix() {
        this.reset();
    }

    public Matrix(Matrix src) {
        this.set(src);
    }

    private Matrix(float[] data) {
        assert (data.length != 9);
        this.mValues = data;
    }

    public void finalize() throws Throwable {
    }

    private void addTransform(float[] matrix) {
        float[] tmp = new float[]{matrix[0] * this.mValues[0] + matrix[1] * this.mValues[3] + matrix[2] * this.mValues[6], matrix[0] * this.mValues[1] + matrix[1] * this.mValues[4] + matrix[2] * this.mValues[7], matrix[0] * this.mValues[2] + matrix[1] * this.mValues[5] + matrix[2] * this.mValues[8], matrix[3] * this.mValues[0] + matrix[4] * this.mValues[3] + matrix[5] * this.mValues[6], matrix[3] * this.mValues[1] + matrix[4] * this.mValues[4] + matrix[5] * this.mValues[7], matrix[3] * this.mValues[2] + matrix[4] * this.mValues[5] + matrix[5] * this.mValues[8], matrix[6] * this.mValues[0] + matrix[7] * this.mValues[3] + matrix[8] * this.mValues[6], matrix[6] * this.mValues[1] + matrix[7] * this.mValues[4] + matrix[8] * this.mValues[7], matrix[6] * this.mValues[2] + matrix[7] * this.mValues[5] + matrix[8] * this.mValues[8]};
        this.mValues = tmp;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.mValues[0], this.mValues[1], this.mValues[2], this.mValues[3], this.mValues[4], this.mValues[5]);
    }

    public boolean hasPerspective() {
        return this.mValues[6] != 0.0f || this.mValues[7] != 0.0f || this.mValues[8] != 1.0f;
    }

    public boolean isIdentity() {
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                if (this.mValues[k] != (float)(i == j ? 1 : 0)) {
                    return false;
                }
                ++j;
                ++k;
            }
        }
        return true;
    }

    public boolean rectStaysRect() {
        return (this.computeTypeMask() & 0x10) != 0;
    }

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            System.arraycopy(src.mValues, 0, this.mValues, 0, this.mValues.length);
        }
    }

    public void set(_Original_Matrix src) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Matrix) {
            Matrix matrix = (Matrix)obj;
            for (int i = 0; i < 9; ++i) {
                if (this.mValues[i] == matrix.mValues[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                this.mValues[k] = i == j ? 1 : 0;
                ++j;
                ++k;
            }
        }
    }

    public void setTranslate(float dx, float dy) {
        this.mValues[0] = 1.0f;
        this.mValues[1] = 0.0f;
        this.mValues[2] = dx;
        this.mValues[3] = 0.0f;
        this.mValues[4] = 1.0f;
        this.mValues[5] = dy;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
    }

    public void setScale(float sx, float sy, float px, float py) {
        this.mValues[0] = 1.0f;
        this.mValues[1] = 0.0f;
        this.mValues[2] = -px;
        this.mValues[3] = 0.0f;
        this.mValues[4] = 1.0f;
        this.mValues[5] = -py;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
        this.addTransform(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
    }

    public void setScale(float sx, float sy) {
        this.mValues[0] = sx;
        this.mValues[1] = 0.0f;
        this.mValues[2] = 0.0f;
        this.mValues[3] = 0.0f;
        this.mValues[4] = sy;
        this.mValues[5] = 0.0f;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
    }

    public void setRotate(float degrees, float px, float py) {
        this.mValues[0] = 1.0f;
        this.mValues[1] = 0.0f;
        this.mValues[2] = -px;
        this.mValues[3] = 0.0f;
        this.mValues[4] = 1.0f;
        this.mValues[5] = -py;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
        double rad = Math.toRadians(degrees);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        this.addTransform(new float[]{cos, -sin, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
    }

    public void setRotate(float degrees) {
        double rad = Math.toRadians(degrees);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        this.mValues[0] = cos;
        this.mValues[1] = -sin;
        this.mValues[2] = 0.0f;
        this.mValues[3] = sin;
        this.mValues[4] = cos;
        this.mValues[5] = 0.0f;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        this.mValues[0] = 1.0f;
        this.mValues[1] = 0.0f;
        this.mValues[2] = -px;
        this.mValues[3] = 0.0f;
        this.mValues[4] = 1.0f;
        this.mValues[5] = -py;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
        this.addTransform(new float[]{cosValue, -sinValue, 0.0f, sinValue, cosValue, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
    }

    public void setSinCos(float sinValue, float cosValue) {
        this.mValues[0] = cosValue;
        this.mValues[1] = -sinValue;
        this.mValues[2] = 0.0f;
        this.mValues[3] = sinValue;
        this.mValues[4] = cosValue;
        this.mValues[5] = 0.0f;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
    }

    public void setSkew(float kx, float ky, float px, float py) {
        this.mValues[0] = 1.0f;
        this.mValues[1] = 0.0f;
        this.mValues[2] = -px;
        this.mValues[3] = 0.0f;
        this.mValues[4] = 1.0f;
        this.mValues[5] = -py;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
        this.addTransform(new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
    }

    public void setSkew(float kx, float ky) {
        this.mValues[0] = 1.0f;
        this.mValues[1] = kx;
        this.mValues[2] = 0.0f;
        this.mValues[3] = ky;
        this.mValues[4] = 1.0f;
        this.mValues[5] = 0.0f;
        this.mValues[6] = 0.0f;
        this.mValues[7] = 0.0f;
        this.mValues[7] = 1.0f;
    }

    public boolean setConcat(Matrix a, Matrix b) {
        if (a == this) {
            this.preConcat(b);
        } else if (b == this) {
            this.postConcat(b);
        } else {
            Matrix tmp = new Matrix(b);
            tmp.addTransform(a.mValues);
            this.set(tmp);
        }
        return true;
    }

    public boolean setConcat(_Original_Matrix a, _Original_Matrix b) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public boolean preTranslate(float dx, float dy) {
        Matrix m = new Matrix(new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f});
        m.addTransform(this.mValues);
        System.arraycopy(m.mValues, 0, this.mValues, 0, 9);
        return true;
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        Matrix m = new Matrix();
        m.setScale(sx, sy, px, py);
        m.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preScale(float sx, float sy) {
        Matrix m = new Matrix();
        m.setScale(sx, sy);
        m.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preRotate(float degrees, float px, float py) {
        Matrix m = new Matrix();
        m.setRotate(degrees, px, py);
        m.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preRotate(float degrees) {
        Matrix m = new Matrix();
        m.setRotate(degrees);
        m.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        Matrix m = new Matrix();
        m.setSkew(kx, ky, px, py);
        m.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preSkew(float kx, float ky) {
        Matrix m = new Matrix();
        m.setSkew(kx, ky);
        m.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preConcat(Matrix other) {
        Matrix m = new Matrix(other);
        other.addTransform(this.mValues);
        this.set(m);
        return true;
    }

    public boolean preConcat(_Original_Matrix other) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public boolean postTranslate(float dx, float dy) {
        this.addTransform(new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        this.addTransform(new float[]{1.0f, 0.0f, -px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postScale(float sx, float sy) {
        this.addTransform(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postRotate(float degrees, float px, float py) {
        this.addTransform(new float[]{1.0f, 0.0f, -px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
        double rad = Math.toRadians(degrees);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        this.addTransform(new float[]{cos, -sin, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postRotate(float degrees) {
        double rad = Math.toRadians(degrees);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        this.addTransform(new float[]{cos, -sin, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        this.addTransform(new float[]{1.0f, 0.0f, -px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        this.addTransform(new float[]{1.0f, 0.0f, px, 0.0f, 1.0f, py, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postSkew(float kx, float ky) {
        this.addTransform(new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        return true;
    }

    public boolean postConcat(Matrix other) {
        this.addTransform(other.mValues);
        return true;
    }

    public boolean postConcat(_Original_Matrix other) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        if (src.isEmpty()) {
            this.reset();
            return false;
        }
        if (dst.isEmpty()) {
            this.mValues[7] = 0.0f;
            this.mValues[6] = 0.0f;
            this.mValues[5] = 0.0f;
            this.mValues[4] = 0.0f;
            this.mValues[3] = 0.0f;
            this.mValues[2] = 0.0f;
            this.mValues[1] = 0.0f;
            this.mValues[0] = 0.0f;
            this.mValues[8] = 1.0f;
        } else {
            float sx = dst.width() / src.width();
            float sy = dst.height() / src.height();
            boolean xLarger = false;
            if (stf != ScaleToFit.FILL) {
                if (sx > sy) {
                    xLarger = true;
                    sx = sy;
                } else {
                    sy = sx;
                }
            }
            float tx = dst.left - src.left * sx;
            float ty = dst.top - src.top * sy;
            if (stf == ScaleToFit.CENTER || stf == ScaleToFit.END) {
                float diff = xLarger ? dst.width() - src.width() * sy : dst.height() - src.height() * sy;
                if (stf == ScaleToFit.CENTER) {
                    diff /= 2.0f;
                }
                if (xLarger) {
                    tx += diff;
                } else {
                    ty += diff;
                }
            }
            this.mValues[0] = sx;
            this.mValues[4] = sy;
            this.mValues[2] = tx;
            this.mValues[5] = ty;
            this.mValues[7] = 0.0f;
            this.mValues[6] = 0.0f;
            this.mValues[3] = 0.0f;
            this.mValues[1] = 0.0f;
        }
        this.mValues[8] = 1.0f;
        return true;
    }

    public boolean setRectToRect(RectF src, RectF dst, _Original_Matrix.ScaleToFit stf) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        throw new UnsupportedOperationException("STUB NEEDED");
    }

    public boolean invert(Matrix inverse) {
        throw new UnsupportedOperationException("STUB NEEDED");
    }

    public boolean invert(_Original_Matrix inverse) {
        throw new UnsupportedOperationException("CALL TO PARENT FORBIDDEN");
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        throw new UnsupportedOperationException("STUB NEEDED");
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        throw new UnsupportedOperationException("STUB NEEDED");
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException("STUB NEEDED");
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        throw new UnsupportedOperationException("STUB NEEDED");
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.mValues, 0, values, 0, this.mValues.length);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(values, 0, this.mValues, 0, this.mValues.length);
    }

    private int computeTypeMask() {
        int mask = 0;
        if ((double)this.mValues[6] != 0.0 || (double)this.mValues[7] != 0.0 || (double)this.mValues[8] != 1.0) {
            mask |= 8;
        }
        if ((double)this.mValues[2] != 0.0 || (double)this.mValues[5] != 0.0) {
            mask |= 1;
        }
        float m00 = this.mValues[0];
        float m01 = this.mValues[1];
        float m10 = this.mValues[3];
        float m11 = this.mValues[4];
        if ((double)m01 != 0.0 || (double)m10 != 0.0) {
            mask |= 4;
        }
        if ((double)m00 != 1.0 || (double)m11 != 1.0) {
            mask |= 2;
        }
        if ((mask & 8) == 0) {
            boolean im00 = m00 != 0.0f;
            boolean im01 = m01 != 0.0f;
            boolean im10 = m10 != 0.0f;
            boolean im11 = m11 != 0.0f;
            boolean dp0 = (im00 | im11) ^ true;
            boolean dp1 = im00 & im11;
            boolean ds0 = (im01 | im10) ^ true;
            boolean ds1 = im01 & im10;
            mask |= (dp0 & ds1 | dp1 & ds0) << 4;
        }
        return mask;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        final int nativeInt;

        private ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

