/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class Path {
    private FillType mFillType = FillType.WINDING;
    private GeneralPath mPath = new GeneralPath();
    private float mLastX = 0.0f;
    private float mLastY = 0.0f;

    public Shape getAwtShape() {
        return this.mPath;
    }

    public Path() {
    }

    public Path(Path src) {
        this.mPath.append(src.mPath, false);
    }

    public void reset() {
        this.mPath = new GeneralPath();
    }

    public void rewind() {
        throw new UnsupportedOperationException();
    }

    public void set(Path src) {
        this.mPath.append(src.mPath, false);
    }

    public FillType getFillType() {
        return this.mFillType;
    }

    public void setFillType(FillType ft) {
        this.mFillType = ft;
        this.mPath.setWindingRule(ft.rule);
    }

    public boolean isInverseFillType() {
        return this.mFillType.inverse;
    }

    public void toggleInverseFillType() {
        switch (this.mFillType) {
            case WINDING: {
                this.mFillType = FillType.INVERSE_WINDING;
                break;
            }
            case EVEN_ODD: {
                this.mFillType = FillType.INVERSE_EVEN_ODD;
                break;
            }
            case INVERSE_WINDING: {
                this.mFillType = FillType.WINDING;
                break;
            }
            case INVERSE_EVEN_ODD: {
                this.mFillType = FillType.EVEN_ODD;
            }
        }
    }

    public boolean isEmpty() {
        return this.mPath.getCurrentPoint() == null;
    }

    public boolean isRect(RectF rect) {
        throw new UnsupportedOperationException();
    }

    public void computeBounds(RectF bounds, boolean exact) {
        Rectangle2D rect = this.mPath.getBounds2D();
        bounds.left = (float)rect.getMinX();
        bounds.right = (float)rect.getMaxX();
        bounds.top = (float)rect.getMinY();
        bounds.bottom = (float)rect.getMaxY();
    }

    public void incReserve(int extraPtCount) {
    }

    public void moveTo(float x, float y) {
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    public void rMoveTo(float dx, float dy) {
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    public void lineTo(float x, float y) {
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    public void rLineTo(float dx, float dy) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.mLastX = x2;
        this.mLastY = y2;
        this.mPath.quadTo(x1, y1, this.mLastX, this.mLastY);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx2 += this.mLastX;
        this.mLastY = dy2 += this.mLastY;
        this.mPath.quadTo(dx1 += this.mLastX, dy1 += this.mLastY, this.mLastX, this.mLastY);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.mLastX = x3;
        this.mLastY = y3;
        this.mPath.curveTo(x1, y1, x2, y2, this.mLastX, this.mLastY);
    }

    public void rCubicTo(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx3 += this.mLastX;
        this.mLastY = dy3 += this.mLastY;
        this.mPath.curveTo(dx1 += this.mLastX, dy1 += this.mLastY, dx2 += this.mLastX, dy2 += this.mLastY, this.mLastX, this.mLastY);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        throw new UnsupportedOperationException();
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.mPath.closePath();
    }

    public void addRect(RectF rect, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRect(rect.left, rect.top, rect.right, rect.bottom, dir);
    }

    public void addRect(float left, float top, float right, float bottom, Direction dir) {
        this.moveTo(left, top);
        switch (dir) {
            case CW: {
                this.lineTo(right, top);
                this.lineTo(right, bottom);
                this.lineTo(left, bottom);
                break;
            }
            case CCW: {
                this.lineTo(left, bottom);
                this.lineTo(right, bottom);
                this.lineTo(right, top);
            }
        }
        this.close();
    }

    public void addOval(RectF oval, Direction dir) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        Ellipse2D.Float ovalShape = new Ellipse2D.Float(oval.left, oval.top, oval.width(), oval.height());
        this.mPath.append(ovalShape, false);
    }

    public void addCircle(float x, float y, float radius, Direction dir) {
        throw new UnsupportedOperationException();
    }

    public void addArc(RectF oval, float startAngle, float sweepAngle) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        throw new UnsupportedOperationException();
    }

    public void addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        throw new UnsupportedOperationException();
    }

    public void addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        throw new UnsupportedOperationException();
    }

    public void addPath(Path src, float dx, float dy) {
        PathIterator iterator = src.mPath.getPathIterator(new AffineTransform(0.0f, 0.0f, dx, 0.0f, 0.0f, dy));
        this.mPath.append(iterator, false);
    }

    public void addPath(Path src) {
        this.addPath(src, 0.0f, 0.0f);
    }

    public void addPath(Path src, Matrix matrix) {
        throw new UnsupportedOperationException();
    }

    public void offset(float dx, float dy, Path dst) {
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(new AffineTransform(0.0f, 0.0f, dx, 0.0f, 0.0f, dy));
        newPath.append(iterator, false);
        if (dst != null) {
            dst.mPath = newPath;
        } else {
            this.mPath = newPath;
        }
    }

    public void offset(float dx, float dy) {
        this.offset(dx, dy, null);
    }

    public void setLastPoint(float dx, float dy) {
        this.mLastX = dx;
        this.mLastY = dy;
    }

    public void transform(Matrix matrix, Path dst) {
        throw new UnsupportedOperationException();
    }

    public void transform(Matrix matrix) {
        this.transform(matrix, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        CW(0),
        CCW(1);

        final int nativeInt;

        private Direction(int ni) {
            this.nativeInt = ni;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillType {
        WINDING(1, false),
        EVEN_ODD(0, false),
        INVERSE_WINDING(1, true),
        INVERSE_EVEN_ODD(0, true);

        final int rule;
        final boolean inverse;

        private FillType(int rule, boolean inverse) {
            this.rule = rule;
            this.inverse = inverse;
        }
    }
}

