/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapDrawable
extends Drawable {
    public static final int DEFAULT_PAINT_FLAGS = 2;
    public BitmapState mBitmapState;
    public Bitmap mBitmap;
    public final Rect mDstRect = new Rect();
    public boolean mApplyGravity;
    public boolean mRebuildShader;
    public int mBitmapWidth;
    public int mBitmapHeight;
    public boolean mMutated;

    public BitmapDrawable() {
        this.mBitmapState = new BitmapState((Bitmap)null);
    }

    public BitmapDrawable(Bitmap bitmap) {
        this(new BitmapState(bitmap));
    }

    public BitmapDrawable(String filepath) {
        this(new BitmapState(BitmapFactory.decodeFile(filepath)));
        if (this.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
        }
    }

    public BitmapDrawable(InputStream is) {
        this(new BitmapState(BitmapFactory.decodeStream(is)));
        if (this.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + is);
        }
    }

    public Paint getPaint() {
        return this.mBitmapState.mPaint;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        if (bitmap != null) {
            this.mBitmapWidth = bitmap.getWidth();
            this.mBitmapHeight = bitmap.getHeight();
        } else {
            this.mBitmapHeight = -1;
            this.mBitmapWidth = -1;
        }
    }

    public void setDensityScale(Canvas canvas) {
        this.setDensityScale(canvas.getDensityScale());
    }

    public void setDensityScale(DisplayMetrics metrics) {
        this.setDensityScale(metrics.density);
    }

    public void setDensityScale(float density) {
        this.mBitmapState.mTargetDensityScale = density = density == -1.0f ? 1.0f : density;
    }

    public int getGravity() {
        return this.mBitmapState.mGravity;
    }

    public void setGravity(int gravity) {
        this.mBitmapState.mGravity = gravity;
        this.mApplyGravity = true;
    }

    public void setAntiAlias(boolean aa) {
        this.mBitmapState.mPaint.setAntiAlias(aa);
    }

    public void setFilterBitmap(boolean filter) {
        this.mBitmapState.mPaint.setFilterBitmap(filter);
    }

    public void setDither(boolean dither) {
        this.mBitmapState.mPaint.setDither(dither);
    }

    public Shader.TileMode getTileModeX() {
        return this.mBitmapState.mTileModeX;
    }

    public Shader.TileMode getTileModeY() {
        return this.mBitmapState.mTileModeY;
    }

    public void setTileModeX(Shader.TileMode mode) {
        this.setTileModeXY(mode, this.mBitmapState.mTileModeY);
    }

    public void setTileModeY(Shader.TileMode mode) {
        this.setTileModeXY(this.mBitmapState.mTileModeX, mode);
    }

    public void setTileModeXY(Shader.TileMode xmode, Shader.TileMode ymode) {
        BitmapState state = this.mBitmapState;
        if (state.mTileModeX != xmode || state.mTileModeY != ymode) {
            state.mTileModeX = xmode;
            state.mTileModeY = ymode;
            this.mRebuildShader = true;
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mBitmapState.mChangingConfigurations;
    }

    public void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mApplyGravity = true;
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null) {
            Shader shader;
            BitmapState state = this.mBitmapState;
            if (this.mRebuildShader) {
                Shader.TileMode tmx = state.mTileModeX;
                Shader.TileMode tmy = state.mTileModeY;
                if (tmx == null && tmy == null) {
                    state.mPaint.setShader(null);
                } else {
                    BitmapShader s = new BitmapShader(bitmap, tmx == null ? Shader.TileMode.CLAMP : tmx, tmy == null ? Shader.TileMode.CLAMP : tmy);
                    state.mPaint.setShader(s);
                }
                this.mRebuildShader = false;
                this.copyBounds(this.mDstRect);
            }
            if ((shader = state.mPaint.getShader()) == null) {
                if (this.mApplyGravity) {
                    Gravity.apply(state.mGravity, this.mBitmapWidth, this.mBitmapHeight, this.getBounds(), this.mDstRect);
                    this.mApplyGravity = false;
                }
                canvas.drawBitmap(bitmap, null, this.mDstRect, state.mPaint);
            } else {
                if (this.mApplyGravity) {
                    this.mDstRect.set(this.getBounds());
                    this.mApplyGravity = false;
                }
                canvas.drawRect(this.mDstRect, state.mPaint);
            }
        }
    }

    public void setAlpha(int alpha) {
        this.mBitmapState.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBitmapState.mPaint.setColorFilter(cf);
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mBitmapState = new BitmapState(this.mBitmapState);
            this.mMutated = true;
        }
        return this;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.BitmapDrawable);
        int id2 = a.getResourceId(1, 0);
        if (id2 == 0) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <bitmap> requires a valid src attribute");
        }
        Bitmap bitmap = BitmapFactory.decodeResource(r, id2);
        if (bitmap == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <bitmap> requires a valid src attribute");
        }
        this.mBitmapState.mBitmap = bitmap;
        this.setBitmap(bitmap);
        this.setDensityScale(r.getDisplayMetrics());
        Paint paint = this.mBitmapState.mPaint;
        paint.setAntiAlias(a.getBoolean(2, paint.isAntiAlias()));
        paint.setFilterBitmap(a.getBoolean(3, paint.isFilterBitmap()));
        paint.setDither(a.getBoolean(4, paint.isDither()));
        this.setGravity(a.getInt(0, 119));
        int tileMode = a.getInt(5, -1);
        if (tileMode != -1) {
            switch (tileMode) {
                case 0: {
                    this.setTileModeXY(Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    break;
                }
                case 1: {
                    this.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    break;
                }
                case 2: {
                    this.setTileModeXY(Shader.TileMode.MIRROR, Shader.TileMode.MIRROR);
                }
            }
        }
        a.recycle();
    }

    public int getIntrinsicWidth() {
        Bitmap bitmap = this.mBitmap;
        BitmapState state = this.mBitmapState;
        if (!state.mAutoScale || state.mBitmapScale == -1.0f) {
            return this.mBitmapWidth;
        }
        return bitmap != null ? (int)((float)this.mBitmapWidth / (state.mBitmapScale / state.mTargetDensityScale) + 0.5f) : -1;
    }

    public int getIntrinsicHeight() {
        Bitmap bitmap = this.mBitmap;
        BitmapState state = this.mBitmapState;
        if (!state.mAutoScale || state.mBitmapScale == -1.0f) {
            return this.mBitmapHeight;
        }
        return bitmap != null ? (int)((float)this.mBitmapHeight / (state.mBitmapScale / state.mTargetDensityScale) + 0.5f) : -1;
    }

    public int getOpacity() {
        if (this.mBitmapState.mGravity != 119) {
            return -3;
        }
        Bitmap bm = this.mBitmap;
        return bm == null || bm.hasAlpha() || this.mBitmapState.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    public Drawable.ConstantState getConstantState() {
        this.mBitmapState.mChangingConfigurations = super.getChangingConfigurations();
        return this.mBitmapState;
    }

    public BitmapDrawable(BitmapState state) {
        this.mBitmapState = state;
        this.setBitmap(state.mBitmap);
    }

    public /* synthetic */ BitmapDrawable(BitmapState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class BitmapState
    extends Drawable.ConstantState {
        public Bitmap mBitmap;
        public int mChangingConfigurations;
        public int mGravity = 119;
        public Paint mPaint = new Paint(2);
        public Shader.TileMode mTileModeX;
        public Shader.TileMode mTileModeY;
        public boolean mAutoScale;
        public float mBitmapScale;
        public float mTargetDensityScale = 1.0f;

        public BitmapState(Bitmap bitmap) {
            this.mBitmap = bitmap;
            if (bitmap != null) {
                this.mBitmapScale = bitmap.getDensityScale();
                this.mAutoScale = bitmap.isAutoScalingEnabled();
            } else {
                this.mBitmapScale = 1.0f;
                this.mAutoScale = false;
            }
        }

        public BitmapState(BitmapState bitmapState) {
            this(bitmapState.mBitmap);
            this.mChangingConfigurations = bitmapState.mChangingConfigurations;
            this.mGravity = bitmapState.mGravity;
            this.mTileModeX = bitmapState.mTileModeX;
            this.mTileModeY = bitmapState.mTileModeY;
            this.mTargetDensityScale = bitmapState.mTargetDensityScale;
            this.mPaint = new Paint(bitmapState.mPaint);
        }

        public Drawable newDrawable() {
            return new BitmapDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

