/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends Drawable
implements Drawable.Callback {
    public InsetState mInsetState;
    public final Rect mTmpRect = new Rect();
    public boolean mMutated;

    public InsetDrawable() {
        this(null);
    }

    public InsetDrawable(Drawable drawable2, int inset) {
        this(drawable2, inset, inset, inset, inset);
    }

    public InsetDrawable(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this(null);
        this.mInsetState.mDrawable = drawable2;
        this.mInsetState.mInsetLeft = insetLeft;
        this.mInsetState.mInsetTop = insetTop;
        this.mInsetState.mInsetRight = insetRight;
        this.mInsetState.mInsetBottom = insetBottom;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        Drawable dr;
        TypedArray a = r.obtainAttributes(attrs, R.styleable.InsetDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        int drawableRes = a.getResourceId(1, 0);
        int inLeft = a.getDimensionPixelOffset(2, 0);
        int inTop = a.getDimensionPixelOffset(4, 0);
        int inRight = a.getDimensionPixelOffset(3, 0);
        int inBottom = a.getDimensionPixelOffset(5, 0);
        a.recycle();
        if (drawableRes != 0) {
            dr = r.getDrawable(drawableRes);
        } else {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs);
        }
        if (dr == null) {
            Log.w("drawable", "No drawable specified for <inset>");
        }
        this.mInsetState.mDrawable = dr;
        this.mInsetState.mInsetLeft = inLeft;
        this.mInsetState.mInsetRight = inRight;
        this.mInsetState.mInsetTop = inTop;
        this.mInsetState.mInsetBottom = inBottom;
        if (dr != null) {
            dr.setCallback(this);
        }
    }

    public void invalidateDrawable(Drawable who) {
        if (this.mCallback != null) {
            this.mCallback.invalidateDrawable(this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.mCallback != null) {
            this.mCallback.scheduleDrawable(this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (this.mCallback != null) {
            this.mCallback.unscheduleDrawable(this, what);
        }
    }

    public void draw(Canvas canvas) {
        this.mInsetState.mDrawable.draw(canvas);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mInsetState.mChangingConfigurations | this.mInsetState.mDrawable.getChangingConfigurations();
    }

    public boolean getPadding(Rect padding) {
        boolean pad = this.mInsetState.mDrawable.getPadding(padding);
        padding.left += this.mInsetState.mInsetLeft;
        padding.right += this.mInsetState.mInsetRight;
        padding.top += this.mInsetState.mInsetTop;
        padding.bottom += this.mInsetState.mInsetBottom;
        return pad || (this.mInsetState.mInsetLeft | this.mInsetState.mInsetRight | this.mInsetState.mInsetTop | this.mInsetState.mInsetBottom) != 0;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.mInsetState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    public void setAlpha(int alpha) {
        this.mInsetState.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mInsetState.mDrawable.setColorFilter(cf);
    }

    public int getOpacity() {
        return this.mInsetState.mDrawable.getOpacity();
    }

    public boolean isStateful() {
        return this.mInsetState.mDrawable.isStateful();
    }

    public boolean onStateChange(int[] state) {
        boolean changed = this.mInsetState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    public void onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mInsetState.mInsetLeft;
        r.top += this.mInsetState.mInsetTop;
        r.right -= this.mInsetState.mInsetRight;
        r.bottom -= this.mInsetState.mInsetBottom;
        this.mInsetState.mDrawable.setBounds(r.left, r.top, r.right, r.bottom);
    }

    public int getIntrinsicWidth() {
        return this.mInsetState.mDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mInsetState.mDrawable.getIntrinsicHeight();
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mInsetState.canConstantState()) {
            this.mInsetState.mChangingConfigurations = super.getChangingConfigurations();
            return this.mInsetState;
        }
        return null;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mInsetState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    public InsetDrawable(InsetState state) {
        this.mInsetState = new InsetState(state, this);
    }

    public /* synthetic */ InsetDrawable(InsetState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class InsetState
    extends Drawable.ConstantState {
        public Drawable mDrawable;
        public int mChangingConfigurations;
        public int mInsetLeft;
        public int mInsetTop;
        public int mInsetRight;
        public int mInsetBottom;
        public boolean mCheckedConstantState;
        public boolean mCanConstantState;

        public InsetState(InsetState orig, InsetDrawable owner) {
            if (orig != null) {
                this.mDrawable = orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mInsetLeft = orig.mInsetLeft;
                this.mInsetTop = orig.mInsetTop;
                this.mInsetRight = orig.mInsetRight;
                this.mInsetBottom = orig.mInsetBottom;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        public Drawable newDrawable() {
            return new InsetDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }
}

