/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class MediaPlayer {
    public static final String TAG = "MediaPlayer";
    public int mNativeContext;
    public int mListenerContext;
    public Surface mSurface;
    public SurfaceHolder mSurfaceHolder;
    public EventHandler mEventHandler;
    public PowerManager.WakeLock mWakeLock = null;
    public boolean mScreenOnWhilePlaying;
    public boolean mStayAwake;
    public static final int MEDIA_NOP = 0;
    public static final int MEDIA_PREPARED = 1;
    public static final int MEDIA_PLAYBACK_COMPLETE = 2;
    public static final int MEDIA_BUFFERING_UPDATE = 3;
    public static final int MEDIA_SEEK_COMPLETE = 4;
    public static final int MEDIA_SET_VIDEO_SIZE = 5;
    public static final int MEDIA_ERROR = 100;
    public static final int MEDIA_INFO = 200;
    public OnPreparedListener mOnPreparedListener;
    public OnCompletionListener mOnCompletionListener;
    public OnBufferingUpdateListener mOnBufferingUpdateListener;
    public OnSeekCompleteListener mOnSeekCompleteListener;
    public OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public OnErrorListener mOnErrorListener;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public OnInfoListener mOnInfoListener;

    public MediaPlayer() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<MediaPlayer>(this));
    }

    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        this.mSurface = sh.getSurface();
        this.updateSurfaceScreenOn();
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        try {
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(context, uri);
            if (holder != null) {
                mp.setDisplay(holder);
            }
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public static MediaPlayer create(Context context, int resid) {
        try {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resid);
            if (afd == null) {
                return null;
            }
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            if (fd != null) {
                fd.close();
            }
        }
        this.setDataSource(uri.toString());
    }

    public void setDataSource(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#setDataSource(Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void prepare() throws IOException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#prepare()V", true, this);
    }

    public void prepareAsync() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#prepareAsync()V", true, this);
    }

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    public void _start() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_start()V", true, this);
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    public void _stop() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_stop()V", true, this);
    }

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    public void _pause() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_pause()V", true, this);
    }

    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    public void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    public void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public int getVideoWidth() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoWidth()I", true, this);
    }

    public int getVideoHeight() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoHeight()I", true, this);
    }

    public boolean isPlaying() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isPlaying()Z", true, this) != 0;
    }

    public void seekTo(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#seekTo(I)V", true, this);
    }

    public int getCurrentPosition() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getCurrentPosition()I", true, this);
    }

    public int getDuration() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getDuration()I", true, this);
    }

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this._release();
    }

    public void _release() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_release()V", true, this);
    }

    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    public void _reset() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_reset()V", true, this);
    }

    public void setAudioStreamType(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAudioStreamType(I)V", true, this);
    }

    public void setLooping(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setLooping(Z)V", true, this);
    }

    public boolean isLooping() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isLooping()Z", true, this) != 0;
    }

    public void setVolume(float f, float f2) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setVolume(FF)V", true, this);
    }

    public Bitmap getFrameAt(int n) throws IllegalStateException {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaPlayer#getFrameAt(I)Landroid/graphics/Bitmap;", true, this);
    }

    public void native_setup(Object object) {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_setup(Ljava/lang/Object;)V", true, this);
    }

    public void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_finalize()V", true, this);
    }

    public void finalize() {
        this.native_finalize();
    }

    public static void postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        MediaPlayer mp = (MediaPlayer)((WeakReference)mediaplayer_ref).get();
        if (mp == null) {
            return;
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    static {
        System.loadLibrary("media_jni");
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    public class EventHandler
    extends Handler {
        public MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        public void handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0) {
                Log.w(MediaPlayer.TAG, "mediaplayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    if (MediaPlayer.this.mOnPreparedListener != null) {
                        MediaPlayer.this.mOnPreparedListener.onPrepared(this.mMediaPlayer);
                    }
                    return;
                }
                case 2: {
                    if (MediaPlayer.this.mOnCompletionListener != null) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 3: {
                    if (MediaPlayer.this.mOnBufferingUpdateListener != null) {
                        MediaPlayer.this.mOnBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    if (MediaPlayer.this.mOnSeekCompleteListener != null) {
                        MediaPlayer.this.mOnSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    if (MediaPlayer.this.mOnVideoSizeChangedListener != null) {
                        MediaPlayer.this.mOnVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 100: {
                    Log.e(MediaPlayer.TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    boolean error_was_handled = false;
                    if (MediaPlayer.this.mOnErrorListener != null) {
                        error_was_handled = MediaPlayer.this.mOnErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    if (MediaPlayer.this.mOnCompletionListener != null && !error_was_handled) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: {
                    Log.i(MediaPlayer.TAG, "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                    if (MediaPlayer.this.mOnInfoListener != null) {
                        MediaPlayer.this.mOnInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    Log.e(MediaPlayer.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }
}

