/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.HashMap;

public class NetworkConnectivityListener {
    public static final String TAG = "NetworkConnectivityListener";
    public static final boolean DBG = false;
    public Context mContext;
    public HashMap<Handler, Integer> mHandlers = new HashMap();
    public State mState = State.UNKNOWN;
    public boolean mListening;
    public String mReason;
    public boolean mIsFailover;
    public NetworkInfo mNetworkInfo;
    public NetworkInfo mOtherNetworkInfo;
    public ConnectivityBroadcastReceiver mReceiver = new ConnectivityBroadcastReceiver(null);

    public synchronized void startListening(Context context) {
        if (!this.mListening) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver(this.mReceiver, filter);
            this.mListening = true;
        }
    }

    public synchronized void stopListening() {
        if (this.mListening) {
            this.mContext.unregisterReceiver(this.mReceiver);
            this.mContext = null;
            this.mNetworkInfo = null;
            this.mOtherNetworkInfo = null;
            this.mIsFailover = false;
            this.mReason = null;
            this.mListening = false;
        }
    }

    public void registerHandler(Handler target, int what) {
        this.mHandlers.put(target, what);
    }

    public void unregisterHandler(Handler target) {
        this.mHandlers.remove(target);
    }

    public State getState() {
        return this.mState;
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public NetworkInfo getOtherNetworkInfo() {
        return this.mOtherNetworkInfo;
    }

    public boolean isFailover() {
        return this.mIsFailover;
    }

    public String getReason() {
        return this.mReason;
    }

    public static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        CONNECTED,
        NOT_CONNECTED;

    }

    public class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        public ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE") || !NetworkConnectivityListener.this.mListening) {
                Log.w(NetworkConnectivityListener.TAG, "onReceived() called with " + NetworkConnectivityListener.this.mState.toString() + " and " + intent);
                return;
            }
            boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
            if (noConnectivity) {
                NetworkConnectivityListener.this.mState = State.NOT_CONNECTED;
            } else {
                NetworkConnectivityListener.this.mState = State.CONNECTED;
            }
            NetworkConnectivityListener.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkConnectivityListener.this.mOtherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
            NetworkConnectivityListener.this.mReason = intent.getStringExtra("reason");
            NetworkConnectivityListener.this.mIsFailover = intent.getBooleanExtra("isFailover", false);
            for (Handler target : NetworkConnectivityListener.this.mHandlers.keySet()) {
                Message message = Message.obtain(target, (Integer)NetworkConnectivityListener.this.mHandlers.get(target));
                target.sendMessage(message);
            }
        }

        public /* synthetic */ ConnectivityBroadcastReceiver(1 x1) {
            this();
        }
    }
}

