/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.DomainNameChecker;
import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertificateChainValidator {
    public static final CertificateChainValidator sInstance = new CertificateChainValidator();
    public X509TrustManager mDefaultTrustManager;

    public static CertificateChainValidator getInstance() {
        return sInstance;
    }

    public CertificateChainValidator() {
        block3: {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
                trustManagerFactory.init((KeyStore)null);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers == null || trustManagers.length <= 0) break block3;
                for (TrustManager trustManager : trustManagers) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    this.mDefaultTrustManager = (X509TrustManager)trustManager;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection connection, SSLSocket sslSocket, String domain) throws IOException {
        X509Certificate[] serverCertificates = null;
        try {
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
        }
        catch (IOException e) {
            this.closeSocketThrowException(sslSocket, e.getMessage(), "failed to perform SSL handshake");
        }
        Certificate[] peerCertificates = sslSocket.getSession().getPeerCertificates();
        if (peerCertificates == null || peerCertificates.length <= 0) {
            this.closeSocketThrowException(sslSocket, "failed to retrieve peer certificates");
        } else {
            serverCertificates = new X509Certificate[peerCertificates.length];
            for (int i = 0; i < peerCertificates.length; ++i) {
                serverCertificates[i] = (X509Certificate)peerCertificates[i];
            }
            if (connection != null && serverCertificates[0] != null) {
                connection.setCertificate(new SslCertificate(serverCertificates[0]));
            }
        }
        X509Certificate currCertificate = serverCertificates[0];
        if (currCertificate == null) {
            this.closeSocketThrowException(sslSocket, "certificate for this site is null");
        } else if (!DomainNameChecker.match(currCertificate, domain)) {
            String errorMessage = "certificate not for this host: " + domain;
            sslSocket.getSession().invalidate();
            return new SslError(2, currCertificate);
        }
        try {
            this.mDefaultTrustManager.checkServerTrusted(serverCertificates, "RSA");
            return null;
        }
        catch (CertificateException e) {
            String errorMessage;
            sslSocket.getSession().invalidate();
            SslError error = null;
            currCertificate = serverCertificates[serverCertificates.length - 1];
            if (currCertificate == null) {
                this.closeSocketThrowException(sslSocket, "root certificate is null");
            }
            X509Certificate[] rootCertificateChain = new X509Certificate[]{currCertificate};
            try {
                this.mDefaultTrustManager.checkServerTrusted(rootCertificateChain, "RSA");
            }
            catch (CertificateExpiredException e2) {
                errorMessage = e2.getMessage();
                if (errorMessage == null) {
                    errorMessage = "root certificate has expired";
                }
                error = new SslError(1, currCertificate);
            }
            catch (CertificateNotYetValidException e3) {
                errorMessage = e3.getMessage();
                if (errorMessage == null) {
                    errorMessage = "root certificate not valid yet";
                }
                error = new SslError(0, currCertificate);
            }
            catch (CertificateException e4) {
                String errorMessage2 = e4.getMessage();
                if (errorMessage2 == null) {
                    errorMessage2 = "root certificate not trusted";
                }
                return new SslError(3, currCertificate);
            }
            X509Certificate prevCertificate = serverCertificates[serverCertificates.length - 1];
            for (int i = serverCertificates.length - 2; i >= 0; --i) {
                block33: {
                    String errorMessage3;
                    currCertificate = serverCertificates[i];
                    if (currCertificate == null) {
                        this.closeSocketThrowException(sslSocket, "null certificate in the chain");
                    }
                    if (!((Object)prevCertificate.getSubjectDN()).equals(currCertificate.getIssuerDN())) {
                        String errorMessage4 = "not trusted by chain";
                        return new SslError(3, currCertificate);
                    }
                    try {
                        currCertificate.verify(prevCertificate.getPublicKey());
                    }
                    catch (GeneralSecurityException e5) {
                        errorMessage3 = e5.getMessage();
                        if (errorMessage3 == null) {
                            errorMessage3 = "not trusted by chain";
                        }
                        return new SslError(3, currCertificate);
                    }
                    try {
                        currCertificate.checkValidity();
                    }
                    catch (CertificateExpiredException e6) {
                        errorMessage3 = e6.getMessage();
                        if (errorMessage3 == null) {
                            errorMessage3 = "certificate expired";
                        }
                        if (error == null || error.getPrimaryError() < 1) {
                            error = new SslError(1, currCertificate);
                        }
                    }
                    catch (CertificateNotYetValidException e7) {
                        errorMessage3 = e7.getMessage();
                        if (errorMessage3 == null) {
                            errorMessage3 = "certificate not valid yet";
                        }
                        if (error != null && error.getPrimaryError() >= 0) break block33;
                        error = new SslError(0, currCertificate);
                    }
                }
                prevCertificate = currCertificate;
            }
            if (error == null) {
                this.closeSocketThrowException(sslSocket, "failed to pre-validate the certificate chain due to a non-standard error");
            }
            return error;
        }
    }

    public void closeSocketThrowException(SSLSocket socket, String errorMessage, String defaultErrorMessage) throws IOException {
        this.closeSocketThrowException(socket, errorMessage != null ? errorMessage : defaultErrorMessage);
    }

    public void closeSocketThrowException(SSLSocket socket, String errorMessage) throws IOException {
        if (socket != null) {
            SSLSession session = socket.getSession();
            if (session != null) {
                session.invalidate();
            }
            socket.close();
        }
        throw new SSLHandshakeException(errorMessage);
    }
}

