/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.os.Bundle;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Vector;
import org.bouncycastle.asn1.x509.X509Name;

public class SslCertificate {
    public DName mIssuedTo;
    public DName mIssuedBy;
    public String mValidNotBefore;
    public String mValidNotAfter;
    public static final String ISSUED_TO = "issued-to";
    public static final String ISSUED_BY = "issued-by";
    public static final String VALID_NOT_BEFORE = "valid-not-before";
    public static final String VALID_NOT_AFTER = "valid-not-after";

    public static Bundle saveState(SslCertificate certificate) {
        Bundle bundle = null;
        if (certificate != null) {
            bundle = new Bundle();
            bundle.putString(ISSUED_TO, certificate.getIssuedTo().getDName());
            bundle.putString(ISSUED_BY, certificate.getIssuedBy().getDName());
            bundle.putString(VALID_NOT_BEFORE, certificate.getValidNotBefore());
            bundle.putString(VALID_NOT_AFTER, certificate.getValidNotAfter());
        }
        return bundle;
    }

    public static SslCertificate restoreState(Bundle bundle) {
        if (bundle != null) {
            return new SslCertificate(bundle.getString(ISSUED_TO), bundle.getString(ISSUED_BY), bundle.getString(VALID_NOT_BEFORE), bundle.getString(VALID_NOT_AFTER));
        }
        return null;
    }

    public SslCertificate(String issuedTo, String issuedBy, String validNotBefore, String validNotAfter) {
        this.mIssuedTo = new DName(issuedTo);
        this.mIssuedBy = new DName(issuedBy);
        this.mValidNotBefore = validNotBefore;
        this.mValidNotAfter = validNotAfter;
    }

    public SslCertificate(X509Certificate certificate) {
        this(certificate.getSubjectDN().getName(), certificate.getIssuerDN().getName(), DateFormat.getInstance().format(certificate.getNotBefore()), DateFormat.getInstance().format(certificate.getNotAfter()));
    }

    public String getValidNotBefore() {
        return this.mValidNotBefore != null ? this.mValidNotBefore : "";
    }

    public String getValidNotAfter() {
        return this.mValidNotAfter != null ? this.mValidNotAfter : "";
    }

    public DName getIssuedTo() {
        return this.mIssuedTo;
    }

    public DName getIssuedBy() {
        return this.mIssuedBy;
    }

    public String toString() {
        return "Issued to: " + this.mIssuedTo.getDName() + ";\n" + "Issued by: " + this.mIssuedBy.getDName() + ";\n";
    }

    public class DName {
        public String mDName;
        public String mCName;
        public String mOName;
        public String mUName;

        public DName(String dName) {
            if (dName != null) {
                this.mDName = dName;
                X509Name x509Name = new X509Name(this.mDName);
                Vector val = x509Name.getValues();
                Vector oid = x509Name.getOIDs();
                for (int i = 0; i < oid.size(); ++i) {
                    if (oid.elementAt(i).equals(X509Name.CN)) {
                        this.mCName = (String)val.elementAt(i);
                        continue;
                    }
                    if (oid.elementAt(i).equals(X509Name.O)) {
                        this.mOName = (String)val.elementAt(i);
                        continue;
                    }
                    if (!oid.elementAt(i).equals(X509Name.OU)) continue;
                    this.mUName = (String)val.elementAt(i);
                }
            }
        }

        public String getDName() {
            return this.mDName != null ? this.mDName : "";
        }

        public String getCName() {
            return this.mCName != null ? this.mCName : "";
        }

        public String getOName() {
            return this.mOName != null ? this.mOName : "";
        }

        public String getUName() {
            return this.mUName != null ? this.mUName : "";
        }
    }
}

