/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Matrix;
import javax.microedition.khronos.opengles.GL10;

public class GLU {
    public static String gluErrorString(int error) {
        switch (error) {
            case 0: {
                return "no error";
            }
            case 1280: {
                return "invalid enum";
            }
            case 1281: {
                return "invalid value";
            }
            case 1282: {
                return "invalid operation";
            }
            case 1283: {
                return "stack overflow";
            }
            case 1284: {
                return "stack underflow";
            }
            case 1285: {
                return "out of memory";
            }
        }
        return null;
    }

    public static void gluLookAt(GL10 gl, float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float fx = centerX - eyeX;
        float fy = centerY - eyeY;
        float fz = centerZ - eyeZ;
        float rlf = 1.0f / Matrix.length(fx, fy, fz);
        float sx = (fy *= rlf) * upZ - (fz *= rlf) * upY;
        float sy = fz * upX - (fx *= rlf) * upZ;
        float sz = fx * upY - fy * upX;
        float rls = 1.0f / Matrix.length(sx, sy, sz);
        float ux = (sy *= rls) * fz - (sz *= rls) * fy;
        float uy = sz * fx - (sx *= rls) * fz;
        float uz = sx * fy - sy * fx;
        float[] m = new float[]{sx, ux, -fx, 0.0f, sy, uy, -fy, 0.0f, sz, uz, -fz, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        gl.glMultMatrixf(m, 0);
        gl.glTranslatef(-eyeX, -eyeY, -eyeZ);
    }

    public static void gluOrtho2D(GL10 gl, float left, float right, float bottom, float top) {
        gl.glOrthof(left, right, bottom, top, -1.0f, 1.0f);
    }

    public static void gluPerspective(GL10 gl, float fovy, float aspect, float zNear, float zFar) {
        float top = zNear * (float)Math.tan((double)fovy * (Math.PI / 360));
        float bottom = -top;
        float left = bottom * aspect;
        float right = top * aspect;
        gl.glFrustumf(left, right, bottom, top, zNear, zFar);
    }

    public static int gluProject(float objX, float objY, float objZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] win, int winOffset) {
        float[] m = new float[16];
        Matrix.multiplyMM(m, 0, project, projectOffset, model, modelOffset);
        float[] v = new float[]{objX, objY, objZ, 1.0f};
        float[] v2 = new float[4];
        Matrix.multiplyMV(v2, 0, m, 0, v, 0);
        float w = v2[3];
        if (w == 0.0f) {
            return 0;
        }
        float rw = 1.0f / w;
        win[winOffset] = (float)view[viewOffset] + (float)view[viewOffset + 2] * (v2[0] * rw + 1.0f) * 0.5f;
        win[winOffset + 1] = (float)view[viewOffset + 1] + (float)view[viewOffset + 3] * (v2[1] * rw + 1.0f) * 0.5f;
        win[winOffset + 2] = (v2[2] * rw + 1.0f) * 0.5f;
        return 1;
    }

    public static int gluUnProject(float winX, float winY, float winZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] obj, int objOffset) {
        float[] pm = new float[16];
        Matrix.multiplyMM(pm, 0, project, projectOffset, model, modelOffset);
        float[] invPM = new float[16];
        if (!Matrix.invertM(invPM, 0, pm, 0)) {
            return 0;
        }
        float[] v = new float[]{2.0f * (winX - (float)view[viewOffset + 0]) / (float)view[viewOffset + 2] - 1.0f, 2.0f * (winY - (float)view[viewOffset + 1]) / (float)view[viewOffset + 3] - 1.0f, 2.0f * winZ - 1.0f, 1.0f};
        float[] v2 = new float[4];
        Matrix.multiplyMV(v2, 0, invPM, 0, v, 0);
        obj[objOffset] = v2[0];
        obj[objOffset + 1] = v2[1];
        obj[objOffset + 2] = v2[2];
        return 1;
    }
}

