/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.SparseArray;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatteryStats
implements Parcelable {
    public static final boolean LOCAL_LOGV = false;
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_WINDOW = 2;
    public static final int SENSOR = 3;
    public static final int WIFI_TURNED_ON = 4;
    public static final int FULL_WIFI_LOCK = 5;
    public static final int SCAN_WIFI_LOCK = 6;
    public static final int STATS_TOTAL = 0;
    public static final int STATS_LAST = 1;
    public static final int STATS_CURRENT = 2;
    public static final int STATS_UNPLUGGED = 3;
    public static final int BATTERY_STATS_CHECKIN_VERSION = 3;
    public static final long BYTES_PER_KB = 1024L;
    public static final long BYTES_PER_MB = 0x100000L;
    public static final long BYTES_PER_GB = 0x40000000L;
    public static final String[] STAT_NAMES = new String[]{"total", "last", "current", "unplugged"};
    public static final String APK_DATA = "apk";
    public static final String PROCESS_DATA = "process";
    public static final String SENSOR_DATA = "sensor";
    public static final String WAKELOCK_DATA = "wakelock";
    public static final String NETWORK_DATA = "network";
    public static final String USER_ACTIVITY_DATA = "useract";
    public static final String BATTERY_DATA = "battery";
    public static final String WIFI_LOCK_DATA = "wifilock";
    public static final String MISC_DATA = "misc";
    public static final String SCREEN_BRIGHTNESS_DATA = "brightness";
    public static final String SIGNAL_STRENGTH_TIME_DATA = "sigtime";
    public static final String SIGNAL_STRENGTH_COUNT_DATA = "sigcnt";
    public static final String DATA_CONNECTION_TIME_DATA = "dconntime";
    public static final String DATA_CONNECTION_COUNT_DATA = "dconncnt";
    public final StringBuilder mFormatBuilder = new StringBuilder(8);
    public final Formatter mFormatter = new Formatter(this.mFormatBuilder);
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    public static final String[] SCREEN_BRIGHTNESS_NAMES = new String[]{"dark", "dim", "medium", "light", "bright"};
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int SIGNAL_STRENGTH_POOR = 1;
    public static final int SIGNAL_STRENGTH_MODERATE = 2;
    public static final int SIGNAL_STRENGTH_GOOD = 3;
    public static final int SIGNAL_STRENGTH_GREAT = 4;
    public static final String[] SIGNAL_STRENGTH_NAMES = new String[]{"none", "poor", "moderate", "good", "great"};
    public static final int NUM_SIGNAL_STRENGTH_BINS = 5;
    public static final int DATA_CONNECTION_NONE = 0;
    public static final int DATA_CONNECTION_GPRS = 1;
    public static final int DATA_CONNECTION_EDGE = 2;
    public static final int DATA_CONNECTION_UMTS = 3;
    public static final int DATA_CONNECTION_OTHER = 4;
    public static final String[] DATA_CONNECTION_NAMES = new String[]{"none", "gprs", "edge", "umts", "other"};
    public static final int NUM_DATA_CONNECTION_TYPES = 5;

    public abstract int getStartCount();

    public abstract long getScreenOnTime(long var1, int var3);

    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract int getInputEventCount(int var1);

    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract long getWifiOnTime(long var1, int var3);

    public abstract long getWifiRunningTime(long var1, int var3);

    public abstract long getBluetoothOnTime(long var1, int var3);

    public abstract boolean getIsOnBattery();

    public abstract SparseArray<? extends Uid> getUidStats();

    public abstract long getBatteryUptime(long var1);

    public abstract long getBatteryRealtime(long var1);

    public abstract int getUnpluggedStartLevel();

    public abstract int getPluggedStartLevel();

    public abstract long computeBatteryUptime(long var1, int var3);

    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    public abstract long computeRealtime(long var1, int var3);

    public static void formatTime(StringBuilder out, long seconds) {
        long mins;
        long used;
        long hours;
        long days = seconds / 86400L;
        if (days != 0L) {
            out.append(days);
            out.append("d ");
        }
        if ((hours = (seconds - (used = days * 60L * 60L * 24L)) / 3600L) != 0L || used != 0L) {
            out.append(hours);
            out.append("h ");
        }
        if ((mins = (seconds - (used += hours * 60L * 60L)) / 60L) != 0L || used != 0L) {
            out.append(mins);
            out.append("m ");
        }
        if (seconds != 0L || (used += mins * 60L) != 0L) {
            out.append(seconds - used);
            out.append("s ");
        }
    }

    public static String formatTime(long time) {
        long sec = time / 100L;
        StringBuilder sb = new StringBuilder();
        BatteryStats.formatTime(sb, sec);
        sb.append((time - sec * 100L) * 10L);
        sb.append("ms ");
        return sb.toString();
    }

    public static String formatTimeMs(long time) {
        long sec = time / 1000L;
        StringBuilder sb = new StringBuilder();
        BatteryStats.formatTime(sb, sec);
        sb.append(time - sec * 1000L);
        sb.append("ms ");
        return sb.toString();
    }

    public String formatRatioLocked(long num, long den) {
        if (den == 0L) {
            return "---%";
        }
        float perc = (float)num / (float)den * 100.0f;
        this.mFormatBuilder.setLength(0);
        this.mFormatter.format("%.1f%%", Float.valueOf(perc));
        return this.mFormatBuilder.toString();
    }

    public String formatBytesLocked(long bytes) {
        this.mFormatBuilder.setLength(0);
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            this.mFormatter.format("%.2fKB", (double)bytes / 1024.0);
            return this.mFormatBuilder.toString();
        }
        if (bytes < 0x40000000L) {
            this.mFormatter.format("%.2fMB", (double)bytes / 1048576.0);
            return this.mFormatBuilder.toString();
        }
        this.mFormatter.format("%.2fGB", (double)bytes / 1.073741824E9);
        return this.mFormatBuilder.toString();
    }

    public static String printWakeLock(StringBuilder sb, Timer timer, long batteryRealtime, String name, int which, String linePrefix) {
        if (timer != null) {
            long totalTimeMicros = timer.getTotalTime(batteryRealtime, which);
            long totalTimeMillis = (totalTimeMicros + 500L) / 1000L;
            int count = timer.getCount(which);
            if (totalTimeMillis != 0L) {
                sb.append(linePrefix);
                sb.append(BatteryStats.formatTimeMs(totalTimeMillis));
                sb.append(name);
                sb.append(' ');
                sb.append('(');
                sb.append(count);
                sb.append(" times)");
                return ", ";
            }
        }
        return linePrefix;
    }

    public static String printWakeLockCheckin(StringBuilder sb, Timer timer, long now, String name, int which, String linePrefix) {
        long totalTimeMicros = 0L;
        int count = 0;
        if (timer != null) {
            totalTimeMicros = timer.getTotalTime(now, which);
            count = timer.getCount(which);
        }
        sb.append(linePrefix);
        sb.append((totalTimeMicros + 500L) / 1000L);
        sb.append(',');
        sb.append(name);
        sb.append(',');
        sb.append(count);
        return ",";
    }

    public static void dumpLine(PrintWriter pw, int uid, String category, String type, Object ... args) {
        pw.print(3);
        pw.print(',');
        pw.print(uid);
        pw.print(',');
        pw.print(category);
        pw.print(',');
        pw.print(type);
        for (Object arg : args) {
            pw.print(',');
            pw.print(arg);
        }
        pw.print('\n');
    }

    public void dumpCheckinLocked(PrintWriter pw, int which) {
        int i;
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long batteryRealtime = this.getBatteryRealtime(rawRealtime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        long screenOnTime = this.getScreenOnTime(batteryRealtime, which);
        long phoneOnTime = this.getPhoneOnTime(batteryRealtime, which);
        long wifiOnTime = this.getWifiOnTime(batteryRealtime, which);
        long wifiRunningTime = this.getWifiRunningTime(batteryRealtime, which);
        long bluetoothOnTime = this.getBluetoothOnTime(batteryRealtime, which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        String category = STAT_NAMES[which];
        BatteryStats.dumpLine(pw, 0, category, BATTERY_DATA, which == 0 ? Integer.valueOf(this.getStartCount()) : "N/A", whichBatteryRealtime / 1000L, whichBatteryUptime / 1000L, totalRealtime / 1000L, totalUptime / 1000L);
        long rxTotal = 0L;
        long txTotal = 0L;
        long fullWakeLockTimeTotal = 0L;
        long partialWakeLockTimeTotal = 0L;
        for (int iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            rxTotal += u.getTcpBytesReceived(which);
            txTotal += u.getTcpBytesSent(which);
            Map<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            if (wakelocks.size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = ent.getValue();
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotal += fullWakeTimer.getTotalTime(batteryRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotal += partialWakeTimer.getTotalTime(batteryRealtime, which);
            }
        }
        BatteryStats.dumpLine(pw, 0, category, MISC_DATA, screenOnTime / 1000L, phoneOnTime / 1000L, wifiOnTime / 1000L, wifiRunningTime / 1000L, bluetoothOnTime / 1000L, rxTotal, txTotal, fullWakeLockTimeTotal, partialWakeLockTimeTotal, this.getInputEventCount(which));
        Object[] args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getScreenBrightnessTime(i, batteryRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SCREEN_BRIGHTNESS_DATA, args);
        args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneSignalStrengthTime(i, batteryRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_TIME_DATA, args);
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneSignalStrengthCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_COUNT_DATA, args);
        args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneDataConnectionTime(i, batteryRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_TIME_DATA, args);
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneDataConnectionCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_COUNT_DATA, args);
        if (which == 3) {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_DATA, this.getUnpluggedStartLevel(), this.getPluggedStartLevel());
        }
        for (int iu = 0; iu < NU; ++iu) {
            Map<String, ? extends Uid.Pkg> packageStats;
            Map<String, ? extends Uid.Proc> processStats;
            Map<Integer, ? extends Uid.Sensor> sensors;
            Map<String, ? extends Uid.Wakelock> wakelocks;
            int uid = uidStats.keyAt(iu);
            Uid u = uidStats.valueAt(iu);
            long rx = u.getTcpBytesReceived(which);
            long tx = u.getTcpBytesSent(which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(batteryRealtime, which);
            long scanWifiLockOnTime = u.getScanWifiLockTime(batteryRealtime, which);
            long wifiTurnedOnTime = u.getWifiTurnedOnTime(batteryRealtime, which);
            if (rx > 0L || tx > 0L) {
                BatteryStats.dumpLine(pw, uid, category, NETWORK_DATA, rx, tx);
            }
            if (fullWifiLockOnTime != 0L || scanWifiLockOnTime != 0L || wifiTurnedOnTime != 0L) {
                BatteryStats.dumpLine(pw, uid, category, WIFI_LOCK_DATA, fullWifiLockOnTime, scanWifiLockOnTime, wifiTurnedOnTime);
            }
            if (u.hasUserActivity()) {
                args = new Object[7];
                boolean hasData = false;
                for (int i2 = 0; i2 < 7; ++i2) {
                    int val = u.getUserActivityCount(i2, which);
                    args[i2] = val;
                    if (val == 0) continue;
                    hasData = true;
                }
                if (hasData) {
                    BatteryStats.dumpLine(pw, 0, category, USER_ACTIVITY_DATA, args);
                }
            }
            if ((wakelocks = u.getWakelockStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                    Uid.Wakelock wl = ent.getValue();
                    String linePrefix = "";
                    sb.setLength(0);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(1), batteryRealtime, "full", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(0), batteryRealtime, "partial", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(2), batteryRealtime, "window", which, linePrefix);
                    if (sb.length() <= 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, WAKELOCK_DATA, ent.getKey(), sb.toString());
                }
            }
            if ((sensors = u.getSensorStats()).size() > 0) {
                for (Map.Entry<Integer, ? extends Uid.Sensor> ent : sensors.entrySet()) {
                    Uid.Sensor se = ent.getValue();
                    int sensorNumber = ent.getKey();
                    Timer timer = se.getSensorTime();
                    if (timer == null) continue;
                    long totalTime = (timer.getTotalTime(batteryRealtime, which) + 500L) / 1000L;
                    int count = timer.getCount(which);
                    if (totalTime == 0L) continue;
                    BatteryStats.dumpLine(pw, uid, category, SENSOR_DATA, sensorNumber, totalTime, count);
                }
            }
            if ((processStats = u.getProcessStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Proc> ent : processStats.entrySet()) {
                    Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    int starts = ps.getStarts(which);
                    if (userTime == 0L && systemTime == 0L && starts == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, PROCESS_DATA, ent.getKey(), userTime * 10L, systemTime * 10L, starts);
                }
            }
            if ((packageStats = u.getPackageStats()).size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Pkg> ent : packageStats.entrySet()) {
                Uid.Pkg ps = ent.getValue();
                int wakeups = ps.getWakeups(which);
                Map<String, ? extends Uid.Pkg.Serv> serviceStats = ps.getServiceStats();
                for (Map.Entry<String, ? extends Uid.Pkg.Serv> sent : serviceStats.entrySet()) {
                    Uid.Pkg.Serv ss = sent.getValue();
                    long startTime = ss.getStartTime(batteryUptime, which);
                    int starts = ss.getStarts(which);
                    int launches = ss.getLaunches(which);
                    if (startTime == 0L && starts == 0 && launches == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, APK_DATA, wakeups, ent.getKey(), sent.getKey(), startTime / 1000L, starts, launches);
                }
            }
        }
    }

    public void dumpLocked(Printer pw, String prefix, int which) {
        int i;
        int iu;
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long batteryRealtime = this.getBatteryRealtime(rawRealtime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        pw.println(prefix + "  Time on battery: " + BatteryStats.formatTimeMs(whichBatteryRealtime / 1000L) + "(" + this.formatRatioLocked(whichBatteryRealtime, totalRealtime) + ") realtime, " + BatteryStats.formatTimeMs(whichBatteryUptime / 1000L) + "(" + this.formatRatioLocked(whichBatteryUptime, totalRealtime) + ") uptime");
        pw.println(prefix + "  Total run time: " + BatteryStats.formatTimeMs(totalRealtime / 1000L) + "realtime, " + BatteryStats.formatTimeMs(totalUptime / 1000L) + "uptime, ");
        long screenOnTime = this.getScreenOnTime(batteryRealtime, which);
        long phoneOnTime = this.getPhoneOnTime(batteryRealtime, which);
        long wifiRunningTime = this.getWifiRunningTime(batteryRealtime, which);
        long wifiOnTime = this.getWifiOnTime(batteryRealtime, which);
        long bluetoothOnTime = this.getBluetoothOnTime(batteryRealtime, which);
        pw.println(prefix + "  Screen on: " + BatteryStats.formatTimeMs(screenOnTime / 1000L) + "(" + this.formatRatioLocked(screenOnTime, whichBatteryRealtime) + "), Input events: " + this.getInputEventCount(which) + ", Active phone call: " + BatteryStats.formatTimeMs(phoneOnTime / 1000L) + "(" + this.formatRatioLocked(phoneOnTime, whichBatteryRealtime) + ")");
        sb.setLength(0);
        sb.append("  Screen brightnesses: ");
        boolean didOne = false;
        for (int i2 = 0; i2 < 5; ++i2) {
            long time = this.getScreenBrightnessTime(i2, batteryRealtime, which);
            if (time == 0L) continue;
            if (didOne) {
                sb.append(", ");
            }
            didOne = true;
            sb.append(SCREEN_BRIGHTNESS_NAMES[i2]);
            sb.append(" ");
            sb.append(BatteryStats.formatTimeMs(time / 1000L));
            sb.append("(");
            sb.append(this.formatRatioLocked(time, screenOnTime));
            sb.append(")");
        }
        if (!didOne) {
            sb.append("No activity");
        }
        pw.println(sb.toString());
        long rxTotal = 0L;
        long txTotal = 0L;
        long fullWakeLockTimeTotalMicros = 0L;
        long partialWakeLockTimeTotalMicros = 0L;
        for (iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            rxTotal += u.getTcpBytesReceived(which);
            txTotal += u.getTcpBytesSent(which);
            Map<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            if (wakelocks.size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = ent.getValue();
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotalMicros += fullWakeTimer.getTotalTime(batteryRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotalMicros += partialWakeTimer.getTotalTime(batteryRealtime, which);
            }
        }
        pw.println(prefix + "  Total received: " + this.formatBytesLocked(rxTotal) + ", Total sent: " + this.formatBytesLocked(txTotal));
        pw.println(prefix + "  Total full wakelock time: " + BatteryStats.formatTimeMs((fullWakeLockTimeTotalMicros + 500L) / 1000L) + ", Total partial waklock time: " + BatteryStats.formatTimeMs((partialWakeLockTimeTotalMicros + 500L) / 1000L));
        sb.setLength(0);
        sb.append("  Signal levels: ");
        didOne = false;
        for (i = 0; i < 5; ++i) {
            long time = this.getPhoneSignalStrengthTime(i, batteryRealtime, which);
            if (time == 0L) continue;
            if (didOne) {
                sb.append(", ");
            }
            didOne = true;
            sb.append(SIGNAL_STRENGTH_NAMES[i]);
            sb.append(" ");
            sb.append(BatteryStats.formatTimeMs(time / 1000L));
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneSignalStrengthCount(i, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append("No activity");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append("  Radio types: ");
        didOne = false;
        for (i = 0; i < 5; ++i) {
            long time = this.getPhoneDataConnectionTime(i, batteryRealtime, which);
            if (time == 0L) continue;
            if (didOne) {
                sb.append(", ");
            }
            didOne = true;
            sb.append(DATA_CONNECTION_NAMES[i]);
            sb.append(" ");
            sb.append(BatteryStats.formatTimeMs(time / 1000L));
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneDataConnectionCount(i, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append("No activity");
        }
        pw.println(sb.toString());
        pw.println(prefix + "  Wifi on: " + BatteryStats.formatTimeMs(wifiOnTime / 1000L) + "(" + this.formatRatioLocked(wifiOnTime, whichBatteryRealtime) + "), Wifi running: " + BatteryStats.formatTimeMs(wifiRunningTime / 1000L) + "(" + this.formatRatioLocked(wifiRunningTime, whichBatteryRealtime) + "), Bluetooth on: " + BatteryStats.formatTimeMs(bluetoothOnTime / 1000L) + "(" + this.formatRatioLocked(bluetoothOnTime, whichBatteryRealtime) + ")");
        pw.println(" ");
        if (which == 3) {
            if (this.getIsOnBattery()) {
                pw.println(prefix + "  Device is currently unplugged");
                pw.println(prefix + "    Discharge cycle start level: " + this.getUnpluggedStartLevel());
            } else {
                pw.println(prefix + "  Device is currently plugged into power");
                pw.println(prefix + "    Last discharge cycle start level: " + this.getUnpluggedStartLevel());
                pw.println(prefix + "    Last discharge cycle end level: " + this.getPluggedStartLevel());
            }
            pw.println(" ");
        }
        for (iu = 0; iu < NU; ++iu) {
            Map<String, ? extends Uid.Pkg> packageStats;
            Map<String, ? extends Uid.Proc> processStats;
            Map<Integer, ? extends Uid.Sensor> sensors;
            Map<String, ? extends Uid.Wakelock> wakelocks;
            int uid = uidStats.keyAt(iu);
            Uid u = uidStats.valueAt(iu);
            pw.println(prefix + "  #" + uid + ":");
            boolean uidActivity = false;
            long tcpReceived = u.getTcpBytesReceived(which);
            long tcpSent = u.getTcpBytesSent(which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(batteryRealtime, which);
            long scanWifiLockOnTime = u.getScanWifiLockTime(batteryRealtime, which);
            long wifiTurnedOnTime = u.getWifiTurnedOnTime(batteryRealtime, which);
            if (tcpReceived != 0L || tcpSent != 0L) {
                pw.println(prefix + "    Network: " + this.formatBytesLocked(tcpReceived) + " received, " + this.formatBytesLocked(tcpSent) + " sent");
            }
            if (u.hasUserActivity()) {
                boolean hasData = false;
                for (int i3 = 0; i3 < 5; ++i3) {
                    int val = u.getUserActivityCount(i3, which);
                    if (val == 0) continue;
                    if (!hasData) {
                        sb.setLength(0);
                        sb.append("    User activity: ");
                        hasData = true;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(val);
                    sb.append(" ");
                    sb.append(Uid.USER_ACTIVITY_TYPES[i3]);
                }
                if (hasData) {
                    pw.println(sb.toString());
                }
            }
            if (fullWifiLockOnTime != 0L || scanWifiLockOnTime != 0L || wifiTurnedOnTime != 0L) {
                pw.println(prefix + "    Turned Wifi On Time: " + BatteryStats.formatTimeMs(wifiTurnedOnTime / 1000L) + "(" + this.formatRatioLocked(wifiTurnedOnTime, whichBatteryRealtime) + ")");
                pw.println(prefix + "    Full Wifi Lock Time: " + BatteryStats.formatTimeMs(fullWifiLockOnTime / 1000L) + "(" + this.formatRatioLocked(fullWifiLockOnTime, whichBatteryRealtime) + ")");
                pw.println(prefix + "    Scan Wifi Lock Time: " + BatteryStats.formatTimeMs(scanWifiLockOnTime / 1000L) + "(" + this.formatRatioLocked(scanWifiLockOnTime, whichBatteryRealtime) + ")");
            }
            if ((wakelocks = u.getWakelockStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                    Uid.Wakelock wl = ent.getValue();
                    String linePrefix = ": ";
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Wake lock ");
                    sb.append(ent.getKey());
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(1), batteryRealtime, "full", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(0), batteryRealtime, "partial", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(2), batteryRealtime, "window", which, linePrefix);
                    if (!linePrefix.equals(": ")) {
                        sb.append(" realtime");
                    } else {
                        sb.append(": (nothing executed)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            if ((sensors = u.getSensorStats()).size() > 0) {
                for (Map.Entry<Integer, ? extends Uid.Sensor> ent : sensors.entrySet()) {
                    Uid.Sensor se = ent.getValue();
                    int sensorNumber = ent.getKey();
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Sensor ");
                    int handle = se.getHandle();
                    if (handle == -10000) {
                        sb.append("GPS");
                    } else {
                        sb.append(handle);
                    }
                    sb.append(": ");
                    Timer timer = se.getSensorTime();
                    if (timer != null) {
                        long totalTime = (timer.getTotalTime(batteryRealtime, which) + 500L) / 1000L;
                        int count = timer.getCount(which);
                        if (totalTime != 0L) {
                            sb.append(BatteryStats.formatTimeMs(totalTime));
                            sb.append("realtime (");
                            sb.append(count);
                            sb.append(" times)");
                        } else {
                            sb.append("(not used)");
                        }
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            if ((processStats = u.getProcessStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Proc> ent : processStats.entrySet()) {
                    Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    int starts = ps.getStarts(which);
                    if (userTime == 0L && systemTime == 0L && starts == 0) continue;
                    pw.println(prefix + "    Proc " + ent.getKey() + ":");
                    pw.println(prefix + "      CPU: " + BatteryStats.formatTime(userTime) + "user + " + BatteryStats.formatTime(systemTime) + "kernel");
                    pw.println(prefix + "      " + starts + " process starts");
                    uidActivity = true;
                }
            }
            if ((packageStats = u.getPackageStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Pkg> ent : packageStats.entrySet()) {
                    Map<String, ? extends Uid.Pkg.Serv> serviceStats;
                    pw.println(prefix + "    Apk " + ent.getKey() + ":");
                    boolean apkActivity = false;
                    Uid.Pkg ps = ent.getValue();
                    int wakeups = ps.getWakeups(which);
                    if (wakeups != 0) {
                        pw.println(prefix + "      " + wakeups + " wakeup alarms");
                        apkActivity = true;
                    }
                    if ((serviceStats = ps.getServiceStats()).size() > 0) {
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> sent : serviceStats.entrySet()) {
                            Uid.Pkg.Serv ss = sent.getValue();
                            long startTime = ss.getStartTime(batteryUptime, which);
                            int starts = ss.getStarts(which);
                            int launches = ss.getLaunches(which);
                            if (startTime == 0L && starts == 0 && launches == 0) continue;
                            pw.println(prefix + "      Service " + sent.getKey() + ":");
                            pw.println(prefix + "        Created for: " + BatteryStats.formatTimeMs(startTime / 1000L) + " uptime");
                            pw.println(prefix + "        Starts: " + starts + ", launches: " + launches);
                            apkActivity = true;
                        }
                    }
                    if (!apkActivity) {
                        pw.println(prefix + "      (nothing executed)");
                    }
                    uidActivity = true;
                }
            }
            if (uidActivity) continue;
            pw.println(prefix + "    (nothing executed)");
        }
    }

    public void dumpLocked(Printer pw) {
        pw.println("Total Statistics (Current and Historic):");
        pw.println("  System starts: " + this.getStartCount() + ", currently on battery: " + this.getIsOnBattery());
        this.dumpLocked(pw, "", 0);
        pw.println("");
        pw.println("Last Run Statistics (Previous run of system):");
        this.dumpLocked(pw, "", 1);
        pw.println("");
        pw.println("Current Battery Statistics (Currently running system):");
        this.dumpLocked(pw, "", 2);
        pw.println("");
        pw.println("Unplugged Statistics (Since last unplugged from power):");
        this.dumpLocked(pw, "", 3);
    }

    public void dumpCheckinLocked(PrintWriter pw, String[] args) {
        boolean isUnpluggedOnly = false;
        for (String arg : args) {
            if (!"-u".equals(arg)) continue;
            isUnpluggedOnly = true;
        }
        if (isUnpluggedOnly) {
            this.dumpCheckinLocked(pw, 3);
        } else {
            this.dumpCheckinLocked(pw, 0);
            this.dumpCheckinLocked(pw, 1);
            this.dumpCheckinLocked(pw, 3);
            this.dumpCheckinLocked(pw, 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Uid {
        public static final String[] USER_ACTIVITY_TYPES = new String[]{"other", "cheek", "touch", "long_touch", "touch_up", "button", "unknown"};
        public static final int NUM_USER_ACTIVITY_TYPES = 7;

        public abstract Map<String, ? extends Wakelock> getWakelockStats();

        public abstract Map<Integer, ? extends Sensor> getSensorStats();

        public abstract Map<String, ? extends Proc> getProcessStats();

        public abstract Map<String, ? extends Pkg> getPackageStats();

        public abstract int getUid();

        public abstract long getTcpBytesReceived(int var1);

        public abstract long getTcpBytesSent(int var1);

        public abstract void noteWifiTurnedOnLocked();

        public abstract void noteWifiTurnedOffLocked();

        public abstract void noteFullWifiLockAcquiredLocked();

        public abstract void noteFullWifiLockReleasedLocked();

        public abstract void noteScanWifiLockAcquiredLocked();

        public abstract void noteScanWifiLockReleasedLocked();

        public abstract long getWifiTurnedOnTime(long var1, int var3);

        public abstract long getFullWifiLockTime(long var1, int var3);

        public abstract long getScanWifiLockTime(long var1, int var3);

        public abstract void noteUserActivityLocked(int var1);

        public abstract boolean hasUserActivity();

        public abstract int getUserActivityCount(int var1, int var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Pkg {
            public abstract int getWakeups(int var1);

            public abstract Map<String, ? extends Serv> getServiceStats();

            public abstract class Serv {
                public abstract long getStartTime(long var1, int var3);

                public abstract int getStarts(int var1);

                public abstract int getLaunches(int var1);
            }
        }

        public static abstract class Proc {
            public abstract long getUserTime(int var1);

            public abstract long getSystemTime(int var1);

            public abstract int getStarts(int var1);
        }

        public static abstract class Sensor {
            public static final int GPS = -10000;

            public abstract int getHandle();

            public abstract Timer getSensorTime();
        }

        public static abstract class Wakelock {
            public abstract Timer getWakeTime(int var1);
        }
    }

    public static abstract class Timer {
        public abstract int getCount(int var1);

        public abstract long getTotalTime(long var1, int var3);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class Counter {
        public abstract int getCount(int var1);

        public abstract void logState(Printer var1, String var2);
    }
}

