/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMDebug;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class Debug {
    public static final int TRACE_COUNT_ALLOCS = 1;
    public static final int SHOW_FULL_DETAIL = 1;
    public static final int SHOW_CLASSLOADER = 2;
    public static final int SHOW_INITIALIZED = 4;
    public static volatile boolean mWaiting = false;
    public static final int MIN_DEBUGGER_IDLE = 1300;
    public static final int SPIN_DELAY = 200;
    public static final String DEFAULT_TRACE_PATH_PREFIX = "/sdcard/";
    public static final String DEFAULT_TRACE_BODY = "dmtrace";
    public static final String DEFAULT_TRACE_EXTENSION = ".trace";
    public static final String DEFAULT_TRACE_FILE_PATH = "/sdcard/dmtrace.trace";
    public static final String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";

    public static void waitForDebugger() {
        block9: {
            long delta;
            if (!VMDebug.isDebuggingEnabled()) {
                return;
            }
            if (Debug.isDebuggerConnected()) {
                return;
            }
            System.out.println("Sending WAIT chunk");
            byte[] data = new byte[]{0};
            Chunk waitChunk = new Chunk(ChunkHandler.type("WAIT"), data, 0, 1);
            DdmServer.sendChunk(waitChunk);
            mWaiting = true;
            while (!Debug.isDebuggerConnected()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {}
            }
            mWaiting = false;
            System.out.println("Debugger has connected");
            while (true) {
                if ((delta = VMDebug.lastDebuggerActivity()) < 0L) {
                    System.out.println("debugger detached?");
                    break block9;
                }
                if (delta >= 1300L) break;
                System.out.println("waiting for debugger to settle...");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {}
            }
            System.out.println("debugger has settled (" + delta + ")");
        }
    }

    public static boolean waitingForDebugger() {
        return mWaiting;
    }

    public static boolean isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    @Deprecated
    public static void changeDebugPort(int port) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startNativeTracing() {
        PrintWriter outStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(SYSFS_QEMU_TRACE_STATE);
            outStream = new PrintWriter(new OutputStreamWriter(fos));
            outStream.println("1");
        }
        catch (Exception exception) {
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        VMDebug.startEmulatorTracing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopNativeTracing() {
        VMDebug.stopEmulatorTracing();
        PrintWriter outStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(SYSFS_QEMU_TRACE_STATE);
            outStream = new PrintWriter(new OutputStreamWriter(fos));
            outStream.println("0");
        }
        catch (Exception exception) {
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static void enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    public static void startMethodTracing() {
        VMDebug.startMethodTracing(DEFAULT_TRACE_FILE_PATH, 0, 0);
    }

    public static void startMethodTracing(String traceName) {
        Debug.startMethodTracing(traceName, 0, 0);
    }

    public static void startMethodTracing(String traceName, int bufferSize) {
        Debug.startMethodTracing(traceName, bufferSize, 0);
    }

    public static void startMethodTracing(String traceName, int bufferSize, int flags) {
        String pathName = traceName;
        if (pathName.charAt(0) != '/') {
            pathName = DEFAULT_TRACE_PATH_PREFIX + pathName;
        }
        if (!pathName.endsWith(DEFAULT_TRACE_EXTENSION)) {
            pathName = pathName + DEFAULT_TRACE_EXTENSION;
        }
        VMDebug.startMethodTracing(pathName, bufferSize, flags);
    }

    public static void stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    public static long threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    public static void startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    public static void stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    public static int getGlobalAllocCount() {
        return VMDebug.getAllocCount(1);
    }

    public static int getGlobalAllocSize() {
        return VMDebug.getAllocCount(2);
    }

    public static int getGlobalFreedCount() {
        return VMDebug.getAllocCount(4);
    }

    public static int getGlobalFreedSize() {
        return VMDebug.getAllocCount(8);
    }

    public static int getGlobalExternalAllocCount() {
        return VMDebug.getAllocCount(4096);
    }

    public static int getGlobalExternalAllocSize() {
        return VMDebug.getAllocCount(8192);
    }

    public static int getGlobalExternalFreedCount() {
        return VMDebug.getAllocCount(16384);
    }

    public static int getGlobalExternalFreedSize() {
        return VMDebug.getAllocCount(32768);
    }

    public static int getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount(16);
    }

    public static int getThreadAllocCount() {
        return VMDebug.getAllocCount(65536);
    }

    public static int getThreadAllocSize() {
        return VMDebug.getAllocCount(131072);
    }

    public static int getThreadExternalAllocCount() {
        return VMDebug.getAllocCount(0x10000000);
    }

    public static int getThreadExternalAllocSize() {
        return VMDebug.getAllocCount(0x20000000);
    }

    public static int getThreadGcInvocationCount() {
        return VMDebug.getAllocCount(0x100000);
    }

    public static void resetGlobalAllocCount() {
        VMDebug.resetAllocCount(1);
    }

    public static void resetGlobalAllocSize() {
        VMDebug.resetAllocCount(2);
    }

    public static void resetGlobalFreedCount() {
        VMDebug.resetAllocCount(4);
    }

    public static void resetGlobalFreedSize() {
        VMDebug.resetAllocCount(8);
    }

    public static void resetGlobalExternalAllocCount() {
        VMDebug.resetAllocCount(4096);
    }

    public static void resetGlobalExternalAllocSize() {
        VMDebug.resetAllocCount(8192);
    }

    public static void resetGlobalExternalFreedCount() {
        VMDebug.resetAllocCount(16384);
    }

    public static void resetGlobalExternalFreedSize() {
        VMDebug.resetAllocCount(32768);
    }

    public static void resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount(16);
    }

    public static void resetThreadAllocCount() {
        VMDebug.resetAllocCount(65536);
    }

    public static void resetThreadAllocSize() {
        VMDebug.resetAllocCount(131072);
    }

    public static void resetThreadExternalAllocCount() {
        VMDebug.resetAllocCount(0x10000000);
    }

    public static void resetThreadExternalAllocSize() {
        VMDebug.resetAllocCount(0x20000000);
    }

    public static void resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount(0x100000);
    }

    public static void resetAllCounts() {
        VMDebug.resetAllocCount(-1);
    }

    public static long getNativeHeapSize() {
        return OverrideMethod.invokeL("android.os.Debug#getNativeHeapSize()J", true, null);
    }

    public static long getNativeHeapAllocatedSize() {
        return OverrideMethod.invokeL("android.os.Debug#getNativeHeapAllocatedSize()J", true, null);
    }

    public static long getNativeHeapFreeSize() {
        return OverrideMethod.invokeL("android.os.Debug#getNativeHeapFreeSize()J", true, null);
    }

    public static void getMemoryInfo(MemoryInfo memoryInfo) {
        OverrideMethod.invokeV("android.os.Debug#getMemoryInfo(Landroid/os/Debug$MemoryInfo;)V", true, null);
    }

    public static int setAllocationLimit(int limit) {
        return VMDebug.setAllocationLimit(limit);
    }

    public static int setGlobalAllocationLimit(int limit) {
        if (limit != 0 && limit != -1) {
            throw new IllegalArgumentException("limit must be 0 or -1");
        }
        return VMDebug.setGlobalAllocationLimit(limit);
    }

    public static void printLoadedClasses(int flags) {
        VMDebug.printLoadedClasses(flags);
    }

    public static int getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    public static void dumpHprofData(String fileName) throws IOException {
        VMDebug.dumpHprofData(fileName);
    }

    public static int getBinderSentTransactions() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderSentTransactions()I", true, null);
    }

    public static int getBinderReceivedTransactions() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderReceivedTransactions()I", true, null);
    }

    public static int getBinderLocalObjectCount() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderLocalObjectCount()I", true, null);
    }

    public static int getBinderProxyObjectCount() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderProxyObjectCount()I", true, null);
    }

    public static int getBinderDeathObjectCount() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderDeathObjectCount()I", true, null);
    }

    public static class InstructionCount {
        public static final int NUM_INSTR = 256;
        public int[] mCounts = new int[256];

        public boolean resetAndStart() {
            try {
                VMDebug.startInstructionCounting();
                VMDebug.resetInstructionCount();
            }
            catch (UnsupportedOperationException uoe) {
                return false;
            }
            return true;
        }

        public boolean collect() {
            try {
                VMDebug.stopInstructionCounting();
                VMDebug.getInstructionCount(this.mCounts);
            }
            catch (UnsupportedOperationException uoe) {
                return false;
            }
            return true;
        }

        public int globalTotal() {
            int count = 0;
            for (int i = 0; i < 256; ++i) {
                count += this.mCounts[i];
            }
            return count;
        }

        public int globalMethodInvocations() {
            int count = 0;
            count += this.mCounts[110];
            count += this.mCounts[111];
            count += this.mCounts[112];
            count += this.mCounts[113];
            count += this.mCounts[114];
            count += this.mCounts[116];
            count += this.mCounts[117];
            count += this.mCounts[118];
            count += this.mCounts[119];
            count += this.mCounts[120];
            count += this.mCounts[248];
            count += this.mCounts[249];
            count += this.mCounts[250];
            return count += this.mCounts[251];
        }
    }

    public static class MemoryInfo {
        public int dalvikPss;
        public int dalvikPrivateDirty;
        public int dalvikSharedDirty;
        public int nativePss;
        public int nativePrivateDirty;
        public int nativeSharedDirty;
        public int otherPss;
        public int otherPrivateDirty;
        public int otherSharedDirty;
    }
}

