/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Looper;
import android.os.Process;

public class HandlerThread
extends Thread {
    public int mPriority;
    public int mTid = -1;
    public Looper mLooper;

    public HandlerThread(String name) {
        super(name);
        this.mPriority = 0;
    }

    public HandlerThread(String name, int priority) {
        super(name);
        this.mPriority = priority;
    }

    public void onLooperPrepared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.mTid = Process.myTid();
        Looper.prepare();
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            this.mLooper = Looper.myLooper();
            Process.setThreadPriority(this.mPriority);
            this.notifyAll();
        }
        this.onLooperPrepared();
        Looper.loop();
        this.mTid = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.mLooper;
    }

    public int getThreadId() {
        return this.mTid;
    }
}

