/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryFile {
    public static String TAG = "MemoryFile";
    public int mFD;
    public int mAddress;
    public int mLength;
    public boolean mAllowPurging = false;

    public int native_open(String string2, int n) {
        return OverrideMethod.invokeI("android.os.MemoryFile#native_open(Ljava/lang/String;I)I", true, this);
    }

    public int native_mmap(int n, int n2) {
        return OverrideMethod.invokeI("android.os.MemoryFile#native_mmap(II)I", true, this);
    }

    public void native_close(int n) {
        OverrideMethod.invokeV("android.os.MemoryFile#native_close(I)V", true, this);
    }

    public int native_read(int n, int n2, byte[] byArray, int n3, int n4, int n5, boolean bl) {
        return OverrideMethod.invokeI("android.os.MemoryFile#native_read(II[BIIIZ)I", true, this);
    }

    public void native_write(int n, int n2, byte[] byArray, int n3, int n4, int n5, boolean bl) {
        OverrideMethod.invokeV("android.os.MemoryFile#native_write(II[BIIIZ)V", true, this);
    }

    public void native_pin(int n, boolean bl) {
        OverrideMethod.invokeV("android.os.MemoryFile#native_pin(IZ)V", true, this);
    }

    public MemoryFile(String name, int length) {
        this.mLength = length;
        this.mFD = this.native_open(name, length);
        this.mAddress = this.native_mmap(this.mFD, length);
    }

    public void close() {
        if (this.mFD > 0) {
            this.native_close(this.mFD);
            this.mFD = 0;
        }
    }

    public void finalize() {
        if (this.mFD > 0) {
            Log.e(TAG, "MemoryFile.finalize() called while ashmem still open");
            this.close();
        }
    }

    public int length() {
        return this.mLength;
    }

    public boolean isPurgingAllowed() {
        return this.mAllowPurging;
    }

    public synchronized boolean allowPurging(boolean allowPurging) throws IOException {
        boolean oldValue = this.mAllowPurging;
        if (oldValue != allowPurging) {
            this.native_pin(this.mFD, !allowPurging);
            this.mAllowPurging = allowPurging;
        }
        return oldValue;
    }

    public InputStream getInputStream() {
        return new MemoryInputStream(null);
    }

    public OutputStream getOutputStream() {
        return new MemoryOutputStream(null);
    }

    public int readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (destOffset < 0 || destOffset > buffer.length || count < 0 || count > buffer.length - destOffset || srcOffset < 0 || srcOffset > this.mLength || count > this.mLength - srcOffset) {
            throw new IndexOutOfBoundsException();
        }
        return this.native_read(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    public void writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (srcOffset < 0 || srcOffset > buffer.length || count < 0 || count > buffer.length - srcOffset || destOffset < 0 || destOffset > this.mLength || count > this.mLength - destOffset) {
            throw new IndexOutOfBoundsException();
        }
        this.native_write(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    public static class 1 {
    }

    public class MemoryOutputStream
    extends OutputStream {
        public int mOffset = 0;
        public byte[] mSingleByte;

        public MemoryOutputStream() {
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            MemoryFile.this.writeBytes(buffer, offset, this.mOffset, count);
        }

        public void write(int oneByte) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)oneByte;
            this.write(this.mSingleByte, 0, 1);
        }

        public /* synthetic */ MemoryOutputStream(1 x1) {
            this();
        }
    }

    public class MemoryInputStream
    extends InputStream {
        public int mMark = 0;
        public int mOffset = 0;
        public byte[] mSingleByte;

        public MemoryInputStream() {
        }

        public int available() throws IOException {
            if (this.mOffset >= MemoryFile.this.mLength) {
                return 0;
            }
            return MemoryFile.this.mLength - this.mOffset;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.mMark = this.mOffset;
        }

        public void reset() throws IOException {
            this.mOffset = this.mMark;
        }

        public int read() throws IOException {
            int result;
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if ((result = this.read(this.mSingleByte, 0, 1)) != 1) {
                throw new IOException("read() failed");
            }
            return this.mSingleByte[0];
        }

        public int read(byte[] buffer, int offset, int count) throws IOException {
            int result = MemoryFile.this.readBytes(buffer, this.mOffset, offset, count);
            if (result > 0) {
                this.mOffset += result;
            }
            return result;
        }

        public long skip(long n) throws IOException {
            if ((long)this.mOffset + n > (long)MemoryFile.this.mLength) {
                n = MemoryFile.this.mLength - this.mOffset;
            }
            this.mOffset = (int)((long)this.mOffset + n);
            return n;
        }

        public /* synthetic */ MemoryInputStream(1 x1) {
            this();
        }
    }
}

