/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NetStat {
    public static final String TAG = "netstat";
    public static final File[] MOBILE_TX_PACKETS = NetStat.mobileFiles("tx_packets");
    public static final File[] MOBILE_RX_PACKETS = NetStat.mobileFiles("rx_packets");
    public static final File[] MOBILE_TX_BYTES = NetStat.mobileFiles("tx_bytes");
    public static final File[] MOBILE_RX_BYTES = NetStat.mobileFiles("rx_bytes");
    public static final File SYS_CLASS_NET_DIR = new File("/sys/class/net");
    public static final byte[] buf = new byte[16];

    public static long getMobileTxPkts() {
        return NetStat.getMobileStat(MOBILE_TX_PACKETS);
    }

    public static long getMobileRxPkts() {
        return NetStat.getMobileStat(MOBILE_RX_PACKETS);
    }

    public static long getMobileTxBytes() {
        return NetStat.getMobileStat(MOBILE_TX_BYTES);
    }

    public static long getMobileRxBytes() {
        return NetStat.getMobileStat(MOBILE_RX_BYTES);
    }

    public static long getTotalTxPkts() {
        return NetStat.getTotalStat("tx_packets");
    }

    public static long getTotalRxPkts() {
        return NetStat.getTotalStat("rx_packets");
    }

    public static long getTotalTxBytes() {
        return NetStat.getTotalStat("tx_bytes");
    }

    public static long getTotalRxBytes() {
        return NetStat.getTotalStat("rx_bytes");
    }

    public static long getUidTxBytes(int uid) {
        return NetStat.getNumberFromFilePath("/proc/uid_stat/" + uid + "/tcp_snd");
    }

    public static long getUidRxBytes(int uid) {
        return NetStat.getNumberFromFilePath("/proc/uid_stat/" + uid + "/tcp_rcv");
    }

    public static File[] mobileFiles(String whatStat) {
        File[] files = new File[]{new File("/sys/class/net/rmnet0/statistics/" + whatStat), new File("/sys/class/net/ppp0/statistics/" + whatStat)};
        return files;
    }

    public static long getTotalStat(String whatStat) {
        File netdir = new File("/sys/class/net");
        File[] nets = SYS_CLASS_NET_DIR.listFiles();
        if (nets == null) {
            return 0L;
        }
        long total = 0L;
        StringBuffer strbuf = new StringBuffer();
        for (File net : nets) {
            strbuf.append(net.getPath()).append(File.separator).append("statistics").append(File.separator).append(whatStat);
            total += NetStat.getNumberFromFilePath(strbuf.toString());
            strbuf.setLength(0);
        }
        return total;
    }

    public static long getMobileStat(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.exists()) continue;
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                return NetStat.getNumberFromFile(raf, file.getAbsolutePath());
            }
            catch (IOException e) {
                Log.w(TAG, "Exception opening TCP statistics file " + file.getAbsolutePath(), e);
            }
        }
        return 0L;
    }

    public static long getNumberFromFilePath(String filename) {
        RandomAccessFile raf = NetStat.getFile(filename);
        if (raf == null) {
            return 0L;
        }
        return NetStat.getNumberFromFile(raf, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long getNumberFromFile(RandomAccessFile raf, String filename) {
        try {
            raf.read(buf);
            raf.close();
        }
        catch (IOException e) {
            Log.w(TAG, "Exception getting TCP bytes from " + filename, e);
            long l = 0L;
            return l;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    Log.w(TAG, "Exception closing " + filename, e);
                }
            }
        }
        long num = 0L;
        for (int i = 0; i < buf.length && buf[i] >= 48 && buf[i] <= 57; ++i) {
            num *= 10L;
            num += (long)(buf[i] - 48);
        }
        return num;
    }

    public static RandomAccessFile getFile(String filename) {
        File f = new File(filename);
        if (!f.canRead()) {
            return null;
        }
        try {
            return new RandomAccessFile(f, "r");
        }
        catch (IOException e) {
            Log.w(TAG, "Exception opening TCP statistics file " + filename, e);
            return null;
        }
    }
}

