/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCallbackList<E extends IInterface> {
    public HashMap<IBinder, Callback> mCallbacks = new HashMap();
    public IInterface[] mActiveBroadcast;
    public boolean mKilled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(E callback) {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            if (this.mKilled) {
                return false;
            }
            IBinder binder = callback.asBinder();
            try {
                Callback cb = new Callback(this, callback);
                binder.linkToDeath(cb, 0);
                this.mCallbacks.put(binder, cb);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(E callback) {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            Callback cb = this.mCallbacks.remove(callback.asBinder());
            if (cb != null) {
                cb.mCallback.asBinder().unlinkToDeath(cb, 0);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            for (Callback cb : this.mCallbacks.values()) {
                cb.mCallback.asBinder().unlinkToDeath(cb, 0);
            }
            this.mCallbacks.clear();
            this.mKilled = true;
        }
    }

    public void onCallbackDied(E callback) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int beginBroadcast() {
        HashMap<IBinder, Callback> hashMap = this.mCallbacks;
        synchronized (hashMap) {
            int N = this.mCallbacks.size();
            if (N <= 0) {
                return 0;
            }
            IInterface[] active = this.mActiveBroadcast;
            if (active == null || active.length < N) {
                this.mActiveBroadcast = active = new IInterface[N];
            }
            int i = 0;
            for (Callback cb : this.mCallbacks.values()) {
                active[i++] = cb.mCallback;
            }
            return i;
        }
    }

    public E getBroadcastItem(int index) {
        return (E)this.mActiveBroadcast[index];
    }

    public void finishBroadcast() {
        IInterface[] active = this.mActiveBroadcast;
        if (active != null) {
            int N = active.length;
            for (int i = 0; i < N; ++i) {
                active[i] = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Callback
    implements IBinder.DeathRecipient {
        public final E mCallback;
        public final /* synthetic */ RemoteCallbackList this$0;

        public Callback(E callback) {
            this.this$0 = var1_1;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            HashMap<IBinder, Callback> hashMap = this.this$0.mCallbacks;
            synchronized (hashMap) {
                this.this$0.mCallbacks.remove(this.mCallback.asBinder());
            }
            this.this$0.onCallbackDied(this.mCallback);
        }
    }
}

