/*
 * Decompiled with CFR 0.152.
 */
package android.server.data;

import android.os.Build;
import com.android.internal.util.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BuildData {
    public static final int VERSION = 0;
    public final String fingerprint;
    public final String incrementalVersion;
    public final long time;

    public BuildData() {
        this.fingerprint = "android:" + Build.FINGERPRINT;
        this.incrementalVersion = Build.VERSION.INCREMENTAL;
        this.time = Build.TIME / 1000L;
    }

    public BuildData(String fingerprint, String incrementalVersion, long time) {
        this.fingerprint = Objects.nonNull(fingerprint);
        this.incrementalVersion = incrementalVersion;
        this.time = time;
    }

    public BuildData(DataInput in) throws IOException {
        int dataVersion = in.readInt();
        if (dataVersion != 0) {
            throw new IOException("Expected 0. Got: " + dataVersion);
        }
        this.fingerprint = in.readUTF();
        this.incrementalVersion = Long.toString(in.readLong());
        this.time = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        long changelist;
        out.writeInt(0);
        out.writeUTF(this.fingerprint);
        try {
            changelist = Long.parseLong(this.incrementalVersion);
        }
        catch (NumberFormatException ex) {
            changelist = -1L;
        }
        out.writeLong(changelist);
        out.writeLong(this.time);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getIncrementalVersion() {
        return this.incrementalVersion;
    }

    public long getTime() {
        return this.time;
    }
}

