/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

public class ServiceState
implements Parcelable {
    public static final int STATE_IN_SERVICE = 0;
    public static final int STATE_OUT_OF_SERVICE = 1;
    public static final int STATE_EMERGENCY_ONLY = 2;
    public static final int STATE_POWER_OFF = 3;
    public int mState = 1;
    public boolean mRoaming;
    public String mOperatorAlphaLong;
    public String mOperatorAlphaShort;
    public String mOperatorNumeric;
    public boolean mIsManualNetworkSelection;
    public static final Parcelable.Creator<ServiceState> CREATOR = new Parcelable.Creator(){

        public ServiceState createFromParcel(Parcel in) {
            return new ServiceState(in);
        }

        public ServiceState[] newArray(int size) {
            return new ServiceState[size];
        }
    };

    public static ServiceState newFromBundle(Bundle m) {
        ServiceState ret = new ServiceState();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    public ServiceState() {
    }

    public ServiceState(ServiceState s) {
        this.copyFrom(s);
    }

    public void copyFrom(ServiceState s) {
        this.mState = s.mState;
        this.mRoaming = s.mRoaming;
        this.mOperatorAlphaLong = s.mOperatorAlphaLong;
        this.mOperatorAlphaShort = s.mOperatorAlphaShort;
        this.mOperatorNumeric = s.mOperatorNumeric;
        this.mIsManualNetworkSelection = s.mIsManualNetworkSelection;
    }

    public ServiceState(Parcel in) {
        this.mState = in.readInt();
        this.mRoaming = in.readInt() != 0;
        this.mOperatorAlphaLong = in.readString();
        this.mOperatorAlphaShort = in.readString();
        this.mOperatorNumeric = in.readString();
        this.mIsManualNetworkSelection = in.readInt() != 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mState);
        out.writeInt(this.mRoaming ? 1 : 0);
        out.writeString(this.mOperatorAlphaLong);
        out.writeString(this.mOperatorAlphaShort);
        out.writeString(this.mOperatorNumeric);
        out.writeInt(this.mIsManualNetworkSelection ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public int getState() {
        return this.mState;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public String getOperatorAlphaLong() {
        return this.mOperatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.mOperatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public boolean getIsManualSelection() {
        return this.mIsManualNetworkSelection;
    }

    public int hashCode() {
        return this.mState * 4660 + (this.mRoaming ? 1 : 0) + (this.mIsManualNetworkSelection ? 1 : 0) + (null == this.mOperatorAlphaLong ? 0 : this.mOperatorAlphaLong.hashCode()) + (null == this.mOperatorAlphaShort ? 0 : this.mOperatorAlphaShort.hashCode()) + (null == this.mOperatorNumeric ? 0 : this.mOperatorNumeric.hashCode());
    }

    public boolean equals(Object o) {
        ServiceState s;
        try {
            s = (ServiceState)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mState == s.mState && this.mRoaming == s.mRoaming && this.mIsManualNetworkSelection == s.mIsManualNetworkSelection && ServiceState.equalsHandlesNulls(this.mOperatorAlphaLong, s.mOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mOperatorAlphaShort, s.mOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mOperatorNumeric, s.mOperatorNumeric);
    }

    public String toString() {
        return this.mState + " " + (this.mRoaming ? "roaming" : "home") + " " + this.mOperatorAlphaLong + " " + this.mOperatorAlphaShort + " " + this.mOperatorNumeric + " " + (this.mIsManualNetworkSelection ? "(manual)" : "");
    }

    public void setStateOutOfService() {
        this.mState = 1;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
    }

    public void setStateOff() {
        this.mState = 3;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public void setRoaming(boolean roaming) {
        this.mRoaming = roaming;
    }

    public void setOperatorName(String longName, String shortName, String numeric) {
        this.mOperatorAlphaLong = longName;
        this.mOperatorAlphaShort = shortName;
        this.mOperatorNumeric = numeric;
    }

    public void setIsManualSelection(boolean isManual) {
        this.mIsManualNetworkSelection = isManual;
    }

    public static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public void setFromNotifierBundle(Bundle m) {
        this.mState = m.getInt("state");
        this.mRoaming = m.getBoolean("roaming");
        this.mOperatorAlphaLong = m.getString("operator-alpha-long");
        this.mOperatorAlphaShort = m.getString("operator-alpha-short");
        this.mOperatorNumeric = m.getString("operator-numeric");
        this.mIsManualNetworkSelection = m.getBoolean("manual");
    }

    public void fillInNotifierBundle(Bundle m) {
        m.putInt("state", this.mState);
        m.putBoolean("roaming", this.mRoaming);
        m.putString("operator-alpha-long", this.mOperatorAlphaLong);
        m.putString("operator-alpha-short", this.mOperatorAlphaShort);
        m.putString("operator-numeric", this.mOperatorNumeric);
        m.putBoolean("manual", this.mIsManualNetworkSelection);
    }
}

